cseg	segment para public 'code'
org	100h

	; This program is used to display the total and available memory.

public	sample
sample	proc far

	assume cs:cseg,ds:cseg,ss:nothing,es:nothing

	jmp short p010		; go to the start

public	total,tmemory,avail,amemory,totmem,fremem
total	db 'Total memory: '
tmemory db '000 KB    '
avail	db 'Memory available: '
amemory db '000 KB','$'
totmem	dw 0			; total memory size
fremem	dw 0			; free memory size

public	p010
p010:	call p100		; get memory size

	mov ax,totmem		; total memory
	mov di,offset tmemory
	call p200		; convert to ascii

	mov ax,fremem		; free (available) memory
	mov di,offset amemory
	call p200		; convert to ascii

	call p300		; display the answers

public	p090
p090:	int 20h 		; return to dos

public	p100
p100	proc near		; get memory size
	mov cl,6		; shift count
	mov si,2		; point to top of memory in psp
	mov ax,[si]		; get top of memory

	shr ax,cl		; convert to KB
	mov totmem,ax		; and save total memory

	mov bx,cs		; get current segment
	shr bx,cl		; convert to KB
	sub ax,bx		; subtract from total memory to get
	mov fremem,ax		; free memory
	ret
p100	endp

public	p200
p200	proc near		; convert number to ascii
	; ax = number, di = output buffer pointer
	push ax 		; save number
	mov al,' '
	mov cx,3
	rep stosb		; clear 3 bytes
	pop ax			; restore number

	mov cx,10		; divisor

public	p210
p210:	xor dx,dx		; clear remainder
	div cx			; divide by 10
	add dl,30h		; convert to ascii
	dec di			; back up 1 byte
	mov [di],dl		; save ascii number

	cmp ax,0		; done?
	jnz p210		; no

	ret
p200	endp

public	p300
p300	proc near		; display memory sizes
	mov ah,9		; display string
	mov dx,offset total	; start of message
	int 21h 		; let dos display it
	ret
p300	endp

sample	endp
cseg	ends
end	sample
