

/*****************************************************************************\
 Interrupts.c - code to turn interrupts on and off

 Dan Crevier, 1995
\*****************************************************************************/

void TurnInterruptsOff(void);
void TurnInterruptsOn(void);

#include "Interrupts.h"
#include <MixedMode.h>

#ifdef powerc

static long setToSevenCode[]    = {0x0007C0700, 0x04E750000}; // or.w #$0700, sr / rts
static long setToZeroCode[]     = {0x0027CF8FF, 0x04E750000}; // and.w #$F8FF, sr / rts

// turn interrupts off
void TurnInterruptsOff(void)
{
    CallUniversalProc((UniversalProcPtr)setToSevenCode, kPascalStackBased);
}
// turn interrupts on
void TurnInterruptsOn(void)
{
    CallUniversalProc((UniversalProcPtr)setToZeroCode, kPascalStackBased);
}
#else
asm void TurnInterruptsOff(void)
{
    or.w #0x0700, SR
    rts
}
asm void TurnInterruptsOn(void)
{
    and.w #0xF8FF, SR
    rts
}
#endif
