

      SUBROUTINE ISVWRT(X,Y,PAT)
      INTEGER*2 X,Y,PAT
C
      INTEGER*1 ISAVE(256,128),TSTVEC(375,84),ANDAR(256,64)
      LOGICAL LFUSES(128,256)
      COMMON /FPLOT/ ISAVE
      COMMON /TST2/ TSTVEC,ANDAR
      COMMON /LFS/LFUSES
C
      ISAVE(X,Y)=PAT
      RETURN
C
      ENTRY TSTWRT(X,Y,PAT)
      TSTVEC(X,Y)=PAT
      RETURN
C
      ENTRY ANDWRT(X,Y,PAT)
      ANDAR(X,Y)=PAT
      RETURN
C
      ENTRY LFSWRT(X,Y,PAT)
      LFUSES(X,Y)=PAT
      RETURN
      END
C
      INTEGER*2 FUNCTION ISVRD(X,Y)
      INTEGER*2 X,Y,PAT
C
      INTEGER*1 ISAVE(256,128),TSTVEC(375,84),ANDAR(256,64)
      LOGICAL LFUSES(128,256)
      COMMON /FPLOT/ ISAVE
      COMMON /TST2/ TSTVEC,ANDAR
      COMMON /LFS/LFUSES
C
      ISVRD=ISAVE(X,Y)
      RETURN
      END
C
      INTEGER*2 FUNCTION TSTRD(X,Y)
      INTEGER*2 X,Y,PAT
C
      INTEGER*1 ISAVE(256,128),TSTVEC(375,84),ANDAR(256,64)
      LOGICAL LFUSES(128,256)
      COMMON /FPLOT/ ISAVE
      COMMON /TST2/ TSTVEC,ANDAR
      COMMON /LFS/LFUSES
C
      TSTRD=TSTVEC(X,Y)
      RETURN
      END
C
      INTEGER*2 FUNCTION ANDRD(X,Y)
      INTEGER*2 X,Y,PAT
C
      INTEGER*1 ISAVE(256,128),TSTVEC(375,84),ANDAR(256,64)
      LOGICAL LFUSES(128,256)
      COMMON /FPLOT/ ISAVE
      COMMON /TST2/ TSTVEC,ANDAR
      COMMON /LFS/LFUSES
C
      ANDRD=ANDAR(X,Y)
      RETURN
      END
C
      INTEGER*2 FUNCTION LFSRD(X,Y)
      INTEGER*2 X,Y,PAT
C
      INTEGER*1 ISAVE(256,128),TSTVEC(375,84),ANDAR(256,64)
      LOGICAL LFUSES(128,256)
      COMMON /FPLOT/ ISAVE
      COMMON /TST2/ TSTVEC,ANDAR
      COMMON /LFS/LFUSES
C
      LFSRD=LFUSES(X,Y)
      RETURN
      END
C
C$$ PAL84.FOR
C PALASM84 FOR 64R32 FIRST REV ON 12/14/83
C*************************
C**PALASM84**PALASM84**PALASM84**PALASM84**PALASM84**PALASM84**PALASM84*
C
C PALASM 84  -  TRANSLATES SYMBOLIC EQUATIONS INTO PAL OBJECT CODE
C   FORMATTED FOR DIRECT INPUT TO STANDARD PROM AND PAL PROGRAMMERS.
C
C
C REV LEVEL: VERSION 1.8C 07/06/83 (C) COPYRIGHT 1983 MONOLITHIC MEMORIES
C
C  V1.8A - 2/23/84 - INITIAL RELEASE - INCORRECT PINOUT
C  V1.8B - 5/11/84 - CORRECT PINOUT, ANNOTATE FUSE PLOT, ADD FLUSH TO JEDEC
C  V1.8C - 7/6/84 - COMPRESS INPUT, ALLOW TABS,FFEED.
C
C INPUT:  PAL DESIGN SPECIFICATION ASSIGNED TO RPD.
C         OPERATION CODES ARE ASSIGNED TO ROP.
C
C OUTPUT: ECHO, SIMULATION, AND FUSE PATTERN ARE ASSIGNED TO POF.
C         JEDEC, HEX, AND BINARY PROGRAMMING FORMATS ARE ASSIGNED TO PDF
C         PROMPTS & ERROR MESSAGES ARE ASSIGNED TO PMS.
C
C PART NUMBER: THE PAL PART NUMBER MUST APPEAR IN COLUMN ONE OF LINE ONE.
C
C PIN LIST:  84 SYMBOLIC PIN NAMES MUST APPEAR STARTING ON LINE FIVE.
C
C EQUATIONS: STARTING FIRST LINE AFTER THE PIN LIST IN THE FOLLOWING FORMS:
C
C          A = B*C + D
C          A := B*C + D
C          IF( A*B )  C = D + E
C
C ALL CHARACTERS FOLLOWING ';' ARE IGNORED UNTIL THE NEXT LINE.
C          BLANKS ARE IGNORED.
C
C OPERATORS:   ( IN HIERARCHY OF EVALUATION )
C
C             ;    COMMENT FOLLOWS
C             /    COMPLEMENT
C             *    AND (PRODUCT)
C             +    OR (SUM)
C             :+:   XOR (EXCLUSIVE OR)
C             ( )   CONDITIONAL THREE-STATE
C             =    EQUALITY
C             :=    REPLACED BY (AFTER CLOCK)
C
C FUNCTION     L, H, X, Z, AND C ARE VALID
C TABLE:     FUNCTION TABLE VECTOR ENTRIES.
C
C REFERENCE:   A COMPLETE USERS GUIDE TO DESIGNING WITH PALS USING PALASM
C              IS PROVIDED IN THE MONOLITHIC MEMORIES PAL HANDBOOK.
C
C SUBROUTINES: INITLZ,GETSYM,INCR,MATCH,IXLATE,ECHO,CAT,PINOUT,FZPLT
C  PLOTF,SUMCHK,ICONV,HEX,SUMCHK,TWEEK,BINR,SLIP, FANTOM,TEST,INTEL
C
C AUTHORS:   JOHN BIRKNER AND VINCENT COLI
C            FAULT TESTING BY IMTIYAZ BENGALI
C            REVISED JEDEC FORMAT BY MANO VAFAI
C            MONOLITHIC MEMORIES INC.
C            2175 MISSION COLLEGE
C            SANTA CLARA, CALIFORNIA 95050
C            (408) 970-9700
C
C FINE PRINT: MONOLITHIC MEMORIES TAKES NO RESPONSIBILITY FOR THE OPERATION
C             OR MAINTENANCE OF THIS PROGRAM. THE SOURCE CODE AS PRINTED HERE
C             PRODUCED THE OBJECT CODE OF THE EXAMPLES IN THE APPLICATIONS
C             SECTION ON A VAX/VMS 11/780 COMPUTER WITH FORTRAN 77 AND A
C             NATIONAL CSS IBM SYSTEM/370 WITH FORTRAN IV (LEVEL G).
C
C*******************************
C
C     MAIN PROGRAM
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      INTEGER*1 FILE1(20),FILE2(20)
      INTEGER ITYPE,IONE,IBL
      INTEGER IC,IL,IC1,J,K,I,I88PRO,I8PRO,OUTPIN
      INTEGER IPROD,COUNT,IBLOW,ILL,ILERR,IIL,IINPUT,ILE,ORCNT,IMATCH
C
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
C
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
      INTEGER*1 ISYM(8,84),IBUF(8,84),IPCNT(80),DDD(128),PPP(84)
C
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LFIRST,
     1        LMATCH,LFSE(84),LBUF(84),LPROD(256),FLFUSE(4,2),FLFLG,
     3        LSAME,LACT,LOPERR,LINP,LERR,ODFLG,EVFLG,LFEED(84)
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR
      INTEGER IDESC,IFUNCT,IEND,SINGLE
      COMMON /FTEST/IFUNCT,IDESC,IEND
      DATA E/'E'/,O/'O'/,T/'T'/,P/'P'/,B/'B'/,D/'D'/,H/'H'/,S/'S'/,
     1     L/'L'/,N/'N'/,C/'C'/,Q/'Q'/,U/'U'/,F/'F'/,Y/'Y'/,W/'W'/
      DATA BB/'B'/,CC/'C'/,DD/'D'/,EE/'E'/,FF/'F'/,II/'I'/,NN/'N'/,
     1     OO/'O'/,PP/'P'/,RR/'R'/,SS/'S'/,TT/'T'/,UU/'U'/,JJ/'J'/
      DATA BEL/007/,IONE/1/,IBLANK/' '/,IBL/0/,TAB/9/,FFEED/12/
C
C
      CALL IOINIT
C
    8 WRITE(CONOUT,1)
    1 FORMAT(/,' MONOLITHIC MEMORIES 84 PIN PALASM (tm) VERSION 1.8C',
     1       /' (C) COPYRIGHT 1984 MONOLITHIC MEMORIES')
C
C     ASSIGNMENT OF DATA SET REFERENCES
C     RPD - PAL DESIGN SPECIFICATION (INPUT FROM DATA FILE)
C     ROC - OPERATION CODE (INPUT FROM TERMINAL)
C     POF - ECHO, SIMULATION AND TRUTH TABLES (OUTPUT)
C     PDF - HEX AND BINARY PROGRAMMING FORMATS (OUTPUT)
C     PMS - PROMPTS AND ERROR MESSAGES (OUTPUT TO TERMINAL)
C
      ROC=CONINP
      PMS=CONOUT
    4 WRITE(CONOUT,2)
    2 FORMAT(/,' WHAT IS THE SOURCE FILENAME (d:filename.ext) ?: '$)
      READ(CONINP,3) (FILE1(I),I=1,20)
    3 FORMAT(20A1)
      IF(KREAD(FILINP,2,0,FILE1) .NE. 0) GO TO 130
      WRITE(CONOUT,333)
  333 FORMAT(/,' OUTPUT FILENAME -',
     1         ' PRESS <ENTER> FOR NO OUTPUT FILE ?: '$)
      READ(CONINP,3) (FILE2(I),I=1,20)
      LUN=CONOUT
      IF(FILE2(1).EQ.IBLANK) GO TO 9
      IF(KWRIT(FILOUT,2,0,FILE2) .NE. 0) GO TO 130
      LUN=FILOUT
    9 RPD=FILINP
      POF=LUN
      PDF=LUN
      IFUNCT=0
      IDESC=0
C
C
C     INITIALIZE FUSE PLOT INFORMATION
      DO 8335 I=1,256
      LPROD(I)=.FALSE.
      DO 8335 J=1,128
 8335 CALL ISVWRT(I,J,IBL)
C
C     INITIALISE FLFUSE TO BE INTACT AND ALL OUTPUTS ARE ASSUMED
C     TO BE REGISTERED AND NOT USED IN FEEDBACK
      FLFUSE(1,1)=.FALSE.
      FLFUSE(1,2)=.FALSE.
      FLFUSE(2,1)=.FALSE.
      FLFUSE(2,2)=.FALSE.
      FLFUSE(3,1)=.FALSE.
      FLFUSE(3,2)=.FALSE.
      FLFUSE(4,1)=.FALSE.
      FLFUSE(4,2)=.FALSE.
      DO 804 I=1,84
      LFEED(I)=.FALSE.
  804 LBYPAS(I)=.FALSE.
C     INITIALIZE LSAME AND LACT TO FALSE (ACTIVE HIGH/LOW ERROR)
      LSAME=.FALSE.
      LACT=.FALSE.
C     INITIALIZE LOPERR TO FALSE (OUTPUT PIN ERROR)
      LOPERR=.FALSE.
C     INITILIZE LINP TO FALSE (INPUT PIN ERROR)
      LINP=.FALSE.
C     INITIALISE LPRD TO FALSE (PRODUCT LINE ERROR)
      LPRD=.FALSE.
C

C
C     READ IN FIRST 4 LINES OF PAL DESIGN SPECIFICATION
C
      READ(RPD,7) IPAL,INAME,(REST(J),J=1,72),
     1 (PATN(J),J=1,79),(TITLE(J),J=1,79),(COMP(J),J=1,79)
   7  FORMAT(3A1,5A1,72A1,/,79A1,/,79A1,/,79A1)
C
      DO 1115 J=1,72
C     SECURITY FUSE 
1115      IF ((REST(J).EQ.SS).AND.(REST(J+1).EQ.EE)
     1 .AND.(REST(J+2).EQ.CC))     DOIT =.TRUE. 
C
      LNPTR=0
      LNMAX=0
10    READ(RPD,5,ENDFILE=15) (CLN(IC),IC=1,80)
5     FORMAT(80A1)
      WRITE (CONOUT,9001)
      LNMAX=LNMAX+1
C
C
      CLN(80)=IBLANK
      J=81
11    J=J-1
      IF (CLN(J) .EQ. TAB) CLN(J)=IBLANK
      IF (CLN(J) .EQ. FFEED) CLN(J)=IBLANK
      IF (J.GT. 1 .AND. CLN(J).EQ.IBLANK) GOTO 11
C
      LOF(LNMAX)=LNPTR
      LLN(LNMAX)=J
      J=0
      SINGLE=0
12    J=J+1
      IF (CLN(J) .EQ. TAB) CLN(J)=IBLANK
      IF (CLN(J) .EQ. FFEED) CLN(J)=IBLANK
      IF (CLN(J) .NE. IBLANK) SINGLE=0
      IF (CLN(J) .EQ. IBLANK) SINGLE=SINGLE+1
      IF (SINGLE .GE. 2) GOTO 12
      LNPTR=LNPTR+1
      CPG(LNPTR)=CLN(J)
C      IF (J.LT. LLN(LNMAX)) GOTO 12
      IF (J.LT. LLN(LNMAX) .AND. CLN(J) .NE. ';') GOTO 12
C
      LNPTR=LNPTR+1
      CPG(LNPTR)=IBLANK
      LLN(LNMAX)=LNPTR-LOF(LNMAX)
C
      IF (LNPTR .GT. 9000) WRITE (PMS,13)
13    FORMAT (1X,'TOO MANY CHARACTERS IN INPUT FILE')
C
C     CHECK FOR 'FUNCTION TABLE' AND SAVE ITS LINE NUMBER
C
      IF(.NOT.(CLN(1).EQ.FF.OR.CLN(1).EQ.DD)) GO TO 10
      IF(   IFUNCT.EQ.0 .AND.CLN(1).EQ.FF.AND.
     1    CLN(2).EQ.UU.AND.CLN(3).EQ.NN.AND.
     2    CLN(4).EQ.CC.AND.CLN(5).EQ.TT.AND.
     3    CLN(6).EQ.II.AND.CLN(7).EQ.OO.AND.
     4    CLN(8).EQ.NN.AND.CLN(10).EQ.TT.AND.
     5    CLN(12).EQ.BB.AND.CLN(14).EQ.EE ) IFUNCT=LNMAX
C
C     CHECK FOR 'DESCRIPTION' AND SAVE ITS LINE NUMBER
C
      IF(    IDESC.EQ.0 .AND.CLN(1).EQ.DD.AND.
     1    CLN(2).EQ.EE.AND.CLN(3).EQ.SS.AND.
     2    CLN(4).EQ.CC.AND.CLN(5).EQ.RR.AND.
     3    CLN(6).EQ.II.AND.CLN(7).EQ.PP.AND.
     4    CLN(8).EQ.TT.AND.CLN(9).EQ.II.AND.
     5    CLN(10).EQ.OO.AND.CLN(11).EQ.NN ) IDESC=LNMAX
C
      GOTO 10
C
C     SAVE THE LAST LINE NUMBER OF THE PAL DESIGN SPECIFICATION
C
   15 IEND=LNMAX
      WRITE(PMS,16) LNMAX,LNPTR
16    FORMAT (1X,'PAL DESIGN FILE READ - ',I5,' LINES',I6,' CHARACTERS'
     2 ' (MAXIMUM=9000)',/)
C
      CALL INITLZ(ITYPE,IPCNT,IC,IL,IBLOW)
C     PRINT ERROR MESSAGE FOR INVALID PAL PART TYPE
      IF(ITYPE.NE.0) GO TO 17
      WRITE(PMS,18) IPAL,INAME
   18 FORMAT(/,' PAL PART TYPE ',3A1,5A1,' IS INCORRECT')
      STOP
C     GET 84 PIN NAMES
   17 DO 20 J=1,84
   20     CALL GETSYM(LFSE,ISYM,J,IC,IL,FLFLG)
          IF(.NOT.(LEQUAL.OR.LLEFT.OR.LAND.OR.LOR.OR.LRIGHT)) GO TO 24
              WRITE(PMS,23)
   23         FORMAT(/, ' LESS THAN 84 PIN NAMES IN PIN LIST')
              STOP
   24 ILE=IL
C     BYPASS FUSE PLOT ASSEMBLY IF HAL ('H' IN LINE 1, COLUMN 1)
      IF( IPAL(1).EQ.H ) GO TO 108
   25 CALL GETSYM(LBUF,IBUF,IONE,IC,IL,FLFLG)
   28     IF(.NOT.LEQUAL) GO TO 25
      WRITE (CONOUT,9001)
9001  FORMAT (1X,'.'$)
          EVFLG=.FALSE.
          ODFLG=.FALSE.
          COUNT=0
          ORCNT=0
          ILL=IL
          CALL MATCH(IMATCH,IBUF,ISYM)
          IF( IMATCH.EQ.0 ) GO TO 100
C         CHECK WHETHER THEE OUTPUT IS BYPASED OR NOT. ALSO
C         AN ERROR IS REPORTED IF THRE IS A CONFLICT IN A
C         SET OF OUTPUT
          CALL BYPAS(FLFUSE,FLFLG,LFEED,ISYM,IMATCH)
C         CHECK FOR VALID POLARITY (ACTIVE LOW)
          LSAME = ( (     LFSE(IMATCH)).AND.(     LBUF(1)).OR.
     1              (.NOT.LFSE(IMATCH)).AND.(.NOT.LBUF(1)) )
          IF(LSAME) LPOLAR(IMATCH)=.TRUE.
          IF(.NOT.LSAME) LPOLAR(IMATCH)=.FALSE.
C         CHECK FOR VALID OUTPUT PIN
          IF((ITYPE.EQ.1).AND.(IMATCH.LT.14).AND.(IMATCH.GT.29)
     1    .AND.(IMATCH.LT.56).AND.(IMATCH.GT.71)) LOPERR=.TRUE.
C         IF THE OUTPIN IS EVEN E.G. PIN14, PIN16 ETC. THEN THE
C         PRODUCT TERMS ARE COUNTED FROM TOP TO BOTTOM
          OUTPIN=IMATCH
          IF (IMATCH.LE.29.AND.(MOD(IMATCH,2).EQ.0))
     1       I88PRO=8*IMATCH-112
          IF (MOD(IMATCH,2).NE.0) ODFLG=.TRUE.
          IF (MOD(IMATCH,2).EQ.0) EVFLG=.TRUE.
C         IF THE OUPUT PIN IS ODD E.G. PIN 15, PIN17 ETC.
C         THEN THE PRODUCT TERMS ARE COUNTED FROM BOTTOM TO TOP
          IF (IMATCH.LE.29.AND.(MOD(IMATCH,2).NE.0))
     1        I88PRO=8*IMATCH-103
C         CALCULATING THE OFFSET I88PRO FOR OUTPINS 56..71
          IF(IMATCH.GE.56.AND.(MOD(IMATCH,2).EQ.0))
     1       I88PRO=8*IMATCH-320
          IF(IMATCH.GE.56.AND.(MOD(IMATCH,2).NE.0))
     1       I88PRO=8*IMATCH-311
          IC=0
   30       CALL INCR(IC,IL,FLFLG)
            IF( .NOT.(LEQUAL.OR.LLEFT) ) GO TO 30
C
          DO 70 I8PRO=1,16
              COUNT=COUNT+1
          IF (EVFLG)IPROD=I88PRO + I8PRO
          IF (ODFLG)IPROD=I88PRO-I8PRO
C         THE TOTAL NUMBER OF PRODUCT TERMS ASSOCIATED WITH A PARTICULAR
C         OUTPUT. THIS IS TO CHECK FOR MAXIMUM OF 16 PRDCT TERMS FOR A PAIR
C         OF OUTPUTS. ORCNT IS THE NUMBER OF PRODUCT TERMS FOR A PAIR OF
C         OUTPUTS.
              IPCNT(OUTPIN)=IPCNT(OUTPIN)+1
              IF(MOD(OUTPIN,2).EQ.0)ORCNT=IPCNT(OUTPIN)+IPCNT(OUTPIN+1)
              IF(MOD(OUTPIN,2).NE.0)ORCNT=IPCNT(OUTPIN)+IPCNT(OUTPIN-1)
              LPROD(IPROD)=.TRUE.
              LFIRST=.TRUE.
   50           ILL=IL
                CALL GETSYM(LBUF,IBUF,IONE,IC,IL,FLFLG)
C         CHECK FOR EXACT NUMBER OF PRODUCT TERMS PER PAIR OF OUTPUTS.
C         IF THE TOTAL NUMBER OF PRODUCT TERMS EXCEED 16 THEN LPRD
C         IS TRUE AND FLG ERROR MESSAGE.
               IF (ORCNT.GT.16) LPRD=.TRUE.
               IF (.NOT.LPRD) GO TO 69
          WRITE(PMS,118) BEL
  118     FORMAT(1X,A1)
          WRITE(PMS,119) IMATCH
  119     FORMAT(' TOO MANY PRODUCT TERMS SPECIFIED FOR'
     1           ' THIS OUTPUT PAIR ' I2 )
          WRITE(PMS,117) ORCNT
  117     FORMAT(/,' THE PRODUCT TERMS ARE  ' I2 )
          STOP
   69           CALL MATCH(IMATCH,IBUF,ISYM)
C         IF THE PARICULAR SIGNAL IS AN OUTPUT AND USED IN
C         FEEDBACK THEN SET THE CORRESPONDING FLG IN LFEED TRUE
          IF(((IMATCH.GE.14).AND.(IMATCH.LE.29))
     1      .OR.((IMATCH.GE.56).AND.(IMATCH.LE.71)))
     2           LFEED(IMATCH)=.TRUE.
C               CHECK FOR INVALID INPUT PIN
                IF((IMATCH.GE.9.AND.IMATCH.LE.13)
     1             .OR. (IMATCH .GE.30 .AND. IMATCH .LE. 34)
     2             .OR. (IMATCH.GE.51.AND.IMATCH.LE.55)
     4             .OR. (IMATCH.GE.72 .AND.IMATCH.LE.76))
     3              LINP=.TRUE.
                ILL=IL
                IF(LINP) GO TO 100
                IF(IMATCH.EQ.0) GO TO 100
                IF((IMATCH.EQ.11).OR.(IMATCH.EQ.53)) GO TO 64
                IF(.NOT.LFIRST) GO TO 58
C
C      WHEN THE PRODUCT TERM IS FIRST TIME TO BE USED, THE
C      CORESPONDING FUSES IN THE ORARRAY ARE  BLOWNED
C      DEPENDING ON ODD OR EVEN OUTPUT PIN. THE ODD PIN
C      IS CONNECTED TO THE FIRST COLUMN OF OR ARRAY. IF
C      THE FUSE IN THE FIRST COLUMN IS NOT BLOWN AND THE PRODUCT TERM
C      IS USED THEN THE FUSE IN THE SECOND COLUMN IS BLOWN. IF THE
C      PRODUCT TERM IS NOT USED BOTH FUSES ARE LEFT INTACT.
C
      IF((ODFLG).AND.(LFIRST).AND.LPROD(IPROD))
     1     LORARY(1,IPROD)=.FALSE.
      IF((ODFLG).AND.(LFIRST).AND.(LPROD(IPROD)))
     1              LORARY(2,IPROD)=.TRUE.
      IF((EVFLG).AND.(LFIRST).AND.LPROD(IPROD))
     1              LORARY(2,IPROD)=.FALSE.
      IF((EVFLG).AND.(LFIRST).AND.(LPROD(IPROD)))
     1              LORARY(1,IPROD)=.TRUE.
                IBLOW = IBLOW+1
                    LFIRST=.FALSE.
                    DO 56 I=1,128
                        IBLOW = IBLOW + 1
   56                   CALL LFSWRT(I,IPROD,IONE)
   58           CALL IXLATE(IINPUT,LFSE,IMATCH,LBUF,ISYM,ITYPE)
                IF(IINPUT.LE.0) GO TO 60
                IBLOW = IBLOW - 1
                CALL LFSWRT(IINPUT,IPROD,IBL)
                CALL PLOT(LBUF,IBUF,IPROD,.FALSE.,ITYPE,LPROD,IOP,IBLOW)
   60           IF(LAND) GO TO 50
   64           IF(.NOT.LRIGHT) GO TO 68
   66           CALL INCR(IC,IL,FLFLG)
                IF(.NOT.LEQUAL) GO TO 66
   68         IF( .NOT.(LOR.OR.LEQUAL) ) GO TO 74
   70         CONTINUE
   74     ILL=IL
          CALL GETSYM(LBUF,IBUF,IONE,IC,IL,FLFLG)
C
           IF(LLEFT.OR.LEQUAL) GO TO 28
  100 IF( ILL.EQ.IFUNCT.OR.ILL.EQ.IDESC.OR.ILL.EQ.IEND ) GO TO 108
C     PRINT AN ERROR MESSAGE FOR AN UNRECOGNIZABLE SYMBOL
      ILERR=ILL+4
      WRITE(PMS,99) BEL
   99 FORMAT(1X,A1)
      WRITE(PMS,101) (IBUF(I,1),I=1,8),ILERR,
     1 (CPG(I),I=(LOF(IL)+1),(LOF(IL)+LLN(IL)))
  101 FORMAT(/,' ERROR SYMBOL =  ',8A1,'      IN LINE NUMBER ',I3,
     1       /,1X,80A1)
C     PRINT AN ERROR MESSAGE FOR ACTIVE HIGH/LOW ERRORS
      IF( (LACT).AND.(.NOT.LOPERR) ) WRITE(PMS,103) IPAL,INAME
  103 FORMAT(' OUTPUT MUST BE INVERTED SINCE ',3A1,5A1,
     1       ' IS AN ACTIVE LOW DEVICE')
C     PRINT AN ERROR MESSAGE FOR AN INVALID OUTPUT PIN
      IF( (LOPERR).AND.IMATCH.NE.0 ) WRITE(PMS,105) IMATCH,IPAL,INAME
  105 FORMAT(' THIS PIN, NUMBER ',I2,' IS AN INVALID OUTPUT PIN',
     1       ' FOR ',3A1,5A1)
C     PRINT AN ERROR MESSAGE FOR AN INVALID INPUT PIN
      IF(LINP) WRITE(PMS,115) IMATCH,IPAL,INAME
  115 FORMAT(' THIS PIN NUMBER ',I2,' IS AN INVALID INPUT PIN',
     1       ' FOR ',3A1,5A1)
      STOP
C
108   WRITE(PMS,107)
  107 FORMAT(/,' E=ECHO INPUT    O=PINOUT     P=PLOT ',
     1       /,' D=DOCUMENT      S=SIMULATE   T=TEST GENERATE',
     2       /,' J=JEDEC FORMAT  C=CATALOG    Q=QUIT')
      WRITE(PMS,110)
  110 FORMAT(/,' ENTER OPERATION CODE: ',$)
      READ(ROC,120) IOP
  120 FORMAT(A1)
C
      IF (IOP .GT. Y) IOP=IOP-32
      IF(POF.NE.CONOUT) WRITE(POF,125)
  125 FORMAT('1')
C
      IF(IOP.EQ.E) CALL ECHO
      IF(IOP.EQ.O) CALL PINOUT
      IF(IOP.EQ.P) CALL XPLOT(FLFUSE,IBLOW)
      IF(IOP.EQ.C) CALL CAT
      IF(IOP.EQ.JJ) CALL JEDEC(DOIT)
C      IF(IOP.EQ.T) CALL TSTGEN
C      IF(IOP.EQ.S) CALL TEST(LFSE,ISYM,IC,IL,ILE,FLFUSE,NVECT)
      IF(IOP.NE.Q) GO TO 108
C
  315 I=KCLOS(FILINP)
      IF(LUN.NE.CONOUT) I=KCLOS(FILOUT)
  320 WRITE(PMS,325)
  325 FORMAT(1X,'RESTART PALASM (Y/N) ?: '$)
      READ(CONINP,3) (FILE1(I),I=1,20)
      IF(FILE1(1).EQ.'Y') GO TO 8
      IF(FILE1(1).EQ.IBLANK) STOP
      IF(FILE1(1).NE.'N') GO TO 320
      STOP
  130 WRITE(PMS,335)
  335 FORMAT(/,' DISK I/O ERROR - MAYBE WRONG FILENAME ???')
      GO TO 315
      END
C
C$$ X8.FOR
C*****************
C
      SUBROUTINE TSTGEN
C     THIS SUBROUTINE GENERATES TEST VECTORS AUTOMATICALLY
C     FOR THE FUSEPLOT PERSONALISED FOR A PARTICULAR APPLICATION
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J,OUT,K,PT1,PT11,PT12,TSTCNT,IDONT,IONE,IZERO
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
C
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      DATA    L/'L'/,H/'H'/,DASH/'-'/,CROSS/'X'/,ZERO/'0'/,
     1  ONE/'1'/,DONT/'D'/,CLOCK/'C'/,P/'P'/,IDONT/3/,IONE/1/,IZERO/0/
C     INITIALISE THE LAND TO LOGICAL DONT CARE
      DO 5 I=1,256
      DO 5 J=1,64
      CALL ANDWRT(I,J,IDONT)
    5 CONTINUE
      TSTCNT=0
C    MAPPING LFUSES INTO LAND WHICH REPRESENTS THE LOGICAL
C    1 OR 0 FOR A PRESENCE OR ABSENCE OF A FUSE UNDER AN INPUT PIN.
C    FOR E.G. A 'X' UNDER /PIN 1 IN LFUSES IS LOGICAL 0 IN LAND.
C    SIMILAIRLY A 'X' UNDER PIN 1 IN LFUSES IS LOGICAL 1 IN LAND.
      DO 10 J=1,256
      K=1
      DO 10 I=1,128,2
      IF((I.EQ.1).OR.(I.EQ.3).OR.(I.EQ.5).OR.(I.EQ.7).OR.(I.EQ.9)
     1 .OR.(I.EQ.11).OR.(I.EQ.13).OR.(I.EQ.15).OR.(I.EQ.17)
     2 .OR.(I.EQ.19).OR.(I.EQ.21).OR.(I.EQ.23).OR.(I.EQ.27)
     3 .OR.(I.EQ.29).OR.(I.EQ.31).OR.(I.EQ.97).OR.(I.EQ.99)
     4 .OR.(I.EQ.101).OR.(I.EQ.103).OR.(I.EQ.105).OR.(I.EQ.107)
     5 .OR.(I.EQ.109).OR.(I.EQ.111).OR.(I.EQ.113).OR.(I.EQ.115)
     6 .OR.(I.EQ.117).OR.(I.EQ.119).OR.(I.EQ.121).OR.(I.EQ.123)
     7 .OR.(I.EQ.125).OR.(I.EQ.127))   GO TO 11
      IF((I.EQ.33).OR.(I.EQ.35).OR.(I.EQ.37).OR.(I.EQ.39)
     1 .OR.(I.EQ.41).OR.(I.EQ.43).OR.(I.EQ.45).OR.(I.EQ.47)
     2 .OR.(I.EQ.49).OR.(I.EQ.51).OR.(I.EQ.53).OR.(I.EQ.55)
     3 .OR.(I.EQ.57).OR.(I.EQ.59).OR.(I.EQ.61).OR.(I.EQ.63)
     4 .OR.(I.EQ.65).OR.(I.EQ.67).OR.(I.EQ.69).OR.(I.EQ.71)
     5 .OR.(I.EQ.73).OR.(I.EQ.75).OR.(I.EQ.77).OR.(I.EQ.79)
     6 .OR.(I.EQ.81).OR.(I.EQ.83).OR.(I.EQ.85).OR.(I.EQ.87)
     7 .OR.(I.EQ.89).OR.(I.EQ.91).OR.(I.EQ.93).OR.(I.EQ.95))
     8     GO TO 12
   10 CONTINUE
      WRITE(POF,1)TITLE
    1 FORMAT(/,80A1,//)
      WRITE(POF,2)
    2 FORMAT(/,'  TEST VECTORS')
      WRITE(POF,3)
    3 FORMAT(/,' PIN',' PDCT','  ','         11111111112222222222',
     1         '3333333333444444444455555555556666666666',
     2         '777777777788888',/,
     3         '           12345678901234567890123456789',
     4         '0123456789012345678901234567890',
     5         '123456789012345678901234','  ',' LSA0',' LSA1')

      GO TO 13
   11 IF((LFSRD(I,J)).AND.(.NOT.LFSRD(I+1,J)))
     1    CALL ANDWRT(J,K,IONE)
      IF((.NOT.LFSRD(I,J)).AND.(LFSRD(I+1,J)))
     2    CALL ANDWRT(J,K,IZERO)
      K=K+1
      GO TO 10
   12 IF((LFSRD(I,J)).AND.(.NOT.LFSRD(I+1,J)))
     1    CALL ANDWRT(J,K,IZERO)
      IF((.NOT.LFSRD(I,J)).AND.(LFSRD(I+1,J)))
     2    CALL ANDWRT(J,K,IONE)
      K=K+1
      GO TO 10
C
   13 DO 15 OUT=14,29
      IF ((OUT.EQ.14).OR.(OUT.EQ.15)) K=1
      IF ((OUT.EQ.16).OR.(OUT.EQ.17)) K=17
      IF ((OUT.EQ.18).OR.(OUT.EQ.19))K=33
      IF ((OUT.EQ.20).OR.(OUT.EQ.21))K=49
      IF ((OUT.EQ.22).OR.(OUT.EQ.23))K=65
      IF ((OUT.EQ.24).OR.(OUT.EQ.25))K=81
      IF ((OUT.EQ.26).OR.(OUT.EQ.27))K=97
      IF ((OUT.EQ.28).OR.(OUT.EQ.29))K=113
C     INITIALISING THE FAULTS COVERED BY A TEST VECTOR AS FALSE
C     ALL THE TEST VECTORS ARE INITIALISED TO DONT CARE VALUES
      DO 6 I=1,375
      DO 6 J=1,84
      CALL TSTWRT(I,J,IDONT)
      PARRY(I)=ZERO
      LTST(I)=.FALSE.
      LSA01(I,1)=.FALSE.
      LSA01(I,2)=.FALSE.
    6 CONTINUE
C
      PT1=1
      CALL TEST1(K,OUT,PT1,PT11)
      CALL TEST2(K,OUT,PT1,PT11,PT12)
      CALL EXCLSV(PT11,PT12,PT1)
      CALL PROUT(PT11,PT12,PT1,OUT)
      TSTCNT=TSTCNT+PT1-1
   15 CONTINUE
      DO 20 OUT=56,71
      IF((OUT.EQ.56).OR.(OUT.EQ.57)) K=129
      IF((OUT.EQ.58).OR.(OUT.EQ.59)) K=145
      IF((OUT.EQ.60).OR.(OUT.EQ.61)) K=161
      IF((OUT.EQ.62).OR.(OUT.EQ.63)) K=177
      IF((OUT.EQ.64).OR.(OUT.EQ.65)) K=193
      IF((OUT.EQ.66).OR.(OUT.EQ.67)) K=209
      IF((OUT.EQ.68).OR.(OUT.EQ.69)) K=225
      IF((OUT.EQ.70).OR.(OUT.EQ.71)) K=241
C     INITIALISING THE FAULTS COVERED BY A TEST VECTOR AS FALSE
C     ALL THE TEST VECTORS ARE INITIALISED TO DONT CARE VALUES
      DO 16 I=1,375
      DO 16 J=1,84
      CALL TSTWRT(I,J,IDONT)
      PARRY(I)=ZERO
      LTST(I)=.FALSE.
      LSA01(I,1)=.FALSE.
      LSA01(I,2)=.FALSE.
   16 CONTINUE
C
      PT1=1
      CALL TEST1(K,OUT,PT1,PT11)
      CALL TEST2(K,OUT,PT1,PT11,PT12)
      CALL EXCLSV(PT11,PT12,PT1)
      CALL PROUT(PT11,PT12,PT1,OUT)
      TSTCNT=TSTCNT+PT1-1
   20 CONTINUE
      WRITE(POF,25) TSTCNT
   25 FORMAT(/,'TOTAL NUMBER OF TEST VECTORS ARE',I6)
      RETURN
      END
C
C*******************************
C
      SUBROUTINE XFER(I,PT1)
C     THIS SUBTOUTINE TRANSFERS THE VECTOR IN LAND MATRIX TO
C     APPROPRIATE PLACES IN THE TSTVEC MATRIX
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J,OUT,PT1,TMP
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
C
      INTEGER XA(64),XB(64)
C
C23456789A123456789B123456789C123456789D123456789E123456789F123456789G123
      DATA XA/1,2,3,4,5,6,7,8,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
     2   28,29,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,56,57,58,
     3   59,60,61,62,63,64,65,66,67,68,69,70,71,77,78,79,80,81,82,83,84/
      DATA XB/1,3,5,7,9,11,13,15,2,4,6,8,10,12,14,16,17,19,21,23,25,27,
     2  29,31,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,33,35,37,
     3  39,41,43,45,47,50,52,54,56,58,60,62,64,49,51,53,55,57,59,61,63/
C
      DO 100 J=1,64
      TMP=ANDRD(I,XB(J))
100   CALL TSTWRT(PT1,XA(J),TMP)
      RETURN
      END
C
C******************
C
      SUBROUTINE TEST1(K,OUT,PT1,PT11)
C     THIS SUBROUTINE GENERATES THE FIRST SET OF TEST VECTORS
C     THESE TEST VECTORS ARE GNERATED SUCH THAT FOR EVERY OUTPUT
C     EACH PRODUCT TERM IS SUCCESSIVELY 'TURNED ON'. THUS THESE
C     VECTORS IN EFFECT TEST FOR A FUSELINK SA0
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J,K,OUT,PT1,PT11,L
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
C
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
      LOGICAL  COVERF
      DATA     ZERO/'0'/,ONE/'1'/,DONT/'D'/
C     CHECK WHETHER A PARTICULAR PRODUCT TERM IS USED OR NOT FOR
C     THAT PARTICULAR OUTPUT
      L=K+15
      DO 15 I=K,L
      IF((MOD(OUT,2).NE.0).AND.(.NOT.LORARY(1,I)).AND.(LORARY(2,I)))
     1 GO TO 10
      IF((MOD(OUT,2).EQ.0).AND.(LORARY(1,I)).AND.(.NOT.LORARY(2,I)))
     2 GO TO 10
   15 CONTINUE
      PT11=PT1-1
      RETURN
   10 CALL XFER(I,PT1)
      LTST(PT1)=.TRUE.
      PARRY(PT1)=I
      LSA01(PT1,1)=.TRUE.
      LSA01(PT1,2)=.FALSE.
      PT1=PT1+1
      GO TO 15
      END
C**************
C
C
      SUBROUTINE TEST2(K,OUT,PT1,PT11,PT12)
C     THIS SUBROUTINE GENERATES TEST VECTORS FOR STEP2. EACH
C     FUSELINK IS TESTED FOR SA1 TEST. THUS VECTORS IN THIS
C     SET OF TEST VECTORS WILL TEST FOR EACH FUSE FOR SA1
C     TEST. THE FAULT FREEE OUTPUT SHOULD BE ZERO.
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER J,I,OUT,PT1,PT11,PT12,K,L,DONT,ONE,ZERO
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
C
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
      DATA    ZERO/0/,ONE/1/,DONT/3/
      L=K+15
      DO 15 I=K,L
      IF((MOD(OUT,2).EQ.0).AND.(LORARY(1,I))
     1 .AND.(.NOT.LORARY(2,I))) GO TO 10
      IF((MOD(OUT,2).NE.0).AND.(.NOT.LORARY(1,I))
     1 .AND.(LORARY(2,I))) GO TO 10
   15 CONTINUE
      PT12=PT11+1
      RETURN
   10 DO 11 J=1,64
C     COMPLEMENTING EACH FUSE
      IF ((ANDRD(I,J) .EQ.DONT)) GO TO 11
      IF((ANDRD(I,J).EQ.ONE)) GO TO 20
      IF((ANDRD(I,J).EQ.ZERO)) GO TO 21
   24 CALL XFER(I,PT1)
C     CHANGING THE FUSE BIT TO ORIGINAL VALUE
      IF((ANDRD(I,J).EQ.ZERO)) GO TO 22
      IF((ANDRD(I,J).EQ.ONE))  GO TO 23
   25 LSA01(PT1,1)=.FALSE.
      LSA01(PT1,2)=.TRUE.
      LTST(PT1)=.TRUE.
      PARRY(PT1)=I
      PT1=PT1+1
   11 CONTINUE
      GO TO 15
   20 CALL ANDWRT(I,J,ZERO)
      GO TO 24
   21 CALL ANDWRT(I,J,ONE)
      GO TO 24
   22 CALL ANDWRT(I,J,ONE)
      GO TO 25
   23 CALL ANDWRT(I,J,ZERO)
      GO TO 25
      END
C****************
C
      SUBROUTINE EXCLSV(PT11,PT12,PT1)
C     THIS SUBROUTINE MAKES EACH VECTOR GENERATED IN TEST 1
C     MUTUALLY EXCLUSIVE. FOR E.G. IF IN VECTOR V1 THERE IS
C     '1' OR '0' IN BIT 1 AND 'X' IN VECTOR 2 AT THE SAME BIT,
C     THEN VECTORS V1 AND V2 ARE MADE MUTUALLY EXCLSIVE BY
C     CHANGING 'X' TO '0' OR '1'
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER J,I,L,PT1,PT12,PT11,DONT,ZERO,ONE,TMP
      LOGICAL  COVERF
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
C
      DATA    ZERO/0/,ONE/1/,DONT/3/
C
      IF ((PT11+PT1) .LT. 375) GOTO 3
      WRITE (6,8005) PT11,PT12,PT1
8005  FORMAT (' ERROR: TOO MANY VECOTORS TO MAKE EXCLUSIVE:',3I5)
      GOTO 25
C
C     MAKE A COPY OF TEST VECTORS
3     DO 5 I=1,PT11
      DO 5 J=1,84
      TMP=TSTRD(I,J)
    5 CALL TSTWRT(375-I,J,TMP)
      DO 25  I=1,PT11
      DO 25  J=1,PT11
      IF (J.EQ.I) GO TO 25
C     INITIALLY ALL VECTORS ARE ASSUMED TO BE COVERED
      COVERF=.TRUE.
      DO 10 L=1,84
      IF(((TSTRD(375-I,L).EQ.ZERO).AND.(TSTRD(375-J,L).EQ.ONE))
     1  .OR.((TSTRD(375-I,L).EQ.ONE).AND.(TSTRD(375-J,L).EQ.ZERO)))
     2 COVERF=.FALSE.
   10 CONTINUE
      IF (.NOT.COVERF) GO TO 25
   15 DO 20 L=1,84
      IF ((TSTRD(375-I,L).EQ.DONT).AND.(TSTRD(375-J,L).EQ.ZERO)
     1 .AND.(COVERF)) GO TO 22
      IF((TSTRD(375-I,L).EQ.DONT).AND.(TSTRD(375-J,L).EQ.ONE)
     1 .AND.(COVERF)) GO TO 24
   20 CONTINUE
      IF(COVERF) GO TO 25
   22 CALL TSTWRT(I,L,ONE)
      COVERF=.FALSE.
      GO TO 25
   24 CALL TSTWRT(I,L,ZERO)
      COVERF=.FALSE.
      GO TO 25
   25 CONTINUE
      RETURN
      END
C
C*****************************
C
      SUBROUTINE PROUT(PT11,PT12,PT1,OUT)
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J,K,LL,L,PT1,PT11,PT12,OUT,PT,IONE,IZE,IDN
C
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
C
      INTEGER*1 TMP(86)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      DATA    ZERO/'0'/,ONE/'1'/,DONT/'D'/,DASH/'-'/,CROSS/'X'/,
     1        P/'P'/,CLOCK/'C'/,IONE/1/,IZE/0/,IDN/3/
      DO 35 I=1,PT11
      WRITE(POF,16)OUT,PARRY(I)-1
   16 FORMAT(/,1X,I3,1X,I3)
      DO 17 L=1,84
      IF (TSTRD(I,L) .EQ. IONE) TMP(L)=ONE
      IF (TSTRD(I,L) .EQ. IZE) TMP(L)=ZERO
      IF (TSTRD(I,L) .EQ. IDN) TMP(L)=DONT
      IF((L.EQ.11).OR.(L.EQ.53)) TMP(L)=ZERO
      IF((L.EQ.32).OR.(L.EQ.74)) TMP(L)=ONE
      IF((L.EQ.13).OR.(L.EQ.30).OR.(L.EQ.55).OR.(L.EQ.72)) TMP(L)=ONE
      IF((L.EQ.10).OR.(L.EQ.33).OR.(L.EQ.52).OR.(L.EQ.75)) TMP(L)=ONE
      IF((L.EQ.9).OR.(L.EQ.34).OR.(L.EQ.51).OR.(L.EQ.76)) TMP(L)=P
      IF((L.EQ.12).OR.(L.EQ.31).OR.(L.EQ.54).OR.(L.EQ.73)) TMP(L)=ZERO
      IF(TMP(L).EQ.DONT) TMP(L)=CROSS
   17 CONTINUE
      DO 18 L=1,2
      IF(LSA01(I,L))TMP(L+84)=CROSS
      IF(.NOT.LSA01(I,L)) TMP(L+84)=DASH
   18 CONTINUE
      WRITE(POF,19)TMP
   19 FORMAT(11X,84A1,2X,2(3X,A1))
      DO 41 L=1,84
      IF((L.EQ.13).OR.(L.EQ.30).OR.(L.EQ.55).OR.(L.EQ.72)) TMP(L)=ZERO
      IF((L.EQ.12).OR.(L.EQ.31).OR.(L.EQ.54).OR.(L.EQ.73)) TMP(L)=CLOCK
      IF((L.EQ.9).OR.(L.EQ.34).OR.(L.EQ.51).OR.(L.EQ.76)) TMP(L)=ONE
      TMP(OUT)=ONE
   41 CONTINUE
      WRITE(POF,19)TMP
         DO 20 J=PT12,PT1
      IF(PARRY(J).EQ.PARRY(I)) GO TO 22
   20 CONTINUE
   35 CONTINUE
      PT=PT1-1
      RETURN
   22 DO 23 L=1,84
      IF (TSTRD(I,L) .EQ. IONE) TMP(L)=ONE
      IF (TSTRD(I,L) .EQ. IZE) TMP(L)=ZERO
      IF (TSTRD(I,L) .EQ. IDN) TMP(L)=DONT
      IF((L.EQ.11).OR.(L.EQ.53)) TMP(L)=ZERO
      IF((L.EQ.32).OR.(L.EQ.74)) TMP(L)=ONE
      IF((L.EQ.13).OR.(L.EQ.30).OR.(L.EQ.55).OR.(L.EQ.72)) TMP(L)=ONE
      IF((L.EQ.10).OR.(L.EQ.33).OR.(L.EQ.52).OR.(L.EQ.75)) TMP(L)=ONE
      IF((L.EQ.9).OR.(L.EQ.34).OR.(L.EQ.51).OR.(L.EQ.76)) TMP(L)=P
      IF((L.EQ.12).OR.(L.EQ.31).OR.(L.EQ.54).OR.(L.EQ.73)) TMP(L)=ZERO
      IF(TMP(L).EQ.DONT) TMP(L)=CROSS
C     WRITE(POF,40)PT
C  40 FORMAT(/,' TOTAL NUMBER OF TEST  VECTORS ARE ',I3)
   23 CONTINUE
      DO 24 L=1,2
      IF(LSA01(J,L)) TMP(L+84)=CROSS
      IF(.NOT.LSA01(J,L)) TMP(L+84)=DASH
   24 CONTINUE
      WRITE(POF,19)TMP
      DO 43 L=1,84
      IF((L.EQ.13).OR.(L.EQ.30).OR.(L.EQ.55).OR.(L.EQ.72)) TMP(L)=ZERO
      IF((L.EQ.12).OR.(L.EQ.31).OR.(L.EQ.54).OR.(L.EQ.73)) TMP(L)=CLOCK
      IF((L.EQ.9).OR.(L.EQ.34).OR.(L.EQ.51).OR.(L.EQ.76)) TMP(L)=ZERO
      TMP(OUT)=ONE
   43 CONTINUE
      WRITE(POF,19)TMP
      GO TO 20
      END
C
C*************
C
      SUBROUTINE GETVEC(LFSE,LFS1,IPIN,IMAX,FVECT,FCVECT,IC,IL)
C     THIS SUBROUTINE GETS A VECTOR FROM THE FUNCTION TABLE AND LOADS
C     IN THE FVECT AND FCVECT. THE FVECT CONTAINS ALL THE I/O VALUES
C     ARANGED IN THE ASCENDING ORDER OF I/O PINLIST. AT THE SAME TIME
C     PROPER POLARITY IS CONSIDERED BY EVALUATING THE LFSE AND LFS1.
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER J,I,IMAX,IC,IL
      INTEGER*1  IPIN(84),FVECT(64),FCVECT(16)
      LOGICAL  LFSE(84),LFS1(84)
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      DATA     H/'H'/,L/'L'/,X/'X'/,Z/'Z'/,C/'C'/,DASH/'-'/
      DATA     COMENT/';'/,BLANK/' '/,ONE/'1'/,ZERO/'0'/,DONT/'D'/
C     GO PASSED THE COMMENT LINES
    5 IF(CPG(LOF(IL)+IC).NE.COMENT) GO TO 6
      IL=IL+1
    6 CONTINUE
C     GET VECTORS FROM FUNCTION TABLE
      IC=IC-1
      DO 10 I=1,IMAX
      IC=IC+1
    7 IF(CPG(LOF(IL)+IC).NE.BLANK) GO TO 8
      IC=IC+1
      GO TO 7
    8 CONTINUE
C     REARRANGING THE FUNCTION TABLE VECTORS IN THE RIGHT ORDER
C     AND POLARITY. ALSO SEPARATING THE CONTROL VECTORS
      J=IPIN(I)
      IF((J.GE.1).AND.(J.LE.8)) V=J
      IF((J.GE.35).AND.(J.LE.50)) V=J-26
      IF((J.GE.77).AND.(J.LE.84)) V=J-52
      IF((J.GE.14).AND.(J.LE.29)) V=J+19
      IF((J.GE.56).AND.(J.LE.71)) V=J-7
      IF((J.EQ.9)) V=1
      IF((J.EQ.10)) V=4
      IF(J.EQ.12) V=2
      IF(J.EQ.13) V=3
      IF(J.EQ.30) V=7
      IF(J.EQ.31) V=6
      IF(J.EQ.33) V=8
      IF(J.EQ.34) V=5
      IF(J.EQ.51) V=9
      IF(J.EQ.52) V=12
      IF(J.EQ.54) V=10
      IF(J.EQ.55) V=11
      IF(J.EQ.72) V=15
      IF(J.EQ.73) V=14
      IF(J.EQ.75) V=16
      IF(J.EQ.76) V=13
C
      IF(CPG(LOF(IL)+IC).EQ.X) FVECT(V)=DONT
      IF(CPG(LOF(IL)+IC).EQ.Z) FVECT(V)=Z
      IF((CPG(LOF(IL)+IC).EQ.H)
     1 .AND.(LFSE(J).NE.LFS1(I))) FVECT(V)=ZERO
      IF((CPG(LOF(IL)+IC).EQ.H)
     1 .AND.(LFSE(J).EQ.LFS1(I))) FVECT(V)=ONE
      IF((CPG(LOF(IL)+IC).EQ.L)
     1 .AND.(LFSE(J).NE.LFS1(I))) FVECT(V)=ONE
      IF((CPG(LOF(IL)+IC).EQ.L)
     1 .AND.(LFSE(J).EQ.LFS1(I))) FVECT(V)=ZERO
   10 CONTINUE
      RETURN
      END
C******************
      SUBROUTINE ANDMAP
C THIS SUBROUTINE GENERATES A LOGICAL ANDMAP FOR THE FUSE PLOT.
C A PRESENCE OR AN ABSENCE OF A FUSE IS PRESENTED BY A '1' OR '0'
C UNDER AN INPUT PIN. FOR E.G. 'X' UNDER /PIN1 IS LOGICAL '0' IN
C IN THE ANDAR AND 'X' UNDER PIN1 IS LOGICAL '1' IN THE ANDAR
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J,K,ONE,ZERO
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
      DATA    ONE/1/, ZERO/0/
      DO 10 J=1,256
      K=1
      DO 10 I=1,128,2
      IF((I.EQ.1).OR.(I.EQ.3).OR.(I.EQ.5).OR.(I.EQ.7).OR.(I.EQ.9)
     1  .OR.(I.EQ.11).OR.(I.EQ.13).OR.(I.EQ.15).OR.(I.EQ.17)
     2  .OR.(I.EQ.19).OR.(I.EQ.21).OR.(I.EQ.23).OR.(I.EQ.25)
     3  .OR.(I.EQ.27).OR.(I.EQ.29).OR.(I.EQ.31).OR.(I.EQ.97)
     4  .OR.(I.EQ.99).OR.(I.EQ.101).OR.(I.EQ.103).OR.(I.EQ.105)
     5  .OR.(I.EQ.107).OR.(I.EQ.109).OR.(I.EQ.111).OR.(I.EQ.113)
     6  .OR.(I.EQ.115).OR.(I.EQ.117).OR.(I.EQ.119).OR.(I.EQ.121)
     7  .OR.(I.EQ.123).OR.(I.EQ.125).OR.(I.EQ.127)) GO TO 11
      IF((I.EQ.33).OR.(I.EQ.35).OR.(I.EQ.37).OR.(I.EQ.39).OR.
     1   (I.EQ.41).OR.(I.EQ.43).OR.(I.EQ.45).OR.(I.EQ.47).OR.
     2   (I.EQ.49).OR.(I.EQ.51).OR.(I.EQ.53).OR.(I.EQ.55).OR.
     3   (I.EQ.57).OR.(I.EQ.59).OR.(I.EQ.61).OR.(I.EQ.63).OR.
     4   (I.EQ.65).OR.(I.EQ.67).OR.(I.EQ.69).OR.(I.EQ.71).OR.
     5   (I.EQ.73).OR.(I.EQ.75).OR.(I.EQ.77).OR.(I.EQ.79).OR.
     6   (I.EQ.81).OR.(I.EQ.83).OR.(I.EQ.85).OR.(I.EQ.87).OR.
     7   (I.EQ.89).OR.(I.EQ.91).OR.(I.EQ.93).OR.(I.EQ.95)) GO TO 12
   10 CONTINUE
      RETURN
   11 IF((LFSRD(I,J)).AND.(.NOT. LFSRD(I+1,J)))
     1  CALL ANDWRT(J,K,ONE)
      IF((.NOT.LFSRD(I,J)).AND.(LFSRD(I+1,J)))
     2  CALL ANDWRT(J,K,ZERO)
      K=K+1
      GO TO 10
   12 IF((LFSRD(I,J)).AND.(.NOT. LFSRD(I+1,J)))
     1  CALL ANDWRT(J,K,ZERO)
      IF((.NOT.LFSRD(I,J)).AND.(LFSRD(I+1,J)))
     2  CALL ANDWRT(J,K,ONE)
      K=K+1
      GO TO 10
      END
C*******************
C
      SUBROUTINE TWEEK1(FPOLAR)
C
C     THIS SUBROUTINE REARANGES THE ANDAR,ORARY,LPOLAR IN THE
C     ORDER OF INPUT PINS AND OUTPUT PINS. THIS IS DONE TO FACILITATE
C     SIMULATION ALGORITHM.
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER J,I,DONT,TEMP
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
       INTEGER XA(64)
C23456789A123456789B123456789C123456789D123456789E123456789F123456789G12
C
      DATA XA/1,33,2,34,3,35,4,36,5,37,6,38,7,39,8,40,41,9,42,10,43,11,
     2 44,12,45,13,46,14,47,15,48,16,49,17,50,18,51,19,52,20,53,21,54,
     3 22,55,23,56,24,25,57,26,58,27,59,28,60,29,61,30,62,31,63,32,64/
C
      LOGICAL FPOLAR(32),LVECT(64)
      DATA  DONT/3/
C     INITIALISE THE ANDAR TO DONT CARES
      DO 4 J=1,256
      DO 4 I=1,64
    4 CALL ANDWRT(J,I,DONT)
      CALL ANDMAP
C     TWEEKING THE ANDARY
      DO 10 I=1,256
      DO 5  J=1,64
C
      TEMP=ANDRD(I,J)
      IF(TEMP.EQ.0) LVECT(XA(J))=.FALSE.
      IF(TEMP.NE.0) LVECT(XA(J))=.TRUE.
C
    5 CONTINUE
      DO 6 J=1,64
      IF(LVECT(J)) TEMP=1
      IF(.NOT.LVECT(J)) TEMP=0
    6 CALL ANDWRT(I,J,TEMP)
   10 CONTINUE
C     TWEEKING THE POLAR ARRAY
      J=1
      DO 15 I=1,84
      IF(.NOT.(((I.GE.14) .AND.(I.LE.29))
     1 .OR.((I.GE.56).AND.(I.LE.71)))) GO TO 15
      FPOLAR(J)=LPOLAR(I)
      J=J+1
   15 CONTINUE
      RETURN
      END
C
C***************
C
      SUBROUTINE TEST(LFSE,ISYM,IC,IL,ILE,FLFUSE,NVECT)
C     THIS SUBROUTINE PERFORMS THE FUNCTION TABLE SIMULATION
C      AND GENERATES TEST VECTORS
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER J,I,C,K,IC,IL,ILE,IC1,IL1,IMATCH,IMAX
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
C
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
      INTEGER*1 ISYM(8,84),ISYM1(8,84),IBUF(8,84),FVECT(64),FCVECT(16),
     1 IPIN(84),FPRE(32),FINPUT(32),FOTPUT(32),IPIN1(84)
      INTEGER*1 OUTPUT(32),PREOUT(32)
      INTEGER ROW,NVECT,ERROR
C
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LSAME,
     1        XORFND,LERR,LFSE(84),LFS1(84),FLG1,FLG2,
     2        FPOLAR(32),FLFUSE(4,2),LTEST(32),LMATCH,FLG3,FLG4
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      INTEGER IDESC,IEND,IFUNCT
      COMMON /FTEST/ IFUNCT,IDESC,IEND
      DATA IDASH/'-'/,L/'L'/,H/'H'/,X/'X'/,C/'C'/,Z/'Z'/,N0/'0'/,
     1     N1/'1'/,ERR/'?'/,IBLANK/' '/,COMENT/';'/,DONT/'D'/
      DATA BEL/007/
      DO 1 I=1,84
      IPIN1(I)=0
   1  CONTINUE   
      ERROR=0
      CALL TWEEK1(FPOLAR)
      NTEST = 0
C     PRINT AN ERROR MESSAGE IF NO FUNCTION TABLE IS SUPPLIED
      IF(IFUNCT.NE.0) GO TO 3
      WRITE(PMS,2)
    2 FORMAT(/,' FUNCTION TABLE MUST BE SUPPLIED IN ORDER TO PERFORM',
     1         ' SIMULATION')
      STOP
C     PRINT TITLE
    3 WRITE(POF,4) TITLE
    4 FORMAT(/,1X,80A1,/)
C     INITIALIZE LERR (FUNCTION TABLE ERROR FLG) TO NO ERROR
      LERR=.FALSE.
C     INITIALIZE NERR (NUMBER OF FUNCTION TABLE ERRORS) TO NO ERROR
      NERR=0
C     SET THE STARTING POINT OF THE FUNCTION TABLE TO COLUMN 0
C      AND IFUNCT + 1
      IC=0
      IL=IFUNCT + 1
C     MAKE A DUMMY CALL TO INCR
      CALL INCR(IC,IL,FLFLG)
C     GET THE FUNCTION TABLE PIN LIST (UP TO 80)
C      GO ONE MORE THAN MAX TO LOOK FOR DASHED LINE
C
      DO 10 I=1,80
      CALL GETSYM(LFS1,ISYM1,I,IC,IL,FLFLG)
         DO 5 J=1,8
    5    IBUF(J,1)=ISYM1(J,I)
      IF(IBUF(8,1).EQ.IDASH) GO TO 12
      CALL MATCH(IMATCH,IBUF,ISYM)
      IF(IMATCH.NE.0) GO TO 9
      WRITE(PMS,6) (IBUF(J,1),J=1,8)
    6 FORMAT(/,' FUNCTION TABLE PIN LIST ERROR AT', 8A1)
      STOP
    9 IPIN(I)=IMATCH
      IPIN1(IMATCH)=I
   10 CONTINUE
C     ALL SIGNAL NAMES FOR THE FUNCTIONAL TEST HAVE BEEN READ IN
C      ADJUST COUNT
   12 IMAX=I-1
      NVECT=0
C
C     CALL GETVECTOR SUBROUTINE. THIS SUBROUTINE GETS A VECTOR FROM
C     THE FUNCTION TABLE AND ARANGES IN AN ORDER OF INPUT/OUTPUT PINS
C     AND ALSO DETERMINES THE STATE OF THE SIGNAL DEPENDING UPON THE
C     VALUES IN LFSE AND LFSE1.THE CONTROL PINS (LOAD,CLOCK AND ENABLE)
C     ARE SEPARATED AND STORED IN FCVECT.
C
C     START MAIN LOOP FOR SIMULATION
   90 NVECT=NVECT+1
      IC1=0
      IL1=ILE
      DO 13 I=1,64
   13 FVECT(I)=DONT
      DO 14 I=1,16
   14 FCVECT(I)=DONT
C     GO PASSED COMMENT LINES
   15 IF(CPG(LOF(IL)+IC).NE.COMENT) GO TO  16
      IL=IL+1
      GO TO 15
   16 CONTINUE
C     IF THE FIRST VECTOR THAN LOAD PREVIUS VECTOR TO DONT CARES
      IF(NVECT.NE.1) GO TO 17
      DO 18 K=1,32
        FPRE(K)=DONT
   18 CONTINUE
   17 IF((CPG(LOF(IL)+IC).EQ.IDASH).AND.(NVECT.NE.1)) GO TO 80
      CALL GETVEC(LFSE,LFS1,IPIN,IMAX,FVECT,FCVECT,IC,IL)
      ROW=ROW+1
C      WRITE(PMS,11) FCVECT
C   11 FORMAT(/,' VECTOR IS    ', 16('  ',A1))
      IL=IL+1
      IC=1
      CALL DEVIDE(FVECT,FINPUT,FOTPUT)
      CALL CREOUT(FINPUT,FPRE,OUTPUT)
C
C       THIS SUBROUTINE SAVES A COPY OF THE OUTPUT TO BE USED
C       WHEN THERE IS PRELODING
C
        DO 8046 K=1,32
          PREOUT(K)=OUTPUT(K)
8046   CONTINUE
C
      CALL CHKON(FOTPUT,OUTPUT,FCVECT,FPRE,FLG1,FLG2,FLG3,FLG4)
      CALL FLUPOL(FLFUSE,FPOLAR,OUTPUT,FPRE)
      CALL OUTMTC(OUTPUT,FOTPUT,LTEST,FLG1,
     1     FLG2,FLG3,FLG4)
      CALL ARANGE(ISYM,IPIN1,FVECT,OUTPUT,LFS1,LTEST,
     1  NVECT,FCVECT,LFSE,ERROR)
C     IF(.NOT.LMATCH) GO TO 20
      IF((FLG1.AND.FLFUSE(1,2)).OR.
     1  (FLG2.AND.FLFUSE(2,2)) .OR.
     2  (FLG3.AND.FLFUSE(3,2)) .OR.
     3  (FLG4.AND.FLFUSE(4,2)))GO TO 300
      IF((FLG1).AND.(FLG2).AND.(FLG3).AND.(FLG4))
     1     GO TO 44
      CALL LODOUT(FPRE,PREOUT,FLG1,FLG2,FLG3,FLG4)
C  46 WRITE(PMS,43)OUTPUT
C  43 FORMAT(/,' EVALUATED OUTPUTS:     ', 32('  ',A1))
C     WRITE(PMS,45)FOTPUT
C  45 FORMAT(/,' FUNCTION TABLE OUTPUTS:', 32('  'A1))
      GO TO 90
C
C
C THIS SUBROUTINE IS CALLED WHEN ALL REGISTERS ARE PRELODED
C
   44 DO 8045 K=1,32
        FPRE(K)=FOTPUT(K)
8045  CONTINUE
C
      GO TO 90
   80 IF(ERROR.NE.0)GO TO 95
      WRITE(PMS,96)
   96 FORMAT(/,' SIMULATION PASSED')
      RETURN
   95 WRITE(PMS,19)ERROR
   19 FORMAT(/,' ERROR IN SIMULATION:  NUMBER OF ERRORS DETECTED ',I3)
C  22 WRITE(6,23)OUTPUT
C  23 FORMAT(/,' EVALUATED OUTPUTS:     ', 32('  ',A1))
C  24 WRITE(6,25)FOTPUT
C  25 FORMAT(/,' FUNCTION TABLE OUTPUTS:', 32('  'A1))
C
C
C THIS SUBROUTINE LOADS OUTPUT WITH DONT CARES AFTER ONE TEST
C VECTOR IS DONE
C
      DO 8043 K=1,32
        OUTPUT(K)=DONT
8043  CONTINUE
C
       RETURN
  300 WRITE(PMS,301)
  301 FORMAT(/,' ERROR:  NO PRELOAD IS ALLOWED
     1         WHEN OUTPUTS ARE BYPASED')
      RETURN
       END
C
C************************
      SUBROUTINE DEVIDE(FVECT,FINPUT,FOTPUT)
C
C      THIS SUBROUTINE DEVIDES FVECTOR INTO FINPUT AND FOTPUT
C
        INTEGER*1 FVECT(64),FINPUT(32),FOTPUT(32)
      INTEGER I
C
         DO 10 I=1,32
         FINPUT(I)=FVECT(I)
         M=32+I
         FOTPUT(I)=FVECT(M)
 10      CONTINUE
        RETURN
        END
C
        SUBROUTINE CREOUT(FINPUT,FPRE,OUTPUT)
C
C************************
C
C       THIS SUBROUTINE CREATES AN OUTPUT VECTOR BASED ON THE FINPUT,
C       FPRE,ANDARRAY AND ORARRAY.
C       TWO OUTPUT PINS CAN SHARES 16 PRODUCT TERMS,THE ORARRAY TELLS WHICH
C       PRODUCT TERM IS CONNECTED TO WHICH OUTPUT.THE ORARRAY HAS TWO
C       COLUMNS. A TRUE IN COLUNM ONE MEANS THE CORRESPONDING ROW(PRODUCT TERM)
C       IS CONNECTED TO AN EVEN NUMBER PIN. A TRUE IN COLUMN 2 MEANS THE
C       CORRESPONDING ROW IS CONNECTED TO AN ODD NUMBER PIN.
C       TWO FALSE IN BOTH COLUMNS MEANS THE PRODUCT TERM IS NOT USED.
C
C       INDEX->POINTS AT THE NEXT LOCATION IN THE OUTPUT
C
C       COUNT->KEEPS TRACK OF WHICH OUTPUT PAIR IS BEING WORKED UPON
C
C       TEST-->TRUE WHEN THE INPUT VECTOR IS MATCHED WITH ONE OF THE
C              VCETORS IN THE ANDARRAY 
C       ODD--->TRUE WHEN THE ODD NUMBERD OUTPUT PIN HAS BEEN SET
C
C
C       THE PROGRAM COMPARES THE ANDARRAY WITH FCOMB,IF THE ROW IS
C       MATCHED,IT FIRST CHECKS IF THE EVEN NUMBER PIN HAD ALREAD
C       BEEN LOADED,IF NOT,THE PROGRAM CHECKS WHICH OUTPUT PIN IS
C       CONNECTED. IF EVEN NUMBER PIN IS CONNECTED,THE CORRESPONDING
C       OUTPUT IS LOADED WITH 1. THEN IT SKIPS THE ROWS THAT IS CONNECTED
C       TO THE EVEN NUMBER PIN,AND CHECKS FOR THE TERMS LEFT FOR THE
C       ODD NUMBER PIN.
C       IF EVEN NUMBER PIN IS NOT CONNECTED AND ODD NUMBER PIN IS
C       CONNECTED,IT MEANS WE HAVE PASSED ALL THE PRODUCT TERMS
C       CONNECTED TO THE EVEN NUMBER PIN.SO,EVEN NUMBER PIN GETS A LOW
C       AND ODD NUMBER PIN GETS A HIGH
C       IF THE EVEN NUMBER PIN HAD ALREADY BEEN LOADED,ODD NUMBER PIN
C       IS LOADED WITH A HIGH
C
C
C***************************
       IMPLICIT INTEGER*1 (A-Z)
      INTEGER J,I,M,INDEX,COUNT,IONE,IZE,IDN
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
       INTEGER*1 FINPUT(32),FPRE(32),FCOMB(64),OUTPUT(32)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      LOGICAL  EVEN,TEST
      DATA H/'H'/,L/'L'/,D/'D'/,ZERO/'0'/,ONE/'1'/,IDN/3/,IONE/1/,IZE/0/
C
C
      INDEX=1
      COUNT=1
      TEST=.TRUE.
      EVEN=.FALSE. 
C       COMBINE FINPUT AND FPRE INTO ONE VECTOR
      DO 1 I=1,32
          FCOMB(I)=FINPUT(I)
  1     CONTINUE
      DO 2 I=1,32
          FCOMB(I+32)=FPRE(I)
  2     CONTINUE
C       START MATCHING
C       WRITE (PMS,11) FCOMB
C 11    FORMAT(/,' FCOBM IS   ', 64('  ',A1))
        I=0
  5     I=I+1
        IF (INDEX .GT. 32) GOTO 120
        IF (I.GT.256) GO TO 120
        DO 10 J=1,64
C       CHECK THE NEXT CHAR IF MATCHED
        IF (FCOMB(J).EQ.ONE .AND. ANDRD(I,J).EQ.IONE) GO TO 10
        IF (FCOMB(J).EQ.ZERO .AND. ANDRD(I,J).EQ.IZE) GO TO 10
        IF((ANDRD(I,J).EQ.IDN).OR.(FCOMB(J).EQ.D)) GO TO 10
        TEST=.FALSE.
  10    CONTINUE
C        MATCHED,CHECK FOR THE OUTPUT PINS
        IF (TEST) GO TO 50
C  20    I=I+1
C               NOT MATCHED,CHECK THE NEXT ONE
  30    TEST=.TRUE.
C               NOT FINISHED WITH A PAIR OF OUTPUTS,GO ON CHECKING
  31    IF (I.LT.(16*COUNT)) GO TO 5
C       NO MATCH,SET THE EVEN PIN IF ODD PIN HAS BEEN SET
        IF (EVEN) GO TO 100
C       NO MATCH FOR THIS PAIR OF OUTPUTS,LOAD THE
C       OUTPUT WITH LOW
        OUTPUT(INDEX)=ZERO
        INDEX=INDEX+1
      OUTPUT(INDEX)=ZERO
C       POINTING AT THE NEXT COLUMN
        INDEX=INDEX+1
      COUNT=COUNT+1
C       GO BACK AND CHECK THE NEXT PAIR OF OUTPUTS
        GO TO 5
C       EVEN # PIN HAS BEEN SET,ONLY ODD # PIN NEEDS TO BE SET
  50    IF (EVEN) GO TO 60
C       IF THE PRODUCT TERM IS NOT USED,SKIP LOADIND THE OUTPUT AND GO ON CHECK
        IF ((.NOT.LORARY(1,I)).AND.(.NOT.LORARY(2,I)))GO TO 31
C       EVEN # PIN IS CONNECTED,SET IT UP FIRST
        IF (.NOT. LORARY(2,I)) GO TO 70
C       EVEN PIN HAS BEEN PASSED->UNCONNECTED
C       SO PUT A LOW IN THE ODD PIN
        OUTPUT(INDEX)=ZERO
        INDEX=INDEX+1
C       EVEN PIN IS CONNECTED,SET IT TO 1
        OUTPUT(INDEX)=ONE
C       POINTING AT THE NEXT COLUMN
        INDEX=INDEX+1
      COUNT=COUNT+1
C       GO ON CHECKING
        GO TO 5
C       SET EVEN # PIN TO 1
  60    OUTPUT(INDEX)=ONE
      INDEX=INDEX+1
        EVEN=.FALSE.
C       DONE WITH THIS PAIR,GET TO THE START NUMBER OF THE NEXT PAIR
        I=16*COUNT+1
      COUNT=COUNT+1  
C       AND KEEP ON CHECKING
        GO TO 5
  70    EVEN=.TRUE.
C       ODD # PIN IS CONNECTED,SO SET IT TO 1
        OUTPUT(INDEX)=ONE
        INDEX=INDEX+1
C       POINTING AT THE NEXT COLUMN
        M=I
  80    M=M+1
C       SKIP THE VECTORS UNTIL ODD # PIN ARE CONNECTED OR THE END OF
C       THE PRODUCT TERMS IS REACHED
        IF (M.LE.16*COUNT.AND.(.NOT.LORARY(2,M))) GO TO 80
        I=M-1
C       CHECK FOR THE ODD # PIN IF THE EVEN PIN IS CONNECTED
        IF (M.LE.16*COUNT.AND.LORARY(2,M)) GO TO 30
C       ODD PIN IS NOT CONNECTED,SET IT TO 0
        OUTPUT(INDEX)=ZERO
        INDEX=INDEX+1
        I=I*COUNT+1
        COUNT=COUNT+1
        GO TO 5
C       ODD PIN HAS BEEN SET,EVEN PIN IS NOT CONNECTED
  100   OUTPUT(INDEX)=ZERO
        INDEX=INDEX+1
        COUNT=COUNT+1
        ODD=.FALSE.
        GO TO 5
  120   RETURN
        END
C
        SUBROUTINE CHKON(FOTPUT,OUTPUT,CVECT,FPRE,FLG1,FLG2,FLG3,FLG4)
C
C***********************
C
C  THIS SUBROUTINE CHECKS THE CONTROL VECTOR.
C  IF THERE IS A PRELOD,THE CORRESPONDING OUTPUT IS SET TO
C  "Z" AND THE FPRE IS SET TO THE VALUES OF FOTPUT.
C  FOTPUT IS THE OUTPUT OBTAINED FROM FUNCTION TABLE.
C  OUTPUT IS THE OUTPUT CREATED IN SUBROUTINE CREOUT.
C
C*************************
        IMPLICIT INTEGER*1 (A-Z)
      INTEGER I
        INTEGER*1 OUTPUT(32),FOTPUT(32),CVECT(16),FPRE(32)
      DATA Z/'Z'/,ZERO/'0'/,ONE/'1'/
      LOGICAL FLG1,FLG2,FLG3,FLG4
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      FLG1=.FALSE.
      FLG2=.FALSE.
        FLG3=.FALSE.
        FLG4=.FALSE.
C     ERROR MESSAGE WHEN ENABLED AND PRELOD AT THE SAME TIME
      IF ((CVECT(1).EQ.ZERO).AND.(CVECT(3).EQ.ZERO)) GO TO 500
C     ENABLED
      IF (CVECT(1).EQ.ONE.AND.CVECT(3).EQ.ZERO) GO TO 40
C     DISABLED
      IF (CVECT(1).EQ.ONE.AND.CVECT(3).EQ.ONE) GO TO 20
C     PRELOD
      DO 10 I=1,8
         OUTPUT(I)=Z
         FPRE(I)=FOTPUT(I)
 10   CONTINUE
      FLG1=.TRUE.
      GO TO 40
C     DISABLED
 20   DO 30 I=1,8
        OUTPUT(I)=Z
 30   CONTINUE
C     OUTPUT IS ENABLED AND THERE IS NO PRELOD,GO ON TO THE
C     NEXT OUTPUT BANK
 40   IF((CVECT(5).EQ.ZERO).AND.(CVECT(7).EQ.ZERO)) GO TO 500
      IF(CVECT(5).EQ.ONE.AND.CVECT(7).EQ.ZERO) GO TO 70
      IF(CVECT(5).EQ.ONE.AND.CVECT(7).EQ.ONE) GO TO 60
      DO 50 I=9,16
        OUTPUT(I)=Z
        FPRE(I)=FOTPUT(I)
 50   CONTINUE
      FLG2=.TRUE.
        GO TO 70
 60     DO 65 I=9,16
          OUTPUT(I)=Z
 65     CONTINUE
 70     IF((CVECT(9).EQ.ZERO).AND.(CVECT(11).EQ.ZERO)) GO TO 500
      IF((CVECT(9).EQ.ONE).AND.(CVECT(11).EQ.ZERO)) GO TO 100
        IF((CVECT(9).EQ.ONE).AND.(CVECT(11).EQ.ONE)) GO TO 90
        DO 80 I=17,24
         OUTPUT(I)=Z
         FPRE(I)=FOTPUT(I)
 80     CONTINUE
        FLG3=.TRUE.
        GO TO 100
 90     DO 95 I=17,24
          OUTPUT(I)=Z
 95     CONTINUE
 100    IF((CVECT(13).EQ.ZERO).AND.(CVECT(15).EQ.ZERO)) GO TO 500
        IF((CVECT(13).EQ.ONE).AND.(CVECT(15).EQ.ZERO)) GO TO 1500
        IF((CVECT(13).EQ.ONE).AND.(CVECT(15).EQ.ONE)) GO TO  120
        DO 105 I=25,32
         OUTPUT(I)=Z
         FPRE(I)=FOTPUT(I)
 105    CONTINUE
        FLG4=.TRUE.
        IF(((CVECT(2).EQ.ONE).AND.(CVECT(1).EQ.ZERO))
     1   .OR.((CVECT(6).EQ.ONE).AND.(CVECT(5).EQ.ZERO))
     2   .OR.((CVECT(10).EQ.ONE).AND.(CVECT(9).EQ.ZERO))
     3   .OR.((CVECT(14).EQ.ONE).AND.(CVECT(13).EQ.ZERI)))
     4    GO TO 1000
       GO TO 1500
 120   DO 125 I=25,32
        OUTPUT(I)=Z       
 125   CONTINUE
      GO TO 1500
 500  WRITE (PMS,510)
 510  FORMAT('ERROR: OUTPUT CANNOT BE ENABLED WHEN PRELODING')
 1000 WRITE (PMS,1100)
 1100 FORMAT('WARNING: NO CLOCK IS NEEDED WHEN PRELODING')
 1500 RETURN
      END
C
C**********************
C
       SUBROUTINE FLUPOL(BYPAS,LPOLAR,OUTPUT,FPRE)
C
C THIS SUBROUTINE CHECKS THE BYPAS VECTOR AND LPOLAR VECTOR.
C IF THE OUTPUT IS BYPASED,THE CORRESPONDING FPRE WOULD BE
C FILLED WITH "D"
C IF THE LPOLAR IS TRUE,THERE IS NO POLARITY CHANGE.
C IF THE LPOLAR IS FALSE,THE CORRESPONDINGO UTPUT IS INVERTED
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I
      INTEGER*1 OUTPUT(32),FPRE(32)
      LOGICAL BYPAS(4,2),LPOLAR(32)
      DATA L/'L'/,H/'H'/,D/'D'/,ZERO/'0'/,ONE/'1'/
C
      DO 10 I=1,32
        IF (LPOLAR(I)) GO TO 10
        IF (OUTPUT(I).EQ.L)GO TO 20
        OUTPUT(I)=ZERO
        GO TO 10
 20   OUTPUT(I)=ONE
 10   CONTINUE
      IF (.NOT.BYPAS(1,2)) GO TO 40
      DO 30 I=1,8
        FPRE(I)=D
 30   CONTINUE
 40   IF (.NOT. BYPAS(2,2)) GO TO 60
      DO 50 I=9,16
        FPRE(I)=D
 50   CONTINUE
 60     IF(.NOT.BYPAS(3,2)) GO TO 80
        DO 70 I=17,24
          FPRE(I)=D
 70     CONTINUE
 80     IF(.NOT.BYPAS(4,2)) GO TO 100
        DO 90 I=25,32
          FPRE(I)=D
 90     CONTINUE
 100  RETURN
      END
C
C**********************
C
      SUBROUTINE OUTMTC(OUTPUT,FOTPUT,LTEST,FLG1,FLG2,FLG3,FLG4)
C
C THIS SUBROUTINE TRIES TO MATCH OUTPUT AND FOTPUT.
C LTEST KEEPS TRACK OF WHICH OUTPUT IS NOT MATCHED. IT IS LATER
C CHECKED IN SUBROUTINE ARANGE TO PUT A QUESTION MARK IN THE OUTPUT
C WHEN LTEST IS FALSE
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I
      INTEGER*1 OUTPUT(32),FOTPUT(32)
      LOGICAL LTEST(32)
      DATA D/'D'/
C
      DO 1 I=1,32
        LTEST(I)=.TRUE.
 1      CONTINUE 
      IF ((FLG1).OR.(FLG2).OR.(FLG3).OR.(FLG4))
     1  GO TO 20
      DO 10 I=1,32
        IF (OUTPUT(I).EQ.FOTPUT(I)) GO TO 10
        IF ((OUTPUT(I).EQ.D).OR.(FOTPUT(I).EQ.D)) GO TO 10
        LTEST(I)=.FALSE.
 10   CONTINUE
      GO TO 50
 20     IF((FLG1).AND.(FLG2).AND.(FLG3)
     1     .AND.(FLG4))GO TO 50
        IF (.NOT.FLG1) GO TO 100
 105    IF (.NOT.FLG2) GO TO 110
 115    IF (.NOT.FLG3) GO TO 120
 125    IF (.NOT.FLG4) GO TO 130
 135    GO TO 50
 100    DO 104 I=1,8
         IF(OUTPUT(I).EQ.FOTPUT(I)) GO TO 104
         IF((OUTPUT(I).EQ.D).OR.(FOTPUT(I).EQ.D)) GO TO 104
         LTEST(I)=.FALSE.
 104    CONTINUE
        GO TO 105
 110    DO 114 I=9,16
         IF(OUTPUT(I).EQ.FOTPUT(I)) GO TO 114
         IF((OUTPUT(I).EQ.D).OR.(FOTPUT(I).EQ.D)) GO TO 114
         LTEST(I)=.FALSE.
 114    CONTINUE
        GO TO 115
 120    DO 124 I=17,24
         IF(OUTPUT(I).EQ.FOTPUT(I)) GO TO 124
         IF((OUTPUT(I).EQ.D).OR.(FOTPUT(I).EQ.D)) GO TO 124
         LTEST(I)=.FALSE.
 124    CONTINUE
        GO TO 125
 130    DO 134 I=25,32
         IF(OUTPUT(I).EQ.FOTPUT(I)) GO TO 134
         IF((OUTPUT(I).EQ.D).OR.(FOTPUT(I).EQ.D)) GO TO 134
         LTEST(I)=.FALSE.
 134    CONTINUE
        GO TO 135
 50   RETURN
      END
C
C********************
C
      SUBROUTINE ARANGE(ISYM,IPIN1,FVECT,OUTPUT,LFS1,LTEST,NVECT,
     1                      CVECT,LFSE,ERROR)
C
C THIS SUBROUTINE TAKES THE OUTPUT AND ARANGES THE INPUT
C AND OUTPUT ACCORDING TO THE FUNCTION TABLE LIST ORDER.
C IT ALSO PRINT OUT AN ERROR MESSAGE IF THE OUTPUTS ARE
C NOT MATCHED
C IPIN1(X) GIVES THE POSITION OF THE FUNCTION TABLE FOR THE
C ORIGINAL PIN LIST NUMBER X
C FVECT(I) IS IN THE ORDER OF INPUT (FIRST 16) AND OUTPUT
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 IPIN1(84),FVECT(64),OUTPUT(32),FNCTBL,TEMP(84),NVECT,
     1 ACTUAL(84),EXPECT(84),TEMPBF(9),ISYM(8,84),CVECT(16)
      INTEGER ERROR,I,N,L,K,INDEX
      LOGICAL LFSE(84),LFS1(84),CHECK(84),LTEST(32),TMPHAS(84)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      DATA MARK/'?'/,DONT/'D'/,ZERO/'0'/,ONE/'1'/,LOW/'L'/,
     1       HIGH/'H'/,X/'X'/,BLANK/' '/
C
      DO 5 I=1,84
        TEMP(I)=DONT
        CHECK(I)=.TRUE.
        TMPHAS(I)=.TRUE.
   5    CONTINUE
      CALL GTCVEC(IPIN1,TEMP,CVECT,LFSE,LFS1,TMPHAS)
      DO 1 I=1,8
        FNCTBL=IPIN1(I)
        IF(FNCTBL.EQ.0)GO TO 6
        IF(((.NOT.LFSE(I)).AND.LFS1(FNCTBL)).OR.(LFSE(I).AND.(.NOT.
     1       LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
        TEMP(FNCTBL)=FVECT(I)
   6    J=34+I
        FNCTBL=IPIN1(J)
        IF(FNCTBL.EQ.0)GO TO 7
        IF(((.NOT.LFSE(J)).AND.LFS1(FNCTBL)).OR.(LFSE(J).AND.(.NOT.
     1       LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
        INDEX=I+8
        TEMP(FNCTBL)=FVECT(INDEX)
   7    J=42+I
        FNCTBL=IPIN1(J)
        IF(FNCTBL.EQ.0)GO TO 8
        IF(((.NOT.LFSE(J)).AND.LFS1(FNCTBL)).OR.(LFSE(J).AND.(.NOT.
     1       LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
        INDEX=I+16
        TEMP(FNCTBL)=FVECT(INDEX)
   8   J=I+76
        FNCTBL=IPIN1(J)
        IF(FNCTBL.EQ.0)GO TO 1
        IF(((.NOT.LFSE(J)).AND.LFS1(FNCTBL)).OR.(LFSE(J).AND.(.NOT.
     1       LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
        INDEX=I+24
        TEMP(FNCTBL)=FVECT(INDEX)
 1      CONTINUE
C
C LOAD THE OUTPUT INTO THE TEMP
C
      DO 2 I=1,16
        J=I+13
        FNCTBL=IPIN1(J)
        INDEX=I+32
          IF(FNCTBL.EQ.0)GO TO 22
        IF(((.NOT.LFSE(J)).AND.LFS1(FNCTBL)).OR.(LFSE(J).AND.(.NOT.
     1       LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
        IF (.NOT.LTEST(I)) GO TO 20
        TEMP(FNCTBL)=FVECT(INDEX)
        GO TO 22
 20     ACTUAL(FNCTBL)=FVECT(INDEX)
        EXPECT(FNCTBL)=OUTPUT(I) 
        CHECK(FNCTBL)=.FALSE.
 22     J=I+55
        K=I+16
        INDEX=I+48
        FNCTBL=IPIN1(J)
        IF(FNCTBL.EQ.0)GO TO 2
        IF(((.NOT.LFSE(J)).AND.LFS1(FNCTBL)).OR.(LFSE(J).AND.(.NOT.
     1       LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
        IF (.NOT.LTEST(K)) GO TO 30
        TEMP(FNCTBL)=FVECT(INDEX)
        GO TO 2
 30     ACTUAL(FNCTBL)=FVECT(INDEX)
        EXPECT(FNCTBL)=OUTPUT(K)
        CHECK(FNCTBL)=.FALSE.
 2      CONTINUE
      DO 3 I=1,84
        IF(CHECK(I)) GO TO 3
        TEMP(I)=MARK
 3    CONTINUE
C
C THIS SUBROUTINE CNVERTS ZERO AND ONE TO LOW AND HIGH
C
      DO 8041 I=1,84
        IF(TEMP(I).EQ.ZERO) TEMP(I)=LOW
        IF(TEMP(I).EQ.ONE) TEMP(I)=HIGH
        IF(TEMP(I).EQ.DONT) TEMP(I)=X
8041   CONTINUE
C
C
C THIS SUBROUTINE TAKES TMPHAS CREATED IN SUBROUTINE CHKPHS
C WHICH TELLS WHETHER THE PHASE IN MAIN PIN LIST IS THE SAME
C WITH THE PHASE IN THE FUNCTION TABLE PIN LIST.IF THEY ARE NOT
C INVERT THE CORRESPONDING OUTPUT
C
      DO 8042 I=1,84
        IF(TMPHAS(I)) GO TO 8042
        IF(TEMP(I).EQ.LOW) TEMP(I)=HIGH
        IF(TEMP(I).EQ.HIGH) TEMP(I)=LOW
8042     CONTINUE
C
      WRITE(POF,33) NVECT,TEMP
 33   FORMAT('  ',I3,'       ',84A1)
      DO 4 I=1,84
        IF (CHECK(I)) GO TO 4
          ERROR=ERROR+1
        CALL CHKPHS(IPIN1,LFS1,ISYM,I,TEMPBF)
        IF((ACTUAL(I).EQ.ZERO).AND.TMPHAS(I)) ACTUAL(I)=LOW
        IF((ACTUAL(I).EQ.ZERO).AND.(.NOT.TMPHAS(I)))
     1       ACTUAL(I)=HIGH
        IF((ACTUAL(I).EQ.ONE).AND.TMPHAS(I)) ACTUAL(I)=HIGH
        IF((ACTUAL(I).EQ.ONE).AND.(.NOT.TMPHAS(I)))
     1       ACTUAL(I)=LOW
        IF((EXPECT(I).EQ.ZERO).AND.TMPHAS(I)) EXPECT(I)=LOW
        IF((EXPECT(I).EQ.ZERO).AND.(.NOT.TMPHAS(I)))
     1       EXPECT(I)=HIGH
        IF((EXPECT(I).EQ.ONE).AND.TMPHAS(I)) EXPECT(I)=HIGH
        IF((EXPECT(I).EQ.ONE).AND.(.NOT.TMPHAS(I)))
     1       EXPECT(I)=LOW
        WRITE(PMS,44)TEMPBF,ACTUAL(I),EXPECT(I)
 44     FORMAT('  ERROR:',9A1,'    ACTUAL=',A1,'    EXPECT=',A1)
          DO 66 N=1,9
          TEMPBF(N)=BLANK
 66       CONTINUE
 4    CONTINUE
      RETURN
      END

C
C*************************
C
      SUBROUTINE GTCVEC(IPIN1,TEMP,CVECT,LFSE,LFS1,TMPHAS)
C
C THIS SUBROUTINE PUTS THE CVECT INTO TEMP WHICH IS IN FUNCTION
C TABLE LISTING ORDER
C
      INTEGER*1 TEMP(84),IPIN1(84),CVECT(16)
      INTEGER FNCTBL
      LOGICAL LFSE(84),LFS1(84),TMPHAS(84)
      FNCTBL=IPIN1(9)
      IF(FNCTBL.EQ.0)GO TO 1
        IF(((.NOT.LFSE(9)).AND.LFS1(FNCTBL)).OR.(LFSE(9)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(1)
  1     FNCTBL=IPIN1(12)
      IF(FNCTBL.EQ.0)GO TO 2
        IF(((.NOT.LFSE(12)).AND.LFS1(FNCTBL)).OR.(LFSE(12)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(2)
  2     FNCTBL=IPIN1(13)
      IF(FNCTBL.EQ.0)GO TO 3
        IF(((.NOT.LFSE(13)).AND.LFS1(FNCTBL)).OR.(LFSE(13).AND.
     1     (.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(3) 
  3     FNCTBL=IPIN1(10)
      IF(FNCTBL.EQ.0)GO TO 4
      IF(((.NOT.LFSE(10)).AND.LFS1(FNCTBL)).OR.(LFSE(10)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(4)
 4    FNCTBL=IPIN1(30)
      IF(FNCTBL.EQ.0)GO TO 11
        IF(((.NOT.LFSE(30)).AND.LFS1(FNCTBL)).OR.(LFSE(30)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(7)
  11     FNCTBL=IPIN1(31)
      IF(FNCTBL.EQ.0)GO TO 12
        IF(((.NOT.LFSE(31)).AND.LFS1(FNCTBL)).OR.(LFSE(31)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(6)
  12    FNCTBL=IPIN1(33)
      IF(FNCTBL.EQ.0)GO TO 13
        IF(((.NOT.LFSE(33)).AND.LFS1(FNCTBL)).OR.(LFSE(33).AND.
     1     (.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(8) 
  13     FNCTBL=IPIN1(34)
      IF(FNCTBL.EQ.0)GO TO 14
      IF(((.NOT.LFSE(34)).AND.LFS1(FNCTBL)).OR.(LFSE(34)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(5)
 14   FNCTBL=IPIN1(51)
      IF(FNCTBL.EQ.0)GO TO 21
        IF(((.NOT.LFSE(51)).AND.LFS1(FNCTBL)).OR.(LFSE(51)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(9)
  21    FNCTBL=IPIN1(54)
      IF(FNCTBL.EQ.0)GO TO 22
        IF(((.NOT.LFSE(54)).AND.LFS1(FNCTBL)).OR.(LFSE(54)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(10)
  22     FNCTBL=IPIN1(55)
      IF(FNCTBL.EQ.0)GO TO 23
        IF(((.NOT.LFSE(55)).AND.LFS1(FNCTBL)).OR.(LFSE(55).AND.
     1     (.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(11) 
  23     FNCTBL=IPIN1(52)
      IF(FNCTBL.EQ.0)GO TO 24
      IF(((.NOT.LFSE(52)).AND.LFS1(FNCTBL)).OR.(LFSE(52)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(12)
 24   FNCTBL=IPIN1(76)
      IF(FNCTBL.EQ.0)GO TO 31
        IF(((.NOT.LFSE(76)).AND.LFS1(FNCTBL)).OR.(LFSE(76)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(13)
  31     FNCTBL=IPIN1(73)
      IF(FNCTBL.EQ.0)GO TO 32
        IF(((.NOT.LFSE(73)).AND.LFS1(FNCTBL)).OR.(LFSE(73)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(14)
  32     FNCTBL=IPIN1(72)
      IF(FNCTBL.EQ.0)GO TO 33
        IF(((.NOT.LFSE(72)).AND.LFS1(FNCTBL)).OR.(LFSE(72).AND.
     1     (.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(15) 
  33     FNCTBL=IPIN1(75)
      IF(FNCTBL.EQ.0)GO TO 6
      IF(((.NOT.LFSE(75)).AND.LFS1(FNCTBL)).OR.(LFSE(75)
     1     .AND.(.NOT.LFS1(FNCTBL)))) TMPHAS(FNCTBL)=.FALSE.
      TEMP(FNCTBL)=CVECT(16)
  6     RETURN
      END
C
C***************************
C
      SUBROUTINE CHKPHS(IPIN1,LFS1,ISYM,FPTR,TEMPBF)
C
C THIS SUBROUTINE CHECKS THE PHASE OF THE INPUTS AND OUTPUTS
C OF BOTH MAIN PIN LIST AND FUNCTION TABLE PIN LIST AND PUTS IN
C A BAR IN THE PRINT OUT IF NECESSARY.
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J
      INTEGER*1 TEMPBF(9),ISYM(8,84),IPIN1(84)
      INTEGER*1 FPTR,SPTR
      LOGICAL LFS1(84),LBAR
        DATA BAR/'/'/,BLANK/' '/
      LBAR=.FALSE.
      DO 1 I=1,84
      IF (IPIN1(I).EQ.FPTR)GO TO 10
  1   CONTINUE
  10    SPTR=I
        IF (LFS1(FPTR)) GO TO 20
      DO 2 I=1,9
        IF(ISYM(I,SPTR).EQ.BLANK)GO TO 2
        IF(LBAR) GO TO 3
        J=I-1
        TEMPBF(J)=BAR
        LBAR=.TRUE.
  3   TEMPBF(I)=ISYM(I,SPTR)
  2     CONTINUE
      RETURN
  20    DO 30 I=1,8
          J=I+1
        TEMPBF(J)=ISYM(I,SPTR)
  30    CONTINUE
      RETURN
      END
C
C***********************
C
      SUBROUTINE LODOUT(FPRE,PREOUT,FLG1,FLG2,FLG3,FLG4)
C
C THIS SUBROUTINE IS CALLED WHEN THE OUTPUTS ARE MATCHED.
C IT FILLS FPRE WITH THE VALUES OF OUTPUT 
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I
      INTEGER*1 FPRE(32),OUTPUT(32),PREOUT(32)
      LOGICAL FLG1,FLG2,FLG3,FLG4
C
      DATA D/'D'/,Z/'Z'/
C
      IF(.NOT.FLG1.AND.(.NOT.FLG2)
     1     .AND.(.NOT.FLG3).AND.(.NOT.FLG4)) GO TO 10
        IF (.NOT. FLG1) GO TO 30
  35    IF (.NOT. FLG2) GO TO 40
  45    IF (.NOT.FLG3)  GO TO 50
  55    IF (.NOT. FLG4) GO TO 60
  65    RETURN
  30    DO 31 I=1,8
          FPRE(I)=PREOUT(I)
  31    CONTINUE
        GO TO 35
  40    DO 41 I=9,16
          FPRE(I)=PREOUT(I)
  41    CONTINUE
        GO TO 45
  50    DO 51 I=17,24
          FPRE(I)=PREOUT(I)
  51    CONTINUE
        GO TO 55
  60    DO 61 I=25,32
          FPRE(I)=PREOUT(I)
  61    CONTINUE
        GO TO 65
  10    DO 11 I=1,32
        FPRE(I)=PREOUT(I)
  11    CONTINUE
        RETURN
      END
C
C$$ Y8.FOR
C*************************
C
      SUBROUTINE IOINIT
C
C     THIS SUBROUTINE ALLOWS CUSTOMER CHANGES OF ARRAY SIZE
C     ALLOCATIONS & I/O UNIT NUMBERS WITHOUT RECOMPILING MAIN
C     PROGRAM - TO BE SUPPLIED TO ALL MMI CUSTOMERS
C
C     AUTHOR NICK SCHMITZ - 1/22/84
C
      IMPLICIT INTEGER*1 (A-Z)
C
C     9000 CHARACTERS    MAX IN PAL DEFINITIONS FILE
C     500 LINES           MAX IN PAL DEFINITIONS FILE
C     80 CHARACTERS/LINE  MAX IN PAL DEFINITIONS FILE
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
C     I/O UNIT ASSIGNMENTS
C
      CONINP=1
      CONOUT=1
      FILINP=10
      FILOUT=11
C
      RETURN
      END
C
C*********************
C
      SUBROUTINE INITLZ(ITYPE,IPCNT,IC,IL,IBLOW)
C     THIS SUBROUTINE INITIALIZIES VARIABLES AND MATCHES PAL PART
C     NUMBER WITH ITYPE
      IMPLICIT INTEGER*1 (A-Z)
C
      INTEGER I,J,IC,IL,IBLOW,IPCTR,ITYPE
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
      INTEGER*1 INFO(6),IPCNT(84)
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LMATCH,LXOR
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
C
      DATA INFO
     1    /'6','4','R','3','2',1/
C
C     INITIALISE LPOLAR. ALL OUTPUTS ARE ASSUMED TO BE ACTIVE LOW
      DO 10 J=1,84
   10 LPOLAR(J)=.FALSE.
C     INITIALISE THE ORARRAY. THE ORARRAY IS ASSUMED TO BE CONNECTED
C     TO BOTH THE OUTPUTS OF A PARTICULAR PAIR. i.e. PRODUCT TERMS
C     1 TO 16 ARE CONNECTED TO PINS 7 AND 8.
      DO 15 J=1,256
      DO 15 I=1,2
   15 LORARY(I,J)=.FALSE.
C     INITIALISE THE IPCNT ARRAY TO 0. AT START NO PRODUCT TERMS
C     ARE CONNECTED TO THE OUTPUTS
      DO 20 I=1,84
   20 IPCNT(I)=0
C     INITIALIZE LFUSES ARRAY (FUSE ARRAY)
      DO 30 J=1,256
         DO 30 I=1,128
   30       CALL LFSWRT(I,J,0)
C     INITIALIZE IBLOW (NUMBER OF FUSES BLOWN)
      IBLOW=0
      IPCTR=0
C     INITIALIZE IC AND IL (COLUMN AND LINE POINTERS)
      IC=0
      IL=1
C     INITIALIZE ITYPE (PAL PART TYPE)
      ITYPE=0
C     ITYPE IS ASSIGNED THE FOLLOWING VALUES FOR THESE PAL PART TYPES:
C     PAL64R32 =  1
      LMATCH=.TRUE.
      DO 40 I=1,5
   40    IF(INAME(I).NE.INFO(I)) LMATCH=.FALSE.
         IF(LMATCH) ITYPE=INFO(6)
         IF (LMATCH) GO TO 50
      IF(ITYPE.EQ.0) RETURN
   50 CALL INCR(IC,IL,FLFLG)
      RETURN
      END
C
C*************************
C
      SUBROUTINE GETSYM(LFSE,ISYM,J,IC,IL,FLFLG)
C     THIS SUBROUTINE GETS THE PIN NAME, / IF COMPLEMENT LOGIC, AND
C      THE FOLLOWING OPERATION SYMBOL IF ANY
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J,IC,IL
      INTEGER*1 ISYM(8,84)
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,
     1        FLFLG,LFSE(84)
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      DATA IBLANK/' '/
      IF( .NOT.(LLEFT.OR.LAND.OR.LOR.OR.LEQUAL.OR.LRIGHT) )  GO TO 10
      CALL INCR(IC,IL,FLFLG)
   10 LFSE(J)=(.NOT.LSLASH)
      IF(LFSE(J)) GO TO 15
      CALL INCR(IC,IL,FLFLG)
   15 DO 20 I=1,8
   20     ISYM(I,J)=IBLANK
   25 DO 30 I=1,7
C
   30     ISYM(I,J)=ISYM(I+1,J)
      ISYM(8,J)=CPG(LOF(IL)+IC)
      CALL INCR(IC,IL,FLFLG)
      IF( LLEFT.OR.LBLANK.OR.LAND.OR.LOR.OR.LRIGHT.OR.LEQUAL ) RETURN
      GO TO 25
      END
C
C************************
C
      SUBROUTINE INCR(IC,IL,FLFLG)
C     THIS SUBROUTINE INCREMENTS COLUMN AND LINE POINTERS
C      BLANKS AND CHARACTERS AFTER ';' ARE IGNORED. IT ALSO SETS
C     A BYPAS FLG TRUE IF THE OUTPUT IS BYPASED
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER IC,IL
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,TAB,
     1        LXOR1,FLFLG,LCOLON
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      DATA IBLANK/' '/,ILEFT/'('/,IAND/'*'/,IOR/'+'/,COMENT/';'/,
     1        ISLASH/'/'/,IEQUAL/'='/,IRIGHT/')'/,ICOLON/':'/,TAB/009/
C     INITIALLY THE OUTPUT IS ASSUMED TO BE BYPASED BY SETTING FLFLG
C     TRUE
      FLFLG=.TRUE.
      LCOLON=.FALSE.
      LBLANK=.FALSE.
      LXOR=.FALSE.
      LXOR1=.FALSE.
   10 IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
      IF( IC.LE.LLN(IL).AND.CTMP.NE.COMENT ) GO TO 30
      IL=IL+1
      IC=0
      GO TO 10
   30 IF ((CTMP.NE.IBLANK).AND.(CTMP.NE.TAB)) GO TO 31
      LBLANK=.TRUE.
      GO TO 10
   31 IF(CTMP.NE.ICOLON) GO TO 32
      IF(LXOR) GO TO 33
C     IF THERE IS A COLON PRESENT LCOLON IS SET TRUE
      LCOLON=.TRUE.
      LXOR1=.TRUE.
      GO TO 10
   33 LOR=.TRUE.
      RETURN
   32 IF( .NOT.(CTMP.EQ.IOR.AND.(LXOR1)) ) GO TO 34
      LXOR=.TRUE.
      GO TO 10
   34 LLEFT =(CTMP.EQ.ILEFT)
      LAND  =(CTMP.EQ.IAND)
      LOR   =(CTMP.EQ.IOR)
      LSLASH=(CTMP.EQ.ISLASH)
      LEQUAL=(CTMP.EQ.IEQUAL)
      LRIGHT=(CTMP.EQ.IRIGHT)
C     IF THERE IS COLON AND EQUAL THEN FLFLG IS RESET, INDICATING
C     THE PARTICULAR OUTPUT IS REGISTERED
      IF((LCOLON).AND.(LEQUAL)) FLFLG=.FALSE.
      RETURN
      END
C
C*************************
C
      SUBROUTINE MATCH(IMATCH,IBUF,ISYM)
C     THIS SUBROUTINE FINDS A MATCH BETWEEN THE PIN NAME IN THE EQUATION
C
C      AND THE PIN NAME IN THE PIN LIST OR FUNCTION TABLE PIN LIST
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J,IMATCH
      INTEGER*1 IBUF(8,84),ISYM(8,84)
      LOGICAL LMATCH
      IMATCH=0
      DO 20 J=1,84
          LMATCH=.TRUE.
          DO 10 I=1,8
   10         LMATCH=LMATCH.AND.(IBUF(I,1).EQ.ISYM(I,J))
          IF(LMATCH) IMATCH=J
   20     CONTINUE
      RETURN
      END
C
C*************************
C
      SUBROUTINE IXLATE(IINPUT,LFSE,IMATCH,LBUF,ISYM,ITYPE)
C     THIS SUBROUTINE FINDS A MATCH BETWEEN INPUT PIN NUMBER AND
C      THE INPUT LINE NUMBER FOR A SPECIFIC PAL.  ADD 1 TO THE INPUT
C      LINE NUMBER IF THE PIN IS A COMPLEMENT
      IMPLICIT INTEGER*1 (A-Z)
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
      INTEGER IMATCH,IBUBL,IINPUT,ITYPE
      INTEGER*1 ITABLE(84),ISYM(8,84)
      LOGICAL LFSE(84),LBUF(84)
      DATA    ITABLE/
     1 2,6,10,14,18,22,26,30,0,0,0,0,0,4,8,12,16,20,24,28,32,
     2 33,37,41,45,49,53,57,61,0,0,0,0,0,35,39,43,47,51,55,59,
     3 63,67,71,75,79,83,87,91,95,0,0,0,0,0,65,69,73,77,81,85,
     4 89,93,100,104,108,112,116,120,124,128,0,0,0,0,0,98,102,
     5 106,110,114,118,122,126/
C
      IBUBL=0
C     FINDING THE PROPER PIN REFERENCE IN THE FUSE ARRAY
C     IF THE PIN IS BYPASED THAN THERE SHOULD NOT BE
C     ANY FEEDBACK. IF THERE IS THAN REPORT ERROR
      IF(   ((IMATCH.GE.1.AND.IMATCH.LE.8)
     1    .OR.(IMATCH.GE.14.AND.IMATCH.LE.21)
     2    .OR.(IMATCH.GE.64.AND.IMATCH.LE.71)
     3    .OR.(IMATCH.GE.77.AND.IMATCH.LE.84))
     4    .AND.(.NOT.LBYPAS(IMATCH))) GO TO 10
      IF(   ((IMATCH.GE.22.AND.IMATCH.LE.29)
     1   .OR.(IMATCH.GE.35.AND.IMATCH.LE.50)
     2   .OR.(IMATCH.GE.56.AND.IMATCH.LE.63))
     3   .AND.(.NOT.LBYPAS(IMATCH))) GO TO 20
      WRITE(6,30)IMATCH
   30 FORMAT(/,' PIN SYMBOL  ',I2, ' IS BYPASED AND CANT HAVE',
     1         '  FEEDBACK')
      STOP
   10 IF(((LFSE(IMATCH)).AND.(.NOT.LBUF(1))).OR.
     1   ((.NOT.LFSE(IMATCH)).AND.(LBUF(1)))) IBUBL=-1
      GO TO 25
   20 IF(((LFSE(IMATCH)).AND.(.NOT.LBUF(1))).OR.
     1   ((.NOT.LFSE(IMATCH)).AND.(LBUF(1)))) IBUBL=1
      GO TO 25
   25 IINPUT=ITABLE(IMATCH)+IBUBL
      RETURN
      END
C
C*************************
      SUBROUTINE ECHO
C     THIS SUBROUTINE PRINTS THE PAL DESIGN SPECIFICATION INPUT FILE
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER IC,IL,J
C
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      WRITE (POF,5) IPAL,INAME,(REST(J),J=1,71),
     1 (PATN(J),J=1,79),(TITLE(J),J=1,79),(COMP(J),J=1,79)
    5 FORMAT(/,1X,3A1,5A1,71A1,/,1X,79A1,/,1X,79A1,/,1X,79A1)
C
15    DO 200 IL=1,LNMAX
200   WRITE(POF,205) (CPG(IC),IC=(LOF(IL)+1),(LOF(IL)+LLN(IL)))
205   FORMAT (1X,79A1)
C
      RETURN
      END
C
C*********************
C
      SUBROUTINE CAT
C     THIS SUBROUTINE PRINTS THE PALASM CATALOG
      IMPLICIT INTEGER*1 (A-Z)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      WRITE(PMS,10) 
   10 FORMAT(/,' MONOLITHIC MEMORIES 84-PIN PALASM VERSION 1.8C')
      WRITE(PMS,15) 7
   15 FORMAT(' (C) COPYRIGHT 1983 MONOLITHIC MEMORIES',A1)
      WRITE(PMS,20)
   20 FORMAT(/,'    ECHO (E)     - PRINTS THE PAL DESIGN SPECIFICATION',
     4       /,'    PINOUT (O)   - PRINTS THE PINOUT OF THE PAL',
     5       /,'    SIMULATE (S) - EXERCISES THE FUNCTION TABLE VECTORS',
     6       / '    TSTGEN (T)   - GENERATES TEST VECTORS')
      WRITE(PMS,30)
   30 FORMAT(  '    PLOT (P)     - PRINTS THE ENTIRE FUSE PLOT',
     1       /,'    JEDEC (J)    - GENERATES JEDEC PROGRAMMING FORMAT',
     6       /,'    CATALOG (C)  - PRINTS THE PALASM CATALOG',
     7       /,'    QUIT (Q)     - EXIT PALASM')
      RETURN
      END
C
C*********************
C
      SUBROUTINE PINOUT
C     THIS SUBROUTINE PRINTS THE PINOUT OF THE PAL
      IMPLICIT INTEGER*1 (A-Z)
C
      INTEGER*1 CPG(9000),CLN(80)
      INTEGER*2 LOF(350),LLN(350),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
      INTEGER I,J,II,IC,IL,JJ
      INTEGER*1 PIN(20,84),IIN(8,2)
      DATA IBLANK/' '/,ISTAR/'*'/
      DO 10 J=1,84
          DO 5 I=1,20
    5         PIN(I,J)=IBLANK
C
   10 CONTINUE
   15 DO 25 J=1,2
          DO 20 I=1,8
   20         IIN(I,J)=IBLANK
   25 CONTINUE
      IIN(2,1)=IPAL(1)
      IIN(4,1)=IPAL(2)
      IIN(6,1)=IPAL(3)
      IIN(1,2)=INAME(1)
      IIN(3,2)=INAME(2)
      IIN(5,2)=INAME(3)
      IIN(7,2)=INAME(4)
      IIN(8,2)=INAME(5)
      J=0
      IL=0
   30 IC=0
      IL=IL+1
   35 IC=IC+1
   40 IF( IC.GT.LLN(IL) ) GO TO 30
      IF( CPG(LOF(IL)+IC).EQ.IBLANK ) GO TO 35
      J=J+1
      IF(J.GT.84) GO TO 60
      DO 55 I=1,42
          PIN(I,J)=CPG(LOF(IL)+IC)
          IC=IC+1
          IF( IC.GT.LLN(IL) ) GO TO 40
          IF( CPG(LOF(IL)+IC).EQ.IBLANK ) GO TO 40
   55     CONTINUE
   60 DO 75 J=1,42
          II=0
   65     II=II+1
          IF(II.EQ.21) GO TO 75
          IF( PIN(II,J).NE.IBLANK ) GO TO 65
          I=21
   70     I=I-1
          II=II-1
          PIN(I,J)=PIN(II,J)
          PIN(II,J)=IBLANK
          IF(II.NE.1) GO TO 70
   75 CONTINUE
      WRITE(POF,76) (TITLE(I),I=1,79)
   76 FORMAT(/,1X,79A1)
      WRITE(POF,78)
   78 FORMAT(/,1X,20X,14('*'),3X,14('*'),
     1       /,1X,20X,'*',13X,'*',1X,'*',13X,'*')
      JJ=84
      DO 88 J=1,42
C          WRITE(POF,82)
          WRITE(POF,81) (PIN(I,J),I=7,20),ISTAR,J,ISTAR,
     1         (IIN(I,1),I=1,8),ISTAR,JJ,ISTAR,(PIN(I,JJ),I=1,20)
   81     FORMAT(1X,14A1,3X,A1,I2,A1,11X,8A1,10X,A1,I2,A1,3X,20A1)
C          WRITE(POF,82)
   82     FORMAT(1X,17X,4('*'),29X,4('*'))
C
          WRITE(POF,84) ISTAR,(IIN(I,2),I=1,8),ISTAR
   84     FORMAT(1X,20X,A1,11X,8A1,10X,A1)
          DO 86 II=1,2
              DO 85 I=1,8
   85             IIN(I,II)=IBLANK
   86     CONTINUE
          JJ=JJ-1
   88 CONTINUE
      WRITE(POF,90)
   90 FORMAT(1X,20X,31('*'))
      RETURN
      END
C
C*************************
C
      SUBROUTINE PLOT(LBUF,IBUF,IPROD,LDUMP,ITYPE,LPROD,IOP,IBLOW)
C     THIS SUBROUTINE PRODUCES THE FUSE PLOT
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J,IONE,IZERO,IBL,IBUF(8,84)
      INTEGER*1 IOUT(128),IDATA(128)
      INTEGER IPROD,IBLOW
      LOGICAL LBUF(84),LDUMP,LPROD(256), FLG1,FLG2
C
C
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
      DATA IAND/'*'/,IOR/'+'/,ISLASH/'/'/,IONE/1/,IZERO/0/,IBL/3/,
     1     IDASH/'-'/,X/'X'/,IBLANK/' '/,P/'P'/,B/'B'/,
     2     D/'D'/,ZERO/'0'/,ONE/'1'/,FX/'0'/,FIDASH/'O'/
      DATA STX/002/,ETX/003/
      IF(ISVRD(IPROD,1).NE.IBL) RETURN
      IF(LBUF(1)) GO TO 5
      DO 30 J=1,127
   30     CALL ISVWRT(IPROD,J,ISVRD(IPROD,J+1))
      CALL ISVWRT(IPROD,128,IONE)
    5 DO 20 I=1,8
         IF( ISVRD(IPROD,1).NE.IBL ) RETURN
          IF( IBUF(I,1).EQ.IBLANK ) GO TO 20
          DO 10 J=1,127
   10         CALL ISVWRT(IPROD,J,ISVRD(IPROD,J+1))
          CALL ISVWRT(IPROD,128,IBUF(I,1))
   20     CONTINUE
      IF(ISVRD(IPROD,1).NE.IBL) RETURN
   40 DO 50 J=1,127
   50     CALL ISVWRT(IPROD,J,ISVRD(IPROD,J+1))
      CALL ISVWRT(IPROD,128,IZERO)
      RETURN
      END
C
C*************************
C
      SUBROUTINE XPLOT(FLFUSE,IBLOW)
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J,K,IBLOW,IPROD
      LOGICAL  FLFUSE(4,2)
      INTEGER  I88PRO
      INTEGER*1  D(128),P(32),OR(2),F(4)
C
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      DATA     DASH/'-'/,CROSS/'X'/,H/'H'/,L/'L'/
C     THIS SUBROUTINE DISPPALYS THE FUSEPLOT IN '-' AND 'X'
C     FORMAT. THE INPUT/FEEDBACK PINS ARE GROUPED IN 8. THE
C     PRODUCT TERMS ARE GROUPED IN 16 FOR EACH PAIR OF OUTPUTS.
C     NEXT TO THE FUSE PLOT IS INDICATED THE ORARRAY FUSE LINKS
C
      WRITE(POF,10) TITLE
   10 FORMAT(/,' PAL84-V 1.8C',/,1X,80A1,//,
     2          10X,10('1'),10('2'),10('3'),10('4'),10('5'),10('6'),
     3          10('7'),10('8'),10('9'),10('0'),10('1'),8('2'),/,
     4          12('0123456789'),'01234567',1X,'01',/)
      F(1)=CROSS
      F(2)=CROSS
      F(3)=CROSS
      F(4)=CROSS
      IF(FLFUSE(1,2)) F(1)=DASH
      IF(FLFUSE(2,2)) F(2)=DASH
      IF(FLFUSE(3,2)) F(3)=DASH
      IF(FLFUSE(4,2)) F(4)=DASH
      IF(FLFUSE(1,2)) IBLOW=IBLOW+1
      IF(FLFUSE(2,2)) IBLOW=IBLOW+1
      IF(FLFUSE(3,2)) IBLOW=IBLOW+1
      IF(FLFUSE(4,2)) IBLOW=IBLOW+1
      IPROD=0
      DO 30 J=1,256,16
      IF (POF .NE. CONOUT) WRITE (CONOUT,9001)
9001  FORMAT (1X,'.'$)
      DO 20 I=1,16
      COUNT=I-1
      IPROD=J+COUNT
      DO 5 K=1,128
      IF(LFSRD(K,IPROD).NE.0) D(K)=DASH
      IF(LFSRD(K,IPROD).EQ.0) D(K)=CROSS
    5 CONTINUE
      DO 6 K=1,2
      IF(LORARY(K,IPROD)) OR(K)=DASH
      IF(.NOT.LORARY(K,IPROD)) OR(K)=CROSS
    6 CONTINUE
      IPROD=IPROD-1
      WRITE(POF,15)D,OR
   15 FORMAT(16(8A1),1X,2A1)
   20 CONTINUE
      IPROD=0
      WRITE(POF,25)
   25 FORMAT(1X)
   30 CONTINUE
      WRITE(POF,35)
   35 FORMAT(1X)
      WRITE(POF,40)
   40 FORMAT(/,' OUTPIN POLARITY: ','11111122 22222222 55556666',
     1                                       '66666677',/,
     2         '                  ','45678901 23456789 67890123',
     3                                       '45678901',/)
      DO 45 I=14,29
      IF(LPOLAR(I)) P(I-13)=DASH
      IF(.NOT.LPOLAR(I))P(I-13)=CROSS
   45 CONTINUE
      DO 46 I=56,71
      IF(LPOLAR(I)) P(I-39)=DASH
      IF(.NOT.LPOLAR(I)) P(I-39)=CROSS
   46 CONTINUE
      WRITE(POF,50) P
   50 FORMAT(/,18X,32A1)
      WRITE(POF,52)
   52 FORMAT(/,' OUTPUT SET:   14-21 22-29 56-63 64-71')
      WRITE(POF,53) F
   53 FORMAT(/,' BYPAS FUSE:  ',A1,'   ',A1,'   ',A1,'   ',A1,/)
      WRITE(POF,55) IBLOW
   55 FORMAT(//,' FUSES BLOWN: ',I5)
      RETURN
      END
C
C******************
C
      SUBROUTINE BYPAS(FLFUSE,FLFLG,LFEED,ISYM,IMATCH)
C     THIS SUBROUTINE DETERMINS WHETHER A PARTICULAR OUTPUT
C     SET IS TO BE BYPASED OR NOT.  A SET OF OUTPUTS 7-14 AND 27-34
C     CAN BE EITHER BYPASED OR NOT AS A SET. AN ERROR IS REPORTED
C     IF A SET OF OUTPUT IS TO BE BYPASED AND ALSO REGISTERED AT THE
C     SAME TIME. NO FEEDBACK PATHS ARE ALLOWED FROM BYPASED OUTPUTS
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,J,IMATCH
      INTEGER*1 ISYM(8,84)
C
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
      LOGICAL FLFUSE(4,2), FLFLG,LFEED(84)
      IF((IMATCH.GE.14).AND.(IMATCH.LE.21)) GO TO 10
      IF((IMATCH.GE.22).AND.(IMATCH.LE.29)) GO TO 20
      IF((IMATCH.GE.56).AND.(IMATCH.LE.63)) GO TO 40
      IF((IMATCH.GE.64).AND.(IMATCH.LE.71)) GO TO 50
      RETURN
C     IF THE PRESENT OUTPUT IS BYPASED AND PREVIOUS OUTPUT IS REGISTERED
C     AN ERROR IS FLGED.
  10  IF((FLFLG).AND.(FLFUSE(1,1))) GO TO 11
C     IF THE PRESENT OUTPUT IS BYPASED AND PREVIOUSLY USED IN
C     FEEDBACK THEN FLG AN ERROR
      IF((FLFLG).AND.(LFEED(IMATCH))) GO TO 19
C     PRESENT OUTPUT IS BYPASED AND THIS IS THE FIRST OUTPUT
      IF((FLFLG).AND.(.NOT.FLFUSE(1,1)).AND.(.NOT.FLFUSE(1,2)))
     1 GO TO 12
C     PRESENT OUTPUT REGISTERED AND PREVIOUS OUTPUT IS BYPASED. ERROR
      IF((.NOT.FLFLG).AND.(FLFUSE(1,2))) GO TO 14
C     PRESENT OUTPUT IS REGISTERED AND THIS IS THE FIRST OUTPUT
      IF((.NOT.FLFLG).AND.(.NOT.FLFUSE(1,1)).AND.(.NOT.FLFUSE(1,2)))
     1 GO TO 15
      RETURN
   20 IF ((FLFLG).AND.(FLFUSE(2,1))) GO TO 11
      IF((FLFLG).AND.(LFEED(IMATCH))) GO TO 19
      IF ((FLFLG).AND.(.NOT.FLFUSE(2,1)).AND.(.NOT.FLFUSE(2,2)))
     1 GO TO 16
      IF ((.NOT.FLFLG).AND.(FLFUSE(2,2))) GO TO 14
      IF ((.NOT.FLFLG).AND.(.NOT.FLFUSE(2,1)).AND.(.NOT.FLFUSE(2,2)))
     1 GO TO 18
      RETURN
   40 IF((FLFLG).AND.(FLFUSE(3,1))) GO TO 11
      IF((FLFLG).AND.(LFEED(IMATCH))) GO TO 19
      IF((FLFLG).AND.(.NOT.FLFUSE(3,1)).AND.(.NOT.FLFUSE(3,2)))
     1 GO TO 41
      IF((.NOT.FLFLG).AND.(FLFUSE(3,2))) GO TO 14
      IF((.NOT.FLFLG).AND.(.NOT.FLFUSE(3,1)).AND.(.NOT.FLFUSE(3,2)))
     1 GO TO 43
      RETURN
   50 IF((FLFLG).AND.(FLFUSE(4,1))) GO TO 11
      IF((FLFLG).AND.(LFEED(IMATCH))) GO TO 19
      IF((FLFLG).AND.(.NOT.FLFUSE(4,1)).AND.(.NOT.FLFUSE(4,2)))
     1 GO TO 51
      IF((.NOT.FLFLG).AND.(FLFUSE(4,2))) GO TO 14
      IF((.NOT.FLFLG).AND.(.NOT.FLFUSE(4,1)).AND.(.NOT.FLFUSE(4,2)))
     1 GO TO 53
      RETURN
   11 WRITE(POF,30)IMATCH
   30 FORMAT(/,'OUTPUT PIN ',I2,' CANNOT BE BYPASED')
      STOP
   12 FLFUSE(1,2)=.TRUE.
      DO 13 I=14,21
   13 LBYPAS(I)=.TRUE.
      RETURN
   14 WRITE(POF,31)IMATCH
   31 FORMAT(/,' OUTPUT PIN ',I2,' CANNOT BE REGISTERED ')
      STOP
   15 FLFUSE(1,1)=.TRUE.
      RETURN
   16 FLFUSE(2,2)=.TRUE.
      DO 17 I=22,29
   17 LBYPAS(I)=.TRUE.
      RETURN
   18 FLFUSE(2,1)=.TRUE.
      RETURN
   41 FLFUSE(3,2)=.TRUE.
      DO 42 I=56,63
   42 LBYPAS(I)=.TRUE.
      RETURN
   43 FLFUSE(3,1)=.TRUE.
      RETURN
   51 FLFUSE(4,2)=.TRUE.
      DO 52 I=64,71
   52 LBYPAS(I)=.TRUE.
      RETURN
   53 FLFUSE(4,1)=.TRUE.
      RETURN
   19 WRITE(POF,32) IMATCH
   32 FORMAT(/,' OUTPUT PIN ',I2,' CANNOT BE USED IN FEEEDBACK')
      STOP
      END
C
C**************************
C
      SUBROUTINE JEDEC(DOIT)
C     THIS SUBROUTINE GENERATES THE JEDEC PROGRAMMING FORMAT WHICH IS
C      COMPATIBLE WITH THE DATA I/O PROGRAMMABLE LOGIC PAK (PLDS)
C
      IMPLICIT INTEGER*1 (A-Z)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      INTEGER*1 IPBUF(64), IDECIO(5)
      INTEGER NFUSE,NTEST,IADR,IPT,IINP,PINOUT,I,J,J1,J2,IGH,IMP,ITM,
     1        MSD
C
      INTEGER*1 IPAL(3),INAME(5),REST(72),PATN(80),TITLE(80),COMP(80)
      COMMON/SPEC/ IPAL,INAME,REST,PATN,TITLE,COMP
C
      INTEGER*2 PARRY(375)
      LOGICAL LSA01(375,2),LTST(375)
      COMMON /TEST/ LSA01,LTST,PARRY
C
      LOGICAL LORARY(2,256),LPOLAR(84),LBYPAS(84)
      COMMON /LFUSE/LORARY,LPOLAR,LBYPAS
C
      DATA ZERO/'0'/,ONE/'1'/,SOH/1/,STX/2/,ETX/3/,BEL/7/
C
      MSD=0
      IADR=0
C      WRITE(PDF,10) BEL,BEL,SOH,STX
   10 FORMAT(1X,4A1)
C
      WRITE (PDF,5) IPAL,INAME,(REST(J),J=1,71),
     1 (PATN(J),J=1,79),(TITLE(J),J=1,79),(COMP(J),J=1,79)
    5 FORMAT(/,1X,3A1,5A1,71A1,/,1X,79A1,/,1X,79A1,/,1X,79A1)
      WRITE(PDF,11) 40
   11 FORMAT(1X,'*D22',I2,'*')
C
C     SECURITY FUSE CONDITION (DOIT)
      IF (DOIT) WRITE(PDF,101)
  101 FORMAT(1X,'G1*F0*')
      IF (.NOT.DOIT) WRITE(PDF,102)
  102 FORMAT(1X,'G0*F0*')
C
      DO 300 IPT=1,256
      IF (PDF .NE. CONOUT) WRITE (CONOUT,9001)
9001  FORMAT (1X,'.'$)
      DO 300 ITM=0,127,64
      NFUSE = 0
      DO 50 IINP=1,64
      NFUSE = NFUSE + 1
      IPBUF(NFUSE)=ZERO
      IF (LFSRD(IINP+ITM,IPT).NE.0) IPBUF(NFUSE)=ONE
   50 CONTINUE
C
      CALL ENCD(MSD,IADR,IDECIO)
      WRITE(PDF,201) IDECIO,(IPBUF(I),I=1,NFUSE)
  201 FORMAT(' L',5A1,1X,64A1,'*')
  250 IADR=IADR+NFUSE
      IF(IADR.GE.10000) MSD=MSD+1
      IF(IADR.GE.10000) IADR=MOD(IADR,10000)
  300 CONTINUE
C
C       OUTPUT POLARITY FUSES
C
      DO 3650 NFUSE=14,29
      IPBUF(NFUSE-13)=ZERO
3650  IF (LPOLAR(NFUSE)) IPBUF(NFUSE-13)=ONE
C
      DO 3660 NFUSE=56,71
      IPBUF(NFUSE-40)=ZERO
3660  IF (LPOLAR(NFUSE)) IPBUF(NFUSE-40)=ONE
      CALL ENCD(MSD,IADR,IDECIO)
      WRITE(PDF,2010) IDECIO,(IPBUF(I),I=1,32)
2010  FORMAT(' L',5A1,1X,32A1,'*')
      IADR=IADR+16
      IF(IADR.GE.10000) MSD=MSD+1
      IF(IADR.GE.10000) IADR=MOD(IADR,10000)
C
C     PRODUCT SHARING FUSES
C
      DO 510 IPT=0,255,16
      NFUSE = 0
      DO 500 IMP=1,16
      DO 450 IINP=1,2
      NFUSE = NFUSE + 1
      IPBUF(NFUSE)=ZERO
      IF (LORARY(IINP,IPT+IMP)) IPBUF(NFUSE)=ONE
450   CONTINUE
  500 CONTINUE
      CALL ENCD(MSD,IADR,IDECIO)
      WRITE(PDF,201) IDECIO,(IPBUF(I),I=1,NFUSE)
      IADR=IADR+NFUSE
      IF(IADR.GE.10000) MSD=MSD+1
      IF(IADR.GE.10000) IADR=MOD(IADR,10000)
  510 CONTINUE
C
C     TEST VECTORS
C
      CALL ENCD(MSD,IADR,IDECIO)
C      WRITE(PDF,410) IDECIO,(TSTRD(I,J),I=1,64)
410   FORMAT(' V',4I1,1X,20A1,' *')
      WRITE(PDF,400) ETX
  400 FORMAT(1X,A1,'0000',/)
      RETURN
      END
C
C***************
C
      SUBROUTINE ENCD(MSD,IADR,IDECIO)
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 ICNV(16),IDECIO(5)
      INTEGER J,IADR,MSD,IDEC(5)
      DATA ICNV/'0','1','2','3','4','5','6','7','8','9',
     1  'A','B','C','D','E','F'/
C
      IDEC(5)=IADR
      DO 100 J=5,2,-1
      IDEC(J-1)=IDEC(J)/10
      IDEC(J)=IDEC(J)-10*IDEC(J-1)
100   IDECIO(J)=ICNV(IDEC(J)+1)
      IDECIO(1)=ICNV(MSD+1)
      RETURN
      END
C
C**************************

$ -1)
100   IDECIO(J)=ICNV(IDEC(J)+1)
      IDECIO(1)=ICNV(MSD+1)
      RET