package sorcererII;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;

public class SorcererAudioFileTape implements SorcererTape
{
  private InputStream inputStream = null;
  private OutputStream outputStream = null;
  private File _file;
  private float _baudRate = 0.0f;
  private boolean _endOfFile = false;
  private boolean _readOnly = false;
  
  public SorcererAudioFileTape( final File file, final boolean readOnly) {
    this(file);
    _readOnly = readOnly;
  }

  public SorcererAudioFileTape( File file )
  {
    _file = file;
  }
  
  public SorcererAudioFileTape( String name )
  {
    this(new File(name));
  }

  public void record() throws IOException
  {
    if( !_readOnly && outputStream == null )
    {
      outputStream = new SorcererAudioOutputStream( _file, _baudRate );
    }
  }

  public void play() throws IOException
  {
    if( inputStream == null )
    {
      inputStream = new SorcererAudioInputStream( _file, _baudRate, Sorcerer.LOGGER );
    }
  }

  public void rewind()
  {

  }

  public void motorOn(float baudRate)
  {
    _baudRate = baudRate;
  }

  public void motorOff()
  {
    _endOfFile = false;
    try
    {
      if( outputStream != null )
      {
        outputStream.close();
        outputStream = null;
      }
      if( inputStream != null )
      {
        _endOfFile = false;
        inputStream.close();
        inputStream = null;
      }
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }
    rewind();
  }

  public byte getByte() throws IOException
  {
    if(_endOfFile) return 0x1A;
    
    if( inputStream == null )
    {
      play();
    }

    int b = inputStream.read();
    
    if(b == -1) {
      Sorcerer.LOGGER.log(Level.INFO, "Reached end of cassette");
      _endOfFile = true;
      inputStream.close();
      inputStream = null;
      return 0x1A;
    }
    
    return (byte)(b&0xff);
  }

  public void writeByte( byte b ) throws IOException
  {
    if(!_readOnly) {
      if( outputStream == null )
      {
        record();
      }
      outputStream.write( 0xff & (int)b );
    }
  }
}