package sorcererII;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;

public class JSorcererTapeDrive extends JFileChooserWithImage {
  /**
   * 
   */
  private static final long serialVersionUID = -3695105504141235512L;
  
  private final Sorcerer _sorcerer;
  private final int _unit;
  
  private class SorcererTapeProxy implements SorcererTape {
    private SorcererTape _delegate = null;

    public void setDelegate(final SorcererTape delegate) {
      _delegate = delegate;
    }
    
    public byte getByte() throws IOException {
      if(_delegate == null) return 0x1A; 
      return _delegate.getByte();
    }

    public void motorOff() {
      setBorderColor(null);
      if(_delegate == null) return;
      _delegate.motorOff();
    }

    public void motorOn(float baudRate) {
      setBorderColor(Color.red);
      if(_delegate == null) return;
      _delegate.motorOn(baudRate);
    }

    public void rewind() {
      if(_delegate == null) return;
      _delegate.rewind();
    }

    public void writeByte(byte b) throws IOException {
      if(_delegate == null) return;
      _delegate.writeByte(b);
    }
  }
  
  private SorcererTapeProxy _sorcererTapeProxy = new SorcererTapeProxy();
  final JCheckBox _readOnlyCheckBox = new JCheckBox("Read only");
  

  public JSorcererTapeDrive(final Sorcerer sorcerer, final int unit) throws IOException {
    super(ImageIO.read(new File("images/icon-cassette-out.png")),
          ImageIO.read(new File("images/icon-cassette-in.png")),
          new File("tapes/"),
          "Cassette Player " + (unit + 1));
    _sorcerer = sorcerer;
    _sorcerer.attachTapeUnit(_sorcererTapeProxy, unit);
    _unit = unit;
    setAccessory(_readOnlyCheckBox);
    setFileFilter(new FileFilter() {

      @Override
      public String getDescription() {
        return "Tape files";
      }

      @Override
      public boolean accept(File f) {
        if (f.isDirectory()) {
          return true;
        }
        final String lowerFileName = f.getName().toLowerCase();

        return lowerFileName.endsWith(".wav") ||
        lowerFileName.endsWith(".tape");
      }
    });
  }
  
  @Override
  public void load(final File file) throws IOException {
    if(file.getName().toLowerCase().endsWith(".wav")) {
      _sorcererTapeProxy.setDelegate(new SorcererAudioFileTape(file, _readOnlyCheckBox.isSelected()));
    }
    else {
      _sorcererTapeProxy.setDelegate(new FileSorcererTape(file, _readOnlyCheckBox.isSelected()));
    }
    Sorcerer.LOGGER.log(Level.INFO, "Loaded cassette drive " + _unit + " with file " + file);
  }  

  @Override
  public void eject() {
    _sorcererTapeProxy.setDelegate(null);
    Sorcerer.LOGGER.log(Level.INFO, "Ejected tape from cassette drive " + _unit);
  }
}
