package sorcererII;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

import javax.imageio.ImageIO;
import javax.swing.JFileChooser;

public class JSorcererSaveScreen extends JMonostableImageButton {

  /**
   * 
   */
  private static final long serialVersionUID = 5184346364731454400L;

  private final Sorcerer _sorcerer;
  private File _file = new File("screen-shots/");

  public JSorcererSaveScreen(final Sorcerer sorcerer) throws IOException {
    super(ImageIO.read(new File("images/icon-screen-shot-faint.png")),
          ImageIO.read(new File("images/icon-screen-shot.png")),
    "Save screen");
    _sorcerer = sorcerer;
  }

  @Override
  public void gotoState1() {
  }

  @Override
  public void gotoState2() {
    _sorcerer.stop();
    try
    {
      final JFileChooser fc = new JFileChooser(_file);
      final int returnVal = fc.showSaveDialog(JSorcererSaveScreen.this);
      if (returnVal == JFileChooser.APPROVE_OPTION) {

        try {
          _file = fc.getSelectedFile();
          final BufferedImage image = new BufferedImage(512, 480, BufferedImage.TYPE_INT_RGB);
          _sorcerer.refreshWholeScreen();
          _sorcerer.writeScreenImage(image.getGraphics());
          _sorcerer.refreshWholeScreen();
          String type = "png";
          final int lastDot = _file.getName().lastIndexOf(".");
          if(lastDot > 0){
            final String suffix = _file.getName().substring(lastDot + 1);
            if(suffix.length() > 0) {
              type = suffix;
            }
          }
          if(!ImageIO.write(image, type, _file)) {
            _sorcerer.LOGGER.log(Level.SEVERE, "Could not write a file of this format");            
          }
        }
        catch (final IOException ex) {
          _sorcerer.LOGGER.log(Level.SEVERE, "Could not save screen image");
        }
      }    } 
    finally {
      _sorcerer.start();
    }
  }
}
