package sorcererII;

import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public abstract class JSorcererResetControl extends JMonostableImageButton {
  
  /**
   * 
   */
  private static final long serialVersionUID = 1360656210019916816L;
  
  private final Sorcerer _sorcerer;
  
  public JSorcererResetControl(final Sorcerer sorcerer) throws IOException {
    super(ImageIO.read(new File("images/icon-reset-faint.png")),
          ImageIO.read(new File("images/icon-reset.png")),
          "Reset");
    _sorcerer = sorcerer;
  }
  
  @Override
  public void gotoState1() {
  }

  @Override
  public void gotoState2() {
    _sorcerer.stop();
    handleReset();
    _sorcerer.reset();
    _sorcerer.start();
  }
  
  protected abstract void handleReset();
}
