package sorcererII;

import java.awt.Color;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;

public class JSorcererDiskDrive extends JFileChooserWithImage {
  /** 
   * 
   */
  private static final long serialVersionUID = -3695105504141235512L;
  
  private class SorcererDiskProxy implements SorcererDisk {
    private SorcererDisk _delegate = null;

    public void activate() throws IOException {
      setBorderColor(Color.red);
      if(_delegate == null) return;
      _delegate.activate();
    }

    public void deactivate() throws IOException {
      setBorderColor(null);
      if(_delegate == null) return;
      _delegate.deactivate();
    }

    public byte read(int track, int sector, int offset) {
      if(_delegate == null) return 0;
      return _delegate.read(track, sector, offset);
    }

    public void write(int track, int sector, int offset, byte data) {
      if(_delegate == null) return;
      _delegate.write(track, sector, offset, data);
    }
    
    public void setDelegate(final SorcererDisk delegate) {
      _delegate = delegate;
    }
  }
  
  private final SorcererDiskProxy _sorcererDiskProxy = new SorcererDiskProxy();
  
  private final SorcererDiskDrive _drive;
  
  public JSorcererDiskDrive(final SorcererDiskDrive drive, final char driveLetter) throws IOException {
    super(ImageIO.read(new File("images/icon-disk-out.png")),
          ImageIO.read(new File("images/icon-disk-in.png")),
          new File("disks/"),
          "Disk " + driveLetter);
    _drive = drive;
    _drive.insertDisk(_sorcererDiskProxy);
    setAccessory(_readOnlyCheckBox);
    
    setFileFilter(new FileFilter() {

      @Override
      public String getDescription() {
        return "Disk files";
      }

      @Override
      public boolean accept(File f) {
        if (f.isDirectory()) {
          return true;
        }
        final String lowerFileName = f.getName().toLowerCase();

        return lowerFileName.endsWith(".dsk");
      }
    });
  }
  
  final JCheckBox _readOnlyCheckBox = new JCheckBox("Read only");
  
  @Override
  public void load(final File file) throws IOException {
    _sorcererDiskProxy.setDelegate(new SorcererFileDisk(file, _readOnlyCheckBox.isSelected()));
  }  
  
  @Override
  public void eject() {
    try {
      _sorcererDiskProxy.deactivate();
    }
    catch (final IOException e) {
      // TODO: handle exception
    }
    _sorcererDiskProxy.setDelegate(null);
  }
}
