package sorcererII;

/*
 * @(#)JSorcerer.java 1.1 15/07/00 Philip M. Scull
 */
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

/**
 * <p>The <a href="http://www.liaquay.co.uk/sorcerer">JSorcerer</a> class wraps up
 * the sorcerer class into an Applet which emulates an Exidy Sorcerer in a Web Page.</p>
 *
 * <p><center>
 *   <applet code=JSorcerer.class width=296 height=232>
 *   <param name=sleepHack value=5>
 *   </applet>
 * </center></p>
 *
 * <p>This applet can be supplied the following parameters:
 * <ul>
 *   <li><b>refreshRate</b> - refresh screen every 'X' interrupts (default=1)
 *   <li><b>sleepHack  </b> - sleep per interrupt in ms, for old VMs (default=0)
 * </ul>
 *
 * <p>The <b>refreshRate</b> parameter specifies how often the screen should be
 * updated in terms of Z80 interrupts. The default value is <b>1</b>.</p>
 *
 * <p>The <b>sleepHack</b> parameter is needed to introduce a delay into the main
 * Z80 execute loop. In some browsers, the thread which updates the screen and
 * delivers keyboard/mouse events to the applet can be blocked out by the sorcerer
 * thread since it never gives up its timeslice. By default the value for this
 * is <b>0</b> which means that the main execute loop runs at full speed.
 *
 * <p>The <b>scale</b> parameter specifies how many screen pixels per sorcer pixel </p>
 *
 * <b>Version:</b> 1.1 27 Apr 1997<br>
 * <b>Authors:</b> <A HREF="http://www.liaquay.co.uk/sorcerer">Philip M. Scull</A><br>
 *
 * @see sorcerer
 * @see Z80
 */

public class JSorcerer extends Applet {
  Sorcerer    sorcerer    = null;
  Thread      thread      = null;
  int         refreshRate = 1;
  int         sleepHack   = 1;
  int         scale       = 1;

  /** Version and author information. */
  public String getAppletInfo() {
    return "JSorcerer V1.1";
  }

  /** Applet parameters and their descriptions. */
  public String[][] getParameterInfo() {
    String [][] info = {
      { "refreshRate", "Number",     "refresh screen every 'X' interrupts (default=1)" },
      { "sleepHack",   "Number",     "sleep per interrupt in ms, for old VMs (default=0)" },
      { "scale",       "Number",     "Screen pixel width per sorcerer pixel width" },
      { "rom8k",       "URL",        "filename of ROM (default=none)" },
      { "snapshot",    "URL",        "filename of snapshot file(default=none)" },
      { "diska",       "URL",        "Disk file for drive A" },
      { "diskb",       "URL",        "Disk file for drive B" },
      { "diskc",       "URL",        "Disk file for drive C" },
      { "diskd",       "URL",        "Disk file for drive D" },
      { "tape1",       "URL",        "Tape file for tape unit 1" },
      { "tape2",       "URL",        "Tape file for tape unit 2" },
      { "hardKeyMap",  "true/false", "Map keyboard by keys or characters" },
    };
    return info;
  }

  private void loadDisk(final String location, final int diskNumber) {
    try
    {
      final URL url = new URL( getDocumentBase(), location );
      final InputStream is = url.openStream();
      try
      {
        sorcerer.insertDiskIntoDrive( new ArraySorcererDisk( new URL( getDocumentBase(), location ).openStream() ), 0 );		  
      }
      finally 
      {
        is.close();
      }
    }
    catch(final Exception e) 
    {
      e.printStackTrace();
    }
  }
  
  /** Initailize the applet. */
  public void init()
  {
    setLayout( null );

    final Set<Integer> _keyDown = new HashSet<Integer>();
    
    addKeyListener( new KeyAdapter()
    {
      public void keyPressed( final KeyEvent e )
      {
        if(!_keyDown.contains(e.getKeyCode())) {
          _keyDown.add(e.getKeyCode());
          
          if( sorcerer != null )
          {
            sorcerer.doKey( true, e );
          }
        }
      }

      public void keyReleased( final KeyEvent e )
      {
        if( sorcerer != null )
        {
          sorcerer.doKey( false, e );
        }
        
        _keyDown.remove(e.getKeyCode());
      }
    });

    addMouseListener( new MouseAdapter()
    {
      public void mouseClicked( MouseEvent e )
      {
        if( e.getClickCount() == 2 )
        {
          if( sorcerer != null )
          {
            sorcerer.toggleSpeed();
          }
        }
      }
    });

    addFocusListener( new FocusAdapter()
    {
      public void focusGained( KeyEvent e )
      {
        if( sorcerer != null )
        {
          sorcerer.resetKeyboard();
        }
      }
    });

    requestFocus();

  }

  /** Start the applet creating a new thread which invokes run(). */
  public void start()
  {
    if(sorcerer == null) {
      refreshRate       = getIntParameter( "refreshRate", refreshRate, 1, 100 );
      sleepHack         = getIntParameter( "sleepHack",   sleepHack,   0, 100 );
      scale             = getIntParameter( "scale",       scale,       1, 4   );
      String rom8k      = getParameter( "rom8k" );
      String snapshot   = getParameter( "snapshot" );
      String diska      = getParameter( "diska" );
      String diskb      = getParameter( "diskb" );
      String diskc      = getParameter( "diskc" );
      String diskd      = getParameter( "diskd" );
      String tape1      = getParameter( "tape1" );
      String tape2      = getParameter( "tape2" );
      String hardKeyMap = getParameter( "hardKeyMap" );

      try
      {
        sorcerer = new Sorcerer(
          this,
          refreshRate,
          sleepHack,
          scale,
          0,
          0 );

        if( tape1 != null )
        {
          sorcerer.attachTapeUnit1( new UrlSorcererTape( getDocumentBase(), tape1 ) );
        }
        else
        {
          sorcerer.attachTapeUnit1( new ArraySorcererTape() );
        }

        if( tape2 != null )
        {
          sorcerer.attachTapeUnit1( new UrlSorcererTape( getDocumentBase(), tape2 ) );
        }
        else
        {
          sorcerer.attachTapeUnit1( new ArraySorcererTape() );
        }

        if( diska != null )
        {
          loadDisk(diska, 0);
        }

        if( diskb != null )
        {
          loadDisk(diskb, 1);
        }

        if( diskc != null )
        {
          loadDisk(diskc, 2);
        }

        if( diskd != null )
        {
          loadDisk(diskd, 3);
        }

        if( snapshot == null )
        {
          sorcerer.loadROMs( getDocumentBase() );

          if( rom8k != null )
          {
            sorcerer.load8kRomPack( getDocumentBase(), rom8k );
          }
        }
        else
        {
          sorcerer.loadSNP( new URL( getDocumentBase(), snapshot ) );
        }
        
        if(hardKeyMap != null) {
          sorcerer.useHardKeys(hardKeyMap.equalsIgnoreCase("true"));
        }
      }
      catch( Exception e )
      {
        e.printStackTrace();
      }      
    }
    
    requestFocus();

    sorcerer.start();
    showStatus( getAppletInfo() );
  }

  public void stop()
  {
    sorcerer.stop();
  }


  /** Handle integer parameters in a range with defaults. */
  public int getIntParameter( String name, int ifUndef, int min, int max ) {
    String param = getParameter( name );
    if ( param == null ) {
      return ifUndef;
    }

    try {
      int n = Integer.parseInt( param );
      if ( n < min ) return min;
      if ( n > max ) return max;
      return n;
    }
    catch ( Exception e ) {
      return ifUndef;
    }
  }

  /** Refresh handling. */
  public void update( Graphics g )
  {
    paint( g );
  }

  /** Paint sets a flag on the sorcerer to tell it to redraw the
      screen on the next Z80 interrupt. */
  public void paint( Graphics g )
  {
    if ( sorcerer != null )
    {
      sorcerer.repaint();
    }
  }
}
