package sorcererII;

import java.util.*;
import java.io.*;

public class ArraySorcererTape implements SorcererTape
{
  Random rand = new Random();

  byte[] data = new byte[ 65536 ];
  int readIndex = 0;
  int writeIndex = 0;

  public void rewind()
  {
    readIndex = 0;
  }

  public void motorOn(float baudRate)
  {
  }

  public void motorOff()
  {
    rewind();
  }

  public byte getByte() throws IOException
  {
    if( readIndex >= data.length )
    {
      return (byte)( rand.nextInt() & 0xff );
    }
    else
    {
      return data[ readIndex++ ];
    }
  }

  public void writeByte( byte b ) throws IOException
  {
    data[ writeIndex++ ] = b;
  }
}