40 PRINT CHR$(12)
50 REM PROGRAM FOR PLOTTING HYDROGEN-LIKE RADIAL WAVE FUNCTIONS OR ELECTRON DENSITY FUNCTIONS
60 W=1
70 INPUT "Enter WAVE for Wave Function or DENS for Elecron Density        Function and press ENTER - ",A$
80 IF A$="WAVE" THEN 90
88 W=2
90 PRINT
100 REM LIMITS ON INDEPENDENT VARIABLE
105 PRINT "X represents distance from the nucleus in Angstroms."
110 INPUT "Enter Xmin - ",X2
120 INPUT "Enter Xmax - ",X3
130 INPUT "Enter Xinc - ",X1
180 REM INTEGERISING FUNCTIONS
190 DEF FNI(X)=INT(X/X1+.5)
200 DEF FNJ(Y)=INT((Y-Y2)/D+.5)+1
300 INPUT "Enter value for the nuclear charge, Z - ",Z
340 INPUT "Enter value for the principal quantum number, N - ",N
350 INPUT "Enter value for the azimuthal quantum number, L - ",L1
370 A1=N+L1
380 B1=2*L1+1
390 DEF FNS(X)=(Z*X)/.529
400 REM RADIAL WAVEFUNCTION DEFINITION
410 DEF FNA(X)=D9*((X9+.000001)^L1)*(EXP(-FNS(X)/N)*T)
415 REM ELECTRON DENSITY FUNCTION DEFINITION
420 DEF FNB(X)=((FNA(X))^2)*(X^2)
425 REM FACTORIAL ROUTINES FOR (N-L-1)! AND (N+L)!
430 N2=(N-L1)-1
440 K6=1
450 IF N2=0 THEN 490
460 FOR I=1 TO N2
470 K6=K6*I
480 NEXT I
490 N3=N+L1
500 K8=1
510 IF N3=0 THEN 550
520 FOR I=1 TO N3
530 K8=K8*I
540 NEXT I
550 C9=-SQR((4*K6)/((N^4)*(K8^3)))
560 C9=C9*(-1)^(N+L1)*K8/K6
570 D9=C9*((Z/.529)^1.5)
580 INPUT "Automatic Scaling ? (YES/NO) - ",A$
590 IF A$="NO" THEN 850
600 REM AUTOSCALING SECTION
610 X=X2
620 GOSUB 8000
630 ON W GOSUB 8100,8200
700 C1=C2=Y
710 FOR X=X2 TO X3 STEP X1
720 GOSUB 8000
730 ON W GOSUB 8100,8200
750 IF C1<=Y THEN 770
760 C1=Y
770 IF C2>=Y THEN 790
780 C2=Y
790 NEXT X
800 PRINT "Ymin = ";C1
810 PRINT "Ymax = ";C2
820 Y2=C1
830 Y3=C2
840 GOTO 900
850 REM LIMITS ON DEPENDENT VARIABLE
860 INPUT "Enter Ymin - ",Y2
880 INPUT "Enter Ymax - ",Y3
900 D=(Y3-Y2)/60
910 PRINT "Yinc = ";D
930 INPUT "Do you want a graph ? (YES/NO) - ",B$
940 IF B$="YES" THEN PRINT CHR$(12)
950 IF B$="NO" THEN 40
990 GOSUB 9000
1000 REM PLOT GENERATOR
1005 FOR X=X2 TO X3 STEP X1
1010 GOSUB 8000
1015 ON W GOSUB 8100,8200
1020 Y=FNJ(Y)
1030 PRINT ".";
1040 IF Y>61 THEN 1070
1050 IF Y<1 THEN 1070
1058 REM PRINTS POINT
1060 PRINT TAB(Y);"*";
1070 PRINT
1080 NEXT X
2000 GOSUB 9000
7998 REM SUBROUTINE FOR ASSOCIATED LAGUERRE POLYNOMIALS
7999 STOP
8000 X9=FNS(X)*2/N
8010 T=0
8020 C3=1
8030 FOR N1=(A1-B1) TO 0 STEP -1
8040 T=T+C3*(X9+.000001)^N1
8050 C3=C3*N1*(N1+B1)/(N1+B1-A1-1+.000001)
8060 NEXT N1
8080 RETURN
8098 REM EVALUATE EIGENFUNCTION
8100 Y=FNA(X)
8110 RETURN
8198 REM EVALUATE ELECTRON DENSITY FUNCTION
8200 Y=FNB(X)
8210 RETURN
8997 REM AXES SUBROUTINE
8999 STOP
9000 PRINT " ";
9010 FOR I=1 TO 61
9020 PRINT ".";
9030 NEXT I
9040 PRINT
9050 RETURN
97 REM AXES SUBROUTINE
8999 STOP
9000 PRINT " ";
9010 FOR I=1 TO 