	title	'PALANTIR Font Definition File -- 04/13/82'

*****************************************************************
*								*
*		Qume PS Theme 11  -  82069			*
*								*
*	The definition table must be assembled to produce	*
*	a HEX file, which should then be LOADed or SAVEd	*
*	(e.g., SAVE 1 name.WPF) from DDT to create the		*
*	font definition file expected by the PALANTIR.		*
*								*
*	The table consists of 128 2-byte entries for the	*
*	character set from Ascii 0-127.  The first byte of	*
*	each entry is the character size in increments.  The	*
*	second byte is the code to be sent to the printer,	*
*	which for some print wheels is different from the	*
*	original Ascii character.  If the high-order bit of	*
*	the second byte is on, the DFSHFT (Shift) logic in	*
*	the print driver is invoked at printout.		*
*								*
*	For mono-spaced wheels, the first byte will be the	*
*	same throughout.  For wheels that use the normal	*
*	character arrangement, the second byte of each entry	*
*	will contain the next higher binary value.  The first	*
*	32 entries of the table are not normally used, unless	*
*	by the Extended Character Set option for printers	*
*	with more than 96 characters per wheel. 		*
*								*
*****************************************************************

	org	100h

std	 equ	 10	 ;Average size at 12-pitch (at 120 increments)

;	List of character sizes

sza	equ	std-6
szb	equ	std-4
szc	equ	std-2
szd	equ	std
sze	equ	std+2
szf	equ	std+4

	page
;	Control/Extended Range

	db	0,0
	db	0,1
	db	0,2
	db	0,3
	db	0,4
	db	0,5
	db	0,6
	db	0,7
	db	0,8
	db	0,9
	db	0,10
	db	0,11
	db	0,12
	db	0,13
	db	0,14
	db	0,15
	db	0,16
	db	0,17
	db	0,18
	db	0,19
	db	0,20
	db	0,21
	db	0,22
	db	0,23
	db	0,24
	db	0,25
	db	0,26
	db	0,27
	db	0,28
	db	std,' '		;Soft Space
	db	szc,'-'		;Hard Hyphen
	db	std,' '		;Hard Space

	page
;	Standard Ascii Character Set

	db	std,' ' 	;Blank
	db	szb,'!' 	;Exclamation Point
	db	szc,'"' 	;Double Quotes
	db	szc,'#' 	;Pound (Number) Sign
	db	szc,'$' 	;Dollar Sign
	db	szd,'%' 	;Percent Sign
	db	sze,'&'		;Ampersand
	db	sza,''''	;Single Quote
	db	szb,'(' 	;Left Parenthesis
	db	szb,')' 	;Right Parenthesis
	db	szc,'*' 	;Asterisk
	db	szc,'+' 	;Plus Sign
	db	sza,',' 	;Comma
	db	szc,'-' 	;Hyphen (Minus Sign)
	db	szb,'.' 	;Period
	db	szc,'/' 	;Slash
	db	szd,'0' 	;Digit Zero
	db	szd,'1' 	;Digit One
	db	szd,'2' 	;Digit Two
	db	szd,'3' 	;Digit Three
	db	szd,'4' 	;Digit Four
	db	szd,'5' 	;Digit Five
	db	szd,'6' 	;Digit Six
	db	szd,'7' 	;Digit Seven
	db	szd,'8' 	;Digit Eight
	db	szd,'9' 	;Digit Nine
	db	szb,':' 	;Colon
	db	szb,';' 	;Semicolon
	db	szd,'<' 	;Less Than
	db	sze,'=' 	;Equal Sign
	db	szd,'>' 	;Greater Than
	db	szb,'?' 	;Question Mark

	db	szd,'@' 	;At-Sign
	db	sze,'A' 	;Capital A
	db	szd,'B' 	;Capital B
	db	sze,'C' 	;Capital C
	db	sze,'D' 	;Capital D
	db	szc,'E' 	;Capital E
	db	szc,'F' 	;Capital F
	db	sze,'G' 	;Capital G
	db	sze,'H' 	;Capital H
	db	szb,'I' 	;Capital I
	db	szb,'J' 	;Capital J
	db	szd,'K' 	;Capital K
	db	szd,'L' 	;Capital L
	db	sze,'M' 	;Capital M
	db	sze,'N' 	;Capital N
	db	sze,'O' 	;Capital O

	db	szd,'P' 	;Capital P
	db	sze,'Q' 	;Capital Q
	db	szd,'R' 	;Capital R
	db	szc,'S' 	;Capital S
	db	szd,'T' 	;Capital T
	db	sze,'U' 	;Capital U
	db	sze,'V' 	;Capital V
	db	sze,'W' 	;Capital W
	db	szd,'X' 	;Capital X
	db	szd,'Y' 	;Capital Y
	db	szc,'Z' 	;Capital Z
	page
	db	szc,'[' 	;Left Square Bracket (Open)
	db	sze,'\' 	;Backslash
	db	szc,']' 	;Right Square Bracket (Close)
	db	sze,'^' 	;Carat
	db	sze,'_' 	;Underscore

	db	szc,60h 	;Accent
	db	szd,'a' 	;Lowercase a
	db	szd,'b' 	;Lowercase b
	db	szd,'c' 	;Lowercase c
	db	szd,'d' 	;Lowercase d
	db	szd,'e' 	;Lowercase e
	db	szc,'f' 	;Lowercase f
	db	szd,'g' 	;Lowercase g
	db	szd,'h' 	;Lowercase h
	db	szb,'i' 	;Lowercase i
	db	szb,'j' 	;Lowercase j
	db	szc,'k' 	;Lowercase k
	db	szb,'l' 	;Lowercase l
	db	szf,'m' 	;Lowercase m
	db	szd,'n' 	;Lowercase n
	db	szd,'o' 	;Lowercase o

	db	szd,'p' 	;Lowercase p
	db	szd,'q' 	;Lowercase q
	db	szc,'r' 	;Lowercase r
	db	szc,'s' 	;Lowercase s
	db	szc,'t' 	;Lowercase t
	db	szc,'u' 	;Lowercase u
	db	szd,'v' 	;Lowercase v
	db	szf,'w' 	;Lowercase w
	db	szc,'x' 	;Lowercase x
	db	szd,'y' 	;Lowercase y
	db	szc,'z' 	;Lowercase z
	db	szc,'{' 	;Left Curly Brace (Open)
	db	szd,'|' 	;Vertical Bar
	db	szd,'}' 	;Right Curly Brace (Close)
	db	szd,'~' 	;Tilde
	db	0,0		;Delete Code (Not Used)

	end
                           