TITLE	'DAISYIIF.ASM - PALANTIR Font Definition File -- 11/19/82'

*****************************************************************
*								*
*	TRS-80 Daisy Wheel Printer II - Madeline P.S.		*
*		    Catalog Number 26-1422			*
*								*
*	The definition table must be assembled to produce	*
*	a HEX file, which should then be LOADed or SAVEd	*
*	(e.g., SAVE 1 name.WPF) from DDT to create the		*
*	font definition file expected by the PALANTIR.		*
*								*
*	The table consists of 128 2-byte entries for the	*
*	character set from Ascii 0-127.  The first byte of	*
*	each entry is the character size in increments.  The	*
*	second byte is the code to be sent to the printer,	*
*	which for some print wheels is different from the	*
*	original Ascii character.  If the high-order bit of	*
*	the second byte is on, the DFSHFT (Shift) logic in	*
*	the print driver is invoked at printout.		*
*								*
*	For mono-spaced wheels, the first byte will be the	*
*	same throughout.  For wheels that use the normal	*
*	character arrangement, the second byte of each entry	*
*	will contain the next higher binary value.  The first	*
*	32 entries of the table are not normally used, unless	*
*	by the Extended Character Set option for printers	*
*	with more than 96 characters per wheel. 		*
*								*
*****************************************************************

	org	100h

std	 equ	 5

;	List of character sizes

sza	equ	std-2
szb	equ	std-1
szc	equ	std-0
szd	equ	std+1
sze	equ	std+2
szf	equ	std+3

	page
;	Control/Extended Range - Translate @ - ^

	db	szc,080h		; a with accent grave
	db	szc,09ch		; c with cedile
	db	szc,0a3h		; Pound Sterling symbol
	db	szc,0a5h		; Greek mu - 'micro'
	db	szb,0a6h		; degree symbol
	db	szc,0a7h		; accent egue
	db	szc,0a8h		; dagger
	db	szc,0a9h		; TM
	db	szd,0aah		; Registered symbol
	db	szd,0abh		; copyright symbol
	db	szc,0ach		; 1/4
	db	szc,0adh		; 3/4
	db	szc,0aeh		; 1/2
	db	szc,0afh		; Paragraph symbol
	db	szc,0bbh		; e with accent egue
	db	szc,0bch		; u with accent grave
	db	szc,0bdh		; e with accent grave
	db	szc,0beh		; umlaudt
	db	szc,0bfh		; script f
	db	szc,0c0h		;
	db	szc,0cch		;
	db	sze,0dbh		; A with umlaudt
	db	szc,0dch		; O with umlaudt
	db	szd,0ddh		; U with umlaudt
	db	szc,0deh		; cent sign
	db	szc,0dfh		; double score
	db	szc,0fbh		; a with umlaudt
	db	szc,0fch		; o with umlaudt
	db	szc,0fdh		; u with umlaudt
	db	szc,0feh		; Greek - capital Beta
	db	szb,'-'		;Hard Hyphen
	db	stc,' '		;Hard Space

	page
;	Standard Ascii Character Set

	db	szc,' ' 	;Blank
	db	sza,'!' 	;Exclamation Point
	db	szb,'"' 	;Double Quotes
	db	szd,'#' 	;Pound (Number) Sign
	db	szc,'$' 	;Dollar Sign
	db	sze,'%' 	;Percent Sign
	db	sze,'&'		;Ampersand
	db	sza,''''	;Single Quote
	db	sza,'(' 	;Left Parenthesis
	db	sza,')' 	;Right Parenthesis
	db	szc,'*' 	;Asterisk
	db	szc,'+' 	;Plus Sign
	db	sza,',' 	;Comma
	db	szb,'-' 	;Hyphen (Minus Sign)
	db	sza,'.' 	;Period
	db	szb,'/' 	;Slash
	db	szc,'0' 	;Digit Zero
	db	szc,'1' 	;Digit One
	db	szc,'2' 	;Digit Two
	db	szc,'3' 	;Digit Three
	db	szc,'4' 	;Digit Four
	db	szc,'5' 	;Digit Five
	db	szc,'6' 	;Digit Six
	db	szc,'7' 	;Digit Seven
	db	szc,'8' 	;Digit Eight
	db	szc,'9' 	;Digit Nine
	db	sza,':' 	;Colon
	db	sza,';' 	;Semicolon
	db	szc,'<' 	;Less Than
	db	szc,'=' 	;Equal Sign
	db	szc,'>' 	;Greater Than
	db	szc,'?' 	;Question Mark

	db	sze,'@' 	;At-Sign
	db	sze,'A' 	;Capital A
	db	szd,'B' 	;Capital B
	db	sze,'C' 	;Capital C
	db	szd,'D' 	;Capital D
	db	szd,'E' 	;Capital E
	db	szd,'F' 	;Capital F
	db	sze,'G' 	;Capital G
	db	szd,'H' 	;Capital H
	db	sza,'I' 	;Capital I
	db	szc,'J' 	;Capital J
	db	sze,'K' 	;Capital K
	db	szd,'L' 	;Capital L
	db	szf,'M' 	;Capital M
	db	szd,'N' 	;Capital N
	db	sze,'O' 	;Capital O

	db	szd,'P' 	;Capital P
	db	sze,'Q' 	;Capital Q
	db	sze,'R' 	;Capital R
	db	szc,'S' 	;Capital S
	db	szd,'T' 	;Capital T
	db	szd,'U' 	;Capital U
	db	szd,'V' 	;Capital V
	db	szf,'W' 	;Capital W
	db	sze,'X' 	;Capital X
	db	sze,'Y' 	;Capital Y
	db	szd,'Z' 	;Capital Z
	page
	db	sza,'[' 	;Left Square Bracket (Open)
	db	szb,'\' 	;Backslash
	db	sza,']' 	;Right Square Bracket (Close)
	db	szc,'^' 	;Carat
	db	szc,'_' 	;Underscore

	db	szc,060h 	;Accent
	db	szc,'a' 	;Lowercase a
	db	szc,'b' 	;Lowercase b
	db	szc,'c' 	;Lowercase c
	db	szc,'d' 	;Lowercase d
	db	szc,'e' 	;Lowercase e
	db	szb,'f' 	;Lowercase f
	db	szc,'g' 	;Lowercase g
	db	szc,'h' 	;Lowercase h
	db	sza,'i' 	;Lowercase i
	db	sza,'j' 	;Lowercase j
	db	szc,'k' 	;Lowercase k
	db	sza,'l' 	;Lowercase l
	db	sze,'m' 	;Lowercase m
	db	szc,'n' 	;Lowercase n
	db	szc,'o' 	;Lowercase o

	db	szc,'p' 	;Lowercase p
	db	szc,'q' 	;Lowercase q
	db	szb,'r' 	;Lowercase r
	db	szb,'s' 	;Lowercase s
	db	szb,'t' 	;Lowercase t
	db	szc,'u' 	;Lowercase u
	db	szc,'v' 	;Lowercase v
	db	sze,'w' 	;Lowercase w
	db	szc,'x' 	;Lowercase x
	db	szc,'y' 	;Lowercase y
	db	szc,'z' 	;Lowercase z
	db	sza,'{' 	;Left Curly Brace (Open)
	db	sza,'|' 	;Vertical Bar
	db	sza,'}' 	;Right Curly Brace (Close)
	db	szc,'~' 	;Tilde
	db	0,0		;Delete Code (Not Used)

	end
                     	!)7AKU_is}
DFXTRA	EQU	$
DFEDOC	DB	0	