/*
 *
 *	Revision History:
 *
 *		03 sep 86	wrf		sw# 94
 *			moved _wsopen() to open_ws.c
 */
#include <stdio.h>

#include <gks/gks_types.h>
#include <gks/message.h>

#include "wsinfo.h"

/*
 *	Workstation Types formerly in gks_types.h
 *
 *	saved here for future reference in case
 *	we ever support additional workstations
 *
 *	#define WST_WISS 0
 *	#define WST_MO 1
 *	#define WST_MI 2
 *	#define WST_CX1200 3
 *	#define WST_CX1300 4
 *	#define WST_CX1400 5
 *	#define WST_CX1500 6
 *	#define WST_CX15OV 7
 *	#define WST_CX1500A WST_CX1500
 *	#define WST_CX15OVA WST_CX15OV
 *	#define WST_CX1500B 8
 *	#define WST_CX15OVB 9
 *	#define WST_HPPLOT 10
 */


/*
 *	"supported" workstations
 */
#define W_GKSM	"gksm"
#define W_1200	"cx1200"
#define W_1300	"cx1300"
#define W_1400	"cx1400"
#define W_1500	"cx1500"
#define W_HP	"hpws"


/*
 * The routines in this module provide the interface
 * to the workstation control structure.
 */

struct wsinfo wshead = 0;		/* head of open workstation list. */
struct wsinfo *wscurs = NULL;	/* cursor to walk list of open workstations */


/*
 *	make pathname by concatenating
 *	Gkspath w/ fname
 */
char *Gksfname( fname )
	char *fname;
	{
#ifdef vms
	globalref char *Gkspath;
#else
	extern char *Gkspath;
#endif

	static char pathname[MAXPATH];
	int l;

	l = strlen(Gkspath);
	copystr(pathname, Gkspath, MAXPATH);
	copystr(&pathname[l], fname, MAXPATH - l);

	return (pathname);

	}


/*
 *	add workstation to list of open workstations.
 */
BOOL WsAdd( wkid, pid, type, categ, conn )
	WKID wkid;
	PID pid;
	WSTYPE type;
	WSCATEG categ;
	char *conn;
	{
	struct wsinfo *ws;

	if((ws = (struct wsinfo *)malloc(sizeof(struct wsinfo))) == NULL)
		return (FALSE);
	
	ws->wsi_id = wkid;
	ws->wsi_pid = pid;
	ws->wsi_type = type;
	ws->wsi_categ = categ;
	ws->wsi_active = FALSE;
	copystr(ws->wsi_conn, conn, MAXCONN);
	ws->wsi_next = wshead.wsi_next;
	wshead.wsi_next = ws;
	return (TRUE);

	}


/*
 *	deactivate all active CX workstations,
 *	activate the target workstation.
 *
 *	Recall that the CX has a strage method of
 *	handling graphics commands.  Because segment
 *	memory is shared between users, only one
 *	workstation can add primitives to the display
 *	list.  Only one workstation out of a set of
 *	multiple active workstations handles the data -
 *	the other workstations ignore it.  This mechanism
 *	must be defeated for assoc_seg() and copy_seg()
 *	to work correctly.
 *
 *	called by assoc_seg() and copy_seg()
 */
VOID WsDeact( ws )
	struct wsinfo *ws;
	{
	register struct wsinfo *w;

	for (w = &wshead; w != NULL; w = w->wsi_next)
		{
		w->wsi_savact = w->wsi_active;
		if (WsIsCx(w))
			{
			if ((w == ws) && !w->wsi_active)
				activate(WsWkid(w));
			else if (w->wsi_active)
				deactivate(WsWkid(w));
			}
		}
	}


/*
 *	restore active state of workstations
 *	diddled with by WsDeact
 *
 *	called by assoc_seg() and copy_seg()
 */
VOID WsReact( )
	{
	register struct wsinfo *w;

	for (w = &wshead; w != NULL; w = w->wsi_next)
		{
		if (w->wsi_savact != w->wsi_active)
			{
			if (w->wsi_savact)
				activate(WsWkid(w));
			else
				deactivate(WsWkid(w));
			}
		}
	}


/*
 *	delete workstation from list of open workstations.
 */
BOOL WsDelete( wkid )
	WKID wkid;
	{
	struct wsinfo *ws;
	struct wsinfo *wssv;

	for(ws = &wshead; ws != NULL; ws = ws->wsi_next)
		if((ws->wsi_next != NULL) && (ws->wsi_next->wsi_id == wkid))
			{
			wssv = ws->wsi_next;
			ws->wsi_next = wssv->wsi_next;
			free(wssv);
			return (TRUE);
			}

	return (FALSE);

	}


/*
 *	delete workstation from list of open workstations from pid
 */
BOOL WsDelpid( pid )
	PID pid;
	{
	struct wsinfo *ws;
	struct wsinfo *wssv;

	for(ws = &wshead; ws != NULL; ws = ws->wsi_next)
		if((ws->wsi_next != NULL) && (ws->wsi_next->wsi_pid == pid))
			{
			wssv = ws->wsi_next;
			ws->wsi_next = wssv->wsi_next;
			free(wssv);
			return (TRUE);
			}

	return (FALSE);

	}


/*
 *	map workstation id to info structure.
 */
WSINFO WsId2info(wkid)
	WKID wkid;
	{
	struct wsinfo *ws;

	for(ws = wshead.wsi_next; ws != NULL; ws = ws->wsi_next)
		if(ws->wsi_id == wkid)
			return (ws);

	return (NULL);

	}


/*
 *	map info structure to id
 */
WKID WsWkid( ws )
	WSINFO ws;
	{

	return (ws->wsi_id);

	}


/*
 *	change workstation state
 */
VOID WsSetstate( wsinfo, active )
	WSINFO wsinfo;
	BOOL active;
	{

	wsinfo->wsi_active = active;

	}


/*
 *	get workstation state [active, not active]
 */
BOOL WsActive( wsinfo )
	WSINFO wsinfo;
	{

	return (wsinfo->wsi_active);

	}


/*
 *	return process id of workstation handler
 */
PID WsGetpid( wsinfo )
	WSINFO wsinfo;
	{

	return (wsinfo->wsi_pid);

	}


/*
 *	return workstation category
 */
WSCATEG WsGetcat( wsinfo )
	WSINFO wsinfo;
	{

	return (wsinfo->wsi_categ);

	}


/*
 *	return workstation type
 */
WSTYPE WsGettype( wsinfo )
	WSINFO wsinfo;
	{

	return (wsinfo->wsi_type);

	}


/*
 *	return workstation connection
 */
char *WsGetconn( wsinfo )
	WSINFO wsinfo;
	{

	return (wsinfo->wsi_conn);

	}


/*
 *	return ^info for first open workstation
 */
WSINFO WsFirst( )
	{

	return (wscurs = wshead.wsi_next);

	}


/*
 *	return ^info for next open workstation
 */
WSINFO WsNext( )
	{

	if( wscurs != NULL)
		return (wscurs = wscurs->wsi_next);
	else
		return (NULL);

	}


#ifdef DEBUG
/*
 *	display workstation information
 */
VOID WsPrint( )
	{
	struct wsinfo *ws;

	for(ws = wshead.wsi_next; ws != NULL; ws = ws->wsi_next)
		dumpws(ws);

	}

VOID dumpws( wsinfo )
	struct wsinfo *wsinfo;
	{

	Gksout("id: %d\tpid: %d\ttype:%d\tcat: %d\tstate: %d\n",
		wsinfo->wsi_id, wsinfo->wsi_pid, wsinfo->wsi_type,
		wsinfo->wsi_categ, wsinfo->wsi_active);
	}

#endif


/*
 *	information about workstations supported in
 *	this implementation.
 */
static struct wsdata Wsdata[] =
	{
		{"",	 WSC_WISS},		/* WISS */
		{W_GKSM, WSC_MO},		/* MO */
		{W_GKSM, WSC_MI},		/* MI */
		{W_1200, WSC_OUTIN},	/* cx1200 */
		{W_1300, WSC_OUTIN},	/* cx1300 */
		{W_1400, WSC_OUTIN},	/* cx1400 */
		{W_1500, WSC_OUTIN},	/* cx1500 bit map (head 1) */
		{W_1500, WSC_OUTIN},	/* cx1500 overlay (head 1) */
		{W_1500, WSC_OUTIN},	/* cx1500 bit map (head 2) */
		{W_1500, WSC_OUTIN},	/* cx1500 overlay (head 2) */
		{W_HP,	 WSC_OUTPUT}	/* hp plotter */
	};


short Wscnt = (sizeof(Wsdata)/sizeof(Wsdata[0]));

struct wsdata *wsdata = Wsdata;

/*
 *	return number of supported workstations
 */
int Wsnumws()
	{

	return (Wscnt);

	}


/*
 *	mark child as expected to die soon.
 */
VOID WsCondemn( ws )
	WSINFO ws;
	{

	ws->wsi_categ = 0;

	}


/*
 *	check if child is expected to die.
 */
BOOL WsIscondemned( pid )
	PID pid;
	{
	struct wsinfo *ws;

	for(ws = WsFirst(); ws != NULL; ws = WsNext())
		if(ws->wsi_pid == pid)
			return (ws->wsi_categ == 0);

	return (TRUE);

	}


/*
 *	exclaim unable to receive message from workstation
 */
GKSERR WsNomsg( )
	{

	Gksout("internal error: unable to receive message from workstation\n");
	
	return (903);

	}


/*
 *	determine if workstation is a CX
 *	using WSINFO structure;
 */
BOOL WsIsCx( ws )
	WSINFO ws;
	{
	extern BOOL CX_Series();

	return (CX_Series(WsGettype(ws)));

	}



/*
 *	determine if workstation is a CX from its type
 */
BOOL CX_Series( type )
	WSTYPE type;
	{

	return (type == WST_CX1500  ||
		    type == WST_CX15OV  ||
		    type == WST_CX1500B ||
			type == WST_CX15OVB);

	}


/*
 *	determine if CX Workstation is already open
 */
WSINFO CX_IsOpen( )
	{
	WSINFO ws;

	for (ws = WsFirst(); ws != NULL; ws = WsNext())
		if (WsIsCx(ws))
			break;
	
	return (ws);

	}
