#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/ptrep.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern BOOL _GksAck;

/*
 * set pattern representation
 */

GKSERR
s_pt_rep(wkid, index, ptx, pty, ptarry)
WKID wkid ;
int index ;
int ptx, pty ;
COLOR *ptarry ;
{
	static char *fname = "s_pt_rep" ;
	struct msptrep *msg ;
	struct rpptrep *reply ;
	int msgsize ;
	WSINFO ws ;
	GKSERR retval = 0 ;

#ifdef TRACE
	if(Gksdebug & DB_ATTR)
		Gksout("%s( %d, %d, %d, %d, colors)\n", fname, wkid, index,
					ptx, pty) ;
#endif

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
		return(err_hand(7, fname)) ;

	if(index <= 0)
		return(err_hand(79, fname)) ;

/*
 * deliver "set pattern representation" message
 */

	ws = WsId2info(wkid) ;
	if(ws == NULL)
		return(err_hand(25, fname)) ;

	if(WsGetcat(ws) == WSC_MI)
		return(err_hand(33, fname)) ;

	if(WsGetcat(ws) == WSC_INPUT)
		return(err_hand(35, fname)) ;

	if(WsGetcat(ws) == WSC_WISS)
		return(err_hand(36, fname)) ;

/*
 * note variable size message here
 * the set pattern rep message allocates room for one color - 
 * (ptx*pty-1)*sizeof(COLOR) more are needed.
 */
	msgsize = sizeof(struct msptrep) + (ptx*pty-1)*sizeof(COLOR) ;
	msg = (struct msptrep *)_allocmsg( msgsize) ;
	if(msg == NULL)
		return(err_hand(904, fname)) ;
	ptrepmsg(msg, WsGetpid(ws), msgsize, index, ptx, pty, ptarry) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	if (_GksAck)
		{
		reply = (struct rpptrep *)_recvmsg(WsGetpid(ws)) ;
		if(reply == NULL)
			return (err_hand(WsNomsg(), fname));
		switch(reply -> mhdr.msg_reply)
			{
		case 0:
			retval = 0 ;
			break ;

		case 1:
			retval = 83 ;
			break ;

		case 2:
			retval = 79 ;
			break ;

		case 3:
			retval = 84 ;
			break ;
		
		case 4:
			retval = 86 ;
			break ;
		
		default:
			Gksout("s_pt_rep: internal error in switch\n") ;
			retval = 0 ;
			}
		_freemsg(reply) ;
		}

	if(retval != 0)
		err_hand(retval, fname) ;
	return(retval) ;
}

static
ptrepmsg(msg, pid, msgsize, index, ptx, pty, color)
struct msptrep *msg ;
PID pid ;
int msgsize ;
int index ;
int ptx, pty ;
COLOR *color ;
{
	msg -> mhdr.msg_id = MSPTREP ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = msgsize - sizeof(MSGHDR) ;
	msg -> mhdr.msg_ack = _GksAck ;
	msg -> mhdr.msg_reply = 0 ;
	msg -> ptr_patno = index ;
	msg -> ptr_dx = ptx ;
	msg -> ptr_dy = pty ;
	cpybuf( msg -> ptr_color, color, ptx * pty * sizeof( COLOR)) ;
}

static char *SccsId = "@(#)s_pt_rep.c	1.4\t2/18/85" ;
