#include <gks/gks_types.h>
#include <gks/gks_structs.h>

/*
 *	set mode for all classes
 */
#if 0
GKSERR _s_md_all( fname, wkid, devno, class, mode, echo )
	char *fname;
	WKID wkid;
	int devno;
	INPUTCLASS class;
	INPUTMODE mode;
	BOOL echo;
	{
	struct msinpmode *msg;
	MSGHDR *reply;
	WSINFO ws;
	register int res = 0;
	int wscat;

#ifdef TRACE
	if(Gksdebug & DB_INPUT)
		Gksout("%s(%d, %d, %d, %d)\n", fname, wkid, devno, mode, echo);
#endif

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
		return(err_hand(7, fname));
	
	if(wkid == 0 )
		return(err_hand(20, fname));

	ws = WsId2info(wkid);
	if(ws == NULL)
		return(err_hand(25, fname));

	wscat = WsGetcat(ws);

	if (class == PICK && wscat != WSC_OUTIN)
		return(err_hand(37, fname));

	if((wscat != WSC_OUTIN) && (wscat != WSC_INPUT))
		return(err_hand(38, fname));

/*
 *	deliver "set mode" message
 */
	msg = (struct msinpmode *)_allocmsg(sizeof(struct msinpmode));
	if(msg == NULL)
		return(err_hand(904, fname));
	
	msg->mhdr.msg_id = MSINPMODE;
	msg->mhdr.msg_to = WsGetpid(ws);
	msg->mhdr.msg_length = sizeof(struct msinpmode) - sizeof(MSGHDR);
	msg->mhdr.msg_ack = _GksAck;
	msg->mhdr.msg_reply = 0;
	msg->inpcls = class;
	msg->inpdevno = devno;
	msg->inpmode = mode;
	msg->inpecho = echo;

	_sendmsg((char *)msg);

/*
 *	wait for reply
 */
	if (_GksAck)
		{
		reply = (MSGHDR *)_recvmsg(WsGetpid(ws));
		if(reply == NULL)
			return (err_hand(WsNomsg(), fname));

		switch (reply->msg_reply)
			{
		case 0:				/* success */
			res = 0;
			break;
		
		case 1:				/* device not present */
			res = 140;
			break;
		
		case 2:				/* device not ready */
			res = 1015;
			break;
		
		default:
			Gksout("gks internal error: bad reply to %s.\n", fname);
			Gksout("\twkid = %d, reply = %d\n", wkid, reply->msg_reply);
			res = 0;
			}

		_freemsg(reply);
		}

	if (res != 0)
		return (err_hand(res, fname));

	return (0);

	}
#endif
