#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/inputmsg.h>

#include <gks/trace.h>


/*
 *	request stroke
 */
GKSERR rq_stk( wkid, devno, status, norm, npts, pts )
	WKID wkid;
	int  devno;
	BOOL *status;
	int  *norm;
	int  *npts;
	WCPT pts[];
	{
	int i;
	int res;
	struct rpinpreq *reply;
	static char *fname = "rq_stk";

	res = _rq_all(fname, wkid, devno, STROKE, &reply);
	if (res == 0)
		{
		/*
		 *	map back to WC through highest priority viewport
		 */
		*npts = reply->reqrec.inpt_stk.stk_npts;
		*norm = _stknorm(*npts, reply->reqrec.inpt_stk.stk_pts);
		for(i = 0; i < *npts; ++i)
			_ndc2wc(*norm, &(reply->reqrec.inpt_stk.stk_pts[i]), &pts[i]);

		*status = reply->reqstat;
		_freemsg(reply);

#ifdef TRACE
		if(Gksdebug & DB_INPUT)
			Gksout("%s returns %d points\n", fname, *npts);
#endif
		}
	
	return (res);

	}
