#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire workstation state
 */
VOID
q_ws_state(wkid, errno, active)
WKID wkid ;
GKSERR *errno ;
BOOL *active ;
{
	static char *fname = "q_ws_state" ;
	WSINFO ws ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}

	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}

	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}

	if(WsGetcat(ws) == WSC_INPUT)
	{
		*errno = 35 ;
		return ;
	}

	*errno = 0 ;
	*active = WsActive(ws) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d)\n", fname, wkid, *errno, *active) ;
#endif
}

static char *SccsId = "@(#)q_ws_state.c	1.2\t2/21/85" ;
