#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qwdinfo.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate;

struct wdinfo *Getwdinfo();
/*
 * provide buffer service for qwdinfo message
 */

static WSTYPE curwk = 0;
static struct wdinfo wdinfo;

struct wdinfo *
Getwdinfo(wktype, errno)
WSTYPE wktype;
GKSERR *errno;
{
	struct msqwdinf *msg;
	struct rpqwdinf *reply;
	WSINFO ws;
	BOOL must_close = FALSE;

	if(curwk != wktype)
	{
		if((msg = (struct msqwdinf *)_allocmsg(sizeof(struct msqwdinf)))
			== NULL)
		{
			Gksout("unable to allocate message\n");
			return(NULL);
		}
/*
 * see if workstation of specified type is already open.
 */
		for(ws = WsFirst(); ws != NULL; ws = WsNext())
			if(WsGettype(ws) == wktype)
				break;

		if (ws == NULL)
			{
			*errno = 25;
			return (NULL);
			}
/***********************************************************************
		if(ws == NULL)		/* quel dommage!
							 * must open workstation, ask, and close it.
							 */
/***********************************************************************
		{
			if(open_ws(0xffff, "", wktype) != 0)
			{
				*errno = 22;
				return(NULL);
			}
			ws = WsId2info(0xffff);
			must_close = TRUE;
		}
***********************************************************************/
		if((WsGetcat(ws) != WSC_OUTPUT) && (WsGetcat(ws) != WSC_OUTIN))
		{
			*errno = 39;
			if(must_close)
				close_ws(0xffff);
			return(NULL);
		}

		wdinfmsg(msg, WsGetpid(ws));
		_sendmsg((char *)msg);
		/*
		 * wait for reply
		 */
		reply = (struct rpqwdinf *)_recvmsg(WsGetpid(ws));
		if(reply == NULL)
			{
			*errno = WsNomsg();
			return (NULL);
			}

		cpybuf(&wdinfo, &(reply->qd_info), sizeof(wdinfo));
		curwk = wktype;
		_freemsg(reply);
	}
	*errno = 0;
	if(must_close)
		close_ws(0xffff);
	return(&wdinfo);
}

static
wdinfmsg(msg, pid)
struct msqwdinf *msg;
PID pid;
{
	msg->mhdr.msg_id = MSQWDINFO;
	msg->mhdr.msg_to = pid;
	msg->mhdr.msg_length = sizeof(struct msqwdinf) - sizeof(MSGHDR);
	msg->mhdr.msg_ack = TRUE;
	msg->mhdr.msg_reply = 0;
}

static char *SccsId = "@(#)q_wdinfo.c	1.6\t3/12/85";
