/* Read/Write binary segment data to files on host
 *
 * Demonstate readback and writeback of a single segment
 * using the cxgseg() and cxsseg() escapes
 * by creating a file containing the segment and then
 * using it to download a segment to the CX
 *
 * Performance is very dependent on the method used
 * to read/write files on the host system. This
 * demo does not use any optimization in that area.
 * A small file buffer is used to test multiple transfers.
 * In real use, a larger buffer >30KB should be used.
 *
 */

#include <stdio.h>
#include <math.h>
#include "gks.h"

#ifdef sun
#include <sys/file.h>
#else
#ifdef vms
#include <sys/file.h>
#else
#include <fcntl.h>
#endif
#endif

#define WS 1
#define BSIZE 16384

static short data[BSIZE];

#ifdef DEBUG
main()
{
	Gfloat	m[2][3];
	Gint	i;

	gopengks(NULL, 0);
	openws(GCXHD1, "Read/Write Segments With Host Files");
	gactivatews(WS);

	makseg("demo.seg");

	m[0][0] = 1.0;
	m[0][1] = 0.0;
	m[0][2] = 0.0;
	m[1][0] = 0.0;
	m[1][1] = 1.0;
	m[1][2] = 0.5;

	for (i = 1; i <= 10; i++)
		{
		_putseg(i, "demo.seg");
		m[0][2] = (float) i / 11.0;
		gsetsegtran(i, m);
		}

	cxpaus();
	gdeactivatews(WS);
	gclosews(WS);
	gclosegks();
}

/*
 * Create a segment named fname
 */

makseg(fname)
	Gchar  *fname;
{
	Gint	n, i;
	Gfloat	theta, ang;
	Gpoint	points[31];
	Gfloat	r;

	/* Make solid object with border */

	r = 0.04;
	n = 28;
	theta = (360.0 / (n + 1)) * 3.14159265 / 180.0;
	for (i = 0; i <= n; i++)
		{
		ang = theta * i;
		points[i].x = r * cos(ang);
		points[i].y = r * sin(ang);
		}
	gcreateseg(1);
	gsetfillintstyle(GSOLID);
	gsetfillcolourind(6);
	gfillarea(n, points);
	gsetfillintstyle(GHOLLOW);
	gsetfillcolourind(7);
	gfillarea(n, points);
	gcloseseg();
	_getseg(WS, 1, fname);
	gdelseg(1);
	cxpaus();
	return;
}
#endif

/*
 * get segment SEGID from CX and store in file FNAME
 */

_getseg(wkid, segid, fname)
	Gint	wkid;		/* not used or checked */
	Gint	segid;
	Gchar  *fname;
{
	Gint	size, tsize, dsize, nsize;
	int	fd;

#ifdef vms
	if ((fd = creat(fname, 0x0)) < 0)
#else
	if ((fd = open(fname, O_WRONLY | O_CREAT | O_TRUNC, 0644)) < 0)
#endif
		{
		printf("Can't create \"%s\"\n", fname);
		return 9999;
		}

	dsize = BSIZE;
	tsize = 0;
	do
		{
		cxgseg(segid, dsize, &size, &nsize, data);
		if (dsize == BSIZE)
			{
			dsize = 0;
			write(fd, (char *) &size, 4);
			printf("Segment size is:%d\n", size * 2);
			}
		write(fd, (char *) data, nsize * 2);
		tsize += nsize;
		} while (tsize != size);
	close(fd);
	return 0;
}

/*
 * transfer file contents to segment on CX
 * see comments in _getseg()
 */

_putseg(segid, fname)
	Gint	segid;
	Gchar  *fname;
{
	Gint	size, tsize, n, fsize;
	Gint	fd;

	fd = open(fname, 0);
	if (fd < 0)
		{
		perror("System error in _putseg");
		return 9999;
		}

	read(fd, (char *) (&size), 4);
	fsize = size;
	tsize = 0;
	do
		{
		if (fsize - tsize >= BSIZE)
			n = BSIZE;
		else
			n = fsize - tsize;
		read(fd, (char *) data, n * 2);
		cxsseg(segid, size, n, data);
		size = 0;
		tsize = tsize + n;
		} while (tsize != fsize);
	close(fd);
	return 0;
}
