/* GKS parameters
 *
 * Copyright 1989 Chromatics. Inc. Release 1.3 SCCS 1.1 (89/01/19)
 *
 */

#include <stdio.h>

/* logical values */

#define FALSE     0
#define TRUE      1

#if 0
/* trace parameters */

#define GDBCTL 1 
#define GDBOUT 2 
#define GDBATT 4 
#define GDBINP 8 
#define GDBSEG 16 
#define GDBINQ 32 
#define GDBMET 64 
#define GDBXFM 128 
#define GDBUTL 256 
#define GDBESC 512 
#define GDBINT 1024 
#endif

/* misc */

#define REPLY 1 
#define NOREPLY 0 

/* vp/wn indices */
#define XMIN 1
#define XMAX 2 
#define YMIN 3 
#define YMAX 4 

/* connection types between the host and the CX */

#define CXITTY 0	/* packed serial interface */
#define CXIDMA 1	/* DMA interface */
#define CXINET 2	/* tcp network interface */
#define CXIRTTY 3	/* unpacked tty */
#define CXISIM  4	/* simulation (i/o to DR11 socket)*/
#define CXITEST 5	/* debug test (printf)*/
#define CXIMAX  5	/* last legal connection */

/* special workstation types (internal) */

#define CXWISS  -1
#define CXMO	-2
#define CXMI	-3

/* gks states (Note: must be ascending #'s ) */

#define GKCL 0 
#define GKOP 1 
#define WSOP 2 
#define WSAC 3 
#define SGOP 4 

/*limits */

#define MAXWRK 32           /* workstations maintained */
#define MAXBUF 8502         /* size of dma buffer in shorts */
#define MAXMSGBUF 8502      /* size of scratch buffer in shorts */
#define MAXCHAR 256         /* max size of gtx text string */
#define MAXTRANS 64         /* max # of nt's */
#define MAXATTR 28          /* number of simple attributes in DLP RAM */
#define MAXATTRSIZ 37       /* number of IAT attributes in DLP RAM */
#define MAXDDNAME 128       /* default DMA device name length */
#define MAXSTROKEBUF 64     /* maximum stroke device buffer size */
#define MAXDISPLAY 8        /* maximum display surfaces */
#define MAXPTS 255          /* maximum complex fillarea points */
#define MAXTXT 255          /* maximum string size */

/* dma buffer states */

#define NORMAL 0 
#define DLPESC 1 

/* deferral */

#define ASAP 0 
#define ASTI 3 

/* default or current output representation */

#define DEFAULT 0 
#define CURRENT 1 

/* GKS input classes */

#define LOCATOR 1 
#define STROKE 2 
#define VALUATOR 3 
#define CHOICE 4 
#define PICK 5 
#define STRING 6 
#define PAN 7 

/* Message Parameters */

#define MSGID 1 
#define MSGFROM 2 
#define MSGTO 3 
#define MSGACK 4 
#define MSGLEN 5 
#define MSGREPLY 6 
#define MSGDATA 7 

/* input device state query offsets */

#define MSQDREC 281 

/* message sizes */

#define MSGSIZHDR 6 
#define MSGSIZDLP 6 

#ifdef SUN
#define MIEEE 1
#define MBYTE 1
#endif

#ifdef VAX
#define MBYTE 1
#endif

/* ieee,host - floating pt conversion */

#ifndef MIEEE
extern float qzieeef();
#define ieee(A,B) qzfieee(&A,&B)
#define host(A) qzieeef(&A)
#endif

/* no conversion */
#ifdef MIEEE
#define ieee(A,B) (B = A)
#define host(A) (A)
#endif

#define MIN(x, y)	(((x) < (y)) ? (x) : (y))

/* gkserror - gkserror(errnumber) */

#define gkserror(A) {gerrorhand(A,fctid,(Gfile *)NULL);return(A);}

/* inqerror - inqerror(errnumber) */

#define inqerror(A) {*errind=(A);return;}

/* gkserrmsg - gkserrmsg(errstr) */

#define gkserrmsg(A) {qzwstr(A);gerrorhand(-2,fctid,(Gfile *)NULL)}

/* setint - copy integer to short array "setint(s, index, int)" */

#define setint(A,B,C) {A[B]=(C>>16);A[B+1]=(C&0xffff);}

/* usetint - copy short array to integer "usetint(hiword, loword, int)" */

#define usetint(A,B,C,D) C=(D)(((int)A << 16) | ((int)B & 0xffff))
