/*
 *
 *	SCCS info	-	@(#)psbrarp.c	1.5   4/22/93
 *
 * Copyright (c) 1994 by Castelle
 * The use of this software is restricted to Castelle customers.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE CASTELLE ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE CASTELLE BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	psbrarp.c	-	Print Server RARP reply via IP/UDP broadcast
 *
 */

#ifdef	UNIXWARE
#define BSD	1
#endif	UNIXWARE

#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#ifdef	IBMAIX
#include <sys/time.h>
#include <sys/ioctl.h>
#else
#ifdef	BSD
#include <sys/sockio.h>
#else
#ifndef	HPUX
#include <sys/stream.h>
#endif	HPUX
#endif	BSD
#endif	IBMAIX
#include <net/if.h>
#include <net/if_arp.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netdb.h>
#include <stdio.h>

#include "psipcfg.h"

#ifdef	UNIXWARE
#undef BSD
#endif	UNIXWARE

/* RARP reply packet to be broadcast */
struct	ether_arp	ea;
char				ifname[64];
struct	in_addr		inaddr;

#ifdef	HPUX
#define	DEFAULT_IFNAME	"lan0"
#else
#ifdef	IBMAIX
#define	DEFAULT_IFNAME	"en0"
#else
#define	DEFAULT_IFNAME	"le0"
#endif	IBMAIX
#endif	HPUX

/*
 *
 *	Show usage and exit
 *
 */

usage(cmd)
char *cmd;
{
	printf("Usage:\n	%s SERIAL_NUMBER IP_ADDRESS INTERFACE\n", cmd);
	printf("\nwhere\n");
	printf("	SERIAL_NUMBER is the 8-digit# of Castelle Print Server\n");
	printf("	IP_ADDRESS is the internet address e.g. 12.23.34.45\n");
	printf("	INTERFACE is the network interface name in 'netstat -i'\n");
	printf("			[default interface: %s]\n", DEFAULT_IFNAME);

	exit(1);
}

/*
 *
 *	UDP/IP broadcaster of a RARP-style reply
 *
 */

main(argc, argv)
int argc;
char *argv[];
{
	struct	ifreq		ifr;
	struct	sockaddr_in	*sin;
	int					s, on = 1;
	struct hostent		*hp = 0, *gethostbyname();

	if (argc < 3)
		usage(argv[0]);

	if (strlen(argv[1]) != 8)
		usage(argv[0]);

	/* extract IP address */
	inaddr.s_addr = inet_addr(argv[2]);

	/* extract interface name */
	if (argc > 3)
		strcpy(ifname, argv[3]);
	else
		strcpy(ifname, DEFAULT_IFNAME);

	s = socket(AF_INET, SOCK_DGRAM, 0);
	strncpy(ifr.ifr_name, ifname, sizeof(ifr.ifr_name));

	if (ioctl(s, SIOCGIFBRDADDR, (caddr_t) &ifr) < 0) {
		printf("%s command failed.\n", argv[0]);
		perror("Error: ioctl (SIOCGIFADDR)");
		printf("Please check interface name %s\n", ifname);
		exit(3);
	}

	sin = (struct sockaddr_in *) &ifr.ifr_addr;
	sin->sin_port = htons(PSIPCFG_PORT);
	if (sin->sin_addr.s_addr != 0)
		printf("Interface: %s, IP broadcast address = %s\n",
						ifname, inet_ntoa(sin->sin_addr));
	else {
		printf("%s command failed.\n", argv[0]);
		printf("Interface: %s, IP broadcast address is ZERO!\n", ifname);
		exit(4);
	}

	if (setsockopt(s, SOL_SOCKET, SO_BROADCAST, &on, sizeof(int)) < 0) {
		printf("%s command could not broadcast IP/RARP.\n", argv[0]);
		perror("Error: setsockopt (SO_BROADCAST)");
		exit(5);
	}

	/* set up the RARP packet and broadcast it */
	setiprarp(argv[1]);
	printf("Broadcasting IP/RARP address %s for %s\n", inet_ntoa(inaddr), argv[1]);
	sendto(s, &ea, sizeof(ea), 0, (struct sockaddr *) sin,
				sizeof(struct sockaddr));
	exit(0);
}

/*
 *
 *	Set up the RARP reply packet for IP/UDP broadcast
 *
 */

setiprarp(pserver)
char *pserver;
{
	u_long	serno, tmp;

	serno = atoi(pserver);

	ea.arp_op = htons(4);							/* RARPOP_REPLY */
	ea.arp_hrd = htons(ARPHRD_ETHER);
	ea.arp_pro = htons(ETHERTYPE_IP);
	ea.arp_hln = 6;
	ea.arp_pln = sizeof(struct in_addr);	/* i.e. 4 */

	/* set up RARP reply */
	memset(ea.arp_sha, 0, 6);
	memset(ea.arp_spa, 0, 4);

#ifdef	BSD
	ea.arp_tha.ether_addr_octet[0] = 0x00;
	ea.arp_tha.ether_addr_octet[1] = 0x00;
	ea.arp_tha.ether_addr_octet[2] = 0x44;
	ea.arp_tha.ether_addr_octet[3] = (serno >> 16) & 0xff;
	ea.arp_tha.ether_addr_octet[4] = (serno >>  8) & 0xff;
	ea.arp_tha.ether_addr_octet[5] = (serno      ) & 0xff;
#else
	ea.arp_tha[0] = 0x00;
	ea.arp_tha[1] = 0x00;
	ea.arp_tha[2] = 0x44;
	ea.arp_tha[3] = (serno >> 16) & 0xff;
	ea.arp_tha[4] = (serno >>  8) & 0xff;
	ea.arp_tha[5] = (serno      ) & 0xff;
#endif	BSD

	tmp = htonl(inaddr.s_addr);
	ea.arp_tpa[0] = (tmp >> 24) & 0xff;
	ea.arp_tpa[1] = (tmp >> 16) & 0xff;
	ea.arp_tpa[2] = (tmp >>  8) & 0xff;
	ea.arp_tpa[3] = (tmp      ) & 0xff;
}
