/*
 * SCCS info --- @(#)ps_text.h	1.11   12/1/94
 */
/*
 * Copyright (c) 1994 by Castelle
 * The use of this software is restricted to Castelle customers.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE CASTELLE ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE CASTELLE BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef PSTEXT_H
#define PSTEXT_H

/*
 *
 * Definitions of ascii strings used by psconfig.
 *
 * Comment: If you need to translate this file to other language, please follow
 * 			the rules defined here.
 *				1. Keep the string length equal or shorter than the original(English).
 *				2. If you must increase the string length then keep it under the
 *					maximum length specified if it have one, otherwise keep it as
 *					short as possible.
 *				3. Do NOT change %s, %x, %c, %d and \n symbols. They are part of C syntax.
 *
 */

#define TEXT_UXCONFIG_VNAME		"CASTELLE UXCONFIG Rev. "
#define TEXT_UXCONFIG_VNUM		"4.0.6"
#define	TEXT_COPY_RIGHT			"(c) Copyright 1990 - 1995 by CASTELLE. All rights reserved.\n"

	/* Installation text. 128 maximum. */
#define TEXT_INSTALL_1		"\nUsage:\n%s host_name [IPA=ip_address] [ROUTE=gateway_address]\n"
#define TEXT_INSTALL_2		"         [NOS=U|A] [SHOW] [VA] [RESET] [MASK=subnet_mask]\n"
#define TEXT_INSTALL_2A		"         [SHOW] [VA] [RESET] [MASK=subnet_mask]\n"
#define TEXT_INSTALL_3		"         [PA1=PCL|PS] [PA1=RP|NORP]"
#define TEXT_INSTALL_4		"         [PA2=PCL|PS] [PA2=RP|NORP]"
#define TEXT_INSTALL_4A		" [PA2=PCL|PS] [PA2=RP|NORP]"
#define TEXT_INSTALL_5		"         [SE1=PCL|PS] [SE1=RP|NORP] [BAUD1=baud_rate]\n"
#define TEXT_INSTALL_6		"         [SE2=PCL|PS] [SE2=RP|NORP] [BAUD2=baud_rate]\n"
#define TEXT_INSTALL_7		"         [PARITY1=ODD|EVEN|NO] [DBITS1=7|8] [SBITS1=1|2] [FCNTL1=XON|XOFF]\n"
#define TEXT_INSTALL_8		"         [PARITY2=ODD|EVEN|NO] [DBITS2=7|8] [SBITS2=1|2] [FCNTL2=XON|XOFF]\n"
#define TEXT_INSTALL_9		" [SPA1=S1|S2|S3|S4|S5]"
#define TEXT_INSTALL_9A		" [SPA2=S1|S2|S3|S4|S5]"
#define TEXT_INSTALL_9B		" [SPA=S1|S2|S3|S4|S5]"
#define TEXT_INSTALL_9C		" [CLBUF]"
#define TEXT_INSTALL_9D		" [INIT]"
#define TEXT_INSTALL_10		"open stream socket error!\n"
#define TEXT_INSTALL_11 	"unknown host name %s! \nThe host name should be Castelle's Print Server name.\n"
#define TEXT_INSTALL_12		"Connecting Print Server Port %d @ %s .. "
#define TEXT_INSTALL_13		"failed!\n"
#define TEXT_INSTALL_14		"connected!\n"
#define TEXT_INSTALL_15		"\nThe entered value is not a valid value.\n"
#define TEXT_INSTALL_17		"writing on stream socket error!\n"
#define TEXT_INSTALL_18		"reading on stream socket error!\n"
#define TEXT_INSTALL_19		"... reply too short (%d)\n";
#define TEXT_INSTALL_20		"Invalid IP_ADDRESS as %s!\n"
#define TEXT_INSTALL_21		"IP_ADDRESS is the 'new' internet address e.g. 12.23.34.45\n"
#define TEXT_INSTALL_22		"Invalid ROUTE_ADDRESS as %s!\n"
#define TEXT_INSTALL_23		"ROUTE_ADDRESS is the internet address e.g. 12.23.34.45\n"
#define TEXT_INSTALL_24		"Invalid SUBNET_MASK as %s!\n"
#define TEXT_INSTALL_25		"SUBNET_MASK is the internet address e.g. 12.23.34.45\n"
#define	TEXT_INSTALL_30		"Possible causes include:\n"
#define	TEXT_INSTALL_31		"    - %s has not been powered on.\n"
#define	TEXT_INSTALL_32		"    - %s has not been connected to the network.\n"
#define	TEXT_INSTALL_33		"    - %s is not a Castelle print server.\n"
#define	TEXT_INSTALL_34		"Check all of the above.\n\n"
#define TEXT_INSTALL_40		"Invalid BAUD RATE value for %s as %s!\n"
#define TEXT_INSTALL_41		"BAUD RATE value should be 300, 600, 1200, 2400, 4800, 9600, 19200 or 38400.\n"
#define TEXT_INSTALL_42		"Invalid DATA BITS value for %s as %s!\n"
#define TEXT_INSTALL_43		"DATA BITS value should be 7 or 8.\n"
#define TEXT_INSTALL_44		"Invalid STOP BITS value for %s as %s!\n"
#define TEXT_INSTALL_45		"STOP BITS value should be 1 or 2.\n"
#define TEXT_INSTALL_46		"Invalid FLOW CONTROL value for %s as %s!\n"
#define TEXT_INSTALL_47		"FLOW CONTROL value should be XON or XOFF.\n"
#define TEXT_INSTALL_48		"Invalid PARITY value for %s as %s!\n"
#define TEXT_INSTALL_49		"PARITY value should be ODD or EVEN.\n"
#define TEXT_INSTALL_60		"\nSYNTAX ERROR: It should be [NOS=U|A].\n   Program aborted.\n"
#define TEXT_INSTALL_61		"\nSYNTAX ERROR: It should be [PA1=PCL|PS] or [PA1=RP|NORP].\n   Program aborted.\n"
#define TEXT_INSTALL_62		"\nSYNTAX ERROR: It should be [PA2=PCL|PS] or [PA2=RP|NORP].\n   Program aborted.\n"
#define TEXT_INSTALL_63		"\nSYNTAX ERROR: It should be [SPA1=S1|S2|S3|S4|S5].\n   Program aborted.\n"
#define TEXT_INSTALL_64		"\nSYNTAX ERROR: It should be [SPA2=S1|S2|S3|S4|S5].\n   Program aborted.\n"
#define TEXT_INSTALL_65		"\nSYNTAX ERROR: It should be [SE1=PCL|PS] or [SE1=RP|NORP].\n   Program aborted.\n"
#define TEXT_INSTALL_66		"\nSYNTAX ERROR: It should be [SE2=PCL|PS] or [SE2=RP|NORP].\n   Program aborted.\n"
#define TEXT_INSTALL_67		"\nSYNTAX ERROR: It should be [SPA=S1|S2|S3|S4|S5].\n   Program aborted.\n"

#define TEXT_INSTALL_70		"SYNTAX ERROR: Unrecognized parameter -- '%s'\n"
#define TEXT_INSTALL_71		"\nUnknown Command Option!!\n"
#define TEXT_INSTALL_72		"Please reboot or reset %s %s to take the change(s)\ninto effect now!\n"
#define TEXT_INSTALL_73		"LANpress/JetPress"
#define TEXT_INSTALL_74		"\nPress any key to continue......\n"
#define TEXT_INSTALL_75		"\nPlease check if the cable is OK and the %s %s is on.\nRe-run this program after everything is checked OK!\n"
#define TEXT_INSTALL_76		"\nThe %s %s does not have parallel port 2!\n"
#define TEXT_INSTALL_77		"\nThe %s %s does not have serial port 1!\n"
#define TEXT_INSTALL_78		"\nThe %s %s does not have serial port 2!\n"
#define TEXT_INSTALL_79		"\nChanging the speed of the parallel port 1 is not valid to %s!\n"
#define TEXT_INSTALL_80		"\nChanging the speed of the parallel port 2 is not valid to %s!\n"
#define	TEXT_INSTALL_81		"\nYou do not have supervisor rights on the current file server. Program aborted.\n"
#define TEXT_INSTALL_82		"\nSYNTAX ERROR: Null name.\n   Program aborted.\n"
#define TEXT_INSTALL_90		"Find Print server serial number failed!\n"
#define TEXT_INSTALL_91		"Set Print server network operating system failed!\n"
#define TEXT_INSTALL_92		"Set Print server port language failed!\n"
#define TEXT_INSTALL_93		"Set Print server port report failed!\n"
#define TEXT_INSTALL_94		"Set Print server parallel speed failed!\n"
#define TEXT_INSTALL_96		"Set Print server to the default failed!\n"

#define TEXT_INSTALL_101	"\nParallel port 1 is set for PCL printer!\n"
#define TEXT_INSTALL_102	"\nParallel port 1 is set for PostScript printer!\n"
#define TEXT_INSTALL_103	"\nParallel port 2 is set for PCL printer!\n"
#define TEXT_INSTALL_104	"\nParallel port 2 is set for PostScript printer!\n"
#define TEXT_INSTALL_105	"\nSerial port 1 is set for PCL printer!\n"
#define TEXT_INSTALL_106	"\nSerial port 1 is set for PostScript printer!\n"
#define TEXT_INSTALL_107	"\nSerial port 2 is set for PCL printer!\n"
#define TEXT_INSTALL_108	"\nSerial port 2 is set for PostScript printer!\n"
#define TEXT_INSTALL_109	"Set Print server to serve Unix and Windows-NT TCPIP system ONLY!\n"
#define TEXT_INSTALL_110	"Set Print server to serve Netware, Unix and Windows-NT TCPIP system!\n"
#define TEXT_INSTALL_111	"\nThe speed is set to be S1 for Parallel port!\n"
#define TEXT_INSTALL_112	"\nThe speed is set to be S1 for Parallel port 2!\n"
#define TEXT_INSTALL_113	"\nThe speed is set to be S2 for Parallel port!\n"
#define TEXT_INSTALL_114	"\nThe speed is set to be S2 for Parallel port 2!\n"
#define TEXT_INSTALL_115	"\nThe speed is set to be S4 for Parallel port!\n"
#define TEXT_INSTALL_116	"\nThe speed is set to be S4 for Parallel port 2!\n"
#define TEXT_INSTALL_117	"\nThe speed is set to be S5 for Parallel port!\n"
#define TEXT_INSTALL_118	"\nThe speed is set to be S5 for Parallel port 2!\n"
#define TEXT_INSTALL_119	"\nThe speed is set to be S3 for Parallel port!\n"
#define TEXT_INSTALL_120	"\nThe speed is set to be S3 for Parallel port 2!\n"
#define TEXT_INSTALL_121	"\nParallel port 1 is set to print configuration report!\n"
#define TEXT_INSTALL_122	"\nParallel port 1 is set to omit configuration report!\n"
#define TEXT_INSTALL_123	"\nParallel port 2 is set to print configuration report!\n"
#define TEXT_INSTALL_124	"\nParallel port 2 is set to omit configuration report!\n"
#define TEXT_INSTALL_125	"\nSerial port 1 is set to print configuration report!\n"
#define TEXT_INSTALL_126	"\nSerial port 1 is set to omit configuration report!\n"
#define TEXT_INSTALL_127	"\nSerial port 2 is set to print configuration report!\n"
#define TEXT_INSTALL_128	"\nSerial port 2 is set to omit configuration report!\n"
#define TEXT_INSTALL_129	"Print Server '%s' clears print buffer successfully.\n"
#define TEXT_INSTALL_130	"Print Server '%s' failed to clear print buffer.\n"
#define TEXT_INSTALL_131	"Print Server '%s' is assigned an IP address %s\n"
#define TEXT_INSTALL_132	"Print Server '%s' IP address configuration failed.\n"
#define TEXT_INSTALL_133	"Print Server '%s' is assigned an Gateway address %s\n"
#define TEXT_INSTALL_134	"Print Server '%s' Gateway address configuration failed.\n"
#define TEXT_INSTALL_135	"Print Server '%s' is assigned an Subnetwork mask %s\n"
#define TEXT_INSTALL_136	"Print Server '%s' Subnetwork mask configuration failed.\n"
#define TEXT_INSTALL_137	"Print Server '%s' is assigned %s parity bits to EVEN\n"
#define TEXT_INSTALL_138	"Print Server '%s' is assigned %s parity bits to ODD\n"
#define TEXT_INSTALL_139	"Print Server '%s' is assigned %s parity bits to NO PARITY\n"
#define TEXT_INSTALL_140	"Print Server '%s' %s parity bits failed.\n"
#define TEXT_INSTALL_141	"Print Server '%s' %s port baud rate is assigned to %d\n"
#define TEXT_INSTALL_142	"Print Server '%s' %s port baud rate failed to set.\n"
#define TEXT_INSTALL_143	"Print Server '%s' is assigned %s databits to %d\n"
#define TEXT_INSTALL_144	"Print Server '%s' %s databits failed.\n"
#define TEXT_INSTALL_145	"Print Server '%s' is assigned %s stopbits to %d\n"
#define TEXT_INSTALL_146	"Print Server '%s' %s stopbits failed.\n"
#define TEXT_INSTALL_147	"Print Server '%s' is assigned %s flow control to XON\n"
#define TEXT_INSTALL_148	"Print Server '%s' is assigned %s flow control to XOFF\n"
#define TEXT_INSTALL_149	"Print Server '%s' %s flow control failed.\n"
#define TEXT_INSTALL_151	"\nThe %s does not have parallel port 2!\n"
#define TEXT_INSTALL_152	"\nThe %s does not have serial port 1!\n"
#define TEXT_INSTALL_153	"\nThe %s does not have serial port 2!\n"
#define TEXT_INSTALL_154	"\nChanging the speed of the parallel port is not valid to %s!\n"
#define TEXT_INSTALL_155	"Print Server '%s' initialize the printer successfully.\n"
#define TEXT_INSTALL_156	"Print Server '%s' failed to initialize the printer.\n"

#define TEXT_INSTALL_200	"\nEEPROM successfully set to factory default values!\n"
#define TEXT_INSTALL_201	"\nThe %s %s has the version %d.%d \n"
#define TEXT_INSTALL_202	"\nRESET is in progress, please wait ..."
#define TEXT_INSTALL_203	"\n        The Print Server %s Configuration\n"
#define TEXT_INSTALL_204	"\nEnabling the diagnostic report is successful!\n"
#define TEXT_INSTALL_205	"\nDisabling the diagnostic report is successful!\n"
#define TEXT_INSTALL_206	"Print server name:            %s\n"
#define TEXT_INSTALL_207	"Serial Number:                %s\n"
#define TEXT_INSTALL_207A	"Hardware Address:             "
#define TEXT_INSTALL_208	"Port Configuration:           %s: Report Enabled\n"
#define TEXT_INSTALL_209	"Port Configuration:           %s: Report Disabled\n"
#define TEXT_INSTALL_210	"                              %s: Report Enabled\n"
#define TEXT_INSTALL_211	"                              %s: Report Disabled\n"
#define TEXT_INSTALL_212	"                                    Format ASCII (PCL)\n"
#define TEXT_INSTALL_213	"                                    Format Postscript\n"
#define TEXT_INSTALL_214	"                                    Speed Setting  %s\n"
#define TEXT_INSTALL_215	"Diagnostic Report Printing:  Disabled\n"
#define TEXT_INSTALL_216	"Diagnostic Report Printing:  Enabled\n"
#define TEXT_INSTALL_217	"                                    Baud Rate   %s\n"
#define TEXT_INSTALL_220	"LPT1"
#define TEXT_INSTALL_221	"LPT2"
#define TEXT_INSTALL_222	"COM1"
#define TEXT_INSTALL_223	"COM2"
#define TEXT_INSTALL_230	"S1"
#define TEXT_INSTALL_231	"S2"
#define TEXT_INSTALL_232	"S3"
#define TEXT_INSTALL_233	"S4"
#define TEXT_INSTALL_234	"S5"
#define TEXT_INSTALL_240	"                                    Baudrate %s \n"
#define TEXT_INSTALL_241	"                                    Data Bits %s\n"
#define TEXT_INSTALL_242	"                                    Stop bits %s \n"
#define TEXT_INSTALL_243	"                                    Flow control  %s\n"
#define TEXT_INSTALL_244	"                                    Parity %s \n"
#define TEXT_INSTALL_250	"300"
#define TEXT_INSTALL_251	"600"
#define TEXT_INSTALL_252	"1200"
#define TEXT_INSTALL_253	"2400"
#define TEXT_INSTALL_254	"4800"
#define TEXT_INSTALL_255	"9600"
#define TEXT_INSTALL_256	"19200"
#define TEXT_INSTALL_257	"38400"
#define TEXT_INSTALL_260	"7"
#define TEXT_INSTALL_261	"8"
#define TEXT_INSTALL_262	"1"
#define TEXT_INSTALL_263	"2"
#define TEXT_INSTALL_264	"XON"
#define TEXT_INSTALL_265	"XOFF"
#define TEXT_INSTALL_266	"ODD"
#define TEXT_INSTALL_267	"EVEN"
#define TEXT_INSTALL_268	"NOT SET"

#define TEXT_INSTALL_290	"\n                EEPROM Record Setting\n\n"
#define TEXT_INSTALL_291	"Node address:                 %02x %02x %02x %02x %02x %02x\n"
#define TEXT_INSTALL_292	"Parallel Port Speed Setting:  %s\n"
#define TEXT_INSTALL_293	"Print server functionality:   Disabled\n"
#define TEXT_INSTALL_295	"\n                Print server Information\n\n"
#define TEXT_INSTALL_296	"Print server functionality:   Not SET\n"

/* for UNIX function information */
#define TEXT_INSTALL_400	"\nUnix and Windows-NT Support:Enabled\n"
#define TEXT_INSTALL_400A	"Protocol NOS Support:         Netware,Unix and Windows-NT TCPIP\n"
#define TEXT_INSTALL_400B	"Protocol NOS Support:         Unix and Windows-NT TCPIP ONLY\n"
#define TEXT_INSTALL_401    "IP Address:                   %s\n"
#define TEXT_INSTALL_402    "IP Address:                   Not set\n"
#define TEXT_INSTALL_403    "Gateway's IP Address:         %s\n"
#define TEXT_INSTALL_405    "Subnetmask:                   %s\n"
#define	TEXT_INSTALL_526	"\nERROR: %s %s is not found!!\n"

/* for config the baud rate for the serial port */
#define	TEXT_INSTALL_700	"\nThe baud rate for the serial port(s) is set to 9600 as the default.\n"
#define	TEXT_INSTALL_701	"Do you want to configure the baud rate for the serial port(s)? [Y/N]:  "
#define	TEXT_INSTALL_702	"Please input the baud rate for COM1:  "
#define	TEXT_INSTALL_703	"Please input the baud rate for COM2:  "
#define	TEXT_INSTALL_705	"The valid baud rate value should be one of the following:\n"
#define	TEXT_INSTALL_706	"  300, 600, 1200, 2400, 4800, 9600, 19200 and 38400.\n"
#endif
