
/*
 *	Download program sections to the DATA I/O pgmr
 *
 *	Modified Oct 85 for 8 bit m.out files (aek)
 */

#include	<stdio.h>
#include	"mac.h"

#define	PGMRNAME	"/dev/pgmr","w"

/*
 * default usable ram 
 */

FILE	*fp;
FILE	*tp;

unsigned int hiused = 0;	/* current psect position */

int	segorg;
int	chksum = 0;

struct	outhdr	header;		/* object file header buffer     */
struct	out	out[8];		/* buffer for segment descriptors */	

/*
 * tables for character conversion
 */
char	hextab[] = "0123456789abcdef";
char	octtab[] = "01234567";
char	dectab[] = "0123456789";

char	hexout[] = "0123456789ABCDEF";

main(argc,argv)
char *argv[];
{
	register int i;
	register int j;
	register int byte;
	register int idx;

	if(argc < 2){
	 printf("Usage: pgm obj obj ...\n");
	 exit(1);
	}
	if((tp = fopen(PGMRNAME)) == NULL){
	 printf("Couldn't open the link to the programmer \n");
	 exit(1);
	}

	for(i=1; i<argc; i++){

	  if(argv[i][0] == '-'){
	    i++;
	  }

	  if((fp = fopen(argv[i],"r")) == NULL){
	    printf("Couldn't open %s\n",argv[i]);
	    exit(1);
	  }
	  fread(&header, AOUT, 1, fp);
	  if(header.ao_mword == 011223)
	    printf("%s old m.out format\n");
	  if((header.ao_mword != MWORD)&&(header.ao_mword != 011223)){
	    printf("Invalid object format %s (%o)\n",argv[i],header.ao_mword);
	    exit(1);
	  }
	  /*
	   *	Read in segment descriptors
	   */

	  fread(&out, OUT, 8, fp);

	  /*
	   * Output the DATA I/O Header
	   * Setting the ram origin to 0
	   */

	  fprintf(tp,"  %c$A0000,\r\n",2);
	  chksum = 0;

	  /*
	   * scan for psects, and output data
	   */

	  for(idx=0; idx<8; idx++){
	    if(out[idx].ou_length){
	      if(out[idx].ou_attrib & ABS){
	        fprintf(stderr,"Asect %d: ",idx);
	        segorg = out[idx].ou_start;
		fprintf(stderr,"Skipping Asects\n");
		continue;
	      }
	      else{
	        segorg = hiused;
		hiused += out[idx].ou_length;
	        fprintf(stderr,"Psect %d: ",idx);
	      }
	      fprintf(stderr,"Adr: %04x Len: %d (0x%x)\n",
	             segorg, out[idx].ou_length, out[idx].ou_length);

	      for(j=0; j<out[idx].ou_length; j++){
		if(header.ao_mword != MWORD)
	          byte = getw(fp);
		 else
		  byte = (getc(fp)&0xff);
		chksum += byte;
	        outhex(byte);
	        fprintf(tp," ");
	      }
	    }
	  }
	}

	/*
	 * Output the trailer info
	 */
	fprintf(tp,"%c                ",3);

	printf("checksum = %x\n",chksum);

}

outw(w){
	putc(w>>8,tp);
	putc(w&0xff,tp);
}

argnum(p)
char *p;
{
	register int n, j;
	n = 0;
	if (*p == '0') {
	  p++;
	  if(*p == 'x'){
	    p++;
	    while((j=any(*p,hextab)) >= 0){
	      n = (n<<4) | j;
	      p++;
	    }
	  return(n);
	  }

	  while ((j = any(*p, octtab)) >=0){
	    n = (n<<3) | j;
	    p++;
	  }
	  return(n);
	}

/*
 * default radix is 16 instead of 10
 */
	while((j=any(*p,hextab)) >= 0){
	  n = (n<<4) | j;
	  p++;
	}
	return(n);
}

/*
 * search string 'str' for character 'c' and return 
 * its ordinal position
 */
any(c,str)
register char c;
char *str;
{
	register i;
	i = 0;
	while(str[i]){
	  if(c == str[i])
	    return(i);
	  i++;
	}
	return(-1);
}


outhex(chr)
{
	register int tmp;
	tmp = chr & 0xf0;
	tmp = (tmp >> 4);
	fputc(hexout[tmp],tp);
	fputc(hexout[chr&0xf],tp);
}
