;
; VT100 display routines.
;
;	Entries -
;		setxy - set xpos, ypos to pixel position
;			corresponding to bottom left corner
;			of char box at curx, cury.
;		dchar - draw character at xpos,ypos and
;			advance xpos,ypos to next char position.
;		echar - erase character box at curx,cury.
;		dsplin - call dchar for char positions from
;			 acc to y reg.
;		dspchr - draw char at curx, cury.
;		undisp - erase char positions from acc to y.
;		scroll - scroll char lines acc to y.


;
; Note - setxy and xsetx should
; really do table lookups instead
; of multiplies.
;

setxy:
	php
	rep	#0x20
	lda	<chight
$1:	bit	Dpdone-1
	bvc	$1
	sta	0xfe00
	lda	<cury
	dec	a
	and	##0xff

	sta	0xfe04
	sta	DaMul
	sec
	lda	<yorg
$2:	bit	Dpdone-1
	bvc	$2
	sbc	0xfe02
	sta	<ypos
	bra	setx1
xsetx:
	php
	rep	#0x20
$1:	bit	Dpdone-1
	bvc	$1
setx1:
	lda	<curx
	dec	a
	and	##0xff
	beq	$ez

	bit	<chrsiz-1
	bmi	$l1			; br if not double width
	bvc	$l2
$l1:	asl	a

$l2:	sta	0xfe04
	lda	<cwidth
	sta	0xfe00
	sta	DaMul
$1:	bit	Dpdone-1
	bvc	$1
	lda	0xfe02
	clc
	adc	<xorg
	sta	<xpos

	plp
	rts
$ez
	lda	<xorg
	sta	<xpos
	plp
	rts
	
dspchr:
	php
	rep	#0x20
	pha
	bsl	echar
	pla
	bsl	dchar
	plp
	rts
	
echar:
	php
	rep	#0x20
	bsl	setxy
	
	lda	<xpos
	sta	Xcap
	lda	<ypos
	sta	Ycap

	lda	<cwidth
	dec	a
	bit	<chrsiz-1
	bmi	$l2
	bvc	$l1	
$l2	asl	a	
$l1	sta	0xfe00
	lda	<chight
	dec	a
	sta	0xfe02

	stz	DaColr
	sta	DaFrr
	plp
	rts


;
; erase screen char positions from acc to y.
;

undisp:
	php
	rep	#0x30
	phx
	phy
	pei	<curx		; save curx and cury.

	sep	#0x30
	sta	<curx
	bsl	setxy
	pei	<xpos
	iny
	sty	<curx
	bsl	xsetx

	rep	#0x20
	pla
	sta	Xcap
	lda	<ypos
	sta	Ycap
	lda	<xpos
	sta	0xfe00
	clc
	lda	<ypos
	adc	<chight
	sta	0xfe02
	stz	DaColr
	sta	DaDfr

	rep	#0x30
	pla
	sta	<curx
	ply
	plx
	plp
	rts

;
; Draw chars from acc to y in current line.
; Note - this routine also called from
; setup mode to display text in prom, hence
; the long address mode used to access 
; the text to be displayed..
;

dsplin:
	php
	rep	#0x30
	phx
	phy
	pei	<curx		; save curx, cury.

	sep	#0x30
	sta	<curx		; first char column to display.
	tya			; find out how many to do.
	sec
	sbc	<curx		; last - first
	bcc	$done
	inc	a		; + 1.
	tax			; save counter.
	ldy	<curx		; first to display.
	dey			; make index into text array.

	bsl	setxy		; set xpos, ypos.

$loop:	lda	[<txtptr],y	; get char.
	bne	$l1
	lda	#32
$l1:	bsl	dchar		; draw it.
	iny			; point to next.
	dex
	bne	$loop

$done:
	rep	#0x30
	pla
	sta	<curx
	ply
	plx
	plp
	rts

dchar:
	php
	rep	#0x30
	pha
	phx
	phy

	lda	<fntptr		; temp
	sta	<temp3

	sep	#0x30

	lda	5,s
	and	#127
	cmp	#127
	bne	$01
	brl	$done

$01:	cmp	#95		; is it in the possible gfx range?
	bcc	$0		; br if not

	bit	<spattr		; are we doing gfx?
	bpl	$0		; br if not

	sec
	sbc	#95
	bcs	$chgptr
	brl	$done
$chgptr
	pha

	lda	<csx
	cmp	#9
	bcs	$c1
	rep	#0x20
	lda	##spfn79
	bra	$c2
$c1: 	rep	#0x20
	lda	##sp1280
$c2	sta	<fntptr
	sep	#0x20
	pla
	bra	$1
	
$0:	cmp	#32
	bne	$00
	brl	$space
$00:	sec
	sbc	#33
	bcs	$1
	brl	$done
$1:
	sta	<temp		; save (char - 33).
	stz	<temp+1

	lda	#1		; restore foreground color.
$f2	bit	Dpdone
	bvc	$f2
	sta	DaColr
	rep	#0x30

; draw underscore if applicable

	lda	<spattr		; see if video attr on
	and	##0x04		; only supports underscore
	beq	$f1		; br if no attr
	lda	<chrsiz
	and	##0xff
	cmp	##64
	beq	$f1		; don't draw underscore for upper 2(high)
	lda	<xpos		; underscore, draw box of 2 pixel high
	sta	Xcap
	lda	<cwidth
	bit	<chrsiz-1
	bpl	$b4
	asl	a
$b4	dec	a
	sta	0xfe00
	lda	<ypos
	inc	a
	inc	a
	sta	Ycap
	lda	##1
	sta	0xfe02
	sta	DaFrr

; figure out Ycap 

$f1	stz	<temp2
	lda	<cslop
	bit	<chrsiz-1
	bvc	$19		; if not double high then move up
	bmi	$29
	lsr	a		; top half lower .5(cslop)
	tax
	lda	<csx
	and	##0xff
	cmp	##9
	bcs	$f5
	dex
$f5	txa
	bra	$19

$29	asl	a		; bottom half raise 1.5(cslop) up
	adc	<cslop
	lsr	a

$19	sta	<temp2
	clc
	lda	<ypos
	adc	<temp2
	tax

	sep	#0x20
	lda	5,s
	cmp	#'_'
	beq	$desc
	cmp	#';'
	beq	$desc
	cmp	#'g'
	beq	$desc
	cmp	#'j'
	beq	$desc
	cmp	#'p'
	beq	$desc
	cmp	#'q'
	beq	$desc
	cmp	#'y'
	bne	$nodesc
$desc:
	bit	<spattr
	bmi	$nodesc
	rep	#0x20
	sec
	txa
	sbc	<desc
	tax
	sep	#0x20
$nodesc:
	stx	<temp1		; save y coord bottom of char.
;
; Calculate char definition -
; (character-0x21 (in temp)) * csy (*2 more if csx > 8);
;

	rep	#0x20
	sep	#0x10
	lda	<temp
	inc	a		; move to next char ( we start bottom )

	ldx	<csx
	cpx	#9
	bcc	$w1
	asl	a
$w1:	bit	Dpdone-1
	bvc	$w1
	sta	0xfe00		; multiplicand.
	lda	<csy
	and	##0x1f
	sta	0xfe04		; multiplier.
	sta	DaMul		; multiply (get result later).

; figure out # of rows to do

	sep	#0x30
	stz	<spflag		; init temp
	lda	<csx
	cmp	#9
	bcs	$l10		; br if 12x16
	lda	<csy		; here for 7x9
	bit	<chrsiz
	bvc	$10		; br if no need for adjustment
	bmi	$l11		; br if bottom to do 4 rows
	inc	a		; (9+1)/2=5 rows for upper
$l11	lsr	a
	bra	$10
$l10
	lda	<csy		; here for 12x16
	bit	<spattr
	bpl	$l12		; br if not gfx set
	lda	5,s		; get original char
	cmp	#0152
	bcc	$l13		; br if too low
	cmp	#0171
	bcs	$l13		; br if too high
	dec	<spflag
	lda	#10
	bra	$l12
$l13
	lda	<csy
$l12	bit	<chrsiz
	bvc	$10
	lsr	a
$10	sta	<temp
	stz	<temp+1
	ldx	#0
	rep	#0x30
	lda	<temp1

$w2:	bit	Dpdone-1	; wait for multiply to be done.
	bvc	$w2

	sta	Ycap
	lda	<xpos
	sta	Xcap

; figure out where to start in font table

	stz	<temp2
	lda	<csx
	and	##0xff
	cmp	##9
	bcs	$b1
$b2	lda	<csy
	and	##0xff
	bit	<chrsiz-1
	bvc	$20		; double wide, no need to adjust pointer
	bmi	$20		; bottom of 2(high), ditto
	lsr	a
;	dec	a
	bra	$f3

$b1	lda	<csy
	and	##0xff
	bit	<spflag-1
	bpl	$b3		; br if not doing special special gfx
	lda	##10		; this section for 12x16 only
	and	##0xff
$b3	bit	<chrsiz-1
	bvc	$20		; bottom half of double high starts
	bmi	$20		; from the middle of the font mask
$f3	sta	<temp2

$20	lda	0xfe02		; get index of char in font.
	and	##0xfff		; mask off sign nibble.
	sec
	sbc	<temp2

	dec	a		; 1st row next char - 1 = bottom row
	bit	<clmode-1	; if 132 columns then once is enough
	bmi	$l20
	dec	a
$l20	tay			; current char index into font table

	sep	#0x20

	lda	<csx
	cmp	#9
	bcs	$a11
	brl	$small

$a11	rep	#0x30
	bit	<spflag-1
	bmi	$a10		; br if doing regular # of rows
	brl	$ll

$a10	pei	<xpos
	phy			; save index value

$a1:	lda	[<fntptr],y
	sta	0xfe30
	sta	0xfe30
	dey
	dey
	inx
	cpx	<temp
	bne	$a1

	lda	<temp1		; move cap 2 pixels to the right
$a6:	bit	Dpdone-1
	bvc	$a6
	sta	Ycap		; and at bottom of char box
	lda	<xpos
	clc
	adc	##2
	bit	<daflag-1
	bpl	$a7
	adc	##2
$a7	sta	Xcap	
	
	ply			; restore index value
	ldx	##0

$a3:	lda	[<fntptr],y
	and	##0x0f
	sta	0xfe30
	sta	0xfe30
	dey
	dey
	inx
	cpx	<temp
	bne	$a3
	
	rep	#0x20
	pla
	bra	$15

$ll:	lda	[<fntptr],y	; get char row mask.
	sta	0xfe30
	dey
	dey
	inx
	cpx	<temp
	bne	$ll
	bra	$space

;
; here for fonts with 8 or less bits/row.
;
;
$small:	
	rep	#0x30
$sm:	lda	[<fntptr],y
	and	##0xff
	asl	a
	asl	a
	asl	a
	asl	a
	sta	0xfe30

	inx
	dey
	cpx	<temp
	bne	$sm
	
$space:
	rep	#0x20
	lda	<xpos
$15	clc
	adc	<cwidth
	bit	<daflag-1
	bpl	$l4
	adc	<cwidth
$l4	sta	<xpos

$done
	rep	#0x30

	lda	<temp3		; restore
	sta	<fntptr

	ply
	plx
	pla
	plp
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Scroll scrolling region of display upwards.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dispup:
	php
	rep	#0x30
	pha
	phx
	phy
	pei	<curx

	sep	#0x30

	sec
	lda	<srbot
	sbc	<srtop
	sta	<temp		; # rows to scroll.
	stz	<temp+1

	lda	<chight
	lsr	a
	lsr	a
	sta	<temp1
	stz	<temp1+1	; # line groups per row.

	lda	<srtop
	sta	<cury
	lda	#1
	sta	<curx
	bsl	setxy
	lda	Capctl		; set x major, both up.
	and	#127-7
	sta	Capctl

	rep	#0x30
	sec
	lda	<ypos
	sbc	##4
	sta	Ycap		; set y cap to first source line.
	stz	Xcap
	
	lda	<temp
	sta	0xfe00
	lda	<temp1
	sta	0xfe04
	sta	DaMul		; compute # line groups to scroll.

	ldx	<chight		; dist from source to target.
	ldy	##-4		; dist from one source to next.
	
$w1:	bit	Dpdone-1
	bvc	$w1

	lda	0xfe02		; get # line groups to scroll.
	sta	0xfe00
	stx	0xfe02
	sty	0xfe04
	sta	DaScr		; do the scroll.

	pla
	sta	<curx
	sep	#0x30
	bsl	chngln

	rep	#0x30
	ply
	plx
	pla
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Scroll scrolling region of display downwards.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dispdn:
	php
	rep	#0x30
	pha
	phx
	phy
	pei	<curx

	sep	#0x30

	sec
	lda	<srbot
	sbc	<srtop

;	inc	a		; I don't know why this is necessary
;	inc	a		; but it is.

	sta	<temp		; # rows to scroll.
	stz	<temp+1

	lda	<chight
	lsr	a
	lsr	a
	sta	<temp1
	stz	<temp1+1	; # line groups per row.

	lda	<srbot
	dec	a
	sta	<cury
	lda	#1
	sta	<curx
	bsl	setxy		; set ypos to bottom of line srbot+1.

	lda	Capctl		; set x major, minor down.
	and	#127-7
	ora	#1
	sta	Capctl

	rep	#0x30
	lda	<ypos
	inc	a
	sta	Ycap		; set y cap to first source line.
	stz	Xcap
	
	lda	<temp		; number rows to scroll.
	sta	0xfe00
	lda	<temp1		; line groups per row.
	sta	0xfe04
	sta	DaMul		; compute # line groups to scroll.

	lda	<chight		; dist from source to target.
	eor	##-1		; make it negative because
	inc	a		; we're scrolling down.
	tax
	ldy	##4		; dist from one source to next.
	
$w1:	bit	Dpdone-1
	bvc	$w1

	lda	0xfe02		; get # line groups to scroll.
	sta	0xfe00
	stx	0xfe02
	sty	0xfe04
	sta	DaScr		; do the scroll.


	pla
	sta	<curx
	sep	#0x30
	bsl	chngln

	rep	#0x30
	ply
	plx
	pla
	plp
	rts

	end
