
;
; Graphics keyboard handler.  This routine gets  
; next key (if there is one) from the keyboard
; input q and processes it.  Return is with carry
; set unless the caller must handle the key, which
; in that case is returned in the acc.
; The latter case occurs only in local mode, and
; only if the key is not one of the special keys
; such as arrow, local, gold etc.
; If the terminal is online any non-special keys
; are sent to the host.  If sif(p), non-special
; keys are are moved from the keyboard input q to
; another q where they wait to be called for with
; the sks command.
;

chkkbd:
$nscrlk	equ	0xb0	;no scroll
$goldk	equ	0366	;pf1/gold
$vernk	equ	0343	;gold alt 9
$cursk	equ	0370	;pf3/cursor
$lclky	equ	0371	;pf4/local
$setupk	equ	0376	;setup/reset

	sec			; assume no key.
	php
	rep	#0x30
	and	##0xff		
	pha
	phx
	phy
	sep	#0x20

	bit	Setupk
	bpl	$noset
	bsl	kludge

$noset:

;
; Get a key from somewhere if
; there is one.
;
	bit	<rdykey		; already a key hanging around ?
	bmi	$unget		; br if yes.
	bvs	$getpf		; br if in mid pfk sequence.

	bit	Iqcnt3+1	; key in input buffer ?
	bmi	$getkbd		; br if yes.

$done:	rep	#0x30
	ply
	plx
	pla
	plp
	rtl	

$unget:
	lda	#128
	trb	<rdykey		; clear ungot flag.
	lda	<keybuf		; get the key.
	bra	$12		; continue as if key was typed.

$getpf:
	bsl	getpfk		; yes, get key from pfk seq.
	bcc	$12		; continue as if key was typed.

$getkbd:	
	jsl	>0,GetKey	; get key from buffer.
	bcs	$done		; br if no key.

;
; Got a key.  If not ASCII, jump to special
; case routine for that key, else 
; if last key was not the gold key,
; continue, else switch kbd input stream to
; the definition of gold(acc).
;
	
$12:
	cmp	#128
	bcc	$13
	brl	$notasc
$13:
	stz	<resflg		; clear reset key flag.
	bit	<gldmod		; last key gold ?
	bpl	$ascii		; br if no.
	bsl	begpfk		; switch stream to pfk(acc).
	bcs	$ascii		; no such pfk, just use key as is.
	bsl	getpfk		; get next key from pfk(acc).
$ascii:	
	sep	#0x30
	tax
	bit	<locsw		; are we in local mode ?
	bmi	$local		; br if yes.
	lda	<vflag
	and	#2
	bne	$local		; do something diff for gin mode
	txa
	bit	<sifval		; online, send keys parallel ?
	bpl	$serial		; br to send serial. (7 = P, 7,6 = M).
	bvs	$serial
	bsl	putsks		; buffer the key for sks.
	bra	$done

$serial:
	jsl	>0,SndHst	; send key serially.
	bit	<locsw
	bvc	$done
	jsl	>0,Dchar
	bra	$done

$local:	
	txa
	sta	5,s		; put key in callers acc.
	lda	7,s		; clear callers carry.
	and	#254		; so he knows key is there.
	sta	7,s
	bra	$done

$notasc:
	cmp	#$setupk	; setup key ?
	bne	$s1		; br if no.
	inc	Setupk
	bit	<gldmod		; last key gold ?
	bpl	$res		; br if no, do some kind of reset. 
	stz	<gldmod
	jsl	>0,Setup	; yes, enter setup mode.
	brl	$done		; back from setup, done.
$res
	rep	#0x20
	lda	StkBas		; make stack empty.
	tcs
	sep	#0x20
	bit	<resflg		; last key also reset ?
	bpl	$s11		; br if no.
	brl	init		; yes, go reset.
$s11:	dec	<resflg		; set "last key reset" flag.
	brl	idle		; go to interpreter idle loop.

$s1:	stz	<resflg
	cmp	#$nscrlk	; no scroll key ?
	bne	$chkalt
	lda	<scrflg
	eor	#-1
	sta	<scrflg
	brl	$done

$chkalt:
	cmp	#0360		; key < 0361 ?
	bcc	$altkey		; br if yes, it's on alt kpad.
	cmp	#0365		; key < 0365 ? (0361..0364).
	bcs	$pf1		; no, check pf1-4.
	brl	$arrow		; go handle arrow key (joystick).
;
; Remaining possibilities are pf1-4.
;

$pf1:
	cmp	#$goldk
	bne	$pf3
	lda	<gldmod
	eor	#255
	sta	<gldmod
	brl	$done
$pf3:
	cmp	#$cursk
	bne	$pf4
	lda	#128
	eor	<curson		; turn cursor on/off.
	sta	<curson
	lda	#ledcur		; toggle cursor led.
	eor	Leds
	sta	Leds
	brl	$done
$pf4:
	cmp	#$lclky
	bne	$pf41
	lda	<locsw
	eor	#128
	sta	<locsw
	lda	#ledloc
	eor	Leds
	sta	Leds	
$pf41:	brl	$done


;
; key is from alternate keypad 
; or break.  replace it with table
; value.  value 0 means nop, -1
; means ctl break (send break to host).
;
$altkey:
	bit	<gldmod
	bpl	$alt1
	bsl	begpfk
	bcs	$vern
	brl	$12
$vern:
	cmp	#$vernk
	bne	$alt1
	rep	#0x20
	lda	##4
	cmp	<jdxdy
	bne	$vern1
	lda	##64
$vern1:	sta	<jdxdy
	brl	$done

$alt1:	php
	phb			; save current dbr.
	phk			; set dbr = pbr.
	plb
	rep	#0x10
	phy
	per	$altab		; addr of alt keypad keys.
	per	$altmap		; addr of their ASCII equivalents.
	ldy	##$altmap-$altab-1 ; index of last table element.
$loop:	cmp	(3,s),y		; acc = altab[y] ?
	beq	$fnd		; br if yes, map it.
	dey			; nope, point to next.
	bne	$loop		; should always branch.
$fnd:	lda	(1,s),y		; get replacement for alt key.
	ply			; clean up stack
	ply
	ply			; restore prev y.
	plb			; restore dbr.
	plp
	cmp	#0		; nop key ?
	bne	$30		; br if no.
	brl	$done		; yes, just return.
$30:	cmp	#-1		; send break to host ?
	beq	$31		; br if no, mapped to ASCII
	brl	$ascii		; continue as if ASCII key typed.
$31:	jsl	>0,Break	; send break and exit.
	brl	$done


$altab:
	dcb	0	;in case value not in table.
	dcb	0261	;alt0
	dcb	0262	;alt.
	dcb	0300	;alt1
	dcb	0301	;alt2
	dcb	0302	;alt3
	dcb	0303	;alt enter
	dcb	0320	;alt4
	dcb	0321	;alt5
	dcb	0322	;alt6
	dcb	0323	;alt,
	dcb	0340	;break (nop)
	dcb	0341	;alt7
	dcb	0342	;alt8
	dcb	0343	;alt9
	dcb	0344	;alt-
	dcb	0352	;sh brk - nop
	dcb	0353	;ctl brk - break host serial line.
	dcb	0354	;ctl sh brk - nop
$altmap:
	dcb	0	; bogus entry.
	dcb	'0'
	dcb	'.'
	dcb	'1'
	dcb	'2'
	dcb	'3'
	dcb	13	; cr
	dcb	'4'
	dcb	'5'
	dcb	'6'
	dcb	','
	dcb	0	; break is a nop
	dcb	'7'
	dcb	'8'
	dcb	'9'
	dcb	'-'
	dcb	0
	dcb	-1	; ctl break
	dcb	0

;
; it's an arrow key.  move one of 
; joyx, joyy in the appropriate direction.
; result is to be 0..2047.
;
$arrow:
	cmp	#0361
	bne	$jdown
	rep	#0x21		; also clears carry.
	lda	<jdxdy
	adc	<joyy
	cmp	##2048
	bcc	$yok
	lda	##2047
	bra	$yok
$jdown:	cmp	#0362
	bne	$jleft
	rep	#0x20
	sec
	lda	<joyy
	sbc	<jdxdy
	bpl	$yok
	lda	##0
$yok:	sta	<joyy	
	brl	$done
$jleft:	cmp	#0363
	bne	$jr
	rep	#0x20
	sec
	lda	<joyx
	sbc	<jdxdy
	bpl	$xok
	lda	##0
	bra	$xok
$jr:	rep	#0x21
	lda	<joyx
	adc	<jdxdy
	cmp	##2048
	bcc	$xok
	lda	##2047
$xok:	sta	<joyx
	brl	$done

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; gold(acc) just happened, set things up so	;
; that subsequent calls to chkbd result in	;
; calls to getpfk.  Set things up for getpfk.	;
; Return with carry set if acc not defined,	;
; or the pfk is already executing (no recursion);
; else return the first key of the sequence.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 

begpfk:
	clc			; assume key is defined.
	php
	sep	#0x20
	stz	<gldmod		; clear "last key gold" flag.
	rep	#0x30
	and	##0xff		; clear acc high byte.
	pha
	ldy	<pfkbuf		; get pointer to pfk list.
	bra	$nxt		; start search for pfk(acc).
$loop:
	cmp	pfknam,x	; this the pfk we're looking for ?
	beq	$found		; br if yes.
	ldy	pfknxt,x	; nope, get pointer to next in list.
$nxt	tyx
	bne	$loop		; loop unless end of list reached.
	pla
	plp
	sec			; set carry to indicate
	rts			; failure and return.
$found:
	lda	<pfkptr		; get pointer to "executing" pfk (if any).
	sta	pfkpop,x	; save it as parent of new pfk.
	lda	##pfkdef	; get index of first byte in pfk.
	tay
	inc	a		; make and save index next byte.
	sta	pfkidx,x
	stx	<pfkptr		; make this pfk the current one.
	lda	(<pfkptr),y	; get first byte this pfk.
	and	##0xff
	sta	1,s
	pla
	plp			; return.
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Return next byte from pfk sequence.	;
; If no next byte, return next from	;
; parent.  If no parent, return carry	;
; set.					;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

getpfk:

	clc
	php
	rep	#0x30

$1:	ldx	<pfkptr			; get ptr to executing pfk.
	bne	$2			; br if there is one.
	brl	$error			; br if no pfk executing.
$2:	lda	pfkidx,x		; get index to next byte.
	cmp	pfksiz,x		; use up all the bytes ?
	bcc	$ok			; br if no.
;
; this pfk all used up, make its' parent
; the current pfk and try to get a byte from it.
;
	lda	##0			; yes, set index back to 0.
	sta	pfkidx,x
	lda	pfkpop,x		; get pointer to parent
	sta	<pfkptr			; make it current pfk.
	bra	$1			; go try to get a byte from it.
;
; return next byte from this pfk.
;

$ok:
	tay				; save index of byte to return.
	inc	a			; make index next byte to return.
	sta	pfkidx,x		; save it for next time.
	lda	(<pfkptr),y		; get byte.
	and	##0xff			; mask off junk
	plp				; and return.
	rts
$error:
	plp
	sec
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Put the acc in the q of keys waiting	;
; to be called for by sks.		;
; Send ksr signal to host if not	;
; already sent.				;
; If q is full, discard the key and 	;
; return with carry set to indicate err.;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

putsks:

$ksr	equ	32
$sksiz	equ	64

	clc			; assume q not full.
	php
	rep	#0x30
	pha
	phx
	phy
	sep	#0x30

	lda	#$ksr
	tsb	ParStat		; set ksr flag in par status image.
	bne	$1		; br if already set.
	lda	ParStat		; status changed, get new status.
	sta	ParOut+1	; send status to host and 
	sta	DevEnd		; interrupt host so he reads it.
$1:
	ldy	<sksin		; get pointer to tail of q.
	iny			; make pointer to next q slot.
	cmp	#$sksize	; past end of q buffer ?
	bcc	$2		; br if no.
	ldy	#0		; yes, wrap to beginning.
$2:
	cpy	<sksout		; tail+1 = head ?
	bne	$3		; br if no.
	lda	7,s		; q full, set callers
	ora	#1		; carry and exit.
	sta	7,s
	bra	$done
$3:
	phy			; save new tail pointer.
	ldy	<sksin		; get current tail pointer.
	lda	5+1,s		; get the key to q.
	sta	(<sksbuf),y	; put in the q.
	ply			; get new tail.
	sty	<sksin		; save it .
$done:
	rep	#0x30
	ply
	plx
	pla
	plp
	rts

kbdend:

	end



