
dfpfil:

	lda	<ovcnt
	asl	a
	tay
	lda	(<ovx)
	sta	(<ovx),y
	lda	(<ovy)
	sta	(<ovy),y
	iny
	iny
	sty	<ovcnt
	tya
				; get 10*ovcnt bytes of	stack
	asl	a		; for the various arrays.
	sta	<temp
	asl	a
	asl	a
	asl	a
	adc	<temp
	sta	<temp
	tsc
	sta	<stack
	sec
	sbc	<temp
	tcs

	inc	a
	clc
	sta	<etx
	adc	<ovcnt
	sta	<ety
	adc	<ovcnt
	sta	<etdx
	adc	<ovcnt
	sta	<etdxf
	adc	<ovcnt
	sta	<etdy
	adc	<ovcnt

	sta	<aetx
	adc	<ovcnt
	sta	<aetxf
	adc	<ovcnt
	sta	<aetdx
	adc	<ovcnt
	sta	<aetdxf
	adc	<ovcnt
	sta	<aetdy

	bsl	bldet
	lda	(<ety)
	sta	<ypos
	stz	<etidx
	stz	<aetcnt

$yloop:
	bsl	mrgaet		; move edges from et to	aet.
	lda	<aetcnt
	bit	##2		; aetcnt hosed ?
	beq	$ok
	brl	dfpdon
$ok:
	lda	<aetcnt
	sta	<newcnt
	bne	$1
	inc	<ypos
	lda	<ypos
	cmp	<ymax
	bcc	$yloop
	brl	$done
$1:
	lda	<ypos
	inc	<ypos
$w1:	bit	Dpdone-1
	bvc	$w1

	sta	Ycap
	sta	0xfe02
	ldy	##0
$floop:
	lda	(<aetx),y	; get beginpoint this run.
	tax			; save.
	iny			; get endpoint.
	iny
	lda	(<aetx),y

$w2:	bit	Dpdone-1
	bvc	$w2

	stx	Xcap		; set cap.
	sta	0xfe00		; set endpoint.
	sta	DaDva		; draw pixel run.

	bsl	nextxy		; calc intersection next y.
	cpy	<aetcnt		; time to move to next line ?
	bcc	$floop		; br if	no.

	bsl	srtaet		; remove, sort.
	brl	$yloop

$done:
dfpdon:

	lda	<stack
	tcs
	lda	<temp+8
	sta	DaFlag
	rts
;
; Calculate intersection with next y
; for current aet edge.	 Dec aetdy.
; Dec newcnt if	aetdy =	0, (# of
; edges	left in	aet).
;

nextxy:
	dey
	dey
	ldx	##2
$1:
	lda	(<aetdy),y	; update scan line counter this	edge.
	dec	a
	sta	(<aetdy),y
	bne	$2		; br if	<> 0, calc intersection	next y.
	dec	<newcnt		; update # edges left in aet.
	dec	<newcnt
	bra	$3
$2:
	clc			; calc intersection next scan line.
	lda	(<aetxf),y	; get fractional x position.
	adc	(<aetdxf),y	; add fractional dx.
	sta	(<aetxf),y	; save result for next time.
	lda	(<aetx),y	; get int x position.
	adc	(<aetdx),y	; add int dx (and carry).
	sta	(<aetx),y	; save next x position.
$3:
	iny
	iny
	dex
	bne	$1
	rts

;
;

srtaet:
	lda	<newcnt		; any edges left ?
	bne	$1		; done if no.
	sta	<aetcnt
	rts
$1:
	cmp	<aetcnt		; any get removed ?
	beq	$sort		; br if	no.
	bsr	remdy0		; remove edges with dy = 0.
	lda	<newcnt
	sta	<aetcnt
$sort:
	lda	<aetx
	inc	a
	inc	a
	sta	<temp
$bubbl:
	lda	<aetcnt
	lsr	a
	dec	a
	tax			; # pairs to compare.
	beq	$done
	stz	<sign		; swap flag.

	ldy	##0
$loop:
	lda	(<aetx),y
	cmp	(<temp),y
	bcc	$nxt
	beq	$nxt

	phx
	lda	<aetx
	bsr	$swap
	lda	<aetxf
	bsr	$swap
	lda	<aetdy
	bsr	$swap
	lda	<aetdx
	bsr	$swap
	lda	<aetdxf
	bsr	$swap
	dec	<sign
	plx
$nxt:
	iny
	iny
	dex
	bne	$loop
	bit	<sign
	bmi	$bubbl
$done:	rts

;
; swap element pointed to by y
; with next element.
;
$swap:
	sta	<temp+2
	inc	a
	inc	a
	sta	<temp+4

	lda	(<temp+2),y
	tax
	lda	(<temp+4),y
	sta	(<temp+2),y
	txa
	sta	(<temp+4),y

	rts

;
; remove edges with dy = 0.
;
remdy0:
	ldy	##0
$loop:
	lda	(<aetdy),y
	beq	$sqz
$nxt	iny
	iny
	cpy	<newcnt
	bcc	$loop
	rts
$sqz:
	tyx			; save target index.
$sloop:
	iny
	iny
	lda	(<aetdy),y
	beq	$sloop

	lda	<aetdy
	bsr	$sqeez
	lda	<aetx
	bsr	$sqeez
	lda	<aetxf
	bsr	$sqeez
	lda	<aetdx
	bsr	$sqeez
	lda	<aetdxf
	bsr	$sqeez

	txy
	brl	$nxt


$sqeez:
	pha
	phx			; target index.
	phy			; source index.

	clc
	adc	3,s		; x+a =	addr target -> y
	tay
				; y + a	= source addr -> x
	clc
	lda	1,s
	adc	5,s
	tax

	sec
	lda	<aetcnt
	sbc	1,s
	dec	a
$1:
	mvn	>0,>0

	ply
	plx
	pla
	rts

;
; Add elements from et to aet,
; maintaining sort order on aetx.
;

mrgaet:
	stz	<aetidx
$loop:
	ldy	<etidx
	cpy	<etcnt		; anything left	in edge	table ?
	bcc	$1		; br if	yes.
$ret:	rts			; nothing to do	if no.
$1:
	lda	(<ety),y	; next edge start at current y ?
	cmp	<ypos
	bne	$ret		; done if no.
;
; get et data needed for this edge in aet.
;
	lda	(<etx),y
	sta	<newx
	lda	(<etdx),y
	sta	<dx
	lda	(<etdxf),y
	sta	<dxf
	lda	(<etdy),y
	sta	<dy
	iny			; make and save	index to next et element.
	iny
	sty	<etidx
;
; add et data to aet (maintain sort order on x).
;

	ldy	<aetidx		; get index next aet element
$sloop:
	cpy	<aetcnt		; at end of aet	list ?
	bcs	$append		; br if	yes, add et data to end.
	lda	<newx		; get x	position this edge.
	cmp	(<aetx),y	; < next x in aet ?
	bcc	$insrt		; no, go add to	aet.
	iny
	iny
	bra	$sloop
$insrt:
	lda	<aetx
	bsr	$xpnd
	lda	<aetxf
	bsr	$xpnd
	lda	<aetdx
	bsr	$xpnd
	lda	<aetdxf
	bsr	$xpnd
	lda	<aetdy
	bsr	$xpnd

$append:
	inc	<aetcnt		; update aet size.
	inc	<aetcnt

	lda	<newx
	sta	(<aetx),y
	lda	##0
	sta	(<aetxf),y
	lda	<dx
	sta	(<aetdx),y
	lda	<dxf
	sta	(<aetdxf),y
	lda	<dy
	sta	(<aetdy),y

	iny
	iny
	sty	<aetidx		; save index next aet element.
	brl	$loop

;
; Make room for	new aet	element	by moving
; elements y ..	aetcnt-2 to y+2	.. aetcnt.
;
$xpnd:

	pha
	phx
	phy			; source index.

	sec
	adc	<aetcnt		; aetcnt+a+1 = addr target -> y
	tay
				; aetcnt+a-1 = source addr -> x
	dec	a
	dec	a
	tax

	sec
	lda	<aetcnt
	sbc	1,s
	dec	a
	mvp	>0,>0

	ply
	plx
	pla
	rts

hosed:	brl	dfpdon
;
; Make edge list from array of vertices.
; For each edge	record ymin, xmin, dx, dy.
; Sort the list	in order of increasing y, then x.
;

bldet:
	lda	(<ovx)
	sta	<xin
	lda	(<ovy)
	sta	<yin

	ldy	<ovcnt
$lup:
	dey
	dey
	bmi	hosed
	sec
	lda	<yin
	sbc	(<ovy),y
	beq	$lup

	sta	<sign		; record dir closing edge.

	ldy	##2
	sty	<ibidx
	stz	<etcnt
$loop:
	lda	(<ovx),y
	sta	<newx
	sta	<x2
	lda	(<ovy),y		; get newy.
	sta	<newy
	sta	<y2
	iny
	iny
	sty	<ibidx
	sec
	sbc	<yin			; new y	> old y	?
	sta	<sign1			; save dir this	edge.
	bcs	$newgt			; br if	going up.
;
; swap,	so that	newy > yin
;
	ldx	<yin
	lda	<newy
	sta	<yin
	stx	<newy
	lda	<newx
	ldx	<xin
	sta	<xin
	stx	<newx
	bra	$1
$newgt:
	bne	$1
	brl	$nxtedg
$1:
;
; if prev edge same direction as current edge,
; fudge	the vertex so it doesn't look like
; an edge when it gets to the aet.  This may
; cause	dy = 0,	which will be handled later.
;
	lda	<sign
	eor	<sign1
	bmi	$diff
	bit	<sign1
	bmi	$k1
	inc	<yin
	bra	$diff
$k1:	dec	<newy
$diff:

;
; enter	new edge at end	of list.
;
	ldy	<etcnt
	lda	<xin
	sta	(<etx),y
	lda	<yin
	sta	(<ety),y
;
; search the list for y	>= yin,	then for
; y == yin, x >	xin.
;
	ldy	##-2
$ysrch:
	iny
	iny
	lda	<yin
	cmp	(<ety),y
	bcc	$insert		; if less, insert at y.
$xsrch:
	bne	$ysrch		; if equal, check x, else search on.
	cpy	<etcnt
	beq	$insrtx
	lda	<xin
	cmp	(<etx),y
	bcs	$ysrch
;
; insert xin, yin at et(y)
;
$insert:
	lda	<etx
	bsr	$xpnd
	lda	<etdx
	bsr	$xpnd
	lda	<ety
	bsr	$xpnd
	lda	<etdy
	bsr	$xpnd

	lda	<xin
	sta	(<etx),y
	lda	<yin
	sta	(<ety),y

;
; compute and save etdx, etdy.
; move x2, y2 to xin, yin.
;

$insrtx:
	sec
	lda	<newx
	sbc	<xin
	sta	(<etdx),y

	sec
	lda	<newy
	sbc	<yin
	sta	(<etdy),y

	inc	<etcnt
	inc	<etcnt
$nxtedg:
	lda	<sign1			; save direction this edge.
	beq	$n1			; unless horizontal.
	sta	<sign
$n1
	lda	<x2
	sta	<xin
	lda	<y2
	sta	<yin
	ldy	<ibidx
	cpy	<ovcnt
	bcs	setdxf
	brl	$loop

;
; Make room for	new et element by moving
; elements y ..	etcnt-2	to y+2 .. etcnt.
;

$xpnd:

	pha
	phy			; source index.

	sec
	adc	<etcnt		; etcnt+a+1 = addr target -> y
	tay
				; etcnt+a-1 = source addr -> x
	dec	a
	dec	a
	tax

	sec
	lda	<etcnt
	sbc	1,s
	dec	a
	mvp	>0,>0

	ply
	pla
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; For each entry in the	edge list, calculate	;
; and save the fractional parts	of dy/dx.	;
; It is	assumed	that horizontal	edges have	;
; been eliminated from the edge	table.		;
; Save max y coord in ymax.			;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

setdxf:
	lda	<newy
	inc	a
	sta	<ymax
;
; abs(y/x)
;
	ldy	##0
$loop:
	lda	(<etdy),y
	sta	0xfe04		; divisor = dy (always > 0).
	bne	$nz
	inc	a
	sta	0xfe04
	dec	a
$nz:
	inc	a
	sta	(<etdy),y	; convert to line count.

	lda	(<etdx),y	; dx

	sta	<sign		; save sign of dx.
	bpl	$1		; convert to abs(dx).
	eor	##-1
	inc	a
$1
	sta	0xfe02		; dividend = abs(dx)
	stz	0xfe00

	sta	DaDiv
$w1	bit	Dpdone-1
	bvc	$w1

;
; If dx	< 0, set quotient = real quotient - 1.
; This simplifies things later on when we're
; dealing with the fractional part of dx/dy.
;
	lda	0xfe00		; get quotient.
	bit	<sign		; make quotient	< 0 if dx < 0.
	bpl	$2
	eor	##-1		; dx is	< 0.
;	inc	a		; NO !!! quotient - 1.
$2	sta	(<etdx),y

;
; get fractional part from remainder.
;

	lda	0xfe02		; get remainder	of dx/dy.
	and	##0xfff		; mask off sign	bits.
	sta	0xfe00		; mult * 2**12.
	stz	0xfe02
	sta	DaDiv		; (same	divisor	as last	time).
$w2	bit	Dpdone-1
	bvc	$w2

	lda	0xfe00		; get 12 bit quotient.
	asl	a		; convert to 16	bit.
	asl	a
	asl	a
	asl	a
;
; If dx	< 0, negate fractional part.
; If fraction =	0, inc quotient	above
; (i.e.	make it	the correct quotient).
;

	bit	<sign
	bpl	$3
	eor	##-1
	inc	a
	bne	$3

	tax
	lda	(<etdx),y	; frdx = 0, correct dx.
	inc	a
	sta	(<etdx),y
	txa
$3:
	sta	(<etdxf),y

	iny
	iny
	cpy	<etcnt
	bcs	$done
	brl	$loop
$done:
	rts

dfpend:
	end
