#include "tcp.h"

sho(x10)		/* set horizontal origin */
int x10;		/* to some value in 0..1023 */
{
	aedbf[0] = SHO;
	aedbf[1] = x10.hibyte & 03;
	aedbf[2] = x10.lobyte;
	obyte(aedbf,3);
}

svo(y10)	/* set vertical origin */
int y10;	/* to some value in 0..1023 */
{
	aedbf[0] = SVO;
	aedbf[1] = y10.hibyte & 03;
	aedbf[2] = y10.lobyte;
	obyte(aedbf,3);
}

/*	return horizontal origin in ox and as function	*/
/*	value.  returned value is in 0..1023		*/

rho(ox)				/* read horizontal origin */
int *ox;
{
	aedbf[0]= RHO;
	ordcmd(aedbf,1);
	ibyte(aedbf,2);

	ox->hibyte = aedbf[0] & 03;
	ox->lobyte = aedbf[1];

	return(*ox);
}

/*	return current vertical origin in y and as	*/
/*	function value.  value returned is in 0..1023  */

rvo(y)				/* read vertical origin */
int *y;				
{
	aedbf[0] = RVO;
	ordcmd(aedbf,1);
	ibyte(aedbf,2);

	y->hibyte = aedbf[0] & 03;
	y->lobyte = aedbf[1];
	return(*y);
}

szr(x,y)	/* set zoom register */
int x,y;
{
	if( (x<1) || (x>16) || (y<1) || (y>16) ){
		printf(" szr ** bad zoom factor(s): %d %d\n",x,y);
		printf(" zoom factors must be in 1..16\n");
		exit(0);
	}
	aedbf[0] = SZR;
	aedbf[1] = x;
	aedbf[2] = y;
	obyte(aedbf,3);
}

/*	read zoom registers ---- AED1024 only	*/

rzr(x,y)
int *x, *y;
{
	aedbf[0] = XTD;
	aedbf[1] = RZR;
	ordcmd(aedbf,2);
	ibyte(aedbf,2);

	*x = aedbf[2];
	*y = aedbf[3];
}

hsr(dx)			/* horizontal scroll relative */
int dx;
{
	aedbf[0] = HSR;
	aedbf[1] = dx;
	obyte(aedbf,2);
}

vsr(dy)		/* vertical scroll relative */
int dy;
{
	aedbf[0] = VSR;
	aedbf[1] = dy;
	obyte(aedbf,2);
}

bso(x10,y10)		/* set horizontal and vertical origins */
int x10,y10;
{
	aedbf[0]= BSO;
	aedbf[1]= x10.hibyte & 03;	/* h and v origins must be */
	aedbf[2]= x10.lobyte;		/* in 0..1023		   */
	aedbf[3]= y10.hibyte & 03;
	aedbf[4]= y10.lobyte;
	obyte(aedbf,5);
}
dpa()				/* disable pan */
{
	aedbf[0]= DPA;
	obyte(aedbf,1);
}

epa()			/* enable panning */
{
	aedbf[0]= EPA;
	obyte(aedbf,1);
}

sup(arg)	/* enable/disable auto roam, 512 only */
int arg;
{
	aedbf[0] = SUP;
	aedbf[1] = arg ? 1 : 0;
	obyte(aedbf,2);
}

sar(xysign,xrate,yrate)		/* set auto roam, 512 only */
int xysign,xrate,yrate;
{
	aedbf[0] = SAR;
	aedbf[1] = xysign;
	aedbf[2] = xrate;
	aedbf[3] = yrate;
	obyte(aedbf,4);
}
