#include "tcp.h"

sbc(color)			/* set background color */
int color;
{
	aedbf[0] = SBC;
	aedbf[1]= color;
	obyte(aedbf,2);
}
sec(color)	/* set current color */
int color;
{
	aedbf[0] = SEC;
	aedbf[1] = color;
	obyte(aedbf,2);
}

/*	load RGB triples for colors add .. add+n-1 
	with the bytes in red[],green[],blue[].
*/
	
sct(add, n, red, green, blue)	/* set color look-up table */
int  add, n;
char red[], green[],blue[];
{

	register char	*ct;
	register char	*r = red,
			*b = blue,
			*g = green;
	 char	*last;

/*	ensure 0<n<=256 - 0 means 256	*/

	if( (n &= 0377) == 0)
		n = 256;	

/*	ensure add is a valid color number - 0..255	*/

	add &= 0377;

/*	make sure there's n colors starting with color add
*/
	if(add + n > 256){
		printf(" sct ** first = %d count = %d\n",add,n);
		printf(" first + count must be < 257\n");
		exit(1);
	}

/*	everything is ok - issue command	*/

	aedbf[0] = SCT;
	aedbf[1] = add;
	aedbf[2] = n;
	obyte(aedbf, 3);


	last = aedct + n * 3; /* last = last needed pos in aedct +1 */

/*	splice the three arrays into a sequence of rgb triples	*/

	for(ct = aedct; ct < last; ){
		*ct++ = *r++;
		*ct++ = *g++;
		*ct++ = *b++;
	}
	obyte(aedct, last - aedct);	
}
/*	read num rgb trples from color table	*/
/*	starting with color number startloc,	*/
/*	into red, green, blue, each of which	*/
/*	must be at least num bytes long.	 */

rct(startloc,num,red,green,blue)	/* read color look-up table */
int startloc,num;
char red[], green[], blue[];
{
	int numx3;
	register char	*ct;
	register char	*r = red,
			*g = green,
			*b = blue;						
	char	*last;

	aedbf[0]= XTD;
	aedbf[1]= RCT;
	aedbf[2]= startloc;

/*
	make sure that we don't ask for more of
	the color table than there is to get,
	else ibyte will hang.
*/
	startloc &= 0377;
	if( (num &= 0377) == 0)
		num = 256;
	if(startloc + num > 256)
		num = 256 - startloc;
	aedbf[3] = num;
	ordcmd(aedbf,4);
	numx3 = num * 3;

	ibyte(aedct, numx3);
	last = aedct + numx3;

	for(ct = aedct; ct < last; ){
		*r++ = *ct++;
		*g++ = *ct++;
		*b++ = *ct++;
	}
	return;
}	

swm(mask)	/* set write mask */
int mask;
{
	aedbf[0] = SWM;
	aedbf[1] = mask;
	obyte(aedbf, 2);
}

srm(m1,m2,m3,m4)	/* set read masks */
int m1,m2,m3,m4;
{
	aedbf[0] = SRM;
	aedbf[1] = m1;
	aedbf[2] = m2;
	aedbf[3] = m3;
	aedbf[4] = m4;
	obyte(aedbf,5);
}

sbl(color,r,g,b,ontime,oftime)	/* set blink */
int color,r,g,b,ontime,oftime;
{
	aedbf[0] = SBL;
	aedbf[1] = color;	/* color number to blink */
	aedbf[2] = r;		/* red,green,blue	*/
	aedbf[3] = g;		/* values for blink	*/
	aedbf[4] = b;
	aedbf[5] = ontime;	/* time to display color as itself */
	aedbf[6] = oftime;	/* time to display color as r,g,b  */
	obyte(aedbf,7);		/* time is in units of refresh rate*/
}

lat(basecol,rlknum)		/* load color table number with */
int basecol;			/* user defined antialiasing ramp */
register char rlknum[];

/*	note that this routine uses aedct for output buffer.	*/
/*	idea is not to do 2 obytes if we can do it with one.	*/
/*	for no good reason aedbf is 16 bytes, we need 19 here 	*/
/*	for commands and data.					*/
{
	register char *bp = aedct;

	if( (basecol > 7) || (basecol < 0) ){
		printf(" lat ** invalid base color %d\n", basecol);
		printf(" base color must be in 0..7\n");
		exit(0);
	}
	*bp++ = XTD;
	*bp++ = LAT;
	*bp++ = basecol;
	while(bp < &aedct[19])
		*bp++ = *rlknum++;
	obyte(aedct,19);
}
