/*	Graphics terminal driver with DMA for AED's 767.
*	aed_v1.c is dma and interrupt per byte version.
*****************************************************************
*								*
*	All rights reserved:	VENTURCOM INC.	1982		*
*								*
*	This source listing is supplied in accordance with	*
*	the Software Agreement you have with VenturCom and	*
*	the Western Electric Company.				*
*								*
*	sample /dev entries for this driver			*
*	crw-rw-rw- 1 root    8,  0 Feb 18 19:08 /dev/aedtimage	*
*	crw-rw-rw- 1 root    8,  1 Feb 18 18:07 /dev/aedimage	*
*	crw-rw-rw- 1 root    8,  2 Nov 21 00:17 /dev/aedtimaoi	*
*	crw-rw-rw- 1 root    8,  3 Feb 24 18:18 /dev/aedimaoi	*
*	crw-rw-rw- 1 root    8,  4 Nov 21 00:17 /dev/aedtwrcmd	*
*	crw-rw-rw- 1 root    8,  5 Feb 19 06:57 /dev/aedwrcmd	*
*	crw-rw-rw- 1 root    8,  6 Feb 28 06:15 /dev/aedbytes	*
*	crw-rw-rw- 1 root    8,  7 Nov 21 00:17 /dev/aedclr	*
*								*
* source current as of 4/18/83 harvie h. branscomb 		*
* modded to correct ibyte problem caused by BYTA being cleared  *
* when any of the 4 controller registers are read 7-jul-83 by   *
* Steven P. Bischoff                                            * 
*****************************************************************/

#include <sys/param.h>
#include <sys/reg.h>
#include <sys/seg.h>
#include <sys/user.h>
#include <sys/tty.h>
#include <sys/buf.h>

	/* user defineable conditions follow: */
/*#define	DIAG	1	/* for dump on hang condition */
/*#define	DEBUG	1	/* for general debug prints */
/*#define	TDEBUG	1	/* for timeout debug prints */
/*#define 	VENIXC	1	/* define VENIXC for release C */
/*#define	PREPR	1	/* for default area of interest */
				/* and raster start position on open */
				/* of appropriate entries, engaged */
				/* by turning on PREBIT in minor device */
				/* above not implemented 4/18/83 */

#define	AEDADDR	0164040		/* hardware address of parallel interface */
				/* registers for AED graphics device */
	/* end of user defineable code */

	/* CSR bits */
#define	ABUSY	0100000
#define	BYTA	040000		/* byte assembled */
#define KRDY	020000		/* keyboard ready flag */
#define	DMADIR	020000		/* 1=read 0 =write */
#define	MTSEL	02000		/* multi terminal select */
#define NOINTR	01000		/* no interrupt on command out */
#define	INTR	0		/* the opposite */
#define	RESET	0400		/* 1= reset terminal */
#define	IE	0100		/* interrupt enable in csr2 */

	/* command codes */
#define	SKEY	066		/* send keystroke command */
#define	RRAST	0100		/* read raster direct */
#define	WRAST	0106		/* write raster direct */
#define	RAOI	057		/* read from area of interest */
#define	WAOI	056		/* write to area of interest */
#define	CDMA	052		/* command dma */
#define	AESC	033		/* escape command for termination */

	/* driver parameters */
#define	NMTRY	100	/* number of tries to reread csr if busy */
#define TIMCKTK	60	/* number of clock ticks between timeout calls */
#define	WAITSEC	10	/* number of intervals of above period to wait
			   before clearing driver */

	/* driver mode bits for aedmode */
#define	STOPPED	040000	/* code for AED idling (termination code sent) */
#define	SLOWING	020000	/* code for AED dma being terminated */
#define	CHNGMOD	010000	/* code for AED terminating before new xfr */
#define	TERMINA 004000	/* code for termination on first open and last close */
#define	ENDAOI	002000	/* end of aborted area of interest transfer */
#define	ODDADD	020	/* code for odd byte count transfers (in minor  */
			/* device number in driver) */
#define	PREBIT	010	/* flag for default aoi and raster processing */
			/* (in minor device number) */

struct {			/* device register layout */
	int	csr;	
	int	csr2;
	char	*addr;	
	int	wcount;
};

	/* static storage */
struct	devtab	aedtab;
int		aeduid	0;		/* current user id */
int		aeddir	0;		/* dma direction flag */
unsigned	aedibyt 0;		/* temporary byte in storage */
unsigned	aedmode = STOPPED;	/* driver mode */
unsigned	aedxmem;		/* extended mem address for int. ops */
int		aedstopcd = 60; 	/* command dma stop command image */
int		aedcsrec;		/* temporary storage of csr */
char		aedctim = -1;		/* timeout counter */
char		*aedipntr;		/* mem address for interrupt ops */
long		aedbytc 0;		/* byte counter for interrupt ops */

#ifdef	DIAG
diagnose(){
	register struct buf *bp;
	if( (bp = aedtab.d_actf) != NULL ){
	printf("buf struct: addr %o, wc %o, dev %o, flags %o\n"
	,bp->b_addr,bp->b_wcount,bp->b_dev,bp->b_flags);
	}
	printf("aeduid %d, aeddir %o, aedibyt %o, aedmode %o, aedbytc %o%o\n"
	,aeduid,aeddir,aedibyt,aedmode,-aedbytc);
	printf("csr %o, csr2 %o, addr %o, wc %o\n",AEDADDR->csr,AEDADDR->csr2
	, AEDADDR->addr, AEDADDR->wcount);
}
#endif
aedioctl(dev, cmd, addr){
	extern lbolt;

	if( cmd == TIOCSETP ){
		aedclear();
	} else
		u.u_error = EINVAL;
}

aedopen(dev,mode) {
	extern lbolt;
	register i;
	if( aeduid!=0 && aeduid!=u.u_ruid && u.u_ruid!=0 ){
		u.u_error = ENXIO;
		return;
	}
	if( ((i =(dev&07)))==07 )
		aedclear();
	else{
		if(i==06)aedibyt = 0;
		AEDADDR->csr2 = IE;
         	if(aeduid==0){
       			if(AEDADDR->csr&ABUSY){
				u.u_error = ENXIO;
				return;
			} 
			if(i < 6){
				aedmode |= SLOWING;
				settimer();
				terminate();
			}
		}  
		aeduid = u.u_ruid;
	}
}

aedclose() {
	register i;

	if(aedmode < SLOWING) {
		if(AEDADDR->csr2&IE){
			i = spl5();
			aedmode |= SLOWING|TERMINA;
			settimer();
			terminate();
			splx(i);
		}
	}
	aeduid = 0;
}
aedtimo(){
#ifdef	TDEBUG
	printf(" |%d| ",aedctim);
#endif
	if((--aedctim) > 0) timeout( &aedtimo,1,TIMCKTK);
	else {
		--aedctim;
		if(aedctim == -1) {
#ifdef	DIAG
			diagnose();	
#endif
			aedclear();
		}else if(aedctim == -12) aedmode = STOPPED;
	}
}
aedclear(){
	register struct buf *bp;
	register int s;

/*        printf("clr csr= %o csr2= %o\n",AEDADDR->csr,AEDADDR->csr2); */
	s = spl5();
	aedibyt =  0;
	aedbytc = 0;
	AEDADDR->csr2 = 0;
	aedmode = SLOWING;
	AEDADDR->csr = RESET|AESC|NOINTR;
	settimer();
	aedctim = -10;
	AEDADDR->wcount = 0;
	killxfr();
	splx(s);
}

killxfr(){
	register struct buf *bp;
	while(( bp = aedtab.d_actf) != NULL ){
		bp->b_flags |= B_ERROR;
		iodone(bp);
		aedtab.d_actf = bp->av_forw;
	}
	aedtab.d_active = 0;
	AEDADDR->wcount = 0;
}

aedstrategy(abp) struct buf *abp; {
	register struct buf *bp;
	register s;

	bp = abp;
	bp->av_forw = 0;
	s = spl5();
	if( aedtab.d_actf == 0 )
		aedtab.d_actf = bp;
	else
		aedtab.d_actl->av_forw = bp;
	aedtab.d_actl = bp;
	if( aedtab.d_active==0 )
		aedstart();
	splx(s);
}

aedstart() {
	register struct buf *bp;
	register i;
	if( (bp = aedtab.d_actf) == NULL ){
		aedctim= 0;
		return;
	}
	settimer();
        if (bp->b_dev&07 != 6)        /* only test wc if not ibyte or obyte */
           if(AEDADDR->wcount)return; 

#ifndef	N_MAP
	if( bp->b_flags&B_PHYS )
		mapalloc(bp);
#endif
	i = 0;
	if( bp->b_flags&B_READ )i = DMADIR;
	if(((bp->b_dev&06) != (aedmode&(~01)))||(i != aeddir)){
		if(aedmode == STOPPED){
			aedtab.d_active++;			

#ifdef	DEBUG
printf("m: %o\n",bp->b_dev );
#endif
			aeddir = i;
			switch((bp->b_dev&07)){
			case 0:	case 1:
				if( i )
					i |= RRAST|NOINTR;
				else
					i = WRAST|NOINTR;
				break;
			case 2:	case 3:
				if( i )
					i |= RAOI|NOINTR;
				else
					i = WAOI|NOINTR;
				break;
			case 4: case 5:
				if( i == 0 ){
					i |= CDMA|NOINTR;
					break;
				}
			case 6: 
				aedbytc = (bp->b_wcount) << 1;
				if(bp->b_dev&ODDADD) aedbytc++;
				aedipntr = bp->b_addr & 077; 
			aedxmem =((bp->b_xmem<<10)|((bp->b_addr>>6)&01777));
				if(i) aedmode = 7;
				else aedmode = 6;
				aedintr(1);
				return;
			default:
				u.u_error = ENODEV;
finish:				killxfr();
				aedstart();
				return;
			}

			aedmode = bp->b_dev&07;
			AEDADDR->csr = i;

		}else{
/*	set mode change bits and send appropriate termination command */
			if(aedmode&SLOWING)return;
#ifdef	DEBUG
printf("change mode code!\n");
#endif
			aedmode |= (SLOWING|CHNGMOD);
			terminate();
			return;
		}
	}
/* check for 18 bit wrap around here before starting */

	if(bp->b_xmem > 02){
		i = bp->b_wcount;
if((i = ((bp->b_xmem<<8)+(((bp->b_addr)-i)>>8))) > 01776){
		u.u_error = ENODEV;
printf("AED:18b wraparound- exit %o\n",i);
		aedmode |= SLOWING;
		terminate();
		killxfr();
		aedstart();
		return;
	}
#ifdef	DEBUG
	printf("check fit in 18 bit memory %o \n",i);
#endif
	}
/* now start up a DMA transfer by resetting wcount register */

	aedtab.d_active++;
	aedmode = bp->b_dev&07;
	AEDADDR->addr = bp->b_addr;
	AEDADDR->csr2 = (((bp->b_xmem&03) << 12)| IE) ;

#ifdef	DEBUG
printf("wc: %o\n",bp->b_wcount);
#endif

	AEDADDR->wcount = (bp->b_wcount) ;
}

aedintr(arg) {
	register  struct buf *bp;
	int a, d;
	unsigned ibyt;		
	int s;
#ifdef	DEBUG
printf("\nintmd%o; arg%o; wc%o; act%o; ctim %d; ibyt%o; bytc%o%o; "
,aedmode,arg,AEDADDR->wcount, aedtab.d_active,aedctim,aedibyt,-aedbytc);
#endif
		s = spl7();
		if(((aedmode&7) != 7)&&((aedmode & 7) != 6)) 
			splx(s);
		if((aedibyt&BYTA)==0){    /*  if we haven't got a byte */
       			if((aedcsrec = AEDADDR->csr)&BYTA){  /* byte ready */
                                 aedibyt = aedcsrec;    /* save byte */
                    while(AEDADDR->csr&BYTA){
                        /* wait for not BYTA */
                     }                
                   }
		}
		if(aedctim > 0)aedctim = WAITSEC;
#ifdef	DEBUG
printf("csr%o",a);
#endif
		if(aedtab.d_active==0){
			if(aedmode&SLOWING){
				if(aedmode&ENDAOI){
					AEDADDR->wcount = 0;
				}
				if(aedmode&TERMINA) AEDADDR->csr2 = 0;
				aedmode = STOPPED;
			}
			if(aedmode == STOPPED){
				aedstart();
				return;
			}
		}
		if(aedtab.d_active&&((aedmode==7)||(aedmode==6))){
			if((aedmode==7)&&((aedibyt&BYTA)==0)){
      				if(arg){spl5(); return;}
				aedibyt = aedcsrec;
			/*	printf("AED:no BYTA flg,csr:%o\n",aedcsrec);
			*/
			}
#ifdef DEBUG
printf("\nbc%o %o; md%o; ib%o",-aedbytc,aedmode,aedibyt);
#endif

/*			spl7();	*/
			a = UISA->r[0];
			d = UISD->r[0];
			UISA->r[0] = aedxmem;
			UISD->r[0] = 077406;
			if(aedmode == 6)ibyt=fuibyte(aedipntr);
			else suibyte(aedipntr,aedibyt);
			UISA->r[0] = a;
			UISD->r[0] = d;
			aedibyt = 0;
			spl5(); 
			if(++aedipntr == 0100){
				aedxmem++;
				aedipntr = 0;
			}
			if(aedcsrec&ABUSY){
				for(d=0;d<NMTRY;d++){
					if((AEDADDR->csr&(ABUSY|BYTA))==0)break;
				}
				if(d>(NMTRY-2))printf("AED:busy %o\n",aedcsrec);
			} 
			if(aedmode == 6){
				AEDADDR->csr = ibyt | INTR;
			}else{
				AEDADDR->csr = AESC| INTR;
			}
			if(++aedbytc) return;
			aedmode |= SLOWING;

		} else{
			if(arg == 1)return;
					/* allow driver to return if forced
					entry from start routine */
			else if((aedtab.d_active==0)&&((aedmode&(0177776))==2)){
#ifdef	DEBUG
				printf("AED:aoi lim\n");
#endif
				u.u_error = ENODEV;
				AEDADDR->wcount = 0;
				aedmode = 2|ENDAOI;
			}
			if((aedmode & 1) == 0){
				aedmode |= SLOWING;
				terminate();
			}							
		}
/*
comment           if (((aedmode && 7) != 7)&((aedmode && 7) !=6)){ 
                  printf("wc int\n"); end comment
  		if(aedtab.d_active&&(AEDADDR->wcount==0)){
			bp = aedtab.d_actf;
			if(bp){
				bp->b_resid = 0;
				aedtab.d_actf = bp->av_forw;
				iodone(bp);
			}
			aedtab.d_active = 0;
		}
  comment       } end comment
		aedstart();
*/
		if(aedtab.d_active == 0){
			aedstart();
			return;
		}
		if(((aedmode & 7) != 7) &&
		   ((aedmode & 6) != 6)){
			if(AEDADDR->wcount != 0){
				aedstart();
				return;
			}
		}
		bp = aedtab.d_actf;
		if(bp){
			bp->b_resid = 0;
			aedtab.d_actf = bp->av_forw;
			iodone(bp);
		}
		aedtab.d_active = 0;
		aedstart();
		return;		
}

terminate(){
	if((aedmode&06) == 04){
		AEDADDR->csr2 = IE;
		AEDADDR->addr = &aedstopcd;
		AEDADDR->wcount = 0177777;
	}
	else   AEDADDR->csr = AESC|aeddir;
            
#ifdef	DEBUG
	printf("term");
#endif
}

aedread(dev) {

	if(u.u_count&01){
		u.u_count++;
		dev |= ODDADD;
	}
	aphysio(aedstrategy, dev, B_READ);
}

aedwrite(dev) {

	if(u.u_count&01){
		u.u_count++;
		dev |= ODDADD;
	}
	aphysio(aedstrategy, dev, B_WRITE);
}
settimer(){

	register int s;
		s = spl6();
		if(( aedctim < 0)){
#ifdef TDEBUG
	printf("set\n");
#endif
			timeout(&aedtimo,1,TIMCKTK);
		}
		aedctim = WAITSEC;
		splx(s);
}


