#include <stdio.h>

#define TOLEFT 1
#define TORIGHT 2
#define TOTOP 	8
#define TOBOTTOM 4

typedef struct {
		int x, y;
	} POINT;

typedef struct {
		POINT p1, p2;
	} LINE;

typedef struct {
		int xleft, ybottom, xright, ytop; 
	} WINDOW;


clipl(p1,p2,wp)		/* return  0 for trivial reject, */
POINT *p1, *p2;		/* else clip xy to wp and return <>0 */
WINDOW *wp;
{
	int c1, c2, vc;
	long dx, dy;
	POINT *pp1, *pp2;


	for(;;){

		c1 = vcode(p1,wp);
		c2 = vcode(p2,wp);
	
		if(c1 & c2)			/* trivial reject */
			return(0);
		if( (c1 | c2) == 0)		/* trivial accept */
			return(1);

/*
	At least 1 endpoint outside.
	Clip coordinates to window until line can
	be trivially accepted or rejected.
*/
		if(c1){
			vc = c1;
			pp1 = p1;
			pp2 = p2;
		}else{
			vc = c2;
			pp1 = p2;
			pp2 = p1;
		}
		dx = pp2->x - pp1->x;
		dy = pp2->y - pp1->y;
	
		if(vc & TOTOP){
			pp1->x += (dx * (wp->ytop - pp1->y))/dy;
			pp1->y = wp->ytop;
		}else
		if(vc & TOBOTTOM){
			pp1->x += (dx * (wp->ybottom - pp1->y))/dy;
			pp1->y = wp->ybottom;
		}else
		if(vc & TOLEFT){
			pp1->y += (dy * (wp->xleft - pp1->x))/dx;
			pp1->x = wp->xleft;
		}else
		if(vc & TORIGHT){
			pp1->y += (dy * (wp->xright - pp1->x))/dx;
			pp1->x = wp->xright;
		}
	}
}

				
			



/*
	return code indicating location of x,y
	with respect to window.
*/

vcode(p,wp)	
POINT *p;
WINDOW *wp;
{
	int vc;
	vc = 0;

	if(p->x < wp->xleft)
		vc = TOLEFT;
	else if(p->x > wp->xright)
		vc = TORIGHT;

	if(p->y < wp->ybottom)
		vc |= TOBOTTOM;
	else if(p->y > wp->ytop)
		vc |= TOTOP;

	return(vc);
}


/*
	Wait for pendown.  Return status and coords. 
*/

getpick(x,y)
int *x, *y;
{
	int flag, dummy, dummy1;

	flag = 0;
	do{
		rtp(&dummy,&flag,x,y);
		sleep(-2);
	}while((flag&1) == 0);

	dummy1 = 1;
	do{	/* debounce */
		rtp(&dummy,&dummy1,&dummy,&dummy);
		sleep(-2);
	}while(dummy1&1);

	return(flag);
}


/*	Enable tablet, delay appropriately */

enable()
{
	int i;
	etp(126);
	for(i=0;i<300;i++)
		;
}
