
;	These addresses	are fixed, the same in all
;	versions of the	firmware.

XLO	equ	024
YLO	equ	026
VM	equ	030
VMIX	equ	031
VMIY	equ	032
VMIXY	equ	033
XPOS	equ	0101
YPOS	equ	0103
COLOR	equ	074

;	These addresses are for 802 versions only.

.GET2	equ	0177671
.GETB	equ	0177655
.GSN	equ	0177666
.GET	equ	0177633
.GCOOR	equ	0177660

;	Floating addresses.

INT	equ	0141103
NMINT	equ	0141061
RESET	equ	0141044


;	The instruction jmp	RESET (6502 reset routine)
;	is at each of the following addresses in RAM.

VEC802	equ	03756	

COP802	equ	03756
IRQ802	equ	03761
NMI802	equ	03764
ABT802	equ	03767
RST802	equ	03772
BRK802	equ	03775
	asect	0
	org	IRQ802
	jmp 	savirq
	org	NMI802
	jmp 	savnmi
	org	RST802
	jmp 	freset
	org	ABT802
	jmp 	freset
	org	COP802
	jmp 	freset
	org	BRK802
	jmp 	freset
;	802 implementation of Micheners	circle algorithm.


	asect	1
	org	0x1400


;	.GLOBL	CIRCLE		; Enter	here to	get radius from	host.
;	.GLOBL	FATCIR		; As above, for	fat circle.
;	.GLOBL	CIR		; Enter	here if	caller has already put
				; radius in RADIUS and initialized
				; the fat circle flag FCFLAG.

;	Local variables	:

RADIUS:	ds	2		; Radius of circle.
FCFLAG:	ds	2		; -1 for fat circle.

IX:	ds	2		; IX and IY are	the displacements
IY:	ds	2		; relative to XPOS, YPOS of the	points
				; on the circumference of the circle.
D:	ds	2		; Decision var,	used to	determine
				; whether next point is	on same	line
				; or the one below.

CXPX:	ds	2		; These	are the	translated points
CXMX:	ds	2		; (XPOS,YPOS) +- (IX,IY) and
CYPY:	ds	2		; (XPOS, YPOS) +- (IY, IX).
CYMY:	ds	2
CYPX:	ds	2
CYMX:	ds	2
CXPY:	ds	2
CXMY:	ds	2


IX4P6:	ds	2		; 4*IX + 6
M4IYP4:	ds	2		; -4*Y + 4

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	This is	an implementation of Micheners circle drawing		;
;	algorithm, described in	Foley/VanDam, pg445.			;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FATCIR:	lda	#-1		; Entry	for fat	circle from host.
	bra	CIRC1

CIRCLE:	lda	#0		; Entry	for regular circle from	host.
CIRC1:	sta	FCFLAG

	jsr	.GET2		; Get radius from host.
	sty	RADIUS+1	; High byte in Y reg.
	stx	RADIUS		; Low byte in X	reg.


CIR:				; Set X, Y counters to up.
	lda	#0140
	ora	<0x24
	sta	<0x24

	jsr	set802		; turn off emulation mode.
	rep	#0x30		; 16 bit regies.

	stz	IX		; init IX = 0, IY = RADIUS.
	lda	RADIUS
	sta	IY

	asl	a		; for computation below.
;	set D	= 3 - 2*RADIUS
;		= 3 - acc
;		= -acc + 3
;		= ((acc	eor -1)+1) + 3
;		= (acc eor -1) +4

	eor	##-1
	clc
	adc	##4
	sta	D


	lda	##6		; Set IX4P6 = IX*4 + 6
	sta	IX4P6

;	Set M4IYP4 = -4*IY + 4 = 4(1-IY)

	lda	IY		; set acc = 1 -	IY
	eor	##-1		; = 1 +	(-IY)
	inc	a		; = 1 +	(1+ (IY	eor -1))
	inc	a		; = 2 +	(IY eor	-1)

	asl	a		; set M4IYP4 = 4*acc
	asl	a		; = 4(1-IY)
	sta	M4IYP4

;	Init the 8 coordinates (XPOS,YPOS) +- (IX, IY)
;	and (XPOS, YPOS) +- (IY, IX).
;	Remember at this point IX = 0.

	lda	<XPOS
	sta	CXPX		; CXMX = CXPX =	XPOS
	sta	CXMX

	clc			; CXPY = XPOS +	IY
	adc	IY
	sta	CXPY

	lda	<YPOS
	sta	CYPX		; CYPX = CYMX =	YPOS
	sta	CYMX


	clc			; CYPY = YPOS +	IY
	adc	IY
	sta	CYPY

	sec
	lda	<XPOS		; CXMY = XPOS -	IY
	sbc	IY
	sta	CXMY

	sec
	lda	<YPOS		; CYMY = YPOS -	IY
	sbc	IY
	sta	CYMY


;	Done initializing, now we can start
;	drawing	the circle.

LOOP	jsr	PLOT		; Plot point at	(XPOS,YPOS)+(IX,IY).

	lda	D
	bpl	XY		; Branch if D positive to drop
				; to next line.
	clc			; D += IX4P6.  Update decision variable.
	adc	IX4P6
	sta	D

	inc	IX		; IX++.

	inc	CXPX		; Update the coordinates that
	inc	CYPX		; are translates of IX.
	dec	CXMX
	dec	CYMX

	clc
	lda	IX4P6		; IX4P6	+= 4.
	adc	##4
	sta	IX4P6

	lda	IX		; Compare IX, IY.
	cmp	IY
	bcc	LOOP		; LOOP if IX < IY.
	bne	L1		; Return if IX > IY.
	jsr	PLOT		; Plot 1 last point if IX = IY,	and return.
L1	jmp	set8bit

;	Here when it's time to move CAP	in Y as	well as	X.

XY
;	 Set D = 4*(IX-IY) + 10.
;	       = IX4P6 + M4IYP4.

	clc
	adc	IX4P6		; D += IX4P6.  Update decision variable.
	clc
	adc	M4IYP4		; D += M4IYP4.
	sta	D

	inc	IX		; IX++.
	dec	IY		; IY--.

	inc	CXPX		; Update the coordinates that
	inc	CYPX		; are translates of IX.
	dec	CXMX
	dec	CYMX

	bit	FCFLAG		; Fat circle ?
	bpl	XY1		; Branch if no.
		jsr	PLOT	; Yes, plot before we move Y cap.

XY1
	inc	CXMY		; Update the coordinates that
	inc	CYMY		; are translates of IY.
	dec	CXPY
	dec	CYPY

	clc
	lda	IX4P6		; IX4P6	+= 4.
	adc	##4
	sta	IX4P6

	clc
	lda	M4IYP4		; M4IYP4 += 4.
	adc	##4
	sta	M4IYP4

	lda	IX		; Compare IX, IY.
	cmp	IY
	bcs	XY2		; LOOP if IX < IY.
	jmp	LOOP
XY2	bne	DONE		; Return if IX > IY.
	jsr	PLOT		; Plot 1 last point if IX = IY,	and return.

DONE	jmp	set8bit		; get back in 6502 mode, return
				; to interpreter.


;	This routine plots the actual points of	the circle.

PLOT
	sep	#0x20		; set 8	bit acc	for pixel writes.
	lda	<COLOR
	rep	#0x20

	ldx	CXPX
	ldy	CYPY

	stx	<XLO
	sty	<YLO

	sep	#0x20
	sta	<VM		; +IX,+IY
	rep	#0x20

	ldx	CYMY
	stx	<YLO

	sep	#0x20
	sta	<VM		; +IX,+IY
	rep	#0x20

	ldx	CXMX
	stx	<XLO

	sep	#0x20
	sta	<VM		; +IX,+IY
	rep	#0x20

	sty	<YLO

	sep	#0x20
	sta	<VM		; +IX,+IY
	rep	#0x20

	ldx	CXPY
	ldy	CYPX

	stx	<XLO
	sty	<YLO

	sep	#0x20
	sta	<VM		; +IX,+IY
	rep	#0x20

	ldx	CYMX
	stx	<YLO

	sep	#0x20
	sta	<VM		; +IX,+IY
	rep	#0x20

	ldx	CXMY
	stx	<XLO

	sep	#0x20
	sta	<VM		; +IX,+IY
	rep	#0x20

	sty	<YLO

	sep	#0x20
	sta	<VM		; +IX,+IY
	rep	#0x20
	rts
;	entries : set802 - takes processor out of emulation mode.
;			   disables interrupts because interrupt 
;			   routines don't know how to save/restore
;			   state yet.
;			   Routines that use 16 bit modes should
;			   call this routine first.
;
;		  set8bit - sets all registers to 8 bit, turns
;			    on interrupts after initializing 
;			    stack pointer, then returns to the
;			    interpreter.

	
	asect	2
	org	0x2700

savirq
	rep	#0x30
	pha			; Save 'real' state.
	phx
	phy

	pea	rti802		; The above RTI will land us at rti802.
	php			; This gets popped in 6502 mode
				; when DISMIS does RTI.
	
	
	sep	#0x30		; Enter 6502 mode, jump to service
	sec			; routine.
	xce
	jmp	INT

savnmi
	rep	#0x30
	pha			; Save 'real' state.
	phx
	phy

	pea	rti802		; The above RTI will land us at rti802.

	php			; This gets popped in 6502 mode
				; when DISMIS does RTI.
	
	
	sep	#0x30		; Enter 6502 mode, jump to service
	sec			; routine.
	xce
	jmp	NMINT

rti802:
	clc
	xce
	rep	#0x30
	ply
	plx
	pla
	rti
	
set802:
	sei
	clc
	xce
	sep	#0x30
	cli
	rts		



;	Jump to this routine to exit from 802 mode.  It
;	sets 6502 emulation mode, enables interrupts and
;	returns, presumably to the interpreter.

set8bit:
	sei
	sep	#0x30			; set 8 bit mode.
	sec
	xce				; set emulation mode.
	cli
	rts

freset
	sei
	sep	#0x30
	sec
	xce
	jmp	RESET
	end
