/*
	Ellipse generator, adapted from the algorithm given
	in IEEE Transactions, Vol C-22, No 12, Dec. 1973,
	"An Improved Algorithm for the Generation of
	 Nonparametric Curves.", Jordan et al.
	This implementation only generates ellipses whose
	axes are parallel to the X,Y coordinate axes and
	are centered at (0,0), i.e.
	f(x,y) = ax**2 + by**2 - ab = 0.
	Also, the algorithm is only used to generate the first
	quadrant of the ellipse - the other points are found
	by symmetry.  The resulting program is a greatly
	simplified version of Figure 3 in Jordan's paper.
	The simplifications are based on the following ideas
	(refer to Jordan's paper).
	In equation (3), we choose D=1, i.e. we generate points
	in the counter-clockwise direction. 
	Because we only generate the first quadrant of the
	ellipse, fx is always <= 0 and fy always >= 0.  (4) and (5)
	now reduce to dx = -1, dy = 1.

*/

#include <stdio.h>
#include <math.h>

double sqrt();
long atol();

long	fx,
	fy,
	fxx,
	fyy;

long	falpha,
	fX,
	fY,
	fXY;

long	absfX,
	absfY,
	absfXY;
/*
int	deltax, deltay;
*/

int	ox,oy;		/* Coordinates of (0,0) centered ellipse. */
int	cx,cy;		/* Center of the actual ellipse */
int	px,py,		/* Coordinates of current points */
	mx,my;		/* on the actual ellipse	*/

long	a,b;

main(argc,argv)
int argc;
char **argv;
{
	a = 100L;
	b = 49L;
	
	if(argc == 3){
		a = atol(argv[1]);
		b = atol(argv[2]);
	}
	printf("%ld %ld\n",a,b);

	ox = sqrt((double)b);
	oy = 0;

	cx = 512;
	cy = 385;
	px = cx + ox;
	py = cy;
	mx = cx - ox;
	my = cy;

	fx = (2.0 * (double)a * sqrt((double)b));
	fy = 0;
	fxx = a<<1;
	fyy = b<<1;

	falpha = 0;
	
	for(;;){
/*
		dxdy();
*/
		plot();
		feasibles();
		step();
/*
		partials();
*/
	}
}

plot()
{
	mov(px,py);
	wpx(2);
	mov(px,my);
	wpx(2);
	mov(mx,my);
	wpx(2);
	mov(mx,py);
	wpx(2);
}

feasibles()
{
/*
	fX = falpha + fx*deltax + a;
	fY = falpha + fy*deltay + b;
*/
	fX = falpha - fx + a;
	fY = falpha + fy + b;

	fXY = fY + fX - falpha;
	absfX = fX > 0 ? fX : -fX;
	absfY = fY > 0 ? fY : -fY;
	absfXY = fXY > 0 ? fXY : -fXY;
}

step()
{
	if((absfY <= absfX) && (absfY < absfXY)){/* step in y */
		falpha = fY;
		fy += fyy;
		py++;
		my--;
	}
	else
	if((absfXY <= absfX) && (absfXY <= absfY)){/* step in x,y */
		falpha = fXY;
		fx -= fxx;
		fy += fyy;
		px--;
		mx++;
		py++;
		my--;
		ox--;
	}
	else
	if((absfX < absfY) && (absfX < absfXY)){ /* step in x */
		falpha = fX;
		fx -= fxx;
		px--;
		mx++;
		ox--;
	}
	else{
		printf("Hosed step\n");
		exit(0);
	}
	if(ox < 0)
		exit(0);
}


/*
	The function of this routine has been moved
	to the cases of step() above.

partials()
{
	fx += fxx*deltax;
	fy += fyy*deltay;
}
*/
/*
	This is not needed for the special case this program
	handles.  deltax here is always -1, deltay always 1.
	The other routines have been modified to take this into
	account.

dxdy()
{
	deltax = fy < 0 ? 1 : -1;
	deltay = fx < 0 ? -1 : 1;
}
*/
