

;	These routines init and exercise the 4
;	INS8250s (ACEs)	used in the 1280.

;	ACE offsets (in decreasing interrupt priority level):

	ACEBNK equ 0xf0		; Data bank containing ACEs.
	ACEPAG equ 0		; Page containing ACEs.
	aceadd equ 0		; Page offset of first ACE.
	acepad equ aceadd + 0	; Mouse/pad ACE.
	acekbd equ aceadd + 0x30; Keyboard ACE.
	acehst equ aceadd + 0x20; Host ACE.
	aceaux equ aceadd + 0x10; Aux ACE.

;	ACE register offsets :

;	(These 2 accessible if bit 7 of ACELCR = 1)
	ACEDLL = 0		; Divisor Latch Low byte.
	ACEDLH = 2		; Divisor Latch High byte.

;	(These 3 accessible if bit 7 of ACELCR = 0)
	ACERBR = 0		; Receiver Buffer Reg. (read data).
	ACETHR = 0		; Transmitter Holding Reg. (write data).
	ACEIER = 2		; Interrupt Enable Reg.

;	(Regardless of ACELCR bit 7).
	ACEIIR = 4		; Interrupt Ident. Reg.(read only).
	ACELCR = 6		; Line Control Register.
	ACEMCR = 8		; Modem Control Reg. (not used).
	ACELSR = 10		; Line Status Register.
	ACEMSR = 12		; Modem Status Reg. (not used).
	ACESCR = 14		; Scratch reg. (not used).
	
