	title	"Physical I/O Routines"
	psect	code

;
;	non-interrupt driven putchr.
;	output a byte in the accumulator
;
putchr:
	php
	sep	#0x20	; 8 bit mem
	pha		; save chr to print

wai:	lda	auxsta	; wait until aux xmtr is free
	bit	#2
	beq	wai

	pla		; get the chr
	sta	auxdat	; write it out

	plp		; restore memory mode
	rts
;
;	non-interrupt driven getchr
;	wait for a character from the aux port
;	return chr in accumulator when received
;
getchr:
	php
	sep	#0x20		; set 8 bit memory
$1:
	lda	auxsta		; wait for chr avail
	bit	#1
	beq	$1
	lda	auxdat
	and	#0x7f		; mask parity bit
	cmp	#0x20
	blt	$2
	cmp	#0x7f
	beq	$2
	bsr	putchr		; print chr and exit
$2:
	plp
	rts
	eject
;
;	WAITP - Wait for a character, then read it
;
waitp:
	bit	9
	bmi	getbp	; neg when one is availible
	bra	waitp	; otherwise just wait

;
;	Read one byte from the parallel interface
;	Generate device end if bit 2 of the high
;	byte of the parallel data is non-zero
;
;	It is assumed that this routine is called
;	after it has been determined that there
;	is a character availible
;

getbp:
	lda	8		; reset CO flag
	lda	0x29
	bit	#2		; no intr?
	bne	$1		; yes.. skip

	lda	0x28		; get the byte
	pha			; save it
	lda	#0x10
	tsb	0x25		; set device end
	nop
	nop
	trb	0x25		; reset device end
	pla
	rts

$1:
	lda	0x28		; get the byte
	rts

	title	"Trap Handlers"
;
;	Warning:
;	This routine MUST be within the first
;	65k of memory, as the pbr is forced to
;	0 on a break instruction
;
; this routine is entered when a breakpoint
; exception is encountered in 816 mode
;
;	when entered, the following is on the stack
;
;   4   pbr
;   3   pc hi
;   2   pc lo
;   1   psw
;  sp-> ---
;
brk:
	rep	#0x30	; 16 bit mem/idx
;
;	save program context
;
	pha		; save target accumulator
	phd		; save target direct page register

	lda	##dirpag
	tcd		; load our direct page reg

	pla
	sta	<sdp	; save target direct page reg
	pla
	sta	<sac	; save target accumulator
	tsc
	sta	<ssp	; save stack pointer
	stx	<six	; ix
	sty	<siy	; iy

	phb
	phb
	pla
	and	##0xff
	sta	<sdb

	lda	2,s	; pc + 2 byte brk ins
	dec	a
	dec	a
	sta	<spc	; program counter at location of brk

	lda	1,s
	sta	<sps	; proc status wrd

	lda	4,s	
	and	##0xff
	sta	<spb	; pgm bank reg

	lda	<dbgsp
	tcs		; load debugger stack pointer

	phk		; set debugger dbr
	plb

	brl	dbgbrk	; enter debugger break handler

;
;	proceed from breakpoint
;
pcmd:
;
;	restore the process's registers
;
	rep	#0x20	; 16 bit memory
	tsc
	sta	<dbgsp	; save a copy of our stack pointer
	tdc
	sta	<dbgdpr	; and our direct page reg

	ldx	<six
	ldy	<siy	; restore index regs

	lda	<ssp
	tcs		; stack references to his stack now...

	lda	<spc
	sta	2,s	; load the updated pc back on the stack

	sep	#0x20	; 8 bit memory
	lda	<sdb
	pha
	plb		; load data bank reg
	lda	<spb
	sta	4,s	; load the updated pbr onto the stack
	lda	<sps
	ora	#4	; ensure interrupts disabled
	sta	1,s	; load the updated psw onto the stack

	rep	#0x30
	lda	<sac	; restore his acc.
	pei	<sdp	; restore his dir page.
	pld
;
;
;	the last thing we do is set the pgm ctr and psw
;	by doing an rti from his stack
;	(the pc was updated to the correct spot by the
;	 brk exception routine)
;
	rti			; away we go.....

;
;	Here if some hoser leans on terminal keyboard.
;	

nmi:
	pha
	lda	>0,04	; clear nmi
	pla
	rti
	end
