;
; This file is included in development versions of the 
; 1280 kernel prom.
; The routine dlprom is called at powerup time
; (before calling the init routines in the proms)
; to load (via host running dl) any RAMs in the prom sockets.
;
; See if any of the prom sockets have ram.
; If so, wait for download from host.
;

ldprom:
	php
	rep	#0x30

	lda	##0
$loop:
	tax
	lda	>ROM,0,x	; get first word from prom socket.
	eor	##0xffff	; invert all bits.
	sta	>ROM,0,x	; try to write it back.
	cmp	>ROM,0,x	; did it write ?
	beq	$ram		; br if yes.
	txa			; no, bump addr to next prom socket.
	clc
	adc	##0x2000
	bne	$loop
	bra	$noram
$ram:	eor	##0xffff	; restore original ram value.
	sta	>ROM,0,x
	bsl	$load		; go download from host.
$noram:
	plp
	rts



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; The host (running dl) sends a series	;
; of lmr commands.  This routine exits  ;
; when an lmr to this prom is issued.	;
; jus commands are ignored.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

$load:
	php
	phb

	phk		; set dbr = prom bank.
	plb

	pea	##0	; flag indicating time to return.
lcmd::
	rep	#0x10	; 16 bit index
	sep	#0x20	; 8 bit memory

$1:	bsl	waitp	; wait for a parallel byte
	cmp	#'}'
	bne	$1	; wait for a sse cmd

	bsl	waitp
	bsl	waitp	; throw away the address


$loop:	bsl	waitp	; get the ":" (hopefully)
	cmp	#':'	; lmr command ?
	beq	$lmr	; branch if yes
	cmp	#';'	; jus command ?
	bne	$loop	; no, junk.
;
; jus command, get the data and return.
;
	bsl	waitp	; get addr high byte
	bsl	waitp	; get addr low byte
	brl	lcmd	; go wait for more downloaded code.
;	
; lmr command - 
; get addr, count and load ram
; return to kernel if addr is in
; kernel prom.
;

$lmr:	bsl	waitp	; get the starting addr high byte
	pha
	bsl	waitp	; start addr low byte
	pha		; push adr onto stack
$2:
	bsl	waitp	; get the count high byte
	pha
	bsl	waitp	; count low byte
	pha		; push count on stack


	ply		; get byte count
	plx		; get addr
	cpx	##0x2801 ; are we done ?
	bne	$3	; branch if no

	bsl	waitp	; yes, gobble last char
	
	lda	1,s
	ora	2,s
	bne	$done
	brl	lcmd	; go wait for more code.

$3:	cpx	##0xffff ; done ?
	bne	$4	 ; br if nop.
	lda	#0xff	 ; yes, set flag for beeper above.
	sta	1,s
$4:
	bsl	waitp	; get a byte
	sta	0,x	; store it
	inx		; incr pointer
	dey		; decr count
	bne	$4
	brl	$loop	; get next lmr or jus
$done:
	rep	#0x20
	pla
	plb
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Send a byte to the parallel interface.;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sendp:
	php
	rep	#0x20
;
; send the byte
;
	sta	>0,ParOut	; put the byte in parallel port.
				; set byte assembled flag for host.
	sta	>0,DevEnd
				; and pulse device end - interrupt host.

;
; wait for ack (any parallel byte from host)
;

$1:	lda	>0,PolDev-1	; data avail  (bit 15) ?
	bpl	$1		; no

	lda	>0,ParIn	; Get status bits in high byte of acc
	bit	##0x0200	; no intr?
	bne	$2		; yes.. skip
	sta	>0,DevEnd	; pulse device end
$2:
	plp
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Read one byte from the parallel interface.	;
; Generate device end if bit 2 of the high	;
; byte of the parallel data is non-zero.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

waitp:
	php
	rep	#0x20		; 16 bit mem
$1:	lda	>0,PolDev-1	; data avail  (bit 15)?
	bpl	$1		; no

	lda	>0,ParIn	; Get status bits.
	bit	##0x0200	; no intr?
	bne	$2		; yes.. skip
	sta	>0,DevEnd	; pulse device end
$2:
	and	##0xff		; mask off status bits
	plp
	rts


	end
