;
; Initialize ACEs.  Keyboard setup doesn't change.
; Other asynchs are set up according to default
; parameters in eeprom.  If the setup routine 
; aceset returns an error, we assume the eeprom data
; was incorrect and call a routine to write the
; default default parameters to it and do the setup.
;

acerst
	php
	rep	#0x30
	pha
	phx
	phy
	phb
	
	sep	#0x30
$wait	bit	0xff1e		; wait for eeprom ready
	bpl	$wait

	phk
	plb
	
	per	$ac3		; set up keyboard from
	bsl	setdfmt		; data in prom.
	pla
	pla

	ldx	#EEP
	phx
	plb

	ldx	#0
	pea	##EEace0
	jsl	>0,AceSet	; set up mouse from eeprom data.
	bcc	$1		; br if no error.
	bsl	acedef		; do default setup from prom.
$1:
	ldx	#1
	pea	##EEace0+6
	jsl	>0,AceSet
	bcc	$2
	bsl	acedef
$2:
	ldx	#2
	pea	##EEace0+12
	jsl	>0,AceSet
	bcc	$3
	bsl	acedef
$3:

;
; Now the asynchs are set up and the 
; eeprom data is known to be good.
; Copy the eedata to ram.
; 
	ldx	#EEP
	phx
	plb
	ldx	#0
	txy
$loop:
	lda	EEace0,y
	sta	>0,Acedat,x
	inx
	iny
	cpy	#3*6
	bcc	$loop

	rep	#0x30
	plb
	ply
	plx
	pla
	plp
	rtl
$ac3
	dcb	0x30		; kbd ACE (Keytronics)
	dcb	384-256		; low byte DLL for 300 baud
	dcb	1		; high byte
	dcb	4+3		; no parity, 2 stop, 8 bits.
	dcb	0

;$ac0
;	dcb	0		; pad (Kurta)
;	dcb	6		; low byte DLL for 19200 baud
;	dcb	0		; high byte
;	dcb	8+4+2		; odd parity, 2 stop, 7 bits.
;	dcb	0		; no handshake.
;;$ac0
;;	dcb	0		; host ACE (AED 1024)
;;	dcb	12		; low byte DLL for 9600 baud
;;	dcb	0		; high byte
;;	dcb	4+3		; no parity, 2 stop, 8 bits.
;	dcb	0
;$ac1
;	dcb	0x10		; aux ACE (VT100)
;	dcb	6		; low byte DLL for 19200 baud
;	dcb	0		; high byte
;	dcb	4+2		; no parity, 2 stop, 7 bits.
;	dcb	0
;$ac2
;	dcb	0x20		; host ACE (VENIX)
;	dcb	12		; low byte DLL for 9600 baud
;	dcb	0		; high byte
;	dcb	4+3		; no parity, 2 stop, 8 bits.
;	dcb	'X'


setdfmt:
	php
	rep	#0x30
	pha
	phx
	phy
	sep	#0x30

	ldy	#0
	lda	(10,s),y		; Get ACE offset.
	tax				; Save for indexing.
	lda	#0
	sta	>ACE,MCR,x		; Disable ACE output during setup.
	lda	#128			; Get ready to set baud.
	sta	>ACE,LCR,x		; Select DL registers.
	iny				; Point to DLL value.
	lda	(10,s),y		; Fetch it.
	sta	>ACE,DLL,x		; Set low byte of DL.
	iny				; Point to DLH value.
	lda	(10,s),y		; Fetch it.
	sta	>ACE,DLH,x		; Set high byte DL.
	iny				; Point to next data byte.
	lda	(10,s),y		; Fetch it.
	sta	>ACE,LCR,x		; Deselect DL reg, set parity,
					; word length, # stop bits.
	lda	#8+2+1
	sta	>ACE,MCR,x		; enable output via OUT2,
					; turn on RTS and DTR.
	rep	#0x30
	ply
	plx
	pla
	plp
	rts	
		
		

	
;
; Init the qcb for ACE(0..3). 
; Inputs are ACE number (0..3) in acc, and a list of
; values for <iocntl, <iqsize and <oqsize.
; Pointer to the qcb must have already been
; stored at Qcbac0..3.  This routine initializes the qcb fields
; <aceoff,<iocntl,<icmask,<iqsize,<oqsize,<iqhigh,and <iqlow,
; acquires buffers of size iqsize and iqlow and points <iqptr, oqptr
; It also initializes the ACE IER register, so interrupts
; for the ACE should have been disabled in Iemask.
; Calling sequence :
;
; 	push pointer to data list (in current data bank)
;	lda	acenumber
;	jsl	>0,Qcbini
; 	bcs	error

qcbini:
			; data ptr	; 13,s
			;ret addr, bnk	; 10,s
	clc		;assume no error.
	php				; 9,s
	phd				; 7,s
	rep	#0x30
	pha				; 5,s
	phx				; 3,s
	phy				; 1,s

	and	##3			; Get ACE number.
	asl	a			; Make index into Qcbac0..3
	pha				; Save for later.
	tax
	lda	>0,Qcbac0,x		; Get pointer to qcb.
	bne	$ok			; 0 is bogus, just return.
	lda	>0,Inierr
	inc	a
	sta	>0,Inierr
	brl	$error

$ok:	tcd				; Make qcb direct page.
;
; Fill the qcb with nulls.
;
	tax				; Point x to first byte of qcb.
	tay				; Point y at second byte.
	iny
	stz	<0			; Put null in first byte.
	lda	##qcbsiz-2		; Get #bytes to move, -1 because
					; mvn moves acc + 1 bytes.
	phb				; Save dbr - mvn trashes it.
	mvn	>0,>0			; Zero fill qcb.
	plb				; Restore dbr.
	pla				; Get ACE number * 2.

;
; set up <aceidx = ace number * 2
;	 <aceoff = ace number * 16,
; 	 <intmsk = 0x10 << acenumber.
;
	sep	#0x30			; Set 8 bit mem/idx
	sta	<aceidx			; save ace # * 2.
	lsr	a			; get ace #.
	tax				; generate int ena mask.
	lda	#0x10			; assume ace 0.
	bra	$nxtmsk
$msk1:
	asl	a
$nxtmsk	dex
	bpl	$msk1
	sta	<intmsk

	lda	<aceidx		
	asl	a			; Convert to offset of
	asl	a			; ACE (ACE number * 16).
	asl	a
	sta	<aceoff			; Store in qcb.
;
; Copy callers data to qcb.
;
	ldy	#0			; Init index into callers
					; initialization data.
	lda	(13,s),y		; Get iocntl value.
	sta	<iocntl			; Store in qcb.
	iny				; Bump index into data.
	lda	(13,s),y		; Get input buffer size.
	sta	<iqsize			; Store in qcb.
	iny				
	lda	(13,s),y		; Get output buffer size.
	sta	<oqsize			; Store in qcb
;
; Acquire buffers of size <iqsize and <oqsize,
; put pointers to them at <iqptr and <oqptr.
;
	rep	#0x20
	lda	<iqsize
	and	##0xff
	beq	$chkout
	pha				; push buffer size needed.
	jsl	>0,GetHeap		; get buffer from heap.
	pla				; get pointer to buffer.
	bcc	$41
	lda	>0,Inierr
	inc	a
	sta	>0,Inierr
	brl	$error
$41:	sta	<iqptr			; save it.

$chkout
	lda	<oqsize
	and	##0xff
	beq	$hilow
	pha
	jsl	>0,GetHeap
	pla	
	bcc	$42
	lda	>0,Inierr
	inc	a
	sta	>0,Inierr
	brl	$error
$42:	sta	<oqptr
$hilow
	sep	#0x20
;
; Set <iqlow = <iqsiz/4, <iqhigh = <iqsize-<iqlow.
; Probably the high and low marks should be calculated
; from the q size and baud rate, but this will do for now.
;
	lda	<iqsize
	beq	$setier
	lsr	a
	lsr	a
	sta	<iqlow
	lda	<iqsize
	sec
	sbc	<iqlow
	sta	<iqhigh

$setier:
;
; Set up the ACE interrupt enable register (IER).
; If <iqsize <> 0, enable receiver int.
; If <oqsize <> 0, enable transmitter empty int.
; If bit 6 of <iocntl set, enable modem status int (for RTS/CTS).
; Always enable line status int.
; Also activate the modem controls DTR, RTS, and OUT2.
; Activating OUT2 enables output from the ACE, DTR and RTS
; are necessary if the hardware at the other end expects
; them, otherwise they are innocuous.
;

	lda	#4			; Enable line status intpt.
	ldx	<iqsize			; <iqsize = 0 ?
	beq	$11			; Br if yes.
	ora	#1			; Enable receiver intpt.
$11:
	ldx	<oqsize			; <oqsize = 0 ?
	beq	$12			; Br if yes.
	ora	#2			; Enable THRE intpt.
$12:
	bit	<iocntl			; RTS/CTS handshake ?
	bvc	$13			; Br if no.
	ora	#8			; Enable modem status intpt.
$13:

;
; The following song and dance is done in case we're programming
; an INS8250, instead of an 8250A.  The former has a problem
; with enabling THRE interrupt, the workaround for which is
; to wait for THRE, write the IER twice and read the IIR.
;
	ldx	<aceoff			; Get offset of this ACE.
	bit	#2			; Are we enabling THRE intpt?
	bne	$14			; Br if yes.
	sta	>ACE,IER,x		; No, this is easy.
	bra	$done			; Clean up stack and return.
$14:
	tay				; Save IER value.
$15:
	lda	>ACE,LSR,x		; Wait for THRE.
	bit	#THRE
	beq	$15
	tya				; Recover IER value.
	sta	>ACE,IER,x		; Write it to IER twice.
	sta	>ACE,IER,x
	lda	>ACE,IIR,x
$done:
;
; Find out how many data bits are used and
; put the appropriate mask value in <icmask
; for masking off unused high bits of input.
; The least 2 bits in the LCR encode word length -
; 0 = 5 bits, 1 = 6 bits, 2 = 7 bits, 3 = 8 bits.
;
	lda	>ACE,LCR,x
	and	#3
	tax
	lda	#0xf
;
; Start with mask for 4 bits, add x+1 bits to it.
;
$bits:	asl	a
	inc	a
	dex
	bpl	$bits
	sta	<icmask
	bra	$finis

$error:
	sep	#0x20
	lda	9,s
	ora	#1
	sta	9,s
;	
; Move stacked return address and psw up in memory
; to eliminate data pointer, fill in the gap with
; saved y (from top of stack), pop saved registers
; and return(long).
;


$finis:
	rep	#0x30
	lda	11,s		; Get ret addr hi, return bank.
	sta	13,s		; Put up where data pointer is.
	lda	9,s		; Get psw, ret addr low.
	sta	11,s		; Put up where addr high was.
	pla			; Get saved y (sp offsets reduce by 2).
	sta	7,s		; Put where psw was.
	plx			; Pop saved stuff and return.
	pla
	pld
	ply
	plp
	rtl			
			
	end
