/*
 * make a hierarchically organized color table
 *
 * al kossow (AED)
 * april 1984
 */

#include <stdio.h>

/*
 * some common full-intensity colors
 */

#define BLACK	r=0x00; g=0x00; b=0x00
#define RED	r=0xff; g=0x00; b=0x00
#define ORANGE	r=0xff; g=0x7f; b=0x00
#define GREEN	r=0x00; g=0xff; b=0x00
#define YELLOW	r=0xff; g=0xff; b=0x00
#define BLUE	r=0x00; g=0x00; b=0xff
#define PURPLE	r=0xff; g=0x00; b=0xff
#define CYAN	r=0x00; g=0xff; b=0xff
#define WHITE	r=0xff; g=0xff; b=0xff

#define DEFBG BLACK
#define PRI80 RED
#define PRI40 ORANGE
#define PRI20 GREEN
#define PRI10 YELLOW
#define PRI08 BLUE
#define PRI04 PURPLE
#define PRI02 CYAN
#define PRI01 WHITE

/*
 * A heirarchy will display 7 forground objects and a background
 * with the foreground objects hierarchically organized
 *
 * the absence of a bit will set the pixel to the next lowest bit
 * the lowest is the background color, which is programmable
 *
 * Sample hierarchy ... +-------+
 *                      |     +-------+
 *                      |  W  |     +-------+
 *                      |  H  |  C  |     +-------+
 *                      |  I  |  Y  |  P  |     +-------+
 *                      |  T  |  A  |  U  |  B  |     +-------+
 *                      |  E  |  N  |  R  |  L  |  Y  |     +-------+
 *                      |     |     |  P  |  U  |  E  |  G  |     +-------+
 *                      +-----|     |  L  |  E  |  L  |  R  |  O  |       |
 *                            +-----|  E  |     |  L  |  E  |  R  |   R   |
 *                                  +-----|     |  O  |  E  |  A  |   E   |
 *                                        +-----|  W  |  N  |  N  |   D   |
 *                                              +-----|     |  G  |       |
 *                                                    +-----|  E  |       |
 *                                                          +-----|       |
 *                                                                +-------+
 *          <----  priority
 *  +-------------------------------+
 *  | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | bit#
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *    |   |   |   |   |   |   |   |
 *    |   |   |   |   |   |   |   +-- white
 *    |   |   |   |   |   |   +------ cyan
 *    |   |   |   |   |   +---------- purple
 *    |   |   |   |   +-------------- blue
 *    |   |   |   +------------------ yellow
 *    |   |   +---------------------- green
 *    |   +-------------------------- orange
 *    +------------------------------ red
 */

struct clrt {
		char r;
		char g;
		char b;
	    }   clrt[256];


main(){
	register unsigned int i,r,g,b;

	printf("struct clrt clrt[] = {\n");

	i=0;
	DEFBG;
	printf("\t0x%02x, 0x%02x, 0x%02x,   /* 0000 0000     0 */\n",r,g,b);
	
	for (i=1; i<256; i++){
	 if(i&0x80){
	  PRI80;
	  goto doit;
	 }

	 if(i&0x40){
	  PRI40;
	  goto doit;
	 }

	 if(i&0x20){
	  PRI20;
	  goto doit;
	 }

	 if(i&0x10){
	  PRI10;
	  goto doit;
	 }

	 if(i&0x08){
	  PRI08;
	  goto doit;
	 }

	 if(i&0x04){
	  PRI04;
	  goto doit;
	 }

	 if(i&0x02){
	  PRI02;
	  goto doit;
	 }

	 PRI01;
doit:
	 printf("\t0x%02x, 0x%02x, 0x%02x,   /* %1d%1d%1d%1d %1d%1d%1d%1d  %4d */\n",
                r,g,b,
	        (i&0x80)>>7,(i&0x40)>>6,(i&0x20)>>5,
		(i&0x10)>>4,(i&0x08)>>3,(i&0x04)>>2,
		(i&0x02)>>1,i&0x01,
                i);
	}
	printf("\t00, 00, 00\n\t};\n");
}	 
                                                                                                                                                                                                                                       
