   \ZORAN\VM\CLEANUP.BAT                                                                                                     : CLEANUP.BAT: Delete files from parse/compile/vlink, except sources and .EXE
: Usage: CLEANUP name1 name2 name3 ...
: Last edit 3/1/86 JJC
echo off
cls

: Check for at least one parameter.
if %1x==x goto noparam
echo === CLEANUP: Delete files from creation of user simulator(s) =========

:----- BEGINNING OF NAME LOOP -----
:NAMELOOP
: If no more names, first parameter will now be null
if %1x==x goto END

: Check for source code file for this name:
: VSP...
if exist %1.ffp goto FOUNDSOURCE
: C...
if exist %1.c goto FOUNDSOURCE
: FORTRAN...
if exist %1.for goto FOUNDSOURCE
if exist %1.f goto FOUNDSOURCE
: Pascal...
if exist %1.pas goto FOUNDSOURCE
if exist %1.p goto FOUNDSOURCE
if exist %1.pf goto FOUNDSOURCE
: Assembler...
if exist %1.asm goto FOUNDSOURCE

: No source file found for this name
echo   
echo No source files found for '%1' -- no files deleted for this name.
goto NEXTNAME

:FOUNDSOURCE
: There is a source file for the current name.  Warn user before proceeding.
echo   
echo All '%1' files with extension .CK, .ERR, .LER, .LST, .MAP, .PH, .SUB
echo will be deleted.  Terminate (via CTRL-C) now, or
pause

: Delete the intermediate files for the current name (%1)
if exist %1.ck  del %1.ck  >nul:
if exist %1.err del %1.err >nul:
if exist %1.ler del %1.ler >nul:
if exist %1.lst del %1.lst >nul:
if exist %1.map del %1.map >nul:
if exist %1.ph  del %1.ph  >nul:
if exist %1.sub del %1.sub >nul:

: Shift command line parameters left to get next name, then go process it
:NEXTNAME
shift
goto NAMELOOP
:----- END OF NAME LOOP -----

:------------------ Error processing ----------------
:noparam
: User entered no parameter.
echo CLEANUP: Missing filename

:explain
echo   CLEANUP deletes intermediate files generated during the parse,
echo   C or FORTRAN compilation, and link of one or more user simulators.
echo   
echo   CLEANUP preserves the following files:
echo     * source files (.FFP, .C, .FOR, .PAS, .P, .PF, .ASM)
echo     * object files (.OBJ)
echo     * the multiple-module link file (.LNK)
echo     * the user simulator (.EXE)
echo   
echo   CLEANUP expects one or more names without extensions.  Examples:
echo   
echo     'CLEANUP TEST' deletes TEST.* except TEST.FFP and TEST.EXE.
echo     'CLEANUP TEST1 TEST2 TEST3' does the same for each of the 3 names.
echo   
echo   CLEANUP does nothing if it finds no source file for a name.

:END
