/*  File:       if.h


    Function:   When if-else statements result in more than one assignment to
                the same variable, combine these into a single minimized
                function.


    Example:    The main program statements

                    if (c1) x=a;
                    if (c2) x=b;

                are combined into

                    x = c1 & a | c2 & b;


    Omission:   If you don't include this header and your program has this kind
                of thing, a "Duplicate Function" error will occur when the
                signal specifications are mapped to the device.  Without this
                header, the above example remains as the two assignments:

                    x = a & c1;
                    x = b & c2;


    Method:     The main program statements

                    if (c1) x=a;
                    if (c2) x=b;

                are compiled to

                    _Dfunction _Minimize _If x=a & c1;
                    _Dfunction _Minimize _If x=b & c2;

                This attribute block combines the two functions into

                    _Dfunction _Minimize _if x=(a & c1) | (b & c2);


    Revision:   89.4.26  */


_Attribute _if;


_Attribute _If(_Any) {
if (_Var _if _Size==0)
    _Vref*=_If _if _Var;
  else {
    _Var _if _Value *= (_Var _if _Value) | (_Vref _Value);
    _Vref*=_Free _Var;
    }
} /* '_If' */
