/*  File:       tvector.h


    Function:   Test Vector Error Detection and Pin Mapping.


    Omission:   You need this header file if there are any test_vectors
                blocks in your program.


    Revision:   89.4.10 */





_Attribute _Vector+ {
/*      Assure that test condition variable (TCV) maps to a device pin
        and that each TCV appears only once in each test vector block.

        The Device Description Header has a function "_Pin pinNN = NN" for each
        valid pin number.  The compiler generates a function

                ... _Vposition _Vector+N TCV = ...

        for each test condition variable, where TCV is the name of the test
        condition variable and N is the identity of the block. */

if (_Final)
    if (_Vsignal _Vposition _Size!=0) {
        /* this is a TCV */
        if (_Pin _Vsignal _Size==0)
            _Exit "This test condition variable does not imply a device pin.";
        if (_Vposition _Attribute _Vsignal _Size > 1)
            _Exit "This test condition variable occurs more than once in "\
                    "the test vector block.";
        } /* TCV */
}





/*      The compiler applies attributes to TCVs which specify the test
        conditions applied.

                Attribute               Test Condition
                ---------               --------------

                _VtcC                   C or K
                _VtcD                   0 or 1
                _VtcT                   L or H
                _VtcZ                   Z
                _VtcS                   supervoltage */


/* The Device Description Header files apply attributes which specify
   the type of device pin: */

_Attribute _vti;        /* input                */
_Attribute _vto;        /* output               */
_Attribute _vtt;        /* tri-state output     */





_Attribute _VtcC {      /* C or K */
if (_Final) {
    _Vref*=_VtcC _Var;
    if (_Pin _Vsignal _Size!=0 && _Vsignal _vti _Size==0)
        _Exit "Warning: Test Condition CLOCK is applied to a pin which "\
                "is not described as an input.";
    }
}





_Attribute _VtcD {      /* 0 or 1 */
if (_Final) {
    _Vref*=_VtcD _Var;
    if (_Pin _Vsignal _Size!=0 && _Vsignal _vti _Size==0)
        _Exit "Warning: Test Condition DRIVE INPUT is applied to a pin "\
                "which is not described as an input.";
    }
}





_Attribute _VtcT {      /* L or H */
if (_Final) {
    _Vref*=_VtcT _Var;
    if (_Pin _Vsignal _Size!=0 && _Vsignal _vto _Size==0 &&
                                                _Vsignal _vtt _Size==0)
        _Exit "Warning: Test Condition TEST OUTPUT is applied to a pin "\
                "which is not described as an output.";
    }
}





_Attribute _VtcZ {      /* Z */
if (_Final) {
    _Vref*=_VtcZ _Var;
    if (_Pin _Vsignal _Size!=0 && _Vsignal _vtt _Size==0)
        _Exit "Warning: Test Condition HIGH IMPEDANCE is applied to a pin "\
                "which is not described as a tri-state output.";
    }
}





/* The Compiler generates a function

        _Device _Vburied = N;

    for each "load_internal" test vector, where N is the number of specified
    buried registers.  The Device Description Header files specify the number
    of buried registers in a device via a

        _Device _vburied = N; */

_Attribute _vburied(_Register);

_Attribute _Vburied(_Register) {
if (_Device _vburied _Size==0)
    _Text "Warning: This device is not described as having buried registers.";
  else
    if (_Value _Device _vburied != _Value _Device _Vburied)
        _Text "Warning: The number of registers in a 'load_internal' test "\
            "vector is not the same as the number of buried registers described "\
            "for the device.";
_Vref*=_Free _Var;
}
