/*************************************************************************/
/* string.h  v5.01                                                       */
/* Copyright (c) 1990 Texas Instruments Inc.                             */
/*************************************************************************/
#ifndef _STRING
#define _STRING
 
#ifndef NULL
#define NULL 0
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

char   *strcpy(char *_dest, const char *_src);
char   *strncpy(char *_to, const char *_from, size_t _n);
char   *strcat(char *_string1, const char *_string2);
char   *strncat(char *_to, const char *_from, size_t _n);
char   *strchr(const char *_string, int _c);
char   *strrchr(const char *_string, int _c);
int     strcmp(const char *_string1, const char *_string2);
int     strncmp(const char *_string1, const char *_string2, size_t _n);
size_t  strlen(const char *_string);

int     strcoll(const char *_string1, const char *_string2);
size_t  strxfrm(char *_to, const char *_from, size_t _n);
char   *strpbrk(const char *_string, const char *_chs);
size_t  strspn(const char *_string, const char *_chs);
size_t  strcspn(const char *_string, const char *_chs);
char   *strstr(const char *_string1, const char *_string2);
char   *strtok(char *_str1, const char *_str2);
char   *strerror(int _errno);

void   *memcpy(void *_s1, const void *_s2, size_t _n);
void   *memmove(void *_s1, const void *_s2, size_t _n);
int     memcmp(const void *_cs, const void *_ct, size_t _n);
void   *memchr(const void *_cs, int _c, size_t _n);
void   *memset(void *_mem, int _ch, size_t _n);

#endif
