/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                      TIGA DEMO FRAME                                     */
/*                                                                          */
/* Draw pen_lines emanating from the centre of the screen                   */
/*                                                                          */
/*    7/01/87...Original version written..................J. Van Aken       */
/*   10/10/88...Converted to TIGA.........................Graham Short      */
/*                                                                          */
/*--------------------------------------------------------------------------*/
#include "tigademo.h"
#include "colors.h"

void frame1()
{
    long  x, y;
    long  r, t;
    short fcolor, rshift;

    set_draw_origin(HRES>>1, VRES>>1);
    set_pensize(4, 3);
    
    rshift = (iscolor) ? 4 : 3;
    fcolor = 0;
    for (r = 20; r < (VRES>>1); r += r >> rshift)
    {
        x = 0;
        y = -r << 16;
        for (t = 0; t < 201; ++t)
        {
            set_phys_fcolor(phys_color[fcolor]);
            c_pen_line(x-(x>>2)>>16, y-(y>>2)>>16, x>>16, y>>16);
            if (++fcolor == max_colors)
                fcolor = 0;

            x -= y >> 5;
            y += x >> 5;
        }
    }

    set_draw_origin(0, 0);
}
