/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                      TIGA DEMO SUPPORT                                   */
/*                                                                          */
/* Draws a title box on the screen centring the text passed in the box      */
/*                                                                          */
/*   10/10/88...Original version written..................Graham Short      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Microsoft-c insert file */
#include <string.h>

#include <tiga.h>
#include <typedefs.h>
#include <extend.h>

#include "tigademo.h"
#include "colors.h"


void title(str)
char *str;
{
    set_phys_fcolor( TITLE_BACKGROUND );
    c_fill_rect(HRES, CHAR_HIGH*3, 0, 0);

    if( iscolor )
        set_fcolor( BORDER );

    draw_rect(HRES-1, (CHAR_HIGH*3)-1, 0, 0);
    draw_rect(HRES-7, (CHAR_HIGH*3)-7, 3, 3);

    if( iscolor )
        set_colors( TITLE, _BLACK );

    transp_on();
    text_out((HRES-text_width(str))>>1, CHAR_HIGH, str);
    transp_off();

    set_clip_rect (HRES, VRES-(CHAR_HIGH*3), 0, CHAR_HIGH*3);
}
