        .width    132

*----------------------------------------------------------------------
*                                    TIGA
*          Copyright (C) 1989-1990  Texas Instruments Incorporated.
*                            All Rights Reserved
*----------------------------------------------------------------------
*
*              SCENERY DATABASE FOR 3D FLY-THROUGH DEMO
*
*----------------------------------------------------------------------
* History:
*   03/29/89...Original version written.....................J. Van Aken
*----------------------------------------------------------------------

* Declare global variables defined in this module.
        .globl    _db3d               ;3D database structure

* Identifiers for leaf (terminal) and nonleaf (intermediate) nodes
ISLEAF  .set      (7<<5)              ;leaf node
NOTLEAF .set      0                   ;nonleaf node

* Define log2 scaling factors for database coordinates.
F0      .set      0                   ;
F2      .set      1                   ;
F3      .set      3                   ;
F5      .set      5                   ;
F6      .set      6                   ;

; Define bounding box test mode parameters.
POSPAD  .set      (2<<12)             ;pad bd box by positive amount
NEGPAD  .set      (3<<12)             ;pad bd box by negative amount
INBOX   .set      (2<<14)             ;return status if INside bd box
OUTBOX  .set      (3<<14)             ;return status if OUTside bd box

; Define size of terrain features.
HW      .set      2                   ;half width of road
VL      .set      2                   ;overlap where road sections meet

* Define drawcode control fields.
NIL     .set      0                   ;nil pointer value
EOD     .set      0                   ;end-of-data terminator code

* Define 16 colors in scenery palette.
EARTHGREEN .set   02222h              ;earth color
SKYBLUE .set      0BBBBh              ;sky color
SUNYELLOW .set    0EEEEh              ;sun color
RED1    .set      0DDDDh              ;light red
RED2    .set      05555h              ;
RED3    .set      01111h              ;dark red
BLUGRN1 .set      0AAAAh              ;light blue-green
BLUGRN2 .set      09999h              ;dark blue-green
BROWN1  .set      0CCCCh              ;beige
BROWN2  .set      04444h              ;
BROWN3  .set      06666h              ;dark brown
GRAY1   .set      0FFFFh              ;light gray
GRAY2   .set      07777h              ;
GRAY3   .set      03333h              ;
GRAY4   .set      08888h              ;
GRAY5   .set      00000h              ;dark gray


*----------------------------------------------------------------------
*
*   Define global variables for horizon colors and start coordinates
*
*----------------------------------------------------------------------
_db3d:
        .long     (DBEND-$)/8         ;length of database in bytes
        .long     NODE01-$            ;bit offset to root node of dbase
        .long     ((40<<F6)-(52<<F0))<<8  ;starting x coordinate (FIX8)
        .long     (-(22<<F6)-(24<<F0))<<8 ;starting y coordinate (FIX8)
        .long     0                       ;starting z coordinate (FIX8)

*----------------------------------------------------------------------
*
*         Define 16 colors in color palette (format = r,g,b,i)
*
*----------------------------------------------------------------------
        .byte   040h,040h,040h,000h   ;GRAY5         0
        .byte   090h,050h,030h,010h   ;RED3          1
        .byte   040h,060h,030h,020h   ;EARTH GREEN   2
        .byte   060h,060h,060h,030h   ;GRAY3         3
        .byte   080h,060h,040h,040h   ;BROWN2        4
        .byte   0A0h,060h,030h,050h   ;RED2          5
        .byte   070h,050h,030h,060h   ;BROWN3        6
        .byte   070h,070h,070h,070h   ;GRAY2         7
        .byte   050h,050h,050h,080h   ;GRAY4         8
        .byte   020h,080h,050h,090h   ;BLUGRN2       9
        .byte   040h,090h,060h,0A0h   ;BLUGRN1      10
        .byte   040h,060h,0F0h,0B0h   ;SKY BLUE     11
        .byte   090h,070h,050h,0C0h   ;BROWN1       12
        .byte   0B0h,070h,040h,0D0h   ;RED1         13
        .byte   0F0h,0D0h,040h,0E0h   ;SUN YELLOW   14
        .byte   080h,080h,080h,0F0h   ;GRAY1        15

*----------------------------------------------------------------------
*
*             Define 16 4x8 monochrome intensity patterns
*                    for 1-bit-per-pixel displays.
*
*----------------------------------------------------------------------
        .byte     000h,055h,000h,055h    ;GRAY5         0
        .byte     0AAh,0DDh,0AAh,0FFh    ;RED3          1
        .byte     0EEh,0FFh,0BBh,0FFh    ;EARTH GREEN   2
        .byte     088h,055h,022h,055h    ;GRAY3         3
        .byte     000h,044h,000h,011h    ;BROWN2        4
        .byte     0AAh,0FFh,0AAh,0FFh    ;RED2          5
        .byte     000h,000h,000h,011h    ;BROWN3        6
        .byte     088h,055h,0AAh,055h    ;GRAY2         7
        .byte     000h,055h,022h,055h    ;GRAY4         8
        .byte     0AAh,0DDh,0AAh,077h    ;BLUGRN2       9
        .byte     0AAh,055h,0AAh,077h    ;BLUGRN1      10
        .byte     0EEh,0FFh,0FFh,0FFh    ;SKY BLUE     11
        .byte     000h,044h,000h,055h    ;BROWN1       12
        .byte     0AAh,0FFh,0BBh,0FFh    ;RED1         13
        .byte     0FFh,0FFh,0FFh,0FFh    ;SUN YELLOW   14
        .byte     0AAh,055h,0AAh,055h    ;GRAY1        15

*----------------------------------------------------------------------
*
*        Pointers to bouncing ball object data and bounding box
*
*----------------------------------------------------------------------
        .long     MYOBJ-$             ;bouncing cube object data
        .long     MYBBOX-$            ;bouncing cube bounding box

*----------------------------------------------------------------------
*
*    Hierarchical 3D object model database organized as binary tree
*
*----------------------------------------------------------------------
        .string   "* begin database *" ;mark start of 3D database

*----------------------------------------------------------------------
*                   Node 01 in Graphics Object Tree
*----------------------------------------------------------------------

NODE01:

*---- bounding sphere radius and log2(scale factor)
        .byte     70,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE02-$            ;left son of this node
        .byte     32,0,0,F6           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE03-$            ;right son of this node
        .byte     -8,16,0,F6          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 02 in Graphics Object Tree
*----------------------------------------------------------------------

NODE02:

*---- bounding sphere radius and log2(scale factor)
        .byte     52,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE04-$            ;left son of this node
        .byte     0,16,0,F6           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE05-$            ;right son of this node
        .byte     0,-16,0,F6          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 03 in Graphics Object Tree
*----------------------------------------------------------------------

NODE03:

*---- bounding sphere radius and log2(scale factor)
        .byte     52,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE06-$            ;left son of this node
        .byte     0,8,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF07-$            ;right son of this node
        .byte     0,-8,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 04 in Graphics Object Tree
*----------------------------------------------------------------------

NODE04:

*---- bounding sphere radius and log2(scale factor)
        .byte     52,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE08-$            ;left son of this node
        .byte     16,0,0,F6           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE09-$            ;right son of this node
        .byte     -16,0,0,F6          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 05 in Graphics Object Tree
*----------------------------------------------------------------------

NODE05:

*---- bounding sphere radius and log2(scale factor)
        .byte     52,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE10-$            ;left son of this node
        .byte     16,0,0,F6           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE11-$            ;right son of this node
        .byte     -16,0,0,F6          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 06 in Graphics Object Tree
*----------------------------------------------------------------------

NODE06:

*---- bounding sphere radius and log2(scale factor)
        .byte     52,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF12-$            ;left son of this node
        .byte     1,8,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF13-$            ;right son of this node
        .byte     0,-3,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 08 in Graphics Object Tree
*----------------------------------------------------------------------

NODE08:

*---- bounding sphere radius and log2(scale factor)
        .byte     29,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE16-$            ;left son of this node
        .byte     0,8,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE17-$            ;right son of this node
        .byte     0,-8,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 09 in Graphics Object Tree
*----------------------------------------------------------------------

NODE09:

*---- bounding sphere radius and log2(scale factor)
        .byte     29,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE18-$            ;left son of this node
        .byte     0,8,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF19-$            ;right son of this node
        .byte     -12,-8,0,F6         ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 10 in Graphics Object Tree
*----------------------------------------------------------------------

NODE10:

*---- bounding sphere radius and log2(scale factor)
        .byte     29,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE20-$            ;left son of this node
        .byte     0,8,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE21-$            ;right son of this node
        .byte     0,-8,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 11 in Graphics Object Tree
*----------------------------------------------------------------------

NODE11:

*---- bounding sphere radius and log2(scale factor)
        .byte     29,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE22-$            ;left son of this node
        .byte     0,8,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF23-$            ;right son of this node
        .byte     0,-8,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 16 in Graphics Object Tree
*----------------------------------------------------------------------

NODE16:

*---- bounding sphere radius and log2(scale factor)
        .byte     23,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE32-$            ;left son of this node
        .byte     8,0,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE33-$            ;right son of this node
        .byte     -8,0,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 17 in Graphics Object Tree
*----------------------------------------------------------------------

NODE17:

*---- bounding sphere radius and log2(scale factor)
        .byte     23,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE34-$            ;left son of this node
        .byte     8,0,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     MYLEAF-$            ;right son of this node
        .byte     -8,0,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 18 in Graphics Object Tree
*----------------------------------------------------------------------

NODE18:

*---- bounding sphere radius and log2(scale factor)
        .byte     23,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE36-$            ;left son of this node
        .byte     8,0,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE37-$            ;right son of this node
        .byte     -8,0,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 20 in Graphics Object Tree
*----------------------------------------------------------------------

NODE20:

*---- bounding sphere radius and log2(scale factor)
        .byte     23,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF40-$            ;left son of this node
        .byte     8,0,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF41-$            ;right son of this node
        .byte     -8,0,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 21 in Graphics Object Tree
*----------------------------------------------------------------------

NODE21:

*---- bounding sphere radius and log2(scale factor)
        .byte     23,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF42-$            ;left son of this node
        .byte     8,0,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE43-$            ;right son of this node
        .byte     -8,0,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 22 in Graphics Object Tree
*----------------------------------------------------------------------

NODE22:

*---- bounding sphere radius and log2(scale factor)
        .byte     23,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE44-$            ;left son of this node
        .byte     8,-2,0,F6           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF45-$            ;right son of this node
        .byte     -8,0,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 32 in Graphics Object Tree
*----------------------------------------------------------------------

NODE32:

*---- bounding sphere radius and log2(scale factor)
        .byte     18,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF64-$            ;left son of this node
        .byte     0,8,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF65-$            ;right son of this node
        .byte     -5,-4,0,F6          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 33 in Graphics Object Tree
*----------------------------------------------------------------------

NODE33:

*---- bounding sphere radius and log2(scale factor)
        .byte     18,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF66-$            ;left son of this node
        .byte     0,14,0,F6           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF67-$            ;right son of this node
        .byte     2,-4,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 34 in Graphics Object Tree
*----------------------------------------------------------------------

NODE34:

*---- bounding sphere radius and log2(scale factor)
        .byte     18,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF68-$            ;left son of this node
        .byte     1,5,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE69-$            ;right son of this node
        .byte     -4,-4,0,F6          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 36 in Graphics Object Tree
*----------------------------------------------------------------------

NODE36:

*---- bounding sphere radius and log2(scale factor)
        .byte     18,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF72-$            ;left son of this node
        .byte     -2,9,0,F6           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF73-$            ;right son of this node
        .byte     -5,-1,0,F6          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 37 in Graphics Object Tree
*----------------------------------------------------------------------

NODE37:

*---- bounding sphere radius and log2(scale factor)
        .byte     18,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE74-$            ;left son of this node
        .byte     0,8,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF75-$            ;right son of this node
        .byte     0,-2,0,F6           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 43 in Graphics Object Tree
*----------------------------------------------------------------------

NODE43:

*---- bounding sphere radius and log2(scale factor)
        .byte     18,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE86-$            ;left son of this node
        .byte     0,4,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF87-$            ;right son of this node
        .byte     0,-12,0,F6          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 44 in Graphics Object Tree
*----------------------------------------------------------------------

NODE44:

*---- bounding sphere radius and log2(scale factor)
        .byte     18,F6               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE88-$            ;left son of this node
        .byte     0,5,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF89-$            ;right son of this node
        .byte     0,-5,0,F5           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 69 in Graphics Object Tree
*----------------------------------------------------------------------

NODE69:

*---- bounding sphere radius and log2(scale factor)
        .byte     66,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF138-$           ;left son of this node
        .byte     14,16,0,F3          ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF139-$           ;right son of this node
        .byte     18,-16,0,F3         ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 74 in Graphics Object Tree
*----------------------------------------------------------------------

NODE74:

*---- bounding sphere radius and log2(scale factor)
        .byte     66,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF148-$           ;left son of this node
        .byte     0,5,0,F6            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF149-$           ;right son of this node
        .byte     -2,-5,0,F6          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 88 in Graphics Object Tree
*----------------------------------------------------------------------

NODE88:

*---- bounding sphere radius and log2(scale factor)
        .byte     66,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE176-$           ;left son of this node
        .byte     32,0,0,F3           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE177-$           ;right son of this node
        .byte     -32,0,0,F3          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 176 in Graphics Object Tree
*----------------------------------------------------------------------

NODE176:

*---- bounding sphere radius and log2(scale factor)
        .byte     63,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE352-$           ;left son of this node
        .byte     0,16,0,F3           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE353-$           ;right son of this node
        .byte     0,-16,0,F3          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 177 in Graphics Object Tree
*----------------------------------------------------------------------

NODE177:

*---- bounding sphere radius and log2(scale factor)
        .byte     63,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE354-$           ;left son of this node
        .byte     0,16,0,F3           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE355-$           ;right son of this node
        .byte     0,-16,0,F3          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 352 in Graphics Object Tree
*----------------------------------------------------------------------

NODE352:

*---- bounding sphere radius and log2(scale factor)
        .byte     54,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF704-$           ;left son of this node
        .byte     16,-7,0,F3          ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE705-$           ;right son of this node
        .byte     -16,0,0,F3          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 353 in Graphics Object Tree
*----------------------------------------------------------------------

NODE353:

*---- bounding sphere radius and log2(scale factor)
        .byte     54,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF706-$           ;left son of this node
        .byte     13,3,0,F3           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE707-$           ;right son of this node
        .byte     -16,0,0,F3          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 354 in Graphics Object Tree
*----------------------------------------------------------------------

NODE354:

*---- bounding sphere radius and log2(scale factor)
        .byte     54,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE708-$           ;left son of this node
        .byte     16,0,0,F3           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF709-$           ;right son of this node
        .byte     -9,-11,0,F3         ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 355 in Graphics Object Tree
*----------------------------------------------------------------------

NODE355:

*---- bounding sphere radius and log2(scale factor)
        .byte     54,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE710-$           ;left son of this node
        .byte     16,0,0,F3           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF711-$           ;right son of this node
        .byte     -16,6,0,F3          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 705 in Graphics Object Tree
*----------------------------------------------------------------------

NODE705:

*---- bounding sphere radius and log2(scale factor)
        .byte     40,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF1410-$          ;left son of this node
        .byte     -4,11,0,F3          ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF1411-$          ;right son of this node
        .byte     1,-8,0,F3           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 707 in Graphics Object Tree
*----------------------------------------------------------------------

NODE707:

*---- bounding sphere radius and log2(scale factor)
        .byte     40,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF1414-$          ;left son of this node
        .byte     0,6,0,F3            ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF1415-$          ;right son of this node
        .byte     -7,-10,0,F3         ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 708 in Graphics Object Tree
*----------------------------------------------------------------------

NODE708:

*---- bounding sphere radius and log2(scale factor)
        .byte     40,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF1416-$          ;left son of this node
        .byte     4,10,0,F3           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF1417-$          ;right son of this node
        .byte     0,-9,0,F3           ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 710 in Graphics Object Tree
*----------------------------------------------------------------------

NODE710:

*---- bounding sphere radius and log2(scale factor)
        .byte     40,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF1420-$          ;left son of this node
        .byte     -4,5,0,F3           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF1421-$          ;right son of this node
        .byte     7,-14,0,F3          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


;---- beginning of object model database ----

*----------------------------------------------------------------------
*                   Graphics Object Model:  Mountain
*----------------------------------------------------------------------

LEAF07:

*---- size of bounding sphere in object space
        .byte     80,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     4                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     0,0,32,F3           ;xyz coordinates for vertex 0
        .byte     -16,64,0,F3         ;xyz coordinates for vertex 1
        .byte     64,0,0,F3           ;xyz coordinates for vertex 2
        .byte     -48,-64,0,F3        ;xyz coordinates for vertex 3

*---- face 0 of object (east slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     0,1,2               ;CW-ordered list of vertices

*---- face 1 of object (south slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     0,2,3               ;CW-ordered list of vertices

*---- face 2 of object (west slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     0,3,1               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*                   Graphics Object Model:  Mountain
*----------------------------------------------------------------------

LEAF12:

*---- size of bounding sphere in object space
        .byte     83,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     5                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     0,0,32,F3           ;xyz coordinates for vertex 0
        .byte     -24,32,0,F3         ;xyz coordinates for vertex 1
        .byte     48,48,0,F3          ;xyz coordinates for vertex 2
        .byte     32,-32,0,F3         ;xyz coordinates for vertex 3
        .byte     -56,-64,0,F3        ;xyz coordinates for vertex 4

*---- face 0 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     0,1,2               ;CW-ordered list of vertices

*---- face 1 of object (east slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     0,2,3               ;CW-ordered list of vertices

*---- face 2 of object (south slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     0,3,4               ;CW-ordered list of vertices

*---- face 3 of object (west slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     0,4,1               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*                   Graphics Object Model:  Mountain
*----------------------------------------------------------------------

LEAF13:

*---- size of bounding sphere in object space
        .byte     70,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     4                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     0,0,24,F3           ;xyz coordinates for vertex 0
        .byte     -64,24,0,F3         ;xyz coordinates for vertex 1
        .byte     48,24,0,F3          ;xyz coordinates for vertex 2
        .byte     32,-40,0,F3         ;xyz coordinates for vertex 3

*---- face 0 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     0,1,2               ;CW-ordered list of vertices

*---- face 1 of object (SE slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     0,2,3               ;CW-ordered list of vertices

*---- face 2 of object (SW slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     0,3,1               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*             Graphics Object Model:  Road and Pine Trees
*----------------------------------------------------------------------

LEAF19:

*---- size of bounding sphere in object space
        .byte     72,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     30                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; two strips of road
        .byte     -16+HW,64+VL,0,F3   ;xyz coordinates for vertex 0
        .byte     -16+HW,0,0,F3       ;xyz coordinates for vertex 1
        .byte     16+HW,-64-VL/2,0,F3 ;xyz coordinates for vertex 2
        .byte     16-HW,-64,0,F3      ;xyz coordinates for vertex 3
        .byte     -16-HW,0,0,F3       ;xyz coordinates for vertex 4
        .byte     -16-HW,64,0,F3      ;xyz coordinates for vertex 5
; 1st tetrahedral pine tree
        .byte     -28,60,8,F3         ;xyz coordinates for vertex 6
        .byte     -28,60+3,0,F3       ;xyz coordinates for vertex 7
        .byte     -28+2,60-1,0,F3     ;xyz coordinates for vertex 8
        .byte     -28-2,60-1,0,F3     ;xyz coordinates for vertex 9
; 2nd tetrahedral pine tree
        .byte     -22,44,9,F3         ;xyz coordinates for vertex 10
        .byte     -22,44+3,0,F3       ;xyz coordinates for vertex 11
        .byte     -22+2,44-1,0,F3     ;xyz coordinates for vertex 12
        .byte     -22-2,44-1,0,F3     ;xyz coordinates for vertex 13
; 3rd tetrahedral pine tree
        .byte     -9,24,7,F3          ;xyz coordinates for vertex 14
        .byte     -9,24+3,0,F3        ;xyz coordinates for vertex 15
        .byte     -9+2,24-1,0,F3      ;xyz coordinates for vertex 16
        .byte     -9-2,24-1,0,F3      ;xyz coordinates for vertex 17
; 4th tetrahedral pine tree
        .byte     -26,0,9,F3          ;xyz coordinates for vertex 18
        .byte     -26,0+3,0,F3        ;xyz coordinates for vertex 19
        .byte     -26+2,0-1,0,F3      ;xyz coordinates for vertex 20
        .byte     -26-2,0-1,0,F3      ;xyz coordinates for vertex 21
; 5th tetrahedral pine tree
        .byte     -16,-48,7,F3        ;xyz coordinates for vertex 22
        .byte     -16,-48+3,0,F3      ;xyz coordinates for vertex 23
        .byte     -16+2,-48-1,0,F3    ;xyz coordinates for vertex 24
        .byte     -16-2,-48-1,0,F3    ;xyz coordinates for vertex 25
; 6th tetrahedral pine tree
        .byte     16,-46,7,F3         ;xyz coordinates for vertex 22
        .byte     16,-46+3,0,F3       ;xyz coordinates for vertex 23
        .byte     16+2,-46-1,0,F3     ;xyz coordinates for vertex 24
        .byte     16-2,-46-1,0,F3     ;xyz coordinates for vertex 25

*---- face 0 of object (west road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,4,5             ;CW-ordered list of vertices

*---- face 1 of object (east road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     1,2,3,4             ;CW-ordered list of vertices

*---- face 2 of object (NE face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     6,7,8               ;CW-ordered list of vertices

*---- face 3 of object (south face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     6,8,9               ;CW-ordered list of vertices

*---- face 4 of object (NW face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     6,9,7               ;CW-ordered list of vertices

*---- face 5 of object (NE face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     10,11,12            ;CW-ordered list of vertices

*---- face 6 of object (south face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     10,12,13            ;CW-ordered list of vertices

*---- face 7 of object (NW face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     10,13,11            ;CW-ordered list of vertices

*---- face 8 of object (NE face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     14,15,16            ;CW-ordered list of vertices

*---- face 9 of object (south face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     14,16,17            ;CW-ordered list of vertices

*---- face 10 of object (NW face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     14,17,15            ;CW-ordered list of vertices

*---- face 11 of object (NE face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     18,19,20            ;CW-ordered list of vertices

*---- face 12 of object (south face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     18,20,21            ;CW-ordered list of vertices

*---- face 13 of object (NW face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     18,21,19            ;CW-ordered list of vertices

*---- face 14 of object (NE face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     22,23,24            ;CW-ordered list of vertices

*---- face 15 of object (south face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     22,24,25            ;CW-ordered list of vertices

*---- face 16 of object (NW face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     22,25,23            ;CW-ordered list of vertices

*---- face 17 of object (NE face of 6th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     26,27,28            ;CW-ordered list of vertices

*---- face 18 of object (south face of 6th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     26,28,29            ;CW-ordered list of vertices

*---- face 19 of object (NW face of 6th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     26,29,27            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*                   Graphics Object Model:  Mountain
*----------------------------------------------------------------------

LEAF23:

*---- size of bounding sphere in object space
        .byte     127,F3|ISLEAF       ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     4                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     0,0,32,F3           ;xyz coordinates for vertex 0
        .byte     16,64,0,F3          ;xyz coordinates for vertex 1
        .byte     112,-64,0,F3        ;xyz coordinates for vertex 2
        .byte     -112,-32,0,F3       ;xyz coordinates for vertex 3

*---- face 0 of object (NE slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     0,1,2               ;CW-ordered list of vertices

*---- face 1 of object (south slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     0,2,3               ;CW-ordered list of vertices

*---- face 2 of object (NW slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     0,3,1               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*              Graphics Object Model:  Mountain and Road
*----------------------------------------------------------------------

LEAF40:

*---- size of bounding sphere in object space
        .byte     80,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     9                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     -64,HW,0,F3         ;xyz coordinates for vertex 0
        .byte     -32-HW,64,0,F3      ;xyz coordinates for vertex 1
        .byte     -32+HW,64,0,F3      ;xyz coordinates for vertex 2
        .byte     -64,-HW,0,F3        ;xyz coordinates for vertex 3
; pyramidal mountain
        .byte     16,-16,20,F3        ;xyz coordinates for vertex 4
        .byte     32,48,0,F3          ;xyz coordinates for vertex 5
        .byte     48,-64,0,F3         ;xyz coordinates for vertex 6
        .byte     -32,-32,0,F3        ;xyz coordinates for vertex 7
        .byte     -40,8,0,F3          ;xyz coordinates for vertex 8

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (north face of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     4,5,6               ;CW-ordered list of vertices

*---- face 2 of object (east face of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     4,6,7               ;CW-ordered list of vertices

*---- face 3 of object (south face of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     4,7,8               ;CW-ordered list of vertices

*---- face 4 of object (west face of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     4,8,5               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*             Graphics Object Model:  Road and Pine Trees
*----------------------------------------------------------------------

LEAF41:

*---- size of bounding sphere in object space
        .byte     75,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     30                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     -64,24,0,F3         ;xyz coordinates for vertex 0
        .byte     -32,19+HW,0,F3      ;xyz coordinates for vertex 1
        .byte     8,-16+HW,0,F3       ;xyz coordinates for vertex 2
        .byte     40,-16+HW,0,F3      ;xyz coordinates for vertex 3
        .byte     64,HW,0,F3          ;xyz coordinates for vertex 4
        .byte     64,-HW,0,F3         ;xyz coordinates for vertex 5
        .byte     40,-16-HW,0,F3      ;xyz coordinates for vertex 6
        .byte     8,-16-HW,0,F3       ;xyz coordinates for vertex 7
        .byte     -32,19-HW,0,F3      ;xyz coordinates for vertex 8
        .byte     -64,24-2*HW,0,F3    ;xyz coordinates for vertex 9
; 1st tetrahedral pine tree
        .byte     -32,32,8,F3         ;xyz coordinates for vertex 10
        .byte     -32,32+3,0,F3       ;xyz coordinates for vertex 11
        .byte     -32+2,32-1,0,F3     ;xyz coordinates for vertex 12
        .byte     -32-2,32-1,0,F3     ;xyz coordinates for vertex 13
; 2nd tetrahedral pine tree
        .byte     -16,16,8,F3         ;xyz coordinates for vertex 14
        .byte     -16,16+3,0,F3       ;xyz coordinates for vertex 15
        .byte     -16+2,16-1,0,F3     ;xyz coordinates for vertex 16
        .byte     -16-2,16-1,0,F3     ;xyz coordinates for vertex 17
; 3rd tetrahedral pine tree
        .byte     16,-32,8,F3         ;xyz coordinates for vertex 18
        .byte     16,-32+3,0,F3       ;xyz coordinates for vertex 19
        .byte     16+2,-32-1,0,F3     ;xyz coordinates for vertex 20
        .byte     16-2,-32-1,0,F3     ;xyz coordinates for vertex 21
; 4th tetrahedral pine tree
        .byte     40,-40,8,F3         ;xyz coordinates for vertex 22
        .byte     40,-40+3,0,F3       ;xyz coordinates for vertex 23
        .byte     40+2,-40-1,0,F3     ;xyz coordinates for vertex 24
        .byte     40-2,-40-1,0,F3     ;xyz coordinates for vertex 25
; 5th tetrahedral pine tree
        .byte     58,-16,8,F3         ;xyz coordinates for vertex 26
        .byte     58,-16+3,0,F3       ;xyz coordinates for vertex 27
        .byte     58+2,-16-1,0,F3     ;xyz coordinates for vertex 28
        .byte     58-2,-16-1,0,F3     ;xyz coordinates for vertex 29

*---- face 0 of object (far west strip of road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,8,9             ;CW-ordered list of vertices

*---- face 1 of object (near west strip of road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     1,2,7,8             ;CW-ordered list of vertices

*---- face 2 of object (near east strip of road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     2,3,6,7             ;CW-ordered list of vertices

*---- face 3 of object (far east strip of road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     3,4,5,6             ;CW-ordered list of vertices

*---- face 4 of object (NE face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     10,11,12            ;CW-ordered list of vertices

*---- face 5 of object (south face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     10,12,13            ;CW-ordered list of vertices

*---- face 6 of object (NW face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     10,13,11            ;CW-ordered list of vertices

*---- face 7 of object (NE face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     14,15,16            ;CW-ordered list of vertices

*---- face 8 of object (south face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     14,16,17            ;CW-ordered list of vertices

*---- face 9 of object (NW face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     14,17,15            ;CW-ordered list of vertices

*---- face 10 of object (NE face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     18,19,20            ;CW-ordered list of vertices

*---- face 11 of object (south face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     18,20,21            ;CW-ordered list of vertices

*---- face 12 of object (NW face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     18,21,19            ;CW-ordered list of vertices

*---- face 13 of object (NE face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     22,23,24            ;CW-ordered list of vertices

*---- face 14 of object (south face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     22,24,25            ;CW-ordered list of vertices

*---- face 15 of object (NW face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     22,25,23            ;CW-ordered list of vertices

*---- face 16 of object (NE face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     26,27,28            ;CW-ordered list of vertices

*---- face 17 of object (south face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     26,28,29            ;CW-ordered list of vertices

*---- face 18 of object (NW face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     26,29,27            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*                   Graphics Object Model:  Mountain
*----------------------------------------------------------------------

LEAF42:

*---- size of bounding sphere in object space
        .byte     117,F3|ISLEAF       ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     6                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     0,0,30,F3           ;xyz coordinates for vertex 0
        .byte     -16,48,0,F3         ;xyz coordinates for vertex 1
        .byte     32,64,0,F3          ;xyz coordinates for vertex 2
        .byte     48,-48,0,F3         ;xyz coordinates for vertex 3
        .byte     -64,-96,0,F3        ;xyz coordinates for vertex 4
        .byte     -48,16,0,F3         ;xyz coordinates for vertex 5

*---- face 0 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     0,1,2               ;CW-ordered list of vertices

*---- face 1 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     0,2,3               ;CW-ordered list of vertices

*---- face 2 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     0,3,4               ;CW-ordered list of vertices

*---- face 3 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     0,4,5               ;CW-ordered list of vertices

*---- face 4 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     0,5,1               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*              Graphics Object Model:  Mountain and Road
*----------------------------------------------------------------------

LEAF45:

*---- size of bounding sphere in object space
        .byte     75,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     9                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     -16+HW-VL,64+VL/2,0,F3 ;xyz coordinates for vertex 0
        .byte     64,24,0,F3          ;xyz coordinates for vertex 1
        .byte     64,24-2*HW,0,F3     ;xyz coordinates for vertex 2
        .byte     -16-HW,64,0,F3      ;xyz coordinates for vertex 3
; pyramidal mountain
        .byte     -24,24,20,F3        ;xyz coordinates for vertex 4
        .byte     -40,64,0,F3         ;xyz coordinates for vertex 5
        .byte     0,48,0,F3           ;xyz coordinates for vertex 6
        .byte     32,0,0,F3           ;xyz coordinates for vertex 7
        .byte     -64,0,0,F3          ;xyz coordinates for vertex 8

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (north face of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     4,5,6               ;CW-ordered list of vertices

*---- face 2 of object (east face of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     4,6,7               ;CW-ordered list of vertices

*---- face 3 of object (south face of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     4,7,8               ;CW-ordered list of vertices

*---- face 4 of object (west face of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     4,8,5               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*              Graphics Object Model:  Mountain and Road
*----------------------------------------------------------------------

LEAF64:

*---- size of bounding sphere in object space
        .byte     92,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; two sections of highway
        .byte     -64,32+HW,0,F3      ;xyz coordinates for vertex 0
        .byte     -32+HW,-16,0,F3     ;xyz coordinates for vertex 1
        .byte     -32+HW,-64,0,F3     ;xyz coordinates for vertex 2
        .byte     -32-HW,-64-VL,0,F3  ;xyz coordinates for vertex 3
        .byte     -32-HW,-16,0,F3     ;xyz coordinates for vertex 4
        .byte     -64-VL,32-HW,0,F3   ;xyz coordinates for vertex 5
; 5-sided mountain
        .byte     0,0,32,F3           ;xyz coordinates for vertex 6
        .byte     -64,64,0,F3         ;xyz coordinates for vertex 7
        .byte     48,48,0,F3          ;xyz coordinates for vertex 8
        .byte     48,-64,0,F3         ;xyz coordinates for vertex 9
        .byte     -16,-16,0,F3        ;xyz coordinates for vertex 10
        .byte     -48,24,0,F3         ;xyz coordinates for vertex 11

*---- face 0 of object (north section of highway)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,4,5             ;CW-ordered list of vertices

*---- face 1 of object (south section of highway)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     1,2,3,4             ;CW-ordered list of vertices

*---- face 2 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     6,7,8               ;CW-ordered list of vertices

*---- face 3 of object (east slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     6,8,9               ;CW-ordered list of vertices

*---- face 4 of object (south slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     6,9,10              ;CW-ordered list of vertices

*---- face 5 of object (SW slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     6,10,11             ;CW-ordered list of vertices

*---- face 6 of object (west slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     6,11,7              ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*             Graphics Object Model:  Road and Pine Trees
*----------------------------------------------------------------------

LEAF65:

*---- size of bounding sphere in object space
        .byte     35,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     16                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     8+HW,32,0,F3        ;xyz coordinates for vertex 0
        .byte     -8+HW,-32-VL,0,F3   ;xyz coordinates for vertex 1
        .byte     -8-HW,-32,0,F3      ;xyz coordinates for vertex 2
        .byte     8-HW,32+VL,0,F3     ;xyz coordinates for vertex 3
; 1st tetrahedral pine tree
        .byte     8,8,8,F3            ;xyz coordinates for vertex 4
        .byte     8,8+3,0,F3          ;xyz coordinates for vertex 5
        .byte     8+2,8-1,0,F3        ;xyz coordinates for vertex 6
        .byte     8-2,8-1,0,F3        ;xyz coordinates for vertex 7
; 2nd tetrahedral pine tree
        .byte     -11,0,9,F3          ;xyz coordinates for vertex 8
        .byte     -11,0+3,0,F3        ;xyz coordinates for vertex 9
        .byte     -11+2,-1,0,F3       ;xyz coordinates for vertex 10
        .byte     -11-2,-1,0,F3       ;xyz coordinates for vertex 11
; 3rd tetrahedral pine tree
        .byte     2,-19,7,F3          ;xyz coordinates for vertex 12
        .byte     2,-19+3,0,F3        ;xyz coordinates for vertex 13
        .byte     2+2,-19-1,0,F3      ;xyz coordinates for vertex 14
        .byte     2-2,-19-1,0,F3      ;xyz coordinates for vertex 15

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (NE face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,5,6               ;CW-ordered list of vertices

*---- face 2 of object (south face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,6,7               ;CW-ordered list of vertices

*---- face 3 of object (NW face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,7,5               ;CW-ordered list of vertices

*---- face 4 of object (NE face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,9,10              ;CW-ordered list of vertices

*---- face 5 of object (south face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,10,11             ;CW-ordered list of vertices

*---- face 6 of object (NW face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,11,9              ;CW-ordered list of vertices

*---- face 7 of object (NE face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     12,13,14            ;CW-ordered list of vertices

*---- face 8 of object (south face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     12,14,15            ;CW-ordered list of vertices

*---- face 9 of object (NW face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     12,15,13            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*             Graphics Object Model:  Road and Pine Trees
*----------------------------------------------------------------------

LEAF66:

*---- size of bounding sphere in object space
        .byte     67,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     26                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; two strips of road
        .byte     -64,-16+HW,0,F3     ;xyz coordinates for vertex 0
        .byte     0,HW,0,F3           ;xyz coordinates for vertex 1
        .byte     64,-16+HW,0,F3      ;xyz coordinates for vertex 2
        .byte     64+VL,-16-HW-VL/2,0,F3 ;xyz coordinates for vertex 3
        .byte     0,-HW,0,F3          ;xyz coordinates for vertex 4
        .byte     -64-VL,-16-HW,0,F3  ;xyz coordinates for vertex 5
; 1st tetrahedral pine tree
        .byte     60,12,8,F3          ;xyz coordinates for vertex 6
        .byte     60,12+3,0,F3        ;xyz coordinates for vertex 7
        .byte     60+2,12-1,0,F3      ;xyz coordinates for vertex 8
        .byte     60-2,12-1,0,F3      ;xyz coordinates for vertex 9
; 2nd tetrahedral pine tree
        .byte     42,-4,9,F3          ;xyz coordinates for vertex 10
        .byte     42,-4+3,0,F3        ;xyz coordinates for vertex 11
        .byte     42+2,-4-1,0,F3      ;xyz coordinates for vertex 12
        .byte     42-2,-4-1,0,F3      ;xyz coordinates for vertex 13
; 3rd tetrahedral pine tree
        .byte     -9,-11,7,F3         ;xyz coordinates for vertex 14
        .byte     -9,-11+3,0,F3       ;xyz coordinates for vertex 15
        .byte     -9+2,-11-1,0,F3     ;xyz coordinates for vertex 16
        .byte     -9-2,-11-1,0,F3     ;xyz coordinates for vertex 17
; 4th tetrahedral pine tree
        .byte     -16,9,9,F3          ;xyz coordinates for vertex 18
        .byte     -16,9+3,0,F3        ;xyz coordinates for vertex 19
        .byte     -16+2,9-1,0,F3      ;xyz coordinates for vertex 20
        .byte     -16-2,9-1,0,F3      ;xyz coordinates for vertex 21
; 5th tetrahedral pine tree
        .byte     -48,-20,7,F3        ;xyz coordinates for vertex 22
        .byte     -48,-20+3,0,F3      ;xyz coordinates for vertex 23
        .byte     -48+2,-20-1,0,F3    ;xyz coordinates for vertex 24
        .byte     -48-2,-20-1,0,F3    ;xyz coordinates for vertex 25

*---- face 0 of object (west road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,4,5             ;CW-ordered list of vertices

*---- face 1 of object (east road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     1,2,3,4             ;CW-ordered list of vertices

*---- face 2 of object (NE face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     6,7,8               ;CW-ordered list of vertices

*---- face 3 of object (south face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     6,8,9               ;CW-ordered list of vertices

*---- face 4 of object (NW face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     6,9,7               ;CW-ordered list of vertices

*---- face 5 of object (NE face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     10,11,12            ;CW-ordered list of vertices

*---- face 6 of object (south face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     10,12,13            ;CW-ordered list of vertices

*---- face 7 of object (NW face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     10,13,11            ;CW-ordered list of vertices

*---- face 8 of object (NE face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     14,15,16            ;CW-ordered list of vertices

*---- face 9 of object (south face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     14,16,17            ;CW-ordered list of vertices

*---- face 10 of object (NW face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     14,17,15            ;CW-ordered list of vertices

*---- face 11 of object (NE face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     18,19,20            ;CW-ordered list of vertices

*---- face 12 of object (south face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     18,20,21            ;CW-ordered list of vertices

*---- face 13 of object (NW face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     18,21,19            ;CW-ordered list of vertices

*---- face 14 of object (NE face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     22,23,24            ;CW-ordered list of vertices

*---- face 15 of object (south face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     22,24,25            ;CW-ordered list of vertices

*---- face 16 of object (NW face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     22,25,23            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*                   Graphics Object Model:  Mountain
*----------------------------------------------------------------------

LEAF67:

*---- size of bounding sphere in object space
        .byte     86,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     4                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     0,0,24,F3           ;xyz coordinates for vertex 0
        .byte     -80,32,0,F3         ;xyz coordinates for vertex 1
        .byte     48,32,0,F3          ;xyz coordinates for vertex 2
        .byte     0,-32,0,F3          ;xyz coordinates for vertex 3

*---- face 0 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     0,1,2               ;CW-ordered list of vertices

*---- face 1 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     0,2,3               ;CW-ordered list of vertices

*---- face 2 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     0,3,1               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*              Graphics Object Model:  Mountain and Road
*----------------------------------------------------------------------

LEAF68:

*---- size of bounding sphere in object space
        .byte     64,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     8                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     -56+HW,24+VL,0,F3   ;xyz coordinates for vertex 0
        .byte     -24+HW,-40,0,F3     ;xyz coordinates for vertex 1
        .byte     -24-HW,-40-VL,0,F3  ;xyz coordinates for vertex 2
        .byte     -56-HW,24,0,F3      ;xyz coordinates for vertex 3
; mountain
        .byte     0,0,16,F3           ;xyz coordinates for vertex 4
        .byte     -40,24,0,F3         ;xyz coordinates for vertex 5
        .byte     56,24,0,F3          ;xyz coordinates for vertex 6
        .byte     -8,-24,0,F3         ;xyz coordinates for vertex 7

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     4,5,6               ;CW-ordered list of vertices

*---- face 2 of object (SE slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     4,6,7               ;CW-ordered list of vertices

*---- face 3 of object (SW slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     4,7,5               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*              Graphics Object Model:  Road and Mountain
*----------------------------------------------------------------------

LEAF72:

*---- size of bounding sphere in object space
        .byte     84,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     9                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     -HW-VL,-72-VL,0,F3  ;xyz coordinates for vertex 0
        .byte     80,24+HW,0,F3       ;xyz coordinates for vertex 1
        .byte     80+VL,24-HW+VL,0,F3 ;xyz coordinates for vertex 2
        .byte     HW,-72,0,F3         ;xyz coordinates for vertex 3
; pyramidal mountain
        .byte     0,0,16,F3           ;xyz coordinates for vertex 4
        .byte     -48,56,0,F3         ;xyz coordinates for vertex 5
        .byte     48,40,0,F3          ;xyz coordinates for vertex 6
        .byte     48,8,0,F3           ;xyz coordinates for vertex 7
        .byte     -32,-56,0,F3        ;xyz coordinates for vertex 8

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     4,5,6               ;CW-ordered list of vertices

*---- face 2 of object (east slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     4,6,7               ;CW-ordered list of vertices

*---- face 3 of object (SE slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     4,7,8               ;CW-ordered list of vertices

*---- face 4 of object (west slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     4,8,5               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*             Graphics Object Model:  Road and Pine Trees
*----------------------------------------------------------------------

LEAF73:

*---- size of bounding sphere in object space
        .byte     28,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     -24-VL/2,-8+HW-VL/2,0,F3 ;xyz coordinates for vertex 0
        .byte     24-HW+VL,8+VL,0,F3  ;xyz coordinates for vertex 1
        .byte     24+HW,8,0,F3        ;xyz coordinates for vertex 2
        .byte     -24,-8-HW,0,F3      ;xyz coordinates for vertex 3
; 1st tetrahedral pine tree
        .byte     20,0,8,F3           ;xyz coordinates for vertex 4
        .byte     20,0+3,0,F3         ;xyz coordinates for vertex 5
        .byte     20+2,0-1,0,F3       ;xyz coordinates for vertex 6
        .byte     20-2,0-1,0,F3       ;xyz cOordinates for vertex 7
; 2nd tetrahedral pine tree
        .byte     -20,0,9,F3          ;xyz coordinates for vertex 8
        .byte     -20,0+3,0,F3        ;xyz coordinates for vertex 9
        .byte     -20+2,0-1,0,F3      ;xyz coordinates for vertex 10
        .byte     -20-2,0-1,0,F3      ;xyz coordinates for vertex 11

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (NE face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,5,6               ;CW-ordered list of vertices

*---- face 2 of object (south face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,6,7               ;CW-ordered list of vertices

*---- face 3 of object (NW face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,7,5               ;CW-ordered list of vertices

*---- face 4 of object (NE face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,9,10              ;CW-ordered list of vertices

*---- face 5 of object (south face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,10,11             ;CW-ordered list of vertices

*---- face 6 of object (NW face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,11,9              ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*                   Graphics Object Model:  Mountain
*----------------------------------------------------------------------

LEAF87:

*---- size of bounding sphere in object space
        .byte     80,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     4                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     0,0,24,F3           ;xyz coordinates for vertex 0
        .byte     -16,48,0,F3         ;xyz coordinates for vertex 1
        .byte     64,-16,0,F3         ;xyz coordinates for vertex 2
        .byte     -64,-48,0,F3        ;xyz coordinates for vertex 3

*---- face 0 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     0,1,2               ;CW-ordered list of vertices

*---- face 1 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     0,2,3               ;CW-ordered list of vertices

*---- face 2 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     0,3,1               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*                   Graphics Object Model:  Mountain
*----------------------------------------------------------------------

LEAF148:

*---- size of bounding sphere in object space
        .byte     69,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     5                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     0,0,24,F3           ;xyz coordinates for vertex 0
        .byte     -64,24,0,F3         ;xyz coordinates for vertex 1
        .byte     64,24,0,F3          ;xyz coordinates for vertex 2
        .byte     16,-40,0,F3         ;xyz coordinates for vertex 3
        .byte     -24,-40,0,F3        ;xyz coordinates for vertex 4

*---- face 0 of object (north slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     0,1,2               ;CW-ordered list of vertices

*---- face 1 of object (east slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     0,2,3               ;CW-ordered list of vertices

*---- face 2 of object (south slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     0,3,4               ;CW-ordered list of vertices

*---- face 3 of object (west slope of mountain)
        .word     3                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     0,4,1               ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*                  Graphics Object Model:  Pine Trees
*----------------------------------------------------------------------

LEAF149:

*---- size of bounding sphere in object space
        .byte     53,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     24                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; 1st tetrahedral pine tree
        .byte     -45,-20,9,F3        ;xyz coordinates for vertex 0
        .byte     -45,-20+3,0,F3      ;xyz coordinates for vertex 1
        .byte     -45+2,-20-1,0,F3    ;xyz coordinates for vertex 2
        .byte     -45-2,-20-1,0,F3    ;xyz coordinates for vertex 3
; 2nd tetrahedral pine tree
        .byte     -36,-8,9,F3         ;xyz coordinates for vertex 4
        .byte     -36,-8+3,0,F3       ;xyz coordinates for vertex 5
        .byte     -36+2,-8-1,0,F3     ;xyz coordinates for vertex 6
        .byte     -36-2,-8-1,0,F3     ;xyz coordinates for vertex 7
; 3rd tetrahedral pine tree
        .byte     -14,8,9,F3          ;xyz coordinates for vertex 8
        .byte     -14,8+3,0,F3        ;xyz coordinates for vertex 9
        .byte     -14+2,8-1,0,F3      ;xyz coordinates for vertex 10
        .byte     -14-2,8-1,0,F3      ;xyz coordinates for vertex 11
; 4th tetrahedral pine tree
        .byte     -2,-8,9,F3          ;xyz coordinates for vertex 12
        .byte     -2,-8+3,0,F3        ;xyz coordinates for vertex 13
        .byte     -2+2,-8-1,0,F3      ;xyz coordinates for vertex 14
        .byte     -2-2,-8-1,0,F3      ;xyz coordinates for vertex 15
; 5th tetrahedral pine tree
        .byte     32,8,9,F3           ;xyz coordinates for vertex 16
        .byte     32,8+3,0,F3         ;xyz coordinates for vertex 17
        .byte     32+2,8-1,0,F3       ;xyz coordinates for vertex 18
        .byte     32-2,8-1,0,F3       ;xyz coordinates for vertex 19
; 6th tetrahedral pine tree
        .byte     40,-16,9,F3         ;xyz coordinates for vertex 20
        .byte     40,-16+3,0,F3       ;xyz coordinates for vertex 21
        .byte     40+2,-16-1,0,F3     ;xyz coordinates for vertex 22
        .byte     40-2,-16-1,0,F3     ;xyz coordinates for vertex 23

*---- face 0 of object (NE face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     0,1,2               ;CW-ordered list of vertices

*---- face 1 of object (south face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     0,2,3               ;CW-ordered list of vertices

*---- face 2 of object (NW face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     0,3,1               ;CW-ordered list of vertices

*---- face 3 of object (NE face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,5,6               ;CW-ordered list of vertices

*---- face 4 of object (south face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,6,7               ;CW-ordered list of vertices

*---- face 5 of object (NW face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,7,5               ;CW-ordered list of vertices

*---- face 6 of object (NE face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,9,10              ;CW-ordered list of vertices

*---- face 7 of object (south face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,10,11             ;CW-ordered list of vertices

*---- face 8 of object (NW face of 3rd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,11,9              ;CW-ordered list of vertices

*---- face 9 of object (NE face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     12,13,14            ;CW-ordered list of vertices

*---- face 10 of object (south face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     12,14,15            ;CW-ordered list of vertices

*---- face 11 of object (NW face of 4th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     12,15,13            ;CW-ordered list of vertices

*---- face 12 of object (NE face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     16,17,18            ;CW-ordered list of vertices

*---- face 13 of object (south face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     16,18,19            ;CW-ordered list of vertices

*---- face 14 of object (NW face of 5th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     16,19,17            ;CW-ordered list of vertices

*---- face 15 of object (NE face of 6th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     20,21,22            ;CW-ordered list of vertices

*---- face 16 of object (south face of 6th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     20,22,23            ;CW-ordered list of vertices

*---- face 17 of object (NW face of 6th pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     20,23,21            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*               Graphics Object Model:  Road and Tunnel
*----------------------------------------------------------------------

LEAF75:

*---- size of bounding sphere in object space
        .byte     70,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN2              ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX75-$)/16       ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     22                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; two strips of road
        .byte     -48-HW,-48,0,F3     ;xyz coordinates for vertex 0
        .byte     0,HW,0,F3           ;xyz coordinates for vertex 1
        .byte     64+VL,HW,0,F3       ;xyz coordinates for vertex 2
        .byte     64,-HW,0,F3         ;xyz coordinates for vertex 3
        .byte     0,-HW,0,F3          ;xyz coordinates for vertex 4
        .byte     -48+HW-VL/2,-48-VL,0,F3 ;xyz coordinates for vertex 5
; tunnel
        .byte     24,2*HW,5,F3        ;xyz coordinates for vertex 6
        .byte     24,2*HW,8,F3        ;xyz coordinates for vertex 7
        .byte     48,2*HW,5,F3        ;xyz coordinates for vertex 8
        .byte     48,2*HW,8,F3        ;xyz coordinates for vertex 9

        .byte     48,-2*HW,5,F3       ;xyz coordinates for vertex 10
        .byte     48,-2*HW,8,F3       ;xyz coordinates for vertex 11
        .byte     24,-2*HW,5,F3       ;xyz coordinates for vertex 12
        .byte     24,-2*HW,8,F3       ;xyz coordinates for vertex 13

        .byte     8,2*HW,0,F3         ;xyz coordinates for vertex 14
        .byte     24,12+2*HW,0,F3     ;xyz coordinates for vertex 15
        .byte     48,12+2*HW,0,F3     ;xyz coordinates for vertex 16
        .byte     64,2*HW,0,F3        ;xyz coordinates for vertex 17

        .byte     64,-2*HW,0,F3       ;xyz coordinates for vertex 18
        .byte     48,-12-2*HW,0,F3    ;xyz coordinates for vertex 19
        .byte     24,-12-2*HW,0,F3    ;xyz coordinates for vertex 20
        .byte     8,-2*HW,0,F3        ;xyz coordinates for vertex 21

*---- face 0 of object (west road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,4,5             ;CW-ordered list of vertices

*---- face 1 of object (east road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     1,2,3,4             ;CW-ordered list of vertices

*---- face 2 of object (north inner wall of tunnel)
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     14,7,9,17           ;CW-ordered list of vertices

*---- face 3 of object (south inner wall of tunnel)
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     18,11,13,21         ;CW-ordered list of vertices

*---- face 4 of object (ceiling of tunnel)
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     6,12,10,8           ;CW-ordered list of vertices

*---- face 5 of object (roof of tunnel)
        .word     4                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     7,9,11,13           ;CW-ordered list of vertices

*---- face 6 of object (west entrance to tunnel)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     6,7,13,12           ;CW-ordered list of vertices

*---- face 7 of object (west entrance to tunnel)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     10,11,9,8           ;CW-ordered list of vertices

*---- face 8 of object (NW side of tunnel)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     14,15,7             ;CW-ordered list of vertices

*---- face 9 of object (north side of tunnel)
        .word     4                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     7,15,16,9           ;CW-ordered list of vertices

*---- face 10 of object (NE side of tunnel)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     9,16,17             ;CW-ordered list of vertices

*---- face 11 of object (SE side of tunnel)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     11,18,19            ;CW-ordered list of vertices

*---- face 12 of object (SE side of tunnel)
        .word     4                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     13,11,19,20         ;CW-ordered list of vertices

*---- face 13 of object (SE side of tunnel)
        .word     3                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     21,13,20            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX75:

*---- bounding boxes for tunnel
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     24,-2*HW,5,F3       ;xmin, ymin, zmin, scale factor
        .byte     48,2*HW,8,F3        ;xmax, ymax, zmax, scale factor

        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     18,2*HW,0,F3        ;xmin, ymin, zmin, scale factor
        .byte     54,2*HW+8,5,F3      ;xmax, ymax, zmax, scale factor

        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     18,-2*HW-8,0,F3     ;xmin, ymin, zmin, scale factor
        .byte     54,-2*HW,5,F3       ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*               Graphics Object Model:  Building in City
*----------------------------------------------------------------------

LEAF89:

*---- size of bounding sphere in object space
        .byte     12,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     RED3                ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX89-$)/16       ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     8                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     -9,5,0,F3           ;xyz coordinates for vertex 0
        .byte     -9,5,6,F3           ;xyz coordinates for vertex 1
        .byte     9,5,0,F3            ;xyz coordinates for vertex 2
        .byte     9,5,6,F3            ;xyz coordinates for vertex 3
        .byte     9,-5,0,F3           ;xyz coordinates for vertex 4
        .byte     9,-5,6,F3           ;xyz coordinates for vertex 5
        .byte     -9,-5,0,F3          ;xyz coordinates for vertex 6
        .byte     -9,-5,6,F3          ;xyz coordinates for vertex 7

*---- face 0 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     2,3,1,0             ;CW-ordered list of vertices

*---- face 1 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     4,5,3,2             ;CW-ordered list of vertices

*---- face 2 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 3 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     0,1,7,6             ;CW-ordered list of vertices

*---- face 4 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     RED3                ;face color (GSP COLOR1 format)
        .word     1,3,5,7             ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX89:

*---- bounding box for building (bumped into building?)
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -9,-5,0,F3          ;xmin, ymin, zmin, scale factor
        .byte     9,5,6,F3            ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*                Graphics Object Model:  Road and Trees
*----------------------------------------------------------------------

LEAF138:

*---- size of bounding sphere in object space
        .byte     18,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     2+HW,16,0,F3        ;xyz coordinates for vertex 0
        .byte     -2+HW,-16,0,F3      ;xyz coordinates for vertex 1
        .byte     -2-HW,-16-VL,0,F3   ;xyz coordinates for vertex 2
        .byte     2-HW,16,0,F3        ;xyz coordinates for vertex 3
; 1st tetrahedral pine tree
        .byte     10,14,8,F3          ;xyz coordinates for vertex 6
        .byte     10,14+3,0,F3        ;xyz coordinates for vertex 7
        .byte     10+2,14-1,0,F3      ;xyz coordinates for vertex 8
        .byte     10-2,14-1,0,F3      ;xyz coordinates for vertex 9
; 2nd tetrahedral pine tree
        .byte     6,-8,9,F3           ;xyz coordinates for vertex 10
        .byte     6,-8+3,0,F3         ;xyz coordinates for vertex 11
        .byte     6+2,-8-1,0,F3       ;xyz coordinates for vertex 12
        .byte     6-2,-8-1,0,F3       ;xyz coordinates for vertex 13

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (NE face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,5,6               ;CW-ordered list of vertices

*---- face 2 of object (south face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,6,7               ;CW-ordered list of vertices

*---- face 3 of object (NW face of 1st pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,7,5               ;CW-ordered list of vertices

*---- face 4 of object (NE face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,9,10              ;CW-ordered list of vertices

*---- face 5 of object (south face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,10,11             ;CW-ordered list of vertices

*---- face 6 of object (NW face of 2nd pine tree)
        .word     3                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     8,11,9              ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*                Graphics Object Model:  Barn and Road
*----------------------------------------------------------------------

LEAF139:

*---- size of bounding sphere in object space
        .byte     19,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     20                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     -6+HW,16,0,F3       ;xyz coordinates for vertex 0
        .byte     -18+HW,-16,0,F3     ;xyz coordinates for vertex 1
        .byte     -18-HW-VL/2,-16-VL,0,F3 ;xyz coordinates for vertex 2
        .byte     -6-HW+VL/2,16+VL,0,F3 ;xyz coordinates for vertex 3
; barn
        .byte     -6,-8,0,F3          ;xyz coordinates for vertex 4
        .byte     -6,-8,3,F3          ;xyz coordinates for vertex 5
        .byte     6,-8,0,F3           ;xyz coordinates for vertex 6
        .byte     6,-8,3,F3           ;xyz coordinates for vertex 7
        .byte     6,-16,0,F3          ;xyz coordinates for vertex 8
        .byte     6,-16,3,F3          ;xyz coordinates for vertex 9
        .byte     -6,-16,0,F3         ;xyz coordinates for vertex 10
        .byte     -6,-16,3,F3         ;xyz coordinates for vertex 11

        .byte     -2,-8,5,F3          ;xyz coordinates for vertex 12
        .byte     2,-8,5,F3           ;xyz coordinates for vertex 13
        .byte     2,-16,5,F3          ;xyz coordinates for vertex 14
        .byte     -2,-16,5,F3         ;xyz coordinates for vertex 15

        .byte     -3,-16,0,F3         ;xyz coordinates for vertex 16
        .byte     -3,-16,2,F3         ;xyz coordinates for vertex 17
        .byte     3,-16,0,F3          ;xyz coordinates for vertex 18
        .byte     3,-16,2,F3          ;xyz coordinates for vertex 19

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (west side of barn)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     4,5,11,10           ;CW-ordered list of vertices

*---- face 2 of object (west roof of barn)
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     5,12,15,11          ;CW-ordered list of vertices

*---- face 3 of object (center roof of barn)
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     12,13,14,15         ;CW-ordered list of vertices

*---- face 4 of object (east roof of barn)
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     13,7,9,14           ;CW-ordered list of vertices

*---- face 5 of object (east side of barn)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 6 of object (north side of barn)
        .word     6                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     6,7,13,12,5,4       ;CW-ordered list of vertices

*---- face 7 of object (north side of barn)
        .word     6                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     10,11,15,14,9,8     ;CW-ordered list of vertices

*---- face 8 of object (north side of barn)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     16,17,19,18         ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*               Graphics Object Model:  Building in City
*----------------------------------------------------------------------

LEAF704:

*---- size of bounding sphere in object space
        .byte     13,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     BROWN3              ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX704-$)/16      ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     8                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     -10,6,0,F3          ;xyz coordinates for vertex 0
        .byte     -10,6,6,F3          ;xyz coordinates for vertex 1
        .byte     10,6,0,F3           ;xyz coordinates for vertex 2
        .byte     10,6,6,F3           ;xyz coordinates for vertex 3
        .byte     10,-6,0,F3          ;xyz coordinates for vertex 4
        .byte     10,-6,6,F3          ;xyz coordinates for vertex 5
        .byte     -10,-6,0,F3         ;xyz coordinates for vertex 6
        .byte     -10,-6,6,F3         ;xyz coordinates for vertex 7

*---- face 0 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     2,3,1,0             ;CW-ordered list of vertices

*---- face 1 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     4,5,3,2             ;CW-ordered list of vertices

*---- face 2 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 3 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     0,1,7,6             ;CW-ordered list of vertices

*---- face 4 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     1,3,5,7             ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX704:

*---- bounding box for building (bumped into building?)
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -10,-6,0,F3         ;xmin, ymin, zmin, scale factor
        .byte     10,6,6,F3           ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*          Graphics Object Model:  Road and Building in City
*----------------------------------------------------------------------

LEAF706:

*---- size of bounding sphere in object space
        .byte     23,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX706-$)/16      ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     -13-VL,13,0,F3      ;xyz coordinates for vertex 0
        .byte     19,13,0,F3          ;xyz coordinates for vertex 1
        .byte     19+VL,9,0,F3        ;xyz coordinates for vertex 2
        .byte     -13-VL,9,0,F3       ;xyz coordinates for vertex 3
; building
        .byte     -5,3,0,F3           ;xyz coordinates for vertex 4
        .byte     -5,3,16,F3          ;xyz coordinates for vertex 5
        .byte     5,3,0,F3            ;xyz coordinates for vertex 6
        .byte     5,3,16,F3           ;xyz coordinates for vertex 7
        .byte     5,-3,0,F3           ;xyz coordinates for vertex 8
        .byte     5,-3,16,F3          ;xyz coordinates for vertex 9
        .byte     -5,-3,0,F3          ;xyz coordinates for vertex 10
        .byte     -5,-3,16,F3         ;xyz coordinates for vertex 11

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 2 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 3 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     10,11,9,8           ;CW-ordered list of vertices

*---- face 4 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     BROWN2              ;face color (GSP COLOR1 format)
        .word     4,5,11,10           ;CW-ordered list of vertices

*---- face 5 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     5,7,9,11            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX706:

*---- bounding box for building
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -5,-3,0,F3          ;xmin, ymin, zmin, scale factor
        .byte     5,3,16,F3           ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*          Graphics Object Model:  Road and Building in City
*----------------------------------------------------------------------

LEAF709:

*---- size of bounding sphere in object space
        .byte     10,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX709-$)/16      ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     8                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     -5,4,0,F3           ;xyz coordinates for vertex 0
        .byte     -5,4,7,F3           ;xyz coordinates for vertex 1
        .byte     5,4,0,F3            ;xyz coordinates for vertex 2
        .byte     5,4,7,F3            ;xyz coordinates for vertex 3
        .byte     5,-4,0,F3           ;xyz coordinates for vertex 4
        .byte     5,-4,7,F3           ;xyz coordinates for vertex 5
        .byte     -5,-4,0,F3          ;xyz coordinates for vertex 6
        .byte     -5,-4,7,F3          ;xyz coordinates for vertex 7

*---- face 0 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     2,3,1,0             ;CW-ordered list of vertices

*---- face 1 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     4,5,3,2             ;CW-ordered list of vertices

*---- face 2 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 3 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     0,1,7,6             ;CW-ordered list of vertices

*---- face 4 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     1,3,5,7             ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX709:

*---- bounding box for building
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -5,-4,0,F3          ;xmin, ymin, zmin, scale factor
        .byte     5,4,7,F3            ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*               Graphics Object Model:  Building in City
*----------------------------------------------------------------------

LEAF711:

*---- size of bounding sphere in object space
        .byte     19,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX711-$)/16      ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     -16-VL,10,0,F3      ;xyz coordinates for vertex 0
        .byte     16+VL,10,0,F3       ;xyz coordinates for vertex 1
        .byte     16+VL,6,0,F3        ;xyz coordinates for vertex 2
        .byte     -16,6,0,F3          ;xyz coordinates for vertex 3
; building
        .byte     -6,4,0,F3           ;xyz coordinates for vertex 0
        .byte     -6,4,6,F3           ;xyz coordinates for vertex 1
        .byte     6,4,0,F3            ;xyz coordinates for vertex 2
        .byte     6,4,6,F3            ;xyz coordinates for vertex 3
        .byte     6,-4,0,F3           ;xyz coordinates for vertex 4
        .byte     6,-4,6,F3           ;xyz coordinates for vertex 5
        .byte     -6,-4,0,F3          ;xyz coordinates for vertex 6
        .byte     -6,-4,6,F3          ;xyz coordinates for vertex 7

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 2 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 3 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     10,11,9,8           ;CW-ordered list of vertices

*---- face 4 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     4,5,11,10           ;CW-ordered list of vertices

*---- face 5 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     BROWN3              ;face color (GSP COLOR1 format)
        .word     5,7,9,11            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX711:

*---- bounding box for building
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -6,-4,0,F3          ;xmin, ymin, zmin, scale factor
        .byte     6,4,6,F3            ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*               Graphics Object Model:  Building in City
*----------------------------------------------------------------------

LEAF1410:

*---- size of bounding sphere in object space
        .byte     17,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX1410-$)/16     ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     8                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     -4,7,0,F3           ;xyz coordinates for vertex 0
        .byte     -4,7,15,F3          ;xyz coordinates for vertex 1
        .byte     4,7,0,F3            ;xyz coordinates for vertex 2
        .byte     4,7,15,F3           ;xyz coordinates for vertex 3
        .byte     4,-7,0,F3           ;xyz coordinates for vertex 4
        .byte     4,-7,15,F3          ;xyz coordinates for vertex 5
        .byte     -4,-7,0,F3          ;xyz coordinates for vertex 6
        .byte     -4,-7,15,F3         ;xyz coordinates for vertex 7

*---- face 0 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     2,3,1,0             ;CW-ordered list of vertices

*---- face 1 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     4,5,3,2             ;CW-ordered list of vertices

*---- face 2 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 3 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     0,1,7,6             ;CW-ordered list of vertices

*---- face 4 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     1,3,5,7             ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX1410:

*---- bounding box for building
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -4,-7,0,F3          ;xmin, ymin, zmin, scale factor
        .byte     4,7,15,F3           ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*               Graphics Object Model:  Building in City
*----------------------------------------------------------------------

LEAF1411:

*---- size of bounding sphere in object space
        .byte     19,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX1411-$)/16     ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     5,-6,0,F3           ;xyz coordinates for vertex 0
        .byte     5,-6,5,F3           ;xyz coordinates for vertex 1
        .byte     5,0,0,F3            ;xyz coordinates for vertex 2
        .byte     5,0,5,F3            ;xyz coordinates for vertex 3
        .byte     -11,0,0,F3          ;xyz coordinates for vertex 4
        .byte     -11,0,5,F3          ;xyz coordinates for vertex 5
        .byte     -11,6,0,F3          ;xyz coordinates for vertex 6
        .byte     -11,6,5,F3          ;xyz coordinates for vertex 7
        .byte     11,6,0,F3           ;xyz coordinates for vertex 8
        .byte     11,6,5,F3           ;xyz coordinates for vertex 9
        .byte     11,-6,0,F3          ;xyz coordinates for vertex 10
        .byte     11,-6,5,F3          ;xyz coordinates for vertex 11

*---- face 0 of object (west inside wall of building)
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     2,3,1,0             ;CW-ordered list of vertices

*---- face 1 of object (north inside wall of building)
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     4,5,3,2             ;CW-ordered list of vertices

*---- face 2 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 3 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 4 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     10,11,9,8           ;CW-ordered list of vertices

*---- face 5 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     0,1,11,10           ;CW-ordered list of vertices

*---- face 6 of object (SE roof of building)
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     1,3,9,11            ;CW-ordered list of vertices

*---- face 7 of object (NW roof of building)
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     3,5,7,9             ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX1411:

*---- 2 bounding boxes for building
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -11,0,0,F3          ;xmin, ymin, zmin, scale factor
        .byte     11,6,5,F3           ;xmax, ymax, zmax, scale factor

        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     5,-6,0,F3           ;xmin, ymin, zmin, scale factor
        .byte     11,6,5,F3           ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*    Graphics Object Model:  Road Intersection and Building in City
*----------------------------------------------------------------------

LEAF1414:

*---- size of bounding sphere in object space
        .byte     19,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX1414-$)/16     ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     14                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; two strips of road
        .byte     -16,10,0,F3         ;xyz coordinates for vertex 0
        .byte     16+VL,10,0,F3       ;xyz coordinates for vertex 1
        .byte     16+VL,6,0,F3        ;xyz coordinates for vertex 2
        .byte     -12,6,0,F3          ;xyz coordinates for vertex 3
        .byte     -12,-8-VL,0,F3      ;xyz coordinates for vertex 4
        .byte     -16,-8-VL,0,F3      ;xyz coordinates for vertex 5
; building
        .byte     -8,4,0,F3           ;xyz coordinates for vertex 6
        .byte     -8,4,10,F3          ;xyz coordinates for vertex 7
        .byte     8,4,0,F3            ;xyz coordinates for vertex 8
        .byte     8,4,10,F3           ;xyz coordinates for vertex 9
        .byte     8,-4,0,F3           ;xyz coordinates for vertex 10
        .byte     8,-4,10,F3          ;xyz coordinates for vertex 11
        .byte     -8,-4,0,F3          ;xyz coordinates for vertex 12
        .byte     -8,-4,10,F3         ;xyz coordinates for vertex 13

*---- face 0 of object (east-west road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (north-south road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,3,4,5             ;CW-ordered list of vertices

*---- face 2 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     BLUGRN2             ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 3 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     10,11,9,8           ;CW-ordered list of vertices

*---- face 4 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     BLUGRN2             ;face color (GSP COLOR1 format)
        .word     12,13,11,10         ;CW-ordered list of vertices

*---- face 5 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     6,7,13,12           ;CW-ordered list of vertices

*---- face 6 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     7,9,11,13           ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX1414:

*---- bounding box for building
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -8,-4,0,F3          ;xmin, ymin, zmin, scale factor
        .byte     8,4,10,F3           ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*          Graphics Object Model:  Road and Building in City
*----------------------------------------------------------------------

LEAF1415:

*---- size of bounding sphere in object space
        .byte     17,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX1415-$)/16     ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     -9,10+VL,0,F3       ;xyz coordinates for vertex 0
        .byte     -5,10+VL,0,F3       ;xyz coordinates for vertex 1
        .byte     -5,-14,0,F3         ;xyz coordinates for vertex 2
        .byte     -9,-14,0,F3         ;xyz coordinates for vertex 3
; building
        .byte     -3,6,0,F3           ;xyz coordinates for vertex 4
        .byte     -3,6,8,F3           ;xyz coordinates for vertex 5
        .byte     3,6,0,F3            ;xyz coordinates for vertex 6
        .byte     3,6,8,F3            ;xyz coordinates for vertex 7
        .byte     3,-6,0,F3           ;xyz coordinates for vertex 8
        .byte     3,-6,8,F3           ;xyz coordinates for vertex 9
        .byte     -3,-6,0,F3          ;xyz coordinates for vertex 10
        .byte     -3,-6,8,F3          ;xyz coordinates for vertex 11

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 2 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY5               ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 3 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     10,11,9,8           ;CW-ordered list of vertices

*---- face 4 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY5               ;face color (GSP COLOR1 format)
        .word     4,5,11,10           ;CW-ordered list of vertices

*---- face 5 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     5,7,9,11            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX1415:

*---- bounding box for building
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -3,-6,0,F3          ;xmin, ymin, zmin, scale factor
        .byte     3,6,8,F3            ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*          Graphics Object Model:  Road and Building in City
*----------------------------------------------------------------------

LEAF1416:

*---- size of bounding sphere in object space
        .byte     19,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX1416-$)/16     ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     12,14,0,F3          ;xyz coordinates for vertex 0
        .byte     12,-10-VL,0,F3      ;xyz coordinates for vertex 1
        .byte     8,-10-VL,0,F3       ;xyz coordinates for vertex 2
        .byte     8,14,0,F3           ;xyz coordinates for vertex 3
; building
        .byte     -4,6,0,F3           ;xyz coordinates for vertex 4
        .byte     -4,6,18,F3          ;xyz coordinates for vertex 5
        .byte     4,6,0,F3            ;xyz coordinates for vertex 6
        .byte     4,6,18,F3           ;xyz coordinates for vertex 7
        .byte     4,-6,0,F3           ;xyz coordinates for vertex 8
        .byte     4,-6,18,F3          ;xyz coordinates for vertex 9
        .byte     -4,-6,0,F3          ;xyz coordinates for vertex 10
        .byte     -4,-6,18,F3         ;xyz coordinates for vertex 11

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 2 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY5               ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 3 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     10,11,9,8           ;CW-ordered list of vertices

*---- face 4 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY5               ;face color (GSP COLOR1 format)
        .word     4,5,11,10           ;CW-ordered list of vertices

*---- face 5 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     5,7,9,11            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX1416:

*---- bounding box for building
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -4,-6,0,F3          ;xmin, ymin, zmin, scale factor
        .byte     4,6,18,F3           ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*          Graphics Object Model:  Road and Building in City
*----------------------------------------------------------------------

LEAF1417:

*---- size of bounding sphere in object space
        .byte     19,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX1417-$)/16     ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     16,9+VL,0,F3        ;xyz coordinates for vertex 0
        .byte     16,-7-VL,0,F3       ;xyz coordinates for vertex 1
        .byte     12,-7-VL,0,F3       ;xyz coordinates for vertex 2
        .byte     12,9+VL,0,F3        ;xyz coordinates for vertex 3
; building
        .byte     -10,5,0,F3          ;xyz coordinates for vertex 4
        .byte     -10,5,8,F3          ;xyz coordinates for vertex 5
        .byte     10,5,0,F3           ;xyz coordinates for vertex 6
        .byte     10,5,8,F3           ;xyz coordinates for vertex 7
        .byte     10,-5,0,F3          ;xyz coordinates for vertex 8
        .byte     10,-5,8,F3          ;xyz coordinates for vertex 9
        .byte     -10,-5,0,F3         ;xyz coordinates for vertex 10
        .byte     -10,-5,8,F3         ;xyz coordinates for vertex 11

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 2 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 3 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     10,11,9,8           ;CW-ordered list of vertices

*---- face 4 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     4,5,11,10           ;CW-ordered list of vertices

*---- face 5 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     5,7,9,11            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX1417:

*---- bounding box for building
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -10,-5,0,F3         ;xmin, ymin, zmin, scale factor
        .byte     10,5,8,F3           ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*          Graphics Object Model:  Road and Building in City
*----------------------------------------------------------------------

LEAF1420:

*---- size of bounding sphere in object space
        .byte     23,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX1420-$)/16     ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; road
        .byte     -12-VL,11,0,F3      ;xyz coordinates for vertex 0
        .byte     20+2*VL,11,0,F3     ;xyz coordinates for vertex 1
        .byte     20+2*VL,7,0,F3      ;xyz coordinates for vertex 2
        .byte     -12-VL,7,0,F3       ;xyz coordinates for vertex 3
; building
        .byte     -8,4,0,F3           ;xyz coordinates for vertex 4
        .byte     -8,4,6,F3           ;xyz coordinates for vertex 5
        .byte     8,4,0,F3            ;xyz coordinates for vertex 6
        .byte     8,4,6,F3            ;xyz coordinates for vertex 7
        .byte     8,-4,0,F3           ;xyz coordinates for vertex 8
        .byte     8,-4,6,F3           ;xyz coordinates for vertex 9
        .byte     -8,-4,0,F3          ;xyz coordinates for vertex 10
        .byte     -8,-4,6,F3          ;xyz coordinates for vertex 11

*---- face 0 of object (road)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 2 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 3 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     10,11,9,8           ;CW-ordered list of vertices

*---- face 4 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     4,5,11,10           ;CW-ordered list of vertices

*---- face 5 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     5,7,9,11            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX1420:

*---- bounding box for building
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -8,-4,0,F3          ;xmin, ymin, zmin, scale factor
        .byte     8,4,6,F3            ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*          Graphics Object Model:  Road and Building in City
*----------------------------------------------------------------------

LEAF1421:

*---- size of bounding sphere in object space
        .byte     12,F3|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX1421-$)/16     ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     8                   ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     -5,10,0,F3          ;xyz coordinates for vertex 0
        .byte     -5,10,4,F3          ;xyz coordinates for vertex 1
        .byte     5,10,0,F3           ;xyz coordinates for vertex 2
        .byte     5,10,4,F3           ;xyz coordinates for vertex 3
        .byte     5,-10,0,F3          ;xyz coordinates for vertex 4
        .byte     5,-10,4,F3          ;xyz coordinates for vertex 5
        .byte     -5,-10,0,F3         ;xyz coordinates for vertex 6
        .byte     -5,-10,4,F3         ;xyz coordinates for vertex 7

*---- face 0 of object (north side of building)
        .word     4                   ;number of vertices in face
        .word     BLUGRN2             ;face color (GSP COLOR1 format)
        .word     2,3,1,0             ;CW-ordered list of vertices

*---- face 1 of object (east side of building)
        .word     4                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     4,5,3,2             ;CW-ordered list of vertices

*---- face 2 of object (south side of building)
        .word     4                   ;number of vertices in face
        .word     BLUGRN2             ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 3 of object (west side of building)
        .word     4                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     0,1,7,6             ;CW-ordered list of vertices

*---- face 4 of object (roof of building)
        .word     4                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     1,3,5,7             ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX1421:

*---- bounding box for building
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -5,-10,0,F3         ;xmin, ymin, zmin, scale factor
        .byte     5,10,4,F3           ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data


*----------------------------------------------------------------------
*                   Node 86 in Graphics Object Tree
*----------------------------------------------------------------------

NODE86:

*---- bounding sphere radius and log2(scale factor)
        .byte     70,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     NODE172-$           ;left son of this node
        .byte     72,88,0,F0          ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     NODE173-$           ;right son of this node
        .byte     -52,0,0,F0          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00001h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 172 in Graphics Object Tree
*----------------------------------------------------------------------

NODE172:

*---- bounding sphere radius and log2(scale factor)
        .byte     63,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF344-$           ;left son of this node
        .byte     -28,28,0,F0         ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF345-$           ;right son of this node
        .byte     36,-36,0,F0         ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*                   Node 173 in Graphics Object Tree
*----------------------------------------------------------------------

NODE173:

*---- bounding sphere radius and log2(scale factor)
        .byte     63,F3               ;nonleaf (intermediate) node
*---- color of node when it is far away and is size of a single pixel
        .word     EARTHGREEN          ;
*---- left son:  pointer and xyz displacements from current node
        .long     LEAF346-$           ;left son of this node
        .byte     0,84,0,F0           ;left son xyz displacements
*---- right son:  pointer and xyz displacements from current node
        .long     LEAF347-$           ;right son of this node
        .byte     0,-84,0,F0          ;right son xyz displacements
*---- coefficients of equation of plane separating left and right sons
        .word     00010h              ;BPP coefficients D::C::B::A


*----------------------------------------------------------------------
*           Graphics Object Model:  Airport Hangar Building
*----------------------------------------------------------------------

LEAF344:

*---- size of bounding sphere in object space
        .byte     67,F0|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX344-$)/16      ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     20                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     -44,20,0,F0         ;xyz coordinates for vertex 0
        .byte     60,20,0,F0          ;xyz coordinates for vertex 1
        .byte     60,-36,0,F0         ;xyz coordinates for vertex 2
        .byte     -44,-36,0,F0        ;xyz coordinates for vertex 3

        .byte     -28,16,0,F0         ;xyz coordinates for vertex 4
        .byte     -28,16,24,F0        ;xyz coordinates for vertex 5
        .byte     28,16,0,F0          ;xyz coordinates for vertex 6
        .byte     28,16,24,F0         ;xyz coordinates for vertex 7
        .byte     28,-16,0,F0         ;xyz coordinates for vertex 8
        .byte     28,-16,24,F0        ;xyz coordinates for vertex 9
        .byte     -28,-16,0,F0        ;xyz coordinates for vertex 10
        .byte     -28,-16,24,F0       ;xyz coordinates for vertex 11

        .byte     -20,16,0,F0         ;xyz coordinates for vertex 12
        .byte     -20,16,20,F0        ;xyz coordinates for vertex 13
        .byte     20,16,0,F0          ;xyz coordinates for vertex 14
        .byte     20,16,20,F0         ;xyz coordinates for vertex 15
        .byte     20,-16,0,F0         ;xyz coordinates for vertex 16
        .byte     20,-16,20,F0        ;xyz coordinates for vertex 17
        .byte     -20,-16,0,F0        ;xyz coordinates for vertex 18
        .byte     -20,-16,20,F0       ;xyz coordinates for vertex 19

*---- face 0 of object
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     13,19,17,15         ;CW-ordered list of vertices

*---- face 2 of object
        .word     4                   ;number of vertices in face
        .word     GRAY5               ;face color (GSP COLOR1 format)
        .word     18,19,13,12         ;CW-ordered list of vertices

*---- face 3 of object
        .word     4                   ;number of vertices in face
        .word     GRAY5               ;face color (GSP COLOR1 format)
        .word     14,15,17,16         ;CW-ordered list of vertices

*---- face 4 of object
        .word     4                   ;number of vertices in face
        .word     RED1                ;face color (GSP COLOR1 format)
        .word     5,7,9,11            ;CW-ordered list of vertices

*---- face 5 of object
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     4,5,11,10           ;CW-ordered list of vertices

*---- face 6 of object
        .word     4                   ;number of vertices in face
        .word     RED2                ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 7 of object
        .word     4                   ;number of vertices in face
        .word     RED3                ;face color (GSP COLOR1 format)
        .word     15,7,5,13           ;CW-ordered list of vertices

*---- face 8 of object
        .word     4                   ;number of vertices in face
        .word     RED3                ;face color (GSP COLOR1 format)
        .word     12,13,5,4           ;CW-ordered list of vertices

*---- face 9 of object
        .word     4                   ;number of vertices in face
        .word     RED3                ;face color (GSP COLOR1 format)
        .word     6,7,15,14           ;CW-ordered list of vertices

*---- face 10 of object
        .word     4                   ;number of vertices in face
        .word     RED3                ;face color (GSP COLOR1 format)
        .word     19,11,9,17          ;CW-ordered list of vertices

*---- face 11 of object
        .word     4                   ;number of vertices in face
        .word     RED3                ;face color (GSP COLOR1 format)
        .word     10,11,19,18         ;CW-ordered list of vertices

*---- face 12 of object
        .word     4                   ;number of vertices in face
        .word     RED3                ;face color (GSP COLOR1 format)
        .word     16,17,9,8           ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX344:

*---- bounding boxes for hangar (roof and two walls)
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -28,-16,20,F0       ;xmin, ymin, zmin, scale factor
        .byte     28,16,24,F0         ;xmax, ymax, zmax, scale factor

        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -28,-16,0,F0        ;xmin, ymin, zmin, scale factor
        .byte     -20,16,24,F0        ;xmax, ymax, zmax, scale factor

        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     20,-16,0,F0         ;xmin, ymin, zmin, scale factor
        .byte     28,16,24,F0         ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*          Graphics Object Model:  Airport Terminal Building
*----------------------------------------------------------------------

LEAF345:

*---- size of bounding sphere in object space
        .byte     114,F0|ISLEAF       ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (BBOX345-$)/16      ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
        .byte     -108,36,0,F0        ;xyz coordinates for vertex 0
        .byte     28,36,0,F0          ;xyz coordinates for vertex 1
        .byte     28,-36,0,F0         ;xyz coordinates for vertex 2
        .byte     -108,-36,0,F0       ;xyz coordinates for vertex 3

        .byte     -16,28,0,F0         ;xyz coordinates for vertex 4
        .byte     -16,28,30,F0        ;xyz coordinates for vertex 5
        .byte     16,28,0,F0          ;xyz coordinates for vertex 6
        .byte     16,28,30,F0         ;xyz coordinates for vertex 7
        .byte     16,-28,0,F0         ;xyz coordinates for vertex 8
        .byte     16,-28,30,F0        ;xyz coordinates for vertex 9
        .byte     -16,-28,0,F0        ;xyz coordinates for vertex 10
        .byte     -16,-28,30,F0       ;xyz coordinates for vertex 11

*---- face 0 of object
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     4,5,11,10           ;CW-ordered list of vertices

*---- face 2 of object
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 3 of object
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 4 of object
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     10,11,9,8           ;CW-ordered list of vertices

*---- face 5 of object
        .word     4                   ;number of vertices in face
        .word     BROWN1              ;face color (GSP COLOR1 format)
        .word     5,7,9,11            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

BBOX345:

*---- bounding box specification
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     -16,-28,0,F0        ;xmin, ymin, zmin, scale factor
        .byte     16,28,30,F0         ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*          Graphics Object Model:  Airport Runway, North Half
*----------------------------------------------------------------------

LEAF346:

*---- size of bounding sphere in object space
        .byte     94,F0|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     32                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; Runway
        .byte     -12,84,0,F0         ;xyz coordinates for vertex 0
        .byte     12,84,0,F0          ;xyz coordinates for vertex 1
        .byte     12,-92,0,F0         ;xyz coordinates for vertex 2
        .byte     -12,-92,0,F0        ;xyz coordinates for vertex 3
; Three stripes down runway
        .byte     -1,72,0,F0          ;xyz coordinates for vertex 4
        .byte     1,72,0,F0           ;xyz coordinates for vertex 5
        .byte     1,44,0,F0           ;xyz coordinates for vertex 6
        .byte     -1,44,0,F0          ;xyz coordinates for vertex 7

        .byte     -1,12,0,F0          ;xyz coordinates for vertex 8
        .byte     1,12,0,F0           ;xyz coordinates for vertex 9
        .byte     1,-12,0,F0          ;xyz coordinates for vertex 10
        .byte     -1,-12,0,F0         ;xyz coordinates for vertex 11

        .byte     -1,-44,0,F0         ;xyz coordinates for vertex 12
        .byte     1,-44,0,F0          ;xyz coordinates for vertex 13
        .byte     1,-72,0,F0          ;xyz coordinates for vertex 14
        .byte     -1,-72,0,F0         ;xyz coordinates for vertex 15
; Connect runway with hangar pavement
        .byte     10,-20,0,F0         ;xyz coordinates for vertex 16
        .byte     58,-20,0,F0         ;xyz coordinates for vertex 17
        .byte     58,-36,0,F0         ;xyz coordinates for vertex 18
        .byte     10,-36,0,F0         ;xyz coordinates for vertex 19
; Control tower
        .byte     -52,36,0,F0         ;xyz coordinates for vertex 20
        .byte     -52,36,49,F0        ;xyz coordinates for vertex 21
        .byte     -40,24,0,F0         ;xyz coordinates for vertex 22
        .byte     -40,24,49,F0        ;xyz coordinates for vertex 23
        .byte     -52,12,0,F0         ;xyz coordinates for vertex 24
        .byte     -52,12,49,F0        ;xyz coordinates for vertex 25
        .byte     -64,24,0,F0         ;xyz coordinates for vertex 26
        .byte     -64,24,49,F0        ;xyz coordinates for vertex 27

        .byte     -52,40,60,F0        ;xyz coordinates for vertex 28
        .byte     -36,24,60,F0        ;xyz coordinates for vertex 29
        .byte     -52,8,60,F0         ;xyz coordinates for vertex 30
        .byte     -68,24,60,F0        ;xyz coordinates for vertex 31

*---- face 0 of object:  runway
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object:  stripe on north part of runway
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     4,5,6,7             ;CW-ordered list of vertices

*---- face 2 of object:  stripe on middle part of runway
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     8,9,10,11           ;CW-ordered list of vertices

*---- face 3 of object:  stripe on south part of runway
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     12,13,14,15         ;CW-ordered list of vertices

*---- face 4 of object:  connect runway to hangar pavement
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     16,17,18,19         ;CW-ordered list of vertices

*---- face 5 of object:  NW side of control tower
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     20,21,27,26         ;CW-ordered list of vertices

*---- face 6 of object:  NE side of control tower
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     22,23,21,20         ;CW-ordered list of vertices

*---- face 7 of object:  SE side of control tower
        .word     4                   ;number of vertices in face
        .word     GRAY1               ;face color (GSP COLOR1 format)
        .word     24,25,23,22         ;CW-ordered list of vertices

*---- face 8 of object:  SW side of control tower
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     26,27,25,24         ;CW-ordered list of vertices

*---- face 9 of object:  NW window of control tower
        .word     4                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     21,28,31,27         ;CW-ordered list of vertices

*---- face 10 of object:  NE window of control tower
        .word     4                   ;number of vertices in face
        .word     BLUGRN2             ;face color (GSP COLOR1 format)
        .word     23,29,28,21         ;CW-ordered list of vertices

*---- face 11 of object:  SE window of control tower
        .word     4                   ;number of vertices in face
        .word     BLUGRN1             ;face color (GSP COLOR1 format)
        .word     25,30,29,23         ;CW-ordered list of vertices

*---- face 12 of object:  SW window of control tower
        .word     4                   ;number of vertices in face
        .word     BLUGRN2             ;face color (GSP COLOR1 format)
        .word     27,31,30,25         ;CW-ordered list of vertices

*---- face 13 of object:  roof of control tower
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     28,29,30,31         ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*          Graphics Object Model:  Airport Runway, South Half
*----------------------------------------------------------------------

LEAF347:

*---- size of bounding sphere in object space
        .byte     84,F0|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     NIL                 ;no bounding box specified

*---- number of xyz-coordinate triples used to describe object
        .word     16                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
; Runway
        .byte     -12,92,0,F0         ;xyz coordinates for vertex 0
        .byte     12,92,0,F0          ;xyz coordinates for vertex 1
        .byte     12,-84,0,F0         ;xyz coordinates for vertex 2
        .byte     -12,-84,0,F0        ;xyz coordinates for vertex 3
; Three stripes on runway
        .byte     -1,72,0,F0          ;xyz coordinates for vertex 4
        .byte     1,72,0,F0           ;xyz coordinates for vertex 5
        .byte     1,44,0,F0           ;xyz coordinates for vertex 6
        .byte     -1,44,0,F0          ;xyz coordinates for vertex 7

        .byte     -1,12,0,F0          ;xyz coordinates for vertex 8
        .byte     1,12,0,F0           ;xyz coordinates for vertex 9
        .byte     1,-12,0,F0          ;xyz coordinates for vertex 10
        .byte     -1,-12,0,F0         ;xyz coordinates for vertex 11

        .byte     -1,-44,0,F0         ;xyz coordinates for vertex 12
        .byte     1,-44,0,F0          ;xyz coordinates for vertex 13
        .byte     1,-72,0,F0          ;xyz coordinates for vertex 14
        .byte     -1,-72,0,F0         ;xyz coordinates for vertex 15

*---- face 0 of object:  runway
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object:  north stripe on runway
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     4,5,6,7             ;CW-ordered list of vertices

*---- face 2 of object:  middle stripe on runway
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     8,9,10,11           ;CW-ordered list of vertices

*---- face 3 of object:  south stripe on runway
        .word     4                   ;number of vertices in face
        .word     GRAY2               ;face color (GSP COLOR1 format)
        .word     12,13,14,15         ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data


*----------------------------------------------------------------------
*        Graphics Object Model:  Bouncing Cube (Moving Object)
*----------------------------------------------------------------------


MYLEAF:

*---- size of bounding sphere in object space
        .byte     50,F2|ISLEAF        ;radius R of bounding sphere

*---- color of object at maximum distance at which it is visible
        .word     GRAY3               ;dot color

*---- word displacement to bounding box parameters for object
        .word     (MYBBOX-$)/16       ;word displacement

*---- number of xyz-coordinate triples used to describe object
        .word     12                  ;no. of xyz coordinate triples

*---- signed 8-bit xyz object coordinates relative to centroid
MYOBJ:
        .byte     -22,22,0,F2         ;xyz coordinates for vertex 0
        .byte     22,22,0,F2          ;xyz coordinates for vertex 1
        .byte     22,-22,0,F2         ;xyz coordinates for vertex 2
        .byte     -22,-22,0,F2        ;xyz coordinates for vertex 3
; Storage for xyz coordinates for bouncing cube's 8 vertices
        .byte     0,0,0,F2            ;xyz coordinates for vertex 4
        .byte     0,0,0,F2            ;xyz coordinates for vertex 5
        .byte     0,0,0,F2            ;xyz coordinates for vertex 6
        .byte     0,0,0,F2            ;xyz coordinates for vertex 7
        .byte     0,0,0,F2            ;xyz coordinates for vertex 8
        .byte     0,0,0,F2            ;xyz coordinates for vertex 9
        .byte     0,0,0,F2            ;xyz coordinates for vertex 10
        .byte     0,0,0,F2            ;xyz coordinates for vertex 11

*---- face 0 of object
        .word     4                   ;number of vertices in face
        .word     BLUGRN2             ;face color (GSP COLOR1 format)
        .word     0,1,2,3             ;CW-ordered list of vertices

*---- face 1 of object
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     6,7,5,4             ;CW-ordered list of vertices

*---- face 2 of object
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     8,9,7,6             ;CW-ordered list of vertices

*---- face 3 of object
        .word     4                   ;number of vertices in face
        .word     GRAY4               ;face color (GSP COLOR1 format)
        .word     10,11,9,8           ;CW-ordered list of vertices

*---- face 4 of object
        .word     4                   ;number of vertices in face
        .word     GRAY3               ;face color (GSP COLOR1 format)
        .word     4,5,11,10           ;CW-ordered list of vertices

*---- face 5 of object
        .word     4                   ;number of vertices in face
        .word     GRAY5               ;face color (GSP COLOR1 format)
        .word     5,7,9,11            ;CW-ordered list of vertices

*---- face 6 of object
        .word     4                   ;number of vertices in face
        .word     GRAY5               ;face color (GSP COLOR1 format)
        .word     10,8,6,4            ;CW-ordered list of vertices

        .word     EOD                 ;end of object model data

MYBBOX:

*---- bounding box specification
        .word     INBOX|POSPAD,1      ;test mode, status code
        .byte     0,0,0,F2            ;xmin, ymin, zmin, scale factor
        .byte     0,0,0,F2            ;xmax, ymax, zmax, scale factor

        .word     INBOX|POSPAD,2      ;test mode, status code
        .byte     0,0,0,F2            ;xmin, ymin, zmin, scale factor
        .byte     0,0,0,F2            ;xmax, ymax, zmax, scale factor

        .word     EOD                 ;end of bounding box data

*----------------------------------------------------------------------
*                       Mark end of 3D database.
*----------------------------------------------------------------------
        .string   "* end database *"
DBEND:

        .end

