/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                      TIGA DEMO FRAME                                     */
/*                                                                          */
/* Draw a series of bouncing filled and pattern filled polygons             */
/*                                                                          */
/*    3/31/87...Original version written..................J. Van Aken       */
/*   10/10/88...Converted to TIGA.........................Graham Short      */
/*    2/08/89...Mods to make more resolution independent..J. Van Aken       */
/*                                                                          */
/*--------------------------------------------------------------------------*/
#include <time.h>

#include "tigademo.h"
#include "colors.h"

#define N 12

static short   xy[N];
static short   vxy[N] = {15,7, -19,20, -12,-30, 32,24, 46,16, 15,7};

void frame7()
{
    short    x, y, xmin, ymin, xmax, ymax, vx, vy, i, j, k;
    short    fcolor, bcolor, pattern, solid_poly, type_change;
    time_t   tim1, tim2;

    for (i = 0; i < N; i+=2)
    {
        xy[i]    = HRES/2;
        xy[i+1]  = 3*CHAR_HIGH+VRES/2;
        vxy[i]   = (signed short) HRES/vxy[i];
        vxy[i+1] = (signed short) VRES/vxy[i+1];
    }

    xmin = 0;
    ymin = 3*CHAR_HIGH;
    xmax = HRES-1;
    ymax = VRES-1;
    fcolor = 1;
    bcolor = 0;
    pattern = 0;
    solid_poly = 1;
    k = ITERATION_COUNT>>1;
    type_change = (iscolor) ? (3*k/4) : k / 2;
    for (i = 0; i < k; ++i)
    {
        if( solid_poly && (i > type_change) )
            solid_poly = 0;

        if( iscolor || (solid_poly && !iscolor))
        {
            set_phys_colors(phys_color[fcolor],phys_color[bcolor]);
            if (++fcolor == max_colors)
                fcolor = 1;
            if (++bcolor == max_colors)
                bcolor = 0;
        }

        if( solid_poly )
            c_fill_polygon(N>>1, xy);
        else
        {
            patn.data = gsp_patterns+((long)pattern<<8);
            set_patn(&patn);
            if (++pattern >= PMAX)
                pattern = 0;
            patnfill_polygon(N>>1, xy);
        }
        for (j = 0; j < (N-2); j += 2)
        {
            x  =  xy[j];
            vx = vxy[j];
            x += vx;
            if (x < xmin)
            {
                vxy[j] = -vx;
                x = (xmin << 1) - x;
            }
            else
                if (x > xmax)
                {
                vxy[j] = -vx;
                x = (xmax << 1) - x;
                }
            xy[j] = x;

            y  =  xy[j+1];
            vy = vxy[j+1];
            y += vy;
            if (y < ymin)
            {
                vxy[j+1]= -vy;
                y = (ymin << 1) - y;
            }
            else
                if (y > ymax)
                {
                vxy[j+1]= -vy;
                y = (ymax << 1) - y;
                }
            xy[j+1] = y;
        }
        /* copy first points to last points */
        xy[N-2] = xy[0];
        xy[N-1] = xy[1];
    }

    /* time delay */
    time(&tim1);
    do
        time(&tim2);
    while (difftime(tim2, tim1) < 1.0);
}

