/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                      TIGA DEMO FRAME                                     */
/*                                                                          */
/* Draw a series of bouncing filled rectangles                              */
/*                                                                          */
/*    3/23/87...Original version written..................J. Van Aken       */
/*   10/10/88...Converted to TIGA.........................Graham Short      */
/*    2/08/89...Mods to make more resolution independent..J. Van Aken       */
/*                                                                          */
/*--------------------------------------------------------------------------*/
#include <time.h>

#include "tigademo.h"
#include "colors.h"

void frame3()
{
    short   i, fcolor, x, y, xmin, ymin, xmax, ymax;
    short   w, h, wmin, hmin, wmax, hmax, vx, vy, vw, vh;
    time_t  tim1, tim2;

    xmin = 0;
    ymin = 3*CHAR_HIGH;
    xmax = HRES - 1;
    ymax = VRES - 1;
    wmin = HRES / 6;
    hmin = VRES / 5;
    wmax = HRES / 3;
    hmax = VRES / 2;
    vx = HRES / 11;
    vy = VRES / 15;
    vw = HRES / 29;
    vh = VRES / 33;
    w = wmin;
    h = hmin;
    x = (xmin + xmax - w) / 2;
    y = (ymin + ymax - h) / 2;
    fcolor = 1;
    for (i = 0; i <= ITERATION_COUNT; i++)
    {
        set_phys_fcolor(phys_color[fcolor]);
        c_fill_rect(w, h, x, y);
        if( ++fcolor == max_colors )
            fcolor = 1;

        /* calculate size and position of next rectangle */
        w += vw;
        if (w < wmin)
        {
            vw = -vw;
            w = 2*wmin - w;
        }
        else
            if (w > wmax)
            {
                vw = -vw;
                w = 2*wmax - w;
            }
        x += vx;
        if (x < xmin)
        {
            vx = -vx;
            x = 2*xmin - x;
        }
        else
            if (x > xmax-w)
            {
                vx = -vx;
                x = 2*(xmax-w) - x;
            }
        h += vh;
        if (h < hmin)
        {
            vh = -vh;
            h = 2*hmin - h;
        }
        else
            if (h > hmax)
            {
                vh = -vh;
                h = 2*hmax - h;
            }
        y += vy;
        if (y < ymin)
        {
            vy = -vy;
            y = 2*ymin - y;
        }
        else
            if (y > ymax-h)
            {
                vy = -vy;
                y = 2*(ymax-h) - y;
            }
    }
    /* time delay */
    time(&tim1);
    do
        time(&tim2);
    while (difftime(tim2, tim1) < 1.0);
}   

