;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;          Copyright (c) 1990  Texas Instruments Incorporated.            ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;                                                                         ;
;   null_patn_line function                                               ;
;                                                                         ;
;   The sole purpose of this routine is to ensure that the area-fill      ;
;   pattern is properly defined following initialization of the drawing   ;
;   environment by the set_config function.  This routine is assigned to  ;
;   the "hsrv" member of the global structure "pattern" within the        ;
;   general graphics initialization function, set_config.  With this      ;
;   default area-fill pattern routine in place, all the pattern-filling   ;
;   Extended Primitives (patn_rect, patn_oval, etc.) will work correctly, ;
;   even if the applications programmer has neglected to call the         ;
;   set_patn function first.  All this function does is to fill a single  ;
;   horizontal span of a filled region or shape with a solid color, using ;
;   the replicated pixel value contained in the COLOR1 register.  Similar ;
;   to the patn_line routine in the Extended Primitives, this routine     ;
;   assumes that it is called from an assembly-language routine that has  ;
;   set up the B-file registers for a FILL XY instruction.                ;
;                                                                         ;
;-------------------------------------------------------------------------;
; At call:  B-file registers are set up for FILL XY instruction.          ;
;                                                                         ;
; Registers altered:  Same as those altered by FILL XY instruction.       ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;   04/21/90...Original version written..................Jerry Van Aken   ;
;-------------------------------------------------------------------------;
;
        .title    'null pattern line fill'
        .file     'nopatnln'
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _null_patn_line
;
;     ENTRY POINT
;
_null_patn_line:

        FILL      XY                  ;
        RETS      0                   ;

        .end

