/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *          Copyright (c) 1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Draw text to the screen using the system font, which should be
 *   selected to be compatible with the resolution of the screen.
 *----------------------------------------------------------------------
 *   04/25/90...Original version written..................J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

#define NLINES	  8	  /* number of lines of text */

static CONFIG cfg;
static FONTINFO fontinfo;

static char *s[NLINES] =
{
    "This demonstration prints",
    "bit-mapped text to the screen",
    "using the system font.",
    "If the text appears too large",
    "or too small at your screen's",
    "resolution, you may wish to",
    "link in an alternate system",
    "font and run the demo again."
};


main()
{
    int hres, vres, i, x, y, w, h, wmax;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(-1);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */
    get_fontinfo(0, &fontinfo);  /* get system font parameters */

    /* Center four lines of text in the middle of the screen. */
    h = fontinfo.charhigh;
    y = (vres - NLINES*h)/2;
    wmax = 0;
    for (i = 0; i < NLINES; i++) {
	w = text_width(s[i]);
	if (w > wmax)
	    wmax = w;
	x = (hres - w)/2;
	text_out(x, y, s[i]);
	y += h;
    }

    /* Draw rectangles to outline text and screen. */
    w = wmax + 4*h;
    h = (NLINES + 2)*h;
    x = (hres - w)/2;
    y = (vres - h)/2;
    draw_rect(w, h, x, y);
    draw_rect(hres-1, vres-1, 0, 0);  /* outline screen */
}

