/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*       Copyright (c) 1987-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  file	    patterns.h						 */
/*                                                                       */
/*  description     This file contains a table of 16x16 two-color	 */
/*		    patterns for filling areas.  This file must be	 */
/*		    included after gsptypes.h so that the PATTERN	 */
/*		    structure type is defined.				 */
/*                                                                       */
/*-----------------------------------------------------------------------*/
/* Revision history:							 */
/*   08/21/87...Created pattern table for Math/Graphics ...J.R. Van Aken */
/*   10/10/88...Converted Math/Graphics patterns to TIGA....Graham Short */
/*   05/18/90...Added NUM_PATNS and current_patn...........J.R. Van Aken */
/*-----------------------------------------------------------------------*/
#define NUM_PATNS   29	   /* number of 16x16 patterns in table below */

typedef struct { short row[16]; } PATN16x16;

static PATTERN current_patn = { 16, 16, 1, 0 };

PATN16x16 patnbits[NUM_PATNS] =
{
      /* PATTERN # 0 */
      { 0x0000, 0x3FFC, 0x7FFE, 0x0006, 0x0006, 0x1FC6, 0x3FE6, 0x3066,
        0x3066, 0x33E6, 0x31C6, 0x3006, 0x3006, 0x3FFE, 0x1FFC, 0x0000 },

      /* PATTERN # 1 */
      { 0x0000, 0x0080, 0x0080, 0x0080, 0x01C0, 0x01C0, 0x7FFF, 0x1FFC,
        0x0FF8, 0x03E0, 0x03E0, 0x07F0, 0x0630, 0x0C18, 0x0808, 0x0000 },

      /* PATTERN # 2 */
      { 0x0000, 0x0000, 0x0E38, 0x1F7C, 0x3FFE, 0x3FFE, 0x3FFE, 0x3FFE,
        0x1FFC, 0x0FF8, 0x07F0, 0x03E0, 0x01C0, 0x0080, 0x0000, 0x0000 },

      /* PATTERN # 3 */
      { 0x0000, 0x01C0, 0x19CC, 0x188C, 0x0490, 0x02A0, 0x31C6, 0x3FFE,
        0x31C6, 0x02A0, 0x0490, 0x188C, 0x19CC, 0x01C0, 0x0000, 0x0000 },

      /* PATTERN # 4 */
      { 0x0420, 0x0420, 0x3FFC, 0x2424, 0x2424, 0xFC3F, 0x2004, 0x2004,
        0x2004, 0x2004, 0xFC3F, 0x2424, 0x2424, 0x3FFC, 0x0420, 0x0420 },

      /* PATTERN # 5 */
      { 0x0101, 0x0101, 0x8282, 0x7C7C, 0x1010, 0x1010, 0x2828, 0xC7C7,
        0x0101, 0x0101, 0x8282, 0x7C7C, 0x1010, 0x1010, 0x2828, 0xC7C7 },

      /* PATTERN # 6 */
      { 0x0000, 0x0000, 0x0000, 0x1FF0, 0x1FF0, 0x0AB0, 0x1570, 0x0AB0,
        0x1570, 0x0AB0, 0x1570, 0x0AB0, 0x0000, 0x0000, 0x0000, 0x0000 },

      /* PATTERN # 7 */
      { 0x0000, 0xFE7F, 0xFE7F, 0xFE7F, 0xFE7F, 0xFE7F, 0xFE7F, 0x0000,                                
        0x0000, 0x7FFE, 0x7FFE, 0x7FFE, 0x7FFE, 0x7FFE, 0x7FFE, 0x0000 },

      /* PATTERN # 8 */
      { 0xF007, 0xF803, 0x9C03, 0x0E07, 0x070E, 0x039C, 0x03F8, 0x07F0,
        0x0FE0, 0x1FC0, 0x39C0, 0x70E0, 0xE070, 0xC039, 0xC01F, 0xE00F },

      /* PATTERN # 9 */
      { 0xAAFA, 0xFF77, 0xFFFF, 0xFF77, 0xAAFA, 0x7070, 0xF8F8, 0x7070,
        0xFAAA, 0x77FF, 0xFFFF, 0x77FF, 0xFAAA, 0x7070, 0xF8F8, 0x7070 },

      /* PATTERN #10 */
      { 0x00C0, 0x0030, 0x1F88, 0x2044, 0x4024, 0x4E24, 0x9124, 0xA1C4,
        0x2385, 0x2489, 0x2472, 0x2402, 0x2204, 0x11F8, 0x0C00, 0x0300 },

      /* PATTERN #11 */
      { 0x93C9, 0x0E70, 0x1C38, 0xB99D, 0xF24F, 0x6666, 0xCDB3, 0x4DB2,
        0x4DB2, 0xCDB3, 0x6666, 0xF24F, 0xB99D, 0x1C38, 0x0E70, 0x93C9 },

      /* PATTERN #12 */
      { 0x0000, 0x7FFE, 0x6426, 0x524A, 0x4992, 0x6666, 0x566A, 0x4992,
        0x4992, 0x566A, 0x6666, 0x4992, 0x524A, 0x6426, 0x7FFE, 0x0000 },

      /* PATTERN #13 */
      { 0x0441, 0x8AA2, 0x5114, 0x2388, 0x5114, 0x8442, 0x0EE1, 0xA54A,
        0x739C, 0xA54A, 0x0EE1, 0x8442, 0x5114, 0x2388, 0x5114, 0x8AA2 },

      /* PATTERN #14 */
      { 0x0000, 0x601E, 0x7C31, 0x2733, 0x29B3, 0x34B0, 0x12B0, 0x18B0,
        0x0F70, 0x00B2, 0x1FF4, 0x7FFC, 0x601C, 0x403C, 0x5842, 0x3800 },

      /* PATTERN #15 */
      { 0x1111, 0x2222, 0x4444, 0x8888, 0x1111, 0x2222, 0x4444, 0x8888,
        0x1111, 0x2222, 0x4444, 0x8888, 0x1111, 0x2222, 0x4444, 0x8888 },

      /* PATTERN #16 */
      { 0x8888, 0x4444, 0x2222, 0x1111, 0x8888, 0x4444, 0x2222, 0x1111,
        0x8888, 0x4444, 0x2222, 0x1111, 0x8888, 0x4444, 0x2222, 0x1111 },

      /* PATTERN #17 */
      { 0x1111, 0xAAAA, 0x4444, 0xAAAA, 0x1111, 0xAAAA, 0x4444, 0xAAAA,
        0x1111, 0xAAAA, 0x4444, 0xAAAA, 0x1111, 0xAAAA, 0x4444, 0xAAAA },

      /* PATTERN #18 */
      { 0x5555, 0xAAAA, 0x5555, 0xAAAA, 0x5555, 0xAAAA, 0x5555, 0xAAAA,
        0x5555, 0xAAAA, 0x5555, 0xAAAA, 0x5555, 0xAAAA, 0x5555, 0xAAAA },

      /* PATTERN #19 */
      { 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000,
        0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000 },

      /* PATTERN #20 */
      { 0x1111, 0x1111, 0x1111, 0x1111, 0x1111, 0x1111, 0x1111, 0x1111,
        0x1111, 0x1111, 0x1111, 0x1111, 0x1111, 0x1111, 0x1111, 0x1111 },

      /* PATTERN #21 */
      { 0xFFFF, 0x1111, 0x1111, 0x1111, 0xFFFF, 0x1111, 0x1111, 0x1111,
        0xFFFF, 0x1111, 0x1111, 0x1111, 0xFFFF, 0x1111, 0x1111, 0x1111 },

      /* PATTERN #22 */
      { 0x8181, 0x4242, 0x2424, 0x1818, 0x8181, 0x4242, 0x2424, 0x1818,
        0x8181, 0x4242, 0x2424, 0x1818, 0x8181, 0x4242, 0x2424, 0x1818 },

      /* PATTERN #23 */
      { 0x1111, 0x2222, 0x4444, 0x8888, 0x8888, 0x4444, 0x2222, 0x1111,
        0x1111, 0x2222, 0x4444, 0x8888, 0x8888, 0x4444, 0x2222, 0x1111 },

      /* PATTERN #24 */
      { 0x4C73, 0x98E6, 0x31CD, 0x639A, 0xC734, 0x8E69, 0x1CD3, 0x39A6,
        0x734C, 0xE698, 0xCD31, 0x9A63, 0x34C7, 0x698E, 0xD31C, 0xA639 },

      /* PATTERN #25 */
      { 0xA639, 0xD31C, 0x698E, 0x34C7, 0x9A63, 0xCD31, 0xE698, 0x734C,
        0x39A6, 0x1CD3, 0x8E69, 0xC734, 0x639A, 0x31CD, 0x98E6, 0x4C73 },

      /* PATTERN #26 */
      { 0x0000, 0x0000, 0x04E0, 0x00E0, 0x31E0, 0x35E0, 0x24E0, 0x75FC,
        0x75F8, 0x75F0, 0x3190, 0x1F80, 0x0F00, 0x0600, 0x0400, 0x0000 },

      /* PATTERN #27 */
      { 0xEEEE, 0x0001, 0x7BFD, 0x336D, 0x3264, 0x3061, 0x3061, 0x3061,
        0x3060, 0x78F1, 0x0001, 0x7A5D, 0x0AC8, 0x0B49, 0x7A5D, 0x0001 },

      /* PATTERN #28 */
      { 0xC7BD, 0xFF85, 0xF005, 0xF035, 0xF7A5, 0xF0A5, 0x00BC, 0x0780,
        0xF400, 0x943E, 0x97BE, 0xF03E, 0x103E, 0x17FE, 0xD781, 0xC781 }
};

